/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.structure;

import com.creativemd.creativecore.common.gui.SubGui;
import com.creativemd.creativecore.common.gui.controls.GuiButton;
import com.creativemd.creativecore.common.gui.event.ControlClickEvent;
import com.creativemd.creativecore.common.utils.Rotation;
import com.creativemd.creativecore.common.utils.RotationUtils;
import com.creativemd.littletiles.common.gui.SubGuiStructure;
import com.creativemd.littletiles.common.gui.controls.GuiTileViewer;
import com.creativemd.littletiles.common.items.ItemBlockTiles;
import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.structure.PreviewTileAxis;
import com.creativemd.littletiles.common.utils.LittleTile;
import com.creativemd.littletiles.common.utils.LittleTilePreview;
import com.creativemd.littletiles.common.utils.small.LittleTileBox;
import com.creativemd.littletiles.common.utils.small.LittleTileVec;
import com.creativemd.littletiles.utils.PreviewTile;
import com.n247s.api.eventapi.eventsystem.CustomEventSubscribe;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class LittleDoor
extends LittleStructure {
    public ForgeDirection normalDirection;
    public RotationUtils.Axis axis;
    public LittleTileVec axisVec;

    @Override
    protected void loadFromNBTExtra(NBTTagCompound nbt) {
        if (nbt.func_74764_b("ax")) {
            this.axisVec = new LittleTileVec("a", nbt);
            if (this.mainTile != null) {
                this.axisVec.subVec(this.mainTile.cornerVec);
            }
        } else {
            this.axisVec = new LittleTileVec("av", nbt);
        }
        this.axis = RotationUtils.Axis.getAxis(nbt.func_74762_e("axis"));
        this.normalDirection = ForgeDirection.getOrientation((int)nbt.func_74762_e("ndirection"));
    }

    @Override
    protected void writeToNBTExtra(NBTTagCompound nbt) {
        this.axisVec.writeToNBT("av", nbt);
        nbt.func_74768_a("axis", this.axis.toInt());
        nbt.func_74768_a("ndirection", RotationUtils.getIndex(this.normalDirection));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void createControls(SubGui gui, LittleStructure structure) {
        LittleDoor door = null;
        if (structure instanceof LittleDoor) {
            door = (LittleDoor)structure;
        }
        GuiTileViewer tile = new GuiTileViewer("tileviewer", 5, 30, 100, 100, ((SubGuiStructure)gui).stack);
        if (door != null) {
            tile.axisDirection = door.axis;
            tile.axisX = door.axisVec.x;
            tile.axisY = door.axisVec.y;
            tile.axisZ = door.axisVec.z;
            tile.normalAxis = RotationUtils.Axis.getAxis(door.normalDirection);
        }
        tile.visibleAxis = true;
        tile.updateViewDirection();
        gui.controls.add(tile);
        gui.controls.add(new GuiButton("reset view", 105, 30, 70));
        gui.controls.add(new GuiButton("flip view", 105, 50, 70));
        gui.controls.add(new GuiButton("swap axis", 105, 10, 70));
        gui.controls.add(new GuiButton("swap normal", 105, 70, 70));
        gui.controls.add(new GuiButton("up", "<-", 125, 90, 20).setRotation(90));
        gui.controls.add(new GuiButton("->", 145, 110, 20));
        gui.controls.add(new GuiButton("<-", 105, 110, 20));
        gui.controls.add(new GuiButton("down", "<-", 125, 110, 20).setRotation(-90));
    }

    public LittleTileVec getAxisVec() {
        LittleTileVec newAxisVec = this.axisVec.copy();
        newAxisVec.addVec(this.mainTile.cornerVec);
        return newAxisVec;
    }

    @CustomEventSubscribe
    @SideOnly(value=Side.CLIENT)
    public void onButtonClicked(ControlClickEvent event) {
        GuiTileViewer viewer = (GuiTileViewer)event.source.parent.getControl("tileviewer");
        if (event.source.is("swap axis")) {
            switch (viewer.axisDirection) {
                case Xaxis: {
                    this.axis = RotationUtils.Axis.Yaxis;
                    break;
                }
                case Yaxis: {
                    this.axis = RotationUtils.Axis.Zaxis;
                    break;
                }
                case Zaxis: {
                    this.axis = RotationUtils.Axis.Xaxis;
                    break;
                }
            }
            viewer.axisDirection = this.axis;
            viewer.updateViewDirection();
            viewer.updateNormalAxis();
        } else if (event.source.is("reset view")) {
            viewer.offsetX = 0.0f;
            viewer.offsetY = 0.0f;
            viewer.scale = 1.0f;
        } else if (event.source.is("flip view")) {
            viewer.viewDirection = viewer.viewDirection.getOpposite();
        } else if (event.source instanceof GuiButton) {
            if (event.source.is("<-")) {
                if (viewer.axisDirection == RotationUtils.Axis.Xaxis) {
                    ++viewer.axisZ;
                } else {
                    --viewer.axisX;
                }
            }
            if (event.source.is("->")) {
                if (viewer.axisDirection == RotationUtils.Axis.Xaxis) {
                    --viewer.axisZ;
                } else {
                    ++viewer.axisX;
                }
            }
            if (event.source.is("up")) {
                if (viewer.axisDirection == RotationUtils.Axis.Yaxis) {
                    --viewer.axisZ;
                } else {
                    ++viewer.axisY;
                }
            }
            if (event.source.is("down")) {
                if (viewer.axisDirection == RotationUtils.Axis.Yaxis) {
                    ++viewer.axisZ;
                } else {
                    --viewer.axisY;
                }
            } else if (event.source.is("swap normal")) {
                viewer.changeNormalAxis();
            }
        }
    }

    @Override
    public ArrayList<PreviewTile> getSpecialTiles() {
        ArrayList<PreviewTile> boxes = new ArrayList<PreviewTile>();
        LittleTileBox box = new LittleTileBox(this.axisVec.x, this.axisVec.y, this.axisVec.z, this.axisVec.x + 1, this.axisVec.y + 1, this.axisVec.z + 1);
        boxes.add(new PreviewTileAxis(box, null, this.axis));
        return boxes;
    }

    @Override
    public void onFlip(World world, EntityPlayer player, ItemStack stack, ForgeDirection direction) {
        LittleTileBox box = new LittleTileBox(this.axisVec.x, this.axisVec.y, this.axisVec.z, this.axisVec.x + 1, this.axisVec.y + 1, this.axisVec.z + 1);
        box.flipBoxWithCenter(direction, null);
        this.axisVec = box.getMinVec();
    }

    @Override
    public void onRotate(World world, EntityPlayer player, ItemStack stack, ForgeDirection direction) {
        LittleTileBox box = new LittleTileBox(this.axisVec.x, this.axisVec.y, this.axisVec.z, this.axisVec.x + 1, this.axisVec.y + 1, this.axisVec.z + 1);
        box.rotateBox(direction);
        this.axisVec = box.getMinVec();
        this.axis = RotationUtils.Axis.getAxis(RotationUtils.rotateForgeDirection(this.axis.getDirection(), direction));
        this.normalDirection = RotationUtils.rotateForgeDirection(this.normalDirection, direction);
    }

    public boolean tryToPlacePreviews(World world, EntityPlayer player, int x, int y, int z, Rotation direction, ArrayList<PreviewTile> defaultpreviews, boolean inverse) {
        LittleTileVec axisPoint = this.getAxisVec();
        LittleTileVec internalOffset = new LittleTileVec(axisPoint.x - x * 16, axisPoint.y - y * 16, axisPoint.z - z * 16);
        ArrayList<PreviewTile> previews = new ArrayList<PreviewTile>();
        for (PreviewTile defaultpreview : defaultpreviews) {
            PreviewTile box = defaultpreview.copy();
            box.box.rotateBoxWithCenter(direction, Vec3.func_72443_a((double)0.03125, (double)0.03125, (double)0.03125));
            box.box.addOffset(internalOffset);
            previews.add(box);
        }
        LittleDoor structure = new LittleDoor();
        structure.dropStack = this.dropStack.func_77946_l();
        structure.axisVec = new LittleTileVec(0, 0, 0);
        structure.setTiles(new ArrayList<LittleTile>());
        structure.axis = this.axis;
        ForgeDirection rotationAxis = this.axis.getDirection();
        if (inverse) {
            rotationAxis = rotationAxis.getOpposite();
        }
        structure.normalDirection = this.normalDirection.getRotation(rotationAxis);
        if (ItemBlockTiles.placeTiles(world, player, previews, structure, x, y, z, null, null)) {
            ArrayList<LittleTile> tiles = this.getTiles();
            for (LittleTile littleTile : tiles) {
                littleTile.te.update();
            }
            tiles.clear();
            tiles = structure.getTiles();
            for (LittleTile tile : tiles) {
                tile.te.combineTiles();
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean onBlockActivated(World world, LittleTile tile, int x, int y, int z, EntityPlayer player, int side, float moveX, float moveY, float moveZ) {
        if (this.axis != null) {
            if (!this.hasLoaded()) {
                player.func_146105_b((IChatComponent)new ChatComponentText("Cannot interact with door! Not all tiles are loaded!"));
                return true;
            }
            ArrayList<PreviewTile> previews = new ArrayList<PreviewTile>();
            LittleTileVec axisPoint = this.getAxisVec();
            int mainX = axisPoint.x / 16;
            int mainY = axisPoint.y / 16;
            int mainZ = axisPoint.z / 16;
            LittleTileVec invaxis = axisPoint.copy();
            invaxis.invert();
            ArrayList<LittleTile> tiles = this.getTiles();
            for (LittleTile tileOfList : tiles) {
                for (int j = 0; j < tileOfList.boundingBoxes.size(); ++j) {
                    NBTTagCompound nbt = new NBTTagCompound();
                    tileOfList.saveTile(nbt);
                    LittleTileBox box = tileOfList.boundingBoxes.get(j).copy();
                    box.addOffset(new LittleTileVec(tileOfList.te.field_145851_c * 16, tileOfList.te.field_145848_d * 16, tileOfList.te.field_145849_e * 16));
                    box.addOffset(invaxis);
                    PreviewTile preview = new PreviewTile(box, new LittleTilePreview(box, nbt));
                    previews.add(preview);
                }
            }
            previews.add(new PreviewTileAxis(new LittleTileBox(0, 0, 0, 1, 1, 1), null, this.axis));
            Rotation rotation = Rotation.EAST;
            double playerRotation = MathHelper.func_76142_g((float)player.field_70177_z);
            boolean rotX = playerRotation <= -90.0 || playerRotation >= 90.0;
            boolean rotY = player.field_70125_A > 0.0f;
            boolean rotZ = playerRotation > 0.0 && playerRotation <= 180.0;
            boolean inverse = false;
            switch (this.axis) {
                case Xaxis: {
                    System.out.println(this.normalDirection);
                    rotation = Rotation.UPX;
                    switch (this.normalDirection) {
                        case UP: {
                            if (rotY) break;
                            rotation = Rotation.DOWNX;
                            break;
                        }
                        case DOWN: {
                            if (!rotY) break;
                            rotation = Rotation.DOWNX;
                            break;
                        }
                        case SOUTH: {
                            if (rotX) break;
                            rotation = Rotation.DOWNX;
                            break;
                        }
                        case NORTH: {
                            if (!rotX) break;
                            rotation = Rotation.DOWNX;
                            break;
                        }
                    }
                    inverse = rotation == Rotation.UPX;
                    break;
                }
                case Yaxis: {
                    rotation = Rotation.SOUTH;
                    switch (this.normalDirection) {
                        case EAST: {
                            if (!rotX) break;
                            rotation = Rotation.NORTH;
                            break;
                        }
                        case WEST: {
                            if (rotX) break;
                            rotation = Rotation.NORTH;
                            break;
                        }
                        case SOUTH: {
                            if (rotZ) break;
                            rotation = Rotation.NORTH;
                            break;
                        }
                        case NORTH: {
                            if (!rotZ) break;
                            rotation = Rotation.NORTH;
                            break;
                        }
                    }
                    inverse = rotation == Rotation.SOUTH;
                    break;
                }
                case Zaxis: {
                    rotation = Rotation.UP;
                    switch (this.normalDirection) {
                        case EAST: {
                            if (!rotZ) break;
                            rotation = Rotation.DOWN;
                            break;
                        }
                        case WEST: {
                            if (rotZ) break;
                            rotation = Rotation.DOWN;
                            break;
                        }
                        case UP: {
                            if (rotY) break;
                            rotation = Rotation.DOWN;
                            break;
                        }
                        case DOWN: {
                            if (!rotY) break;
                            rotation = Rotation.DOWN;
                            break;
                        }
                    }
                    inverse = rotation == Rotation.UP;
                    break;
                }
            }
            for (LittleTile value : tiles) {
                value.te.removeTile(value);
            }
            if (this.tryToPlacePreviews(world, player, mainX, mainY, mainZ, rotation, previews, !inverse)) {
                return true;
            }
            if (this.tryToPlacePreviews(world, player, mainX, mainY, mainZ, rotation.getOpposite(), previews, inverse)) {
                return true;
            }
            for (LittleTile littleTile : tiles) {
                littleTile.te.addTile(littleTile);
            }
            return true;
        }
        return true;
    }

    public void updateNormalDirection() {
        switch (this.axis) {
            case Xaxis: {
                this.normalDirection = RotationUtils.Axis.Zaxis.getDirection();
                break;
            }
            case Yaxis: {
                this.normalDirection = RotationUtils.Axis.Xaxis.getDirection();
                break;
            }
            case Zaxis: {
                this.normalDirection = RotationUtils.Axis.Yaxis.getDirection();
                break;
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public LittleStructure parseStructure(SubGui gui) {
        LittleDoor door = new LittleDoor();
        GuiTileViewer viewer = (GuiTileViewer)gui.getControl("tileviewer");
        door.axisVec = new LittleTileVec(viewer.axisX, viewer.axisY, viewer.axisZ);
        door.axis = viewer.axisDirection;
        door.normalDirection = viewer.normalAxis.getDirection();
        return door;
    }
}

