/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.creativecore.common.gui;

import com.creativemd.creativecore.client.rendering.RenderHelper2D;
import com.creativemd.creativecore.common.container.SubContainer;
import com.creativemd.creativecore.common.event.CreativeCoreEventBus;
import com.creativemd.creativecore.common.gui.GuiContainerSub;
import com.creativemd.creativecore.common.gui.controls.GuiControl;
import com.creativemd.creativecore.common.gui.event.ControlClickEvent;
import com.creativemd.creativecore.common.gui.event.GuiControlEvent;
import com.creativemd.creativecore.common.gui.event.GuiToolTipEvent;
import com.creativemd.creativecore.common.gui.premade.SubGuiDialog;
import com.creativemd.creativecore.common.packet.GuiControlPacket;
import com.creativemd.creativecore.common.packet.GuiLayerPacket;
import com.creativemd.creativecore.common.packet.PacketHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import javax.vecmath.Vector2d;
import javax.vecmath.Vector4d;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public abstract class SubGui {
    public static Minecraft mc = Minecraft.func_71410_x();
    public static RenderItem itemRender;
    private CreativeCoreEventBus eventBus;
    public GuiContainerSub gui;
    public SubContainer container;
    public int width;
    public int height;
    public ArrayList<GuiControl> controls = new ArrayList();

    public SubGui() {
        this(176, 166);
    }

    public SubGui(int width, int height) {
        this.width = width;
        this.height = height;
        this.eventBus = new CreativeCoreEventBus();
        this.eventBus.RegisterEventListener(this);
    }

    public boolean isTopLayer() {
        if (this.gui == null) {
            return false;
        }
        return this.gui.getTopLayer() == this;
    }

    public int getLayerID() {
        return this.gui.layers.indexOf(this);
    }

    public void openNewLayer(NBTTagCompound nbt) {
        this.openNewLayer(nbt, false);
    }

    public void openNewLayer(NBTTagCompound nbt, boolean isPacket) {
        this.gui.addLayer(this.createLayer((World)SubGui.mc.field_71441_e, (EntityPlayer)SubGui.mc.field_71439_g, nbt));
        if (!isPacket) {
            PacketHandler.sendPacketToServer(new GuiLayerPacket(nbt, this.getLayerID(), false));
        }
    }

    public void closeLayer(NBTTagCompound nbt) {
        this.closeLayer(nbt, false);
    }

    public void closeLayer(NBTTagCompound nbt, boolean isPacket) {
        this.onGuiClose();
        if (!isPacket) {
            PacketHandler.sendPacketToServer(new GuiLayerPacket(nbt, this.getLayerID(), true));
        }
        this.gui.removeLayer(this);
        if (this.gui.hasTopLayer()) {
            this.gui.getTopLayer().onLayerClosed(this, nbt);
        }
    }

    public void onLayerClosed(SubGui gui, NBTTagCompound nbt) {
        if (nbt.func_74767_n("dialog")) {
            String[] buttons = new String[nbt.func_74762_e("count")];
            for (int i = 0; i < buttons.length; ++i) {
                buttons[i] = nbt.func_74779_i("b" + i);
            }
            this.onDialogClosed(nbt.func_74779_i("text"), buttons, nbt.func_74779_i("clicked"));
        }
    }

    public void closeGui() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74757_a("exit", true);
        this.closeLayer(nbt);
        if (this.gui.layers.size() == 0) {
            SubGui.mc.field_71439_g.func_71053_j();
        }
    }

    public SubGui createLayer(World world, EntityPlayer player, NBTTagCompound nbt) {
        SubGui layer = this.createLayerFromPacket(world, player, nbt);
        layer.container = this.container.createLayerFromPacket(world, player, nbt);
        layer.gui = this.gui;
        layer.initGui();
        return layer;
    }

    public SubGui createLayerFromPacket(World world, EntityPlayer player, NBTTagCompound nbt) {
        if (nbt.func_74767_n("dialog")) {
            String[] buttons = new String[nbt.func_74762_e("count")];
            for (int i = 0; i < buttons.length; ++i) {
                buttons[i] = nbt.func_74779_i("b" + i);
            }
            return new SubGuiDialog(nbt.func_74779_i("text"), buttons);
        }
        return null;
    }

    public void openYesNoDialog(String text) {
        this.openButtonDialogDialog(text, "Yes", "No");
    }

    public void openButtonDialogDialog(String text, String ... buttons) {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74757_a("dialog", true);
        nbt.func_74778_a("text", text);
        nbt.func_74768_a("count", buttons.length);
        for (int i = 0; i < buttons.length; ++i) {
            nbt.func_74778_a("b" + i, buttons[i]);
        }
        this.openNewLayer(nbt);
    }

    public void openSaveDialog(String text) {
        this.openButtonDialogDialog(text, "Yes", "No", "Cancel");
    }

    public void onDialogClosed(String text, String[] buttons, String clicked) {
    }

    public void initGui() {
        int i;
        this.createControls();
        for (i = 0; i < this.controls.size(); ++i) {
            this.controls.get((int)i).parent = this;
            this.controls.get(i).init();
        }
        if (this.container != null) {
            for (i = 0; i < this.container.controls.size(); ++i) {
                this.container.controls.get(i).init();
                this.controls.add(this.container.controls.get((int)i).guiControl);
            }
        }
        this.refreshControls();
    }

    public void removeControl(GuiControl control) {
        this.controls.remove(control);
    }

    public void refreshControls() {
        for (int i = 0; i < this.controls.size(); ++i) {
            this.controls.get((int)i).parent = this;
            this.controls.get(i).resetID();
            this.controls.get(i).setID(i);
        }
    }

    public GuiControl getControl(String name) {
        for (int i = 0; i < this.controls.size(); ++i) {
            if (!this.controls.get((int)i).name.equalsIgnoreCase(name)) continue;
            return this.controls.get(i);
        }
        return null;
    }

    public boolean hasControl(String name) {
        for (int i = 0; i < this.controls.size(); ++i) {
            if (!this.controls.get((int)i).name.equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    public void removeControls(String ... except) {
        int i = 0;
        while (i < this.controls.size()) {
            boolean isException = false;
            for (int j = 0; j < except.length; ++j) {
                if (!this.controls.get(i).is(except[j])) continue;
                isException = true;
                break;
            }
            if (!isException) {
                this.controls.remove(i);
                continue;
            }
            ++i;
        }
    }

    public void removeControls() {
        this.controls.clear();
    }

    public abstract void createControls();

    public void onGuiClose() {
        for (int i = 0; i < this.controls.size(); ++i) {
            this.controls.get(i).onGuiClose();
        }
        this.eventBus.removeAllEventListeners();
    }

    public boolean raiseEvent(GuiControlEvent event) {
        return !this.eventBus.raiseEvent(event);
    }

    public void addListener(Object listener) {
        this.eventBus.RegisterEventListener(listener);
    }

    public void removeListener(Object listener) {
        this.eventBus.removeEventListener(listener);
    }

    public void moveControlBehind(GuiControl control, GuiControl controlInBack) {
        if (this.controls.contains(controlInBack) && this.controls.remove(control) && this.controls.indexOf(controlInBack) + 1 < this.controls.size()) {
            this.controls.add(this.controls.indexOf(controlInBack) + 1, control);
        } else {
            this.moveControlToBottom(control);
        }
        this.refreshControls();
    }

    public void moveControlAbove(GuiControl control, GuiControl controlInFront) {
        if (this.controls.contains(controlInFront) && this.controls.remove(control)) {
            this.controls.add(this.controls.indexOf(controlInFront), control);
        }
        this.refreshControls();
    }

    public void moveControlToTop(GuiControl control) {
        if (this.controls.remove(control)) {
            this.controls.add(1, control);
        }
        this.refreshControls();
    }

    public void moveControlToBottom(GuiControl control) {
        if (this.controls.remove(control)) {
            this.controls.add(control);
        }
        this.refreshControls();
    }

    public void readFromOpeningNBT(NBTTagCompound nbt) {
    }

    public void readFromNBT(NBTTagCompound nbt) {
    }

    public void sendPacketToServer(int controlID, NBTTagCompound nbt) {
        PacketHandler.sendPacketToServer(new GuiControlPacket(this.getLayerID(), controlID, nbt));
    }

    public void mouseMove(int posX, int posY, int button) {
        Vector2d mouse = this.getMousePos();
        for (int i = 0; i < this.controls.size(); ++i) {
            Vector2d pos = this.controls.get(i).getValidPos((int)mouse.x, (int)mouse.y);
            if (!this.controls.get(i).isInteractable()) continue;
            this.controls.get(i).mouseMove((int)pos.x, (int)pos.y, button);
        }
    }

    public void mouseReleased(int posX, int posY, int button) {
        Vector2d mouse = this.getMousePos();
        for (int i = 0; i < this.controls.size(); ++i) {
            Vector2d pos = this.controls.get(i).getValidPos((int)mouse.x, (int)mouse.y);
            if (!this.controls.get(i).isInteractable()) continue;
            this.controls.get(i).mouseReleased((int)pos.x, (int)pos.y, button);
        }
    }

    public void mousePressed(int posX, int posY, int button) {
        Vector2d mouse = this.getMousePos();
        for (int i = 0; i < this.controls.size(); ++i) {
            GuiControl control = this.controls.get(i);
            Vector2d pos = control.getValidPos((int)mouse.x, (int)mouse.y);
            if (!control.isInteractable()) continue;
            if (control.isMouseOver((int)pos.x, (int)pos.y) && control.mousePressed((int)pos.x, (int)pos.y, button)) {
                control.raiseEvent(new ControlClickEvent(control, (int)pos.x, (int)pos.y));
                return;
            }
            control.onLoseFocus();
        }
    }

    public void mouseDragged(int posX, int posY, int button, long time) {
        Vector2d mouse = this.getMousePos();
        for (int i = 0; i < this.controls.size(); ++i) {
            Vector2d pos = this.controls.get(i).getValidPos((int)mouse.x, (int)mouse.y);
            if (!this.controls.get(i).isInteractable() || !this.controls.get(i).isMouseOver((int)pos.x, (int)pos.y) || !this.controls.get(i).mouseDragged((int)pos.x, (int)pos.y, button, time)) continue;
            return;
        }
    }

    public boolean mouseScrolled(int posX, int posY, int scrolled) {
        Vector2d mouse = this.getMousePos();
        for (int i = 0; i < this.controls.size(); ++i) {
            Vector2d pos = this.controls.get(i).getValidPos((int)mouse.x, (int)mouse.y);
            if (!this.controls.get(i).isInteractable() || !this.controls.get(i).isMouseOver((int)pos.x, (int)pos.y) || !this.controls.get(i).mouseScrolled((int)pos.x, (int)pos.y, scrolled > 0 ? 1 : -1)) continue;
            return true;
        }
        return false;
    }

    public boolean keyTyped(char character, int key) {
        block4: {
            block3: {
                for (int i = 0; i < this.controls.size(); ++i) {
                    if (!this.controls.get(i).isInteractable() || !this.controls.get(i).onKeyPressed(character, key)) continue;
                    return true;
                }
                if (key == 1) break block3;
                if (key != SubGui.mc.field_71474_y.field_151445_Q.func_151463_i()) break block4;
            }
            this.closeGui();
            return true;
        }
        return false;
    }

    public Vector2d getMousePos() {
        return GuiControl.getMousePos(this.width, this.height);
    }

    public abstract void drawOverlay(FontRenderer var1);

    public void renderControls(FontRenderer fontRenderer) {
        for (int i = this.controls.size() - 1; i >= 0; --i) {
            GuiControl control = this.controls.get(i);
            if (!control.visible || control.posY + control.height < 0 || control.posY > this.height) continue;
            control.renderControl(fontRenderer, 0);
        }
    }

    public void renderTooltip(FontRenderer fontRenderer) {
        Vector2d mouse = this.getMousePos();
        for (int i = 0; i < this.controls.size(); ++i) {
            Vector2d pos = this.controls.get(i).getValidPos((int)mouse.x, (int)mouse.y);
            if (!this.controls.get((int)i).visible || !this.controls.get(i).isMouseOver((int)pos.x, (int)pos.y)) continue;
            ArrayList<String> tooltip = this.controls.get(i).getTooltip();
            if (this.raiseEvent(new GuiToolTipEvent(tooltip, this.controls.get(i)))) {
                RenderHelper2D.drawHoveringText(tooltip, (int)mouse.x, (int)mouse.y, fontRenderer, this.width, this.height);
            }
            return;
        }
    }

    public void onTick() {
    }

    public void drawForeground(FontRenderer fontRenderer) {
        this.onTick();
        this.renderControls(fontRenderer);
        this.drawOverlay(fontRenderer);
        if (this.isTopLayer()) {
            this.renderTooltip(fontRenderer);
        }
    }

    public void drawBackground() {
        int k = (this.width - this.width) / 2;
        int l = (this.height - this.height) / 2;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        mc.func_110434_K().func_110577_a(GuiContainerSub.background);
        int frameSX = 176;
        int frameSY = 166;
        SubGui.drawTexturedModalRect(k, l, 0, 0, 6, 6);
        SubGui.drawTexturedModalRect(k + this.width - 6, l, 170, 0, 6, 6);
        SubGui.drawTexturedModalRect(k, l + this.height - 6, 0, 160, 6, 6);
        SubGui.drawTexturedModalRect(k + this.width - 6, l + this.height - 6, 170, 160, 6, 6);
        float sizeX = 164.0f;
        float amountX = (float)(this.width - 12) / sizeX;
        int i = 0;
        while (amountX > 0.0f) {
            float percent = 1.0f;
            if (amountX < 1.0f) {
                percent = amountX;
            }
            SubGui.drawTexturedModalRect(k + 6 + (int)((float)i * sizeX), l, 6, 0, (int)Math.ceil(sizeX * percent), 6);
            SubGui.drawTexturedModalRect(k + 6 + (int)((float)i * sizeX), l + this.height - 6, 6, 160, (int)Math.ceil(sizeX * percent), 6);
            amountX -= 1.0f;
            ++i;
        }
        float sizeY = 154.0f;
        float amountY = (float)(this.height - 12) / sizeY;
        i = 0;
        while (amountY > 0.0f) {
            float percent = 1.0f;
            if (amountY < 1.0f) {
                percent = amountY;
            }
            SubGui.drawTexturedModalRect(k, l + 6 + (int)((float)i * sizeY), 0, 6, 6, (int)Math.ceil(sizeY * percent));
            SubGui.drawTexturedModalRect(k + this.width - 6, l + 6 + (int)((float)i * sizeY), 170, 6, 6, (int)Math.ceil(sizeY * percent));
            amountY -= 1.0f;
            ++i;
        }
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2929);
        GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
        Vector4d color = new Vector4d(198.0, 198.0, 198.0, 255.0);
        RenderHelper2D.drawGradientRect(k + 6, l + 6, k + this.width - 6, l + this.height - 6, color, color);
        GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
    }

    public static void drawTexturedModalRect(int x, int y, int u, int v, int width, int height) {
        boolean zLevel = false;
        float f = 0.00390625f;
        float f1 = 0.00390625f;
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a((double)(x + 0), (double)(y + height), (double)zLevel, (double)((float)(u + 0) * f), (double)((float)(v + height) * f1));
        tessellator.func_78374_a((double)(x + width), (double)(y + height), (double)zLevel, (double)((float)(u + width) * f), (double)((float)(v + height) * f1));
        tessellator.func_78374_a((double)(x + width), (double)(y + 0), (double)zLevel, (double)((float)(u + width) * f), (double)((float)(v + 0) * f1));
        tessellator.func_78374_a((double)(x + 0), (double)(y + 0), (double)zLevel, (double)((float)(u + 0) * f), (double)((float)(v + 0) * f1));
        tessellator.func_78381_a();
    }
}

