/*
 * Decompiled with CFR 0.152.
 */
package openblocks;

import cpw.mods.fml.common.IFuelHandler;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.RegistryDelegate;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraftforge.common.ChestGenHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.oredict.RecipeSorter;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import openblocks.OpenBlocks;
import openblocks.common.Stencil;
import openblocks.common.TrophyHandler;
import openblocks.common.item.ItemImaginary;
import openblocks.common.item.ItemPaintBrush;
import openblocks.common.item.MetasBucket;
import openblocks.common.item.MetasGeneric;
import openblocks.common.item.MetasGenericUnstackable;
import openblocks.common.recipe.CrayonGlassesRecipe;
import openblocks.common.recipe.CrayonMixingRecipe;
import openblocks.common.recipe.EpicEraserRecipe;
import openblocks.common.recipe.GoldenEyeRechargeRecipe;
import openblocks.common.recipe.MapCloneRecipe;
import openblocks.common.recipe.MapResizeRecipe;
import openblocks.enchantments.EnchantmentExplosive;
import openblocks.enchantments.EnchantmentFlimFlam;
import openblocks.enchantments.EnchantmentLastStand;
import openblocks.enchantments.ExplosiveEnchantmentsHandler;
import openblocks.enchantments.FlimFlamEnchantmentsHandler;
import openblocks.enchantments.LastStandEnchantmentsHandler;
import openmods.config.properties.ConfigProperty;
import openmods.config.properties.OnLineModifiable;
import openmods.utils.ColorUtils;

public class Config {
    @OnLineModifiable
    @ConfigProperty(category="dropblock", name="searchDistance", comment="The range of the drop block")
    public static int elevatorTravelDistance = 20;
    @OnLineModifiable
    @ConfigProperty(category="dropblock", name="ignoreAllBlocks", comment="Disable limit of blocks between elevators (equivalent to maxPassThrough = infinity)")
    public static boolean elevatorIgnoreBlocks = false;
    @OnLineModifiable
    @ConfigProperty(category="dropblock", name="ignoreHalfBlocks", comment="The elevator will ignore half blocks when counting the blocks it can pass through")
    public static boolean elevatorIgnoreHalfBlocks = false;
    @OnLineModifiable
    @ConfigProperty(category="dropblock", name="maxPassThrough", comment="The maximum amount of blocks the elevator can pass through before the teleport fails")
    public static int elevatorMaxBlockPassCount = 4;
    @OnLineModifiable
    @ConfigProperty(category="dropblock", name="centerOnBlock", comment="Should elevator move player to center of block after teleporting\t")
    public static boolean elevatorCenter = false;
    @OnLineModifiable
    @ConfigProperty(category="dropblock", name="specialBlockRules", comment="Defines blocks that are handled specially by elevators. Entries are in form <modId>:<blockName>:<action> or id:<blockId>:<action>. Possible actions: abort (elevator can't pass block), increment (counts for elevatorMaxBlockPassCount limit) and ignore")
    public static String[] elevatorRules = new String[0];
    @OnLineModifiable
    @ConfigProperty(category="dropblock", name="elevatorXpDrainRatio", comment="XP consumed by elevator (total amount = ratio * distance)")
    public static float elevatorXpDrainRatio = 0.0f;
    @ConfigProperty(category="tanks", name="bucketsPerTank", comment="The amount of buckets each tank can hold")
    public static int bucketsPerTank = 16;
    @OnLineModifiable
    @ConfigProperty(category="tanks", name="tankTicks", comment="Should tanks try to balance liquid amounts with neighbours")
    public static boolean shouldTanksUpdate = true;
    @OnLineModifiable
    @ConfigProperty(category="tanks", name="displayAllFluids", comment="Should filled tanks be searchable with creative menu")
    public static boolean displayAllFilledTanks = true;
    @OnLineModifiable
    @ConfigProperty(category="tanks", name="fluidDifferenceUpdateThreshold", comment="Minimal difference in fluid level between neigbors required for tank update (can be used for performance finetuning")
    public static int tankFluidUpdateThreshold = 0;
    @OnLineModifiable
    @ConfigProperty(category="trophy", name="trophyDropChance", comment="Legacy value. For actual configuration, see 'trophyDropChanceFormula'")
    public static double trophyDropChance = 0.001;
    @OnLineModifiable
    @ConfigProperty(category="trophy", name="trophyDropChanceFormula", comment="Formula for calculating trophy drop chance. Trophy drops when result is positive.")
    public static String trophyDropChanceFormula = "let([bias=rand()/4, selection=rand()], (looting + bias) * chance - selection)";
    @OnLineModifiable
    @ConfigProperty(category="dropblock", name="irregularBlocksArePassable", comment="The elevator will try to pass through blocks that have custom collision boxes")
    public static boolean irregularBlocksArePassable = true;
    @OnLineModifiable
    @ConfigProperty(category="tanks", name="emitLight", comment="Tanks will emit light when they contain a liquid that glows (eg. lava)")
    public static boolean tanksEmitLight = true;
    @OnLineModifiable
    @ConfigProperty(category="sprinkler", name="fertilizeChance", comment="1/chance that crops will be fertilized without bonemeal")
    public static int sprinklerFertilizeChance = 500;
    @OnLineModifiable
    @ConfigProperty(category="sprinkler", name="bonemealFertilizeChance", comment="1/chance that crops will be fertilized with bonemeal")
    public static int sprinklerBonemealFertizizeChance = 200;
    @OnLineModifiable
    @ConfigProperty(category="sprinkler", name="effectiveRange", comment="The range in each cardinal direction that crops will be affected.")
    public static int sprinklerEffectiveRange = 4;
    @ConfigProperty(category="sprinkler", name="internalTankCapacity", comment="Capacity (in mB) of internal tank.")
    public static int sprinklerInternalTank = 50;
    @OnLineModifiable
    @ConfigProperty(category="sprinkler", name="bonemealConsumeRate", comment="Consume rate of bonemeal (ticks/item).")
    public static int sprinklerBonemealConsumeRate = 600;
    @OnLineModifiable
    @ConfigProperty(category="sprinkler", name="waterConsumeRate", comment="Consume rate of sprinkler (ticks/mB).")
    public static int sprinklerWaterConsumeRate = 20;
    @OnLineModifiable
    @ConfigProperty(category="glasses", name="opacity", comment="0.0 - no visible change to world, 1.0 - world fully obscured")
    public static double sonicGlassesOpacity = 0.95;
    @OnLineModifiable
    @ConfigProperty(category="glasses", name="useTexture", comment="Use texture for obscuring world")
    public static boolean sonicGlassesUseTexture = true;
    @OnLineModifiable
    @ConfigProperty(category="imaginary", name="fadingSpeed", comment="Speed of imaginary blocks fading/appearing")
    public static float imaginaryFadingSpeed = 0.0075f;
    @ConfigProperty(category="imaginary", name="numberOfUses", comment="Number of newly created crayon/pencil uses")
    public static float imaginaryItemUseCount = 10.0f;
    @ConfigProperty(category="crane", name="doCraneCollisionCheck", comment="Enable collision checking of crane arm")
    public static boolean doCraneCollisionCheck = false;
    @OnLineModifiable
    @ConfigProperty(category="crane", name="boringMode", comment="Use shift to control crane direction (otherwise, toggle every time)")
    public static boolean craneShiftControl = true;
    @OnLineModifiable
    @ConfigProperty(category="crane", name="turtleMagnetRange", comment="Range of magnet CC peripheral")
    public static double turtleMagnetRange = 32.0;
    @OnLineModifiable
    @ConfigProperty(category="crane", name="turtleMagnetDeactivateRange", comment="Maximal distance from turtle to magnet when deactivating")
    public static double turtleMagnetRangeDeactivate = 3.0;
    @ConfigProperty(category="crane", name="addTurtles", comment="Enable magnet turtles")
    public static boolean enableCraneTurtles = true;
    @ConfigProperty(category="crane", name="showTurtles", comment="Show magnet turtles in creative list")
    public static boolean showCraneTurtles = true;
    @ConfigProperty(category="hacks", name="enableExperimentalFeatures", comment="Enable experimental features that may be buggy or broken entirely")
    public static boolean experimentalFeatures = false;
    @ConfigProperty(category="tomfoolery", name="weAreSeriousPeople", comment="Are you serious too?")
    public static boolean soSerious = true;
    @OnLineModifiable
    @ConfigProperty(category="tomfoolery", name="doItWhileTyping", comment="You know, THAT thing! That you shouldn't do in public!")
    public static boolean fartTypying = false;
    @OnLineModifiable
    @ConfigProperty(category="tomfoolery", name="flimFlamBlacklist", comment="Blacklist/Whitelist for effects used by flim-flam enchantment")
    public static String[] flimFlamList = new String[0];
    @OnLineModifiable
    @ConfigProperty(category="tomfoolery", name="reverseBlacklist", comment="If true, flim-flam blacklist will become whitelist")
    public static boolean flimFlamWhitelist = false;
    @OnLineModifiable
    @ConfigProperty(category="tomfoolery", name="safeOnly", comment="Allow only flimflams that don't cause death (or at least very rarely)")
    public static boolean safeFlimFlams = false;
    @OnLineModifiable
    @ConfigProperty(category="tomfoolery", name="sillyLoreDisplay", comment="0 - lore hidden, 1 - visible only with pressed ALT, 2 - always visible")
    public static int loreDisplay = 1;
    @OnLineModifiable
    @ConfigProperty(category="debug", name="goldenEyeDebug", comment="Show structures found by golden eye")
    public static boolean eyeDebug = false;
    @OnLineModifiable
    @ConfigProperty(category="debug", name="gravesDebug", comment="Dump extra amount of data, every time grave is created")
    public static boolean debugGraves = false;
    @OnLineModifiable
    @ConfigProperty(category="graves", name="destructiveGraves", comment="Try to overwrite blocks with graves if no suitable place is found on first try")
    public static boolean destructiveGraves = false;
    @OnLineModifiable
    @ConfigProperty(category="graves", name="spawnRange", comment="Size of cube searched for spaces suitable for grave spawning")
    public static int graveSpawnRange = 10;
    @OnLineModifiable
    @ConfigProperty(category="graves", name="storeContents", comment="Store contents of spawned graves into separate NBT files (can later be restored with ob_inventory command)")
    public static boolean backupGraves = true;
    @OnLineModifiable
    @ConfigProperty(category="graves", name="spawnSkeletons", comment="Should grave randomly spawn skeletons")
    public static boolean spawnSkeletons = true;
    @OnLineModifiable
    @ConfigProperty(category="graves", name="skeletonSpawnRate", comment="Spawn rate, range: 0..1, default: about 1 per 50s")
    public static double skeletonSpawnRate = 0.002;
    @OnLineModifiable
    @ConfigProperty(category="graves", name="requiresGraveInInv", comment="Require gravestone to be in a player's inventory (it is consumed)")
    public static boolean requiresGraveInInv = false;
    @OnLineModifiable
    @ConfigProperty(category="graves", name="specialActionFrequency", comment="Frequency of special action on grave digging, 0..1")
    public static double graveSpecialAction = 0.03;
    @OnLineModifiable
    @ConfigProperty(category="graves", name="canSpawnBase", comment="Can grave spawn single block of dirt when it has no block under?")
    public static boolean graveBase = true;
    @OnLineModifiable
    @ConfigProperty(category="graves", name="minimalPosY", comment="Minimal height where grave should be spawned (default value selected to prevent spawning in bedrock)")
    public static int minGraveY = 6;
    @OnLineModifiable
    @ConfigProperty(category="graves", name="maximalPosY", comment="Maximal height where grave should be spawned (default value selected to prevent spawning in bedrock)")
    public static int maxGraveY = 249;
    @ConfigProperty(category="features", name="explosiveEnchantmentId", comment="Id of explosive enchantment")
    public static int explosiveEnchantmentId = 211;
    @ConfigProperty(category="features", name="lastStandEnchantmentId", comment="Id of last stand enchantment")
    public static int lastStandEnchantmentId = 212;
    @ConfigProperty(category="features", name="flimFlamEnchantmentId", comment="Id of flim flam enchantment")
    public static int flimFlamEnchantmentId = 213;
    @ConfigProperty(category="features", name="explosiveEnchantGrief", comment="Explosive enchant can break blocks at level 3")
    public static boolean explosiveEnchantGrief = true;
    @OnLineModifiable
    @ConfigProperty(category="features", name="lastStandFormula", comment="Formula for XP cost (variables: hp,dmg,ench,xp). Note: calculation only triggers when hp - dmg < 1.")
    public static String lastStandEnchantmentFormula = "max(1, 50*(1-(hp-dmg))/ench)";
    @ConfigProperty(category="cursor", name="cursorMaxDistance", comment="Maximum distance cursor can reach (warning: increasing may cause crashes)")
    public static int cursorDistanceLimit = 64;
    @OnLineModifiable
    @ConfigProperty(category="additional", name="disableMobNames", comment="List any mob names you want disabled on the server")
    public static String[] disableMobNames = new String[0];
    @OnLineModifiable
    @ConfigProperty(category="additional", name="dumpDeadPlayersInventories", comment="Should player inventories be stored after death (can be later restored with ob_inventory command)")
    public static boolean dumpStiffsStuff = true;
    @OnLineModifiable
    @ConfigProperty(category="cartographer", name="blockBlacklist", comment="List of blocks that should be invisible to cartographer. Example: id:3,  OpenBlocks:openblocks_radio (case sensitive)")
    public static String[] mapBlacklist = new String[]{"Natura:Cloud"};
    @OnLineModifiable
    @ConfigProperty(category="cartographer", name="reportInvalidRequest", comment="Should invalid height map request be always reported")
    public static boolean alwaysReportInvalidMapRequests = false;
    @ConfigProperty(category="radio", name="radioVillagerId", comment="Music merchant id (-1 to disable)")
    public static int radioVillagerId = 6156;
    @OnLineModifiable
    @ConfigProperty(category="radio", name="radioVillagerSellsRecords", comment="Should tuned crystals sell records too")
    public static boolean radioVillagerRecords = true;
    @OnLineModifiable
    @ConfigProperty(category="fan", name="fanForce", comment="Maximum force applied every tick to entities nearby (linear decay)")
    public static double fanForce = 0.05;
    @OnLineModifiable
    @ConfigProperty(category="fan", name="fanRange", comment="Range of fan in blocks")
    public static double fanRange = 10.0;
    @OnLineModifiable
    @ConfigProperty(category="fan", name="isRedstoneActivated", comment="Is fan force controlled by redstone current")
    public static boolean redstoneActivatedFan = true;
    @ConfigProperty(category="sponge", name="spongeStickUseCount", comment="SpongeOnAStick use count")
    public static int spongeMaxDamage = 256;
    @OnLineModifiable
    @ConfigProperty(category="sponge", name="spongeRange", comment="Sponge block range (distance from center)")
    public static int spongeRange = 3;
    @OnLineModifiable
    @ConfigProperty(category="sponge", name="spongeRange", comment="Sponge block range (distance from center)")
    public static int spongeStickRange = 3;
    @ConfigProperty(category="projector", name="lightUpWhenWorking", comment="Projector will light up whenever it is displaying a map")
    public static boolean litWhenDisplayingMap = true;
    @ConfigProperty(category="projector", name="renderHolographicCone", comment="Projector will render a holographic cone whenever active")
    public static boolean renderHoloCone = true;
    @ConfigProperty(category="projector", name="brightness", comment="The projector's cone will use the specified brightness value to render.\nValue must be between 0 and 255 inclusive. To use the default world brightness set -1 as the value.\nKeep in mind that default brightness means that the cone will render as light blue during the day and dark blue during the night.")
    public static int coneBrightness = -1;
    @ConfigProperty(category="projector", name="lightLevel", comment="Level of light emitted by the active projector. Defaults to 10. Must be at maximum 15 and positive")
    public static int projectorLightLevelValue = 10;
    @ConfigProperty(category="projector", name="renderHolographicGrid", comment="The holographic cone will display a grid.\nThe grid texture may look a bit pixelated and there may be a little gap between two corners.\nThis is not an error and it is only a texture calculation problem (e.g. 0.25 does not correctly correspond to 16 pixels in a 64x64 texture)")
    public static boolean renderHoloGrid = false;
    @OnLineModifiable
    @ConfigProperty(category="loot", name="donationStation")
    public static boolean donationStationLoot = false;
    @OnLineModifiable
    @ConfigProperty(category="loot", name="sonicGlasses")
    public static boolean sonicGlassesLoot = false;
    @OnLineModifiable
    @ConfigProperty(category="loot", name="technicolorGlasses")
    public static boolean technicolorGlassesLoot = true;
    @OnLineModifiable
    @ConfigProperty(category="loot", name="stencil")
    public static boolean stencilLoot = false;
    @OnLineModifiable
    @ConfigProperty(category="loot", name="paintBrush")
    public static boolean paintBrushLoot = false;
    @OnLineModifiable
    @ConfigProperty(category="features", name="infoBook", comment="Should every player get info book on first login")
    public static boolean spamInfoBook = true;
    @ConfigProperty(category="features", name="xpToLiquidRatio", comment="Storage in mB needed to store single XP point")
    public static int xpToLiquidRatio = 20;
    @OnLineModifiable
    @ConfigProperty(category="guide", name="redstoneSensitivity", comment="How builder guide should react to redstone. 0 - not sensitive, 1 - powered == on, -1 - inverted")
    public static int guideRedstone = 1;
    @OnLineModifiable
    @ConfigProperty(category="guide", name="renderDistanceSq", comment="Square of guide maximum render distance")
    public static double guideRenderRangeSq = 65536.0;
    @ConfigProperty(category="guide", name="useAdvancedRenderer", comment="Try to use advanced OpenGL for performance improvement")
    public static boolean useAdvancedRenderer = true;
    @OnLineModifiable
    @ConfigProperty(category="scaffolding", name="despawnRate", comment="The rate at which scaffolding should break. 0 - fastest")
    public static int scaffoldingDespawnRate = 4;
    @OnLineModifiable
    @ConfigProperty(category="egg", name="pickBlocks", comment="Can golden egg pick blocks while hatching (may lead to glitches)")
    public static boolean eggCanPickBlocks = true;
    @OnLineModifiable
    @ConfigProperty(category="magnet", name="pickEntities", comment="Can crane magnet pick entities?")
    public static boolean canMagnetPickEntities = true;
    @OnLineModifiable
    @ConfigProperty(category="magnet", name="pickBlocks", comment="Can crane magnet pick block?")
    public static boolean canMagnetPickBlocks = true;
    @OnLineModifiable
    @ConfigProperty(category="ladder", name="infiniteMode", comment="If true, ladders will behave in old way: single item will place ladder all the way down, but it will not drop when broken")
    public static boolean infiniteLadder = false;
    @OnLineModifiable
    @ConfigProperty(category="devnull", name="sneakClickToGui", comment="If true, /dev/null will require sneaking in addition to clicking air to open gui")
    public static boolean devNullSneakGui = true;
    @OnLineModifiable
    @ConfigProperty(category="hangglider", name="enableThermal", comment="Enable a whole new level of hanggliding experience through thermal lift. See keybindings for acoustic vario controls")
    public static boolean hanggliderEnableThermal = true;

    public static void register() {
        WeightedRandomChestContent drop;
        List recipeList = CraftingManager.func_77594_a().func_77592_b();
        MetasGeneric.registerItems();
        OpenBlocks.Items.generic.initRecipes();
        MetasGenericUnstackable.registerItems();
        OpenBlocks.Items.genericUnstackable.initRecipes();
        if (OpenBlocks.Blocks.ladder != null) {
            recipeList.add(new ShapelessOreRecipe((Block)OpenBlocks.Blocks.ladder, new Object[]{Blocks.field_150468_ap, Blocks.field_150415_aT}));
        }
        if (OpenBlocks.Blocks.guide != null) {
            recipeList.add(new ShapedOreRecipe((Block)OpenBlocks.Blocks.guide, new Object[]{"grg", "gtg", "grg", Character.valueOf('g'), "blockGlass", Character.valueOf('t'), Blocks.field_150478_aa, Character.valueOf('r'), "dustRedstone"}));
        }
        if (OpenBlocks.Blocks.builderGuide != null) {
            recipeList.add(new ShapedOreRecipe((Block)OpenBlocks.Blocks.builderGuide, new Object[]{"grg", "ete", "grg", Character.valueOf('g'), "blockGlass", Character.valueOf('t'), Blocks.field_150478_aa, Character.valueOf('r'), "dustRedstone", Character.valueOf('e'), Items.field_151079_bi}));
        }
        if (OpenBlocks.Blocks.elevator != null) {
            recipeList.add(new ShapedOreRecipe((Block)OpenBlocks.Blocks.elevator, new Object[]{"www", "wew", "www", Character.valueOf('w'), Blocks.field_150325_L, Character.valueOf('e'), Items.field_151079_bi}));
        }
        if (OpenBlocks.Blocks.elevatorRotating != null) {
            recipeList.add(new ShapedOreRecipe((Block)OpenBlocks.Blocks.elevatorRotating, new Object[]{"wiw", "wew", "wiw", Character.valueOf('w'), Blocks.field_150325_L, Character.valueOf('e'), Items.field_151079_bi, Character.valueOf('i'), "ingotIron"}));
            if (OpenBlocks.Blocks.elevator != null) {
                recipeList.add(new ShapelessOreRecipe((Block)OpenBlocks.Blocks.elevatorRotating, new Object[]{OpenBlocks.Blocks.elevator, "ingotIron", "ingotIron"}));
            }
        }
        if (OpenBlocks.Blocks.target != null) {
            recipeList.add(new ShapedOreRecipe((Block)OpenBlocks.Blocks.target, new Object[]{"www", "www", "s s", Character.valueOf('w'), Blocks.field_150325_L, Character.valueOf('s'), "stickWood"}));
        }
        if (OpenBlocks.Blocks.flag != null) {
            recipeList.add(new ShapedOreRecipe(new ItemStack((Block)OpenBlocks.Blocks.flag, 3), new Object[]{"scc", "sc ", "s  ", Character.valueOf('c'), Blocks.field_150404_cg, Character.valueOf('s'), "stickWood"}));
        }
        if (OpenBlocks.Blocks.tank != null) {
            recipeList.add(new ShapedOreRecipe(new ItemStack((Block)OpenBlocks.Blocks.tank, 2), new Object[]{"ogo", "ggg", "ogo", Character.valueOf('g'), "paneGlass", Character.valueOf('o'), Blocks.field_150343_Z}));
        }
        if (OpenBlocks.Blocks.trophy != null) {
            MinecraftForge.EVENT_BUS.register((Object)new TrophyHandler());
        }
        if (OpenBlocks.Blocks.bearTrap != null) {
            recipeList.add(new ShapedOreRecipe((Block)OpenBlocks.Blocks.bearTrap, new Object[]{"fif", "fif", "fif", Character.valueOf('f'), Blocks.field_150411_aY, Character.valueOf('i'), "ingotIron"}));
        }
        if (OpenBlocks.Blocks.sprinkler != null) {
            recipeList.add(new ShapedOreRecipe((Block)OpenBlocks.Blocks.sprinkler, new Object[]{"ifi", "iri", "ifi", Character.valueOf('i'), "ingotIron", Character.valueOf('r'), Blocks.field_150429_aA, Character.valueOf('f'), Blocks.field_150411_aY}));
        }
        if (OpenBlocks.Blocks.cannon != null) {
            recipeList.add(new ShapedOreRecipe((Block)OpenBlocks.Blocks.cannon, new Object[]{" d ", " f ", "iri", Character.valueOf('d'), Blocks.field_150367_z, Character.valueOf('f'), Blocks.field_150411_aY, Character.valueOf('i'), "ingotIron", Character.valueOf('r'), "blockRedstone"}));
        }
        if (OpenBlocks.Blocks.vacuumHopper != null) {
            recipeList.add(new ShapelessOreRecipe((Block)OpenBlocks.Blocks.vacuumHopper, new Object[]{Blocks.field_150438_bZ, Blocks.field_150343_Z, Items.field_151061_bv}));
        }
        if (OpenBlocks.Blocks.sponge != null) {
            recipeList.add(new ShapelessOreRecipe((Block)OpenBlocks.Blocks.sponge, new Object[]{Blocks.field_150325_L, "slimeball"}));
        }
        if (OpenBlocks.Blocks.bigButton != null) {
            recipeList.add(new ShapedOreRecipe((Block)OpenBlocks.Blocks.bigButton, new Object[]{"bb", "bb", Character.valueOf('b'), Blocks.field_150430_aB}));
        }
        if (OpenBlocks.Blocks.imaginary != null) {
            ItemStack pencil = ItemImaginary.setupValues(null, new ItemStack((Block)OpenBlocks.Blocks.imaginary, 1, 0));
            recipeList.add(new ShapelessOreRecipe(pencil, new Object[]{Items.field_151044_h, "stickWood", Items.field_151061_bv, "slimeball"}));
            for (ColorUtils.ColorMeta colorMeta : ColorUtils.getAllColors()) {
                ItemStack crayon = ItemImaginary.setupValues(colorMeta.rgb, new ItemStack((Block)OpenBlocks.Blocks.imaginary, 1, 1));
                recipeList.add(new ShapelessOreRecipe(crayon, new Object[]{colorMeta.oreName, Items.field_151121_aF, Items.field_151061_bv, "slimeball"}));
            }
            recipeList.add(new CrayonMixingRecipe());
            RecipeSorter.register((String)"openblocks:crayon_mix", CrayonMixingRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"after:minecraft:shapeless");
        }
        if (OpenBlocks.Blocks.fan != null) {
            recipeList.add(new ShapedOreRecipe((Block)OpenBlocks.Blocks.fan, new Object[]{"f", "i", "s", Character.valueOf('f'), Blocks.field_150411_aY, Character.valueOf('i'), "ingotIron", Character.valueOf('s'), Blocks.field_150333_U}));
        }
        if (OpenBlocks.Blocks.xpBottler != null) {
            recipeList.add(new ShapedOreRecipe((Block)OpenBlocks.Blocks.xpBottler, new Object[]{"iii", "ibi", "iii", Character.valueOf('i'), "ingotIron", Character.valueOf('b'), Items.field_151069_bo}));
        }
        if (OpenBlocks.Blocks.villageHighlighter != null) {
            recipeList.add(new ShapedOreRecipe((Block)OpenBlocks.Blocks.villageHighlighter, new Object[]{"www", "wew", "ccc", Character.valueOf('w'), "plankWood", Character.valueOf('e'), "gemEmerald", Character.valueOf('c'), "cobblestone"}));
        }
        if (OpenBlocks.Blocks.path != null) {
            recipeList.add(new ShapelessOreRecipe(new ItemStack((Block)OpenBlocks.Blocks.path, 2), new Object[]{"stone", "cobblestone"}));
        }
        if (OpenBlocks.Blocks.autoAnvil != null) {
            recipeList.add(new ShapedOreRecipe((Block)OpenBlocks.Blocks.autoAnvil, new Object[]{"iii", "iai", "rrr", Character.valueOf('i'), "ingotIron", Character.valueOf('a'), Blocks.field_150467_bQ, Character.valueOf('r'), "dustRedstone"}));
        }
        if (OpenBlocks.Blocks.autoEnchantmentTable != null) {
            recipeList.add(new ShapedOreRecipe((Block)OpenBlocks.Blocks.autoEnchantmentTable, new Object[]{"iii", "iei", "rrr", Character.valueOf('i'), "ingotIron", Character.valueOf('e'), Blocks.field_150381_bn, Character.valueOf('r'), "dustRedstone"}));
        }
        if (OpenBlocks.Blocks.xpDrain != null) {
            recipeList.add(new ShapedOreRecipe((Block)OpenBlocks.Blocks.xpDrain, new Object[]{"iii", "iii", "iii", Character.valueOf('i'), Blocks.field_150411_aY}));
        }
        if (OpenBlocks.Blocks.blockBreaker != null) {
            recipeList.add(new ShapedOreRecipe((Block)OpenBlocks.Blocks.blockBreaker, new Object[]{"icc", "src", "icc", Character.valueOf('i'), "ingotIron", Character.valueOf('c'), "cobblestone", Character.valueOf('r'), "dustRedstone", Character.valueOf('s'), Items.field_151046_w}));
        }
        if (OpenBlocks.Blocks.blockPlacer != null) {
            recipeList.add(new ShapedOreRecipe((Block)OpenBlocks.Blocks.blockPlacer, new Object[]{"icc", "src", "icc", Character.valueOf('i'), "ingotIron", Character.valueOf('c'), "cobblestone", Character.valueOf('r'), "dustRedstone", Character.valueOf('s'), Blocks.field_150331_J}));
        }
        if (OpenBlocks.Blocks.itemDropper != null) {
            recipeList.add(new ShapedOreRecipe((Block)OpenBlocks.Blocks.itemDropper, new Object[]{"icc", "src", "icc", Character.valueOf('i'), "ingotIron", Character.valueOf('c'), "cobblestone", Character.valueOf('r'), "dustRedstone", Character.valueOf('s'), Blocks.field_150438_bZ}));
        }
        if (OpenBlocks.Blocks.ropeLadder != null) {
            recipeList.add(new ShapedOreRecipe(new ItemStack((Block)OpenBlocks.Blocks.ropeLadder, 8), new Object[]{"sts", "sts", "sts", Character.valueOf('t'), "stickWood", Character.valueOf('s'), Items.field_151007_F}));
        }
        if (OpenBlocks.Blocks.donationStation != null) {
            drop = new WeightedRandomChestContent(new ItemStack((Block)OpenBlocks.Blocks.donationStation), 1, 1, 2);
            if (donationStationLoot) {
                ChestGenHooks.getInfo((String)"dungeonChest").addItem(drop);
                ChestGenHooks.getInfo((String)"mineshaftCorridor").addItem(drop);
            }
            recipeList.add(new ShapedOreRecipe((Block)OpenBlocks.Blocks.donationStation, new Object[]{"ppp", "pcp", "ppp", Character.valueOf('p'), Items.field_151147_al, Character.valueOf('c'), "chestWood"}));
        }
        if (OpenBlocks.Blocks.paintMixer != null) {
            recipeList.add(new ShapedOreRecipe((Block)OpenBlocks.Blocks.paintMixer, new Object[]{"ooo", "i i", "iii", Character.valueOf('o'), Blocks.field_150343_Z, Character.valueOf('i'), "ingotIron"}));
        }
        if (OpenBlocks.Blocks.canvas != null) {
            recipeList.add(new ShapedOreRecipe(new ItemStack((Block)OpenBlocks.Blocks.canvas, 9), new Object[]{"ppp", "pfp", "ppp", Character.valueOf('p'), Items.field_151121_aF, Character.valueOf('f'), Blocks.field_150422_aJ}));
        }
        if (OpenBlocks.Blocks.projector != null) {
            recipeList.add(new ShapedOreRecipe((Block)OpenBlocks.Blocks.projector, new Object[]{"grl", "iri", "srs", Character.valueOf('s'), Blocks.field_150333_U, Character.valueOf('r'), "dustRedstone", Character.valueOf('g'), "dustGlowstone", Character.valueOf('i'), "ingotIron", Character.valueOf('l'), "gemLapis"}));
            recipeList.add(new ShapedOreRecipe((Block)OpenBlocks.Blocks.projector, new Object[]{"lrg", "iri", "srs", Character.valueOf('s'), Blocks.field_150333_U, Character.valueOf('r'), "dustRedstone", Character.valueOf('g'), "dustGlowstone", Character.valueOf('i'), "ingotIron", Character.valueOf('l'), "gemLapis"}));
        }
        if (OpenBlocks.Blocks.goldenEgg != null) {
            recipeList.add(new ShapedOreRecipe((Block)OpenBlocks.Blocks.goldenEgg, new Object[]{"ggg", "geg", "ggg", Character.valueOf('g'), "ingotGold", Character.valueOf('e'), Items.field_151110_aK}));
        }
        if (OpenBlocks.Blocks.sky != null) {
            ItemStack normal6 = new ItemStack((Block)OpenBlocks.Blocks.sky, 6, 0);
            ItemStack itemStack = new ItemStack((Block)OpenBlocks.Blocks.sky, 1, 1);
            ItemStack inverted = new ItemStack((Block)OpenBlocks.Blocks.sky, 1, 0);
            recipeList.add(new ShapedOreRecipe(normal6, new Object[]{"geg", "gsg", "geg", Character.valueOf('g'), "blockGlassColorless", Character.valueOf('e'), Items.field_151061_bv, Character.valueOf('s'), Blocks.field_150377_bs}));
            recipeList.add(new ShapelessOreRecipe(inverted, new Object[]{itemStack, Blocks.field_150429_aA}));
            recipeList.add(new ShapelessOreRecipe(itemStack, new Object[]{inverted, Blocks.field_150429_aA}));
        }
        if (OpenBlocks.Blocks.drawingTable != null) {
            recipeList.add(new ShapedOreRecipe((Block)OpenBlocks.Blocks.drawingTable, new Object[]{"sks", "pcp", "ppp", Character.valueOf('p'), "plankWood", Character.valueOf('c'), "craftingTableWood", Character.valueOf('s'), MetasGeneric.unpreparedStencil.newItemStack(), Character.valueOf('k'), MetasGeneric.sketchingPencil.newItemStack()}));
        }
        if (OpenBlocks.Blocks.xpShower != null) {
            recipeList.add(new ShapedOreRecipe((Block)OpenBlocks.Blocks.xpShower, new Object[]{"iii", "  o", Character.valueOf('i'), "ingotIron", Character.valueOf('o'), Blocks.field_150343_Z}));
        }
        if (OpenBlocks.Blocks.scaffolding != null) {
            ItemStack result = new ItemStack((Block)OpenBlocks.Blocks.scaffolding, 8);
            recipeList.add(new ShapedOreRecipe(result, new Object[]{"sss", "s s", "sss", Character.valueOf('s'), "stickWood"}));
            final RegistryDelegate registryDelegate = result.func_77973_b().delegate;
            GameRegistry.registerFuelHandler((IFuelHandler)new IFuelHandler(){

                public int getBurnTime(ItemStack fuel) {
                    return fuel.func_77973_b() == registryDelegate.get() ? 100 : 0;
                }
            });
        }
        if (OpenBlocks.Items.hangGlider != null) {
            recipeList.add(new ShapedOreRecipe((Item)OpenBlocks.Items.hangGlider, new Object[]{"wsw", Character.valueOf('w'), MetasGeneric.gliderWing.newItemStack(), Character.valueOf('s'), "stickWood"}));
        }
        if (OpenBlocks.Items.luggage != null) {
            recipeList.add(new ShapedOreRecipe((Item)OpenBlocks.Items.luggage, new Object[]{"sds", "scs", "sss", Character.valueOf('s'), "stickWood", Character.valueOf('d'), "gemDiamond", Character.valueOf('c'), "chestWood"}));
        }
        if (OpenBlocks.Items.sonicGlasses != null) {
            recipeList.add(new ShapedOreRecipe((Item)OpenBlocks.Items.sonicGlasses, new Object[]{"ihi", "oso", "   ", Character.valueOf('s'), "stickWood", Character.valueOf('h'), Items.field_151028_Y, Character.valueOf('o'), Blocks.field_150343_Z, Character.valueOf('i'), "ingotIron"}));
            ItemStack stack = new ItemStack((Item)OpenBlocks.Items.sonicGlasses);
            if (sonicGlassesLoot) {
                WeightedRandomChestContent weightedRandomChestContent = new WeightedRandomChestContent(stack, 1, 1, 2);
                ChestGenHooks.getInfo((String)"dungeonChest").addItem(weightedRandomChestContent);
            }
        }
        if (OpenBlocks.Blocks.imaginary != null) {
            if (OpenBlocks.Items.pencilGlasses != null) {
                ItemStack block = new ItemStack((Block)OpenBlocks.Blocks.imaginary, 1, 0);
                ItemImaginary.setupValues(null, block);
                recipeList.add(new ShapelessOreRecipe((Item)OpenBlocks.Items.pencilGlasses, new Object[]{block, Items.field_151121_aF}));
            }
            if (OpenBlocks.Items.crayonGlasses != null) {
                recipeList.add(new CrayonGlassesRecipe());
                RecipeSorter.register((String)"openblocks:crayon_glasses", CrayonGlassesRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"after:minecraft:shapeless");
            }
            if (technicolorGlassesLoot && OpenBlocks.Items.technicolorGlasses != null) {
                drop = new WeightedRandomChestContent(new ItemStack((Item)OpenBlocks.Items.technicolorGlasses), 1, 1, 2);
                ChestGenHooks.getInfo((String)"dungeonChest").addItem(drop);
                ChestGenHooks.getInfo((String)"mineshaftCorridor").addItem(drop);
            }
        }
        if (OpenBlocks.Items.craneControl != null) {
            recipeList.add(new ShapedOreRecipe((Item)OpenBlocks.Items.craneControl, new Object[]{"ili", "grg", "iri", Character.valueOf('i'), "ingotIron", Character.valueOf('g'), "nuggetGold", Character.valueOf('l'), "dustGlowstone", Character.valueOf('r'), "dustRedstone"}));
        }
        if (OpenBlocks.Items.craneBackpack != null) {
            ItemStack line = MetasGeneric.line.newItemStack();
            ItemStack itemStack = MetasGeneric.beam.newItemStack();
            recipeList.add(new ShapelessOreRecipe((Item)OpenBlocks.Items.craneBackpack, new Object[]{MetasGeneric.craneEngine.newItemStack(), MetasGeneric.craneMagnet.newItemStack(), itemStack, itemStack, line, line, line, Items.field_151116_aA}));
        }
        if (OpenBlocks.Items.slimalyzer != null) {
            recipeList.add(new ShapedOreRecipe((Item)OpenBlocks.Items.slimalyzer, new Object[]{"igi", "isi", "iri", Character.valueOf('i'), "ingotIron", Character.valueOf('g'), "paneGlass", Character.valueOf('s'), "slimeball", Character.valueOf('r'), "dustRedstone"}));
        }
        if (OpenBlocks.Items.sleepingBag != null) {
            recipeList.add(new ShapedOreRecipe((Item)OpenBlocks.Items.sleepingBag, new Object[]{"cc ", "www", "ccw", Character.valueOf('c'), Blocks.field_150404_cg, Character.valueOf('w'), Blocks.field_150325_L}));
        }
        if (OpenBlocks.Items.paintBrush != null) {
            recipeList.add(new ShapedOreRecipe((Item)OpenBlocks.Items.paintBrush, new Object[]{"w  ", " s ", "  s", Character.valueOf('w'), Blocks.field_150325_L, Character.valueOf('s'), "stickWood"}));
            ItemStack template = new ItemStack((Item)OpenBlocks.Items.paintBrush, 1, Short.MAX_VALUE);
            for (ColorUtils.ColorMeta color : ColorUtils.getAllColors()) {
                ItemStack brush = ItemPaintBrush.createStackWithColor(color.rgb);
                recipeList.add(new ShapelessOreRecipe(brush, new Object[]{template, color.oreName}));
            }
            if (paintBrushLoot) {
                for (int color : new int[]{0xFF0000, 65280, 255}) {
                    ItemStack stack = ItemPaintBrush.createStackWithColor(color);
                    WeightedRandomChestContent drop3 = new WeightedRandomChestContent(stack, 1, 1, 2);
                    ChestGenHooks.getInfo((String)"dungeonChest").addItem(drop3);
                    ChestGenHooks.getInfo((String)"villageBlacksmith").addItem(drop3);
                    ChestGenHooks.getInfo((String)"bonusChest").addItem(drop3);
                    ChestGenHooks.getInfo((String)"mineshaftCorridor").addItem(drop3);
                }
            }
        }
        if (OpenBlocks.Items.stencil != null && stencilLoot) {
            for (Stencil stencil : Stencil.values()) {
                WeightedRandomChestContent drop4 = new WeightedRandomChestContent(new ItemStack((Item)OpenBlocks.Items.stencil, 1, stencil.ordinal()), 1, 1, 2);
                ChestGenHooks.getInfo((String)"dungeonChest").addItem(drop4);
                ChestGenHooks.getInfo((String)"mineshaftCorridor").addItem(drop4);
            }
        }
        if (OpenBlocks.Items.squeegee != null) {
            if (OpenBlocks.Blocks.sponge != null) {
                recipeList.add(new ShapedOreRecipe((Item)OpenBlocks.Items.squeegee, new Object[]{"sss", " w ", " w ", Character.valueOf('s'), OpenBlocks.Blocks.sponge, Character.valueOf('w'), "stickWood"}));
            } else {
                recipeList.add(new ShapedOreRecipe((Item)OpenBlocks.Items.squeegee, new Object[]{"sss", " w ", " w ", Character.valueOf('s'), "slimeball", Character.valueOf('w'), "stickWood"}));
            }
        }
        if (OpenBlocks.Items.emptyMap != null) {
            if (OpenBlocks.Items.heightMap != null) {
                recipeList.add(new MapCloneRecipe());
                RecipeSorter.register((String)"openblocks:map_clone", MapCloneRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"after:minecraft:shapeless");
            }
            recipeList.add(new MapResizeRecipe());
            RecipeSorter.register((String)"openblocks:map_resize", MapResizeRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPED, (String)"after:minecraft:shaped");
            ItemStack memory = MetasGeneric.mapMemory.newItemStack(2);
            ItemStack itemStack = MetasGeneric.mapController.newItemStack(1);
            recipeList.add(new ShapedOreRecipe(OpenBlocks.Items.emptyMap.createMap(0), new Object[]{" m ", "mcm", " m ", Character.valueOf('m'), memory, Character.valueOf('c'), itemStack}));
        }
        if (OpenBlocks.Items.cartographer != null) {
            recipeList.add(new ShapelessOreRecipe((Item)OpenBlocks.Items.cartographer, new Object[]{MetasGeneric.assistantBase.newItemStack(), Items.field_151061_bv}));
        }
        if (OpenBlocks.Items.goldenEye != null) {
            recipeList.add(new GoldenEyeRechargeRecipe());
            RecipeSorter.register((String)"openblocks:golden_eye_recharge", GoldenEyeRechargeRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"after:minecraft:shapeless");
            recipeList.add(new ShapedOreRecipe(new ItemStack((Item)OpenBlocks.Items.goldenEye, 1, 100), new Object[]{"ggg", "geg", "ggg", Character.valueOf('g'), "nuggetGold", Character.valueOf('e'), Items.field_151061_bv}));
        }
        if (OpenBlocks.Items.tastyClay != null) {
            ItemStack cocoa = ColorUtils.ColorMeta.BROWN.createStack(Items.field_151100_aR, 1);
            recipeList.add(new ShapelessOreRecipe(new ItemStack((Item)OpenBlocks.Items.tastyClay, 2), new Object[]{Items.field_151119_aD, Items.field_151117_aB, cocoa}));
        }
        if (OpenBlocks.Items.cursor != null) {
            ItemStack whiteWool = ColorUtils.ColorMeta.WHITE.createStack(Blocks.field_150325_L, 1);
            recipeList.add(new ShapedOreRecipe((Item)OpenBlocks.Items.cursor, new Object[]{"w  ", "www", "www", Character.valueOf('w'), whiteWool}));
        }
        if (OpenBlocks.Items.infoBook != null) {
            recipeList.add(new ShapelessOreRecipe(new ItemStack((Item)OpenBlocks.Items.infoBook), new Object[]{Items.field_151119_aD, Items.field_151122_aG}));
        }
        if (OpenBlocks.Items.devNull != null) {
            recipeList.add(new ShapelessOreRecipe(new ItemStack((Item)OpenBlocks.Items.devNull), new Object[]{"cobblestone", Items.field_151034_e}));
        }
        if (OpenBlocks.Items.spongeonastick != null && OpenBlocks.Blocks.sponge != null) {
            recipeList.add(new ShapedOreRecipe((Item)OpenBlocks.Items.spongeonastick, new Object[]{" s ", " w ", " w ", Character.valueOf('s'), OpenBlocks.Blocks.sponge, Character.valueOf('w'), "stickWood"}));
        }
        if (OpenBlocks.Items.pedometer != null) {
            recipeList.add(new ShapedOreRecipe((Item)OpenBlocks.Items.pedometer, new Object[]{"www", "rcr", "www", Character.valueOf('w'), "plankWood", Character.valueOf('r'), "dustRedstone", Character.valueOf('c'), Items.field_151113_aN}));
        }
        if (OpenBlocks.Items.epicEraser != null) {
            recipeList.add(new EpicEraserRecipe());
            RecipeSorter.register((String)"openblocks:epic_eraser", EpicEraserRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"after:minecraft:shapeless");
            recipeList.add(new ShapelessOreRecipe((Item)OpenBlocks.Items.epicEraser, new Object[]{"gemLapis", "slimeball", Blocks.field_150325_L}));
        }
        if (OpenBlocks.Items.filledBucket != null) {
            MetasBucket.registerItems();
            MetasBucket.xpbucket.registerAsBucketFor(OpenBlocks.Fluids.xpJuice);
        }
        if (OpenBlocks.Items.wrench != null) {
            recipeList.add(new ShapedOreRecipe((Item)OpenBlocks.Items.wrench, new Object[]{"iii", "iii", Character.valueOf('i'), "ingotIron"}));
        }
        if (explosiveEnchantmentId > 0) {
            MinecraftForge.EVENT_BUS.register((Object)new ExplosiveEnchantmentsHandler());
            OpenBlocks.Enchantments.explosive = new EnchantmentExplosive(explosiveEnchantmentId);
        }
        if (lastStandEnchantmentId > 0) {
            MinecraftForge.EVENT_BUS.register((Object)new LastStandEnchantmentsHandler());
            OpenBlocks.Enchantments.lastStand = new EnchantmentLastStand(lastStandEnchantmentId);
        }
        if (flimFlamEnchantmentId > 0) {
            MinecraftForge.EVENT_BUS.register((Object)new FlimFlamEnchantmentsHandler());
            OpenBlocks.Enchantments.flimFlam = new EnchantmentFlimFlam(flimFlamEnchantmentId);
            for (int i = 0; i < 4; ++i) {
                int n = 1 << i;
                ItemStack result = Items.field_151134_bR.func_92111_a(new EnchantmentData(OpenBlocks.Enchantments.flimFlam, i + 1));
                Object[] recipe = new Object[n + 1];
                recipe[0] = Items.field_151122_aG;
                Arrays.fill(recipe, 1, recipe.length, "gemEmerald");
                recipeList.add(new ShapelessOreRecipe(result, recipe));
            }
        }
    }
}

