/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.renderer.element;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.malisis.core.renderer.RenderParameters;
import net.malisis.core.renderer.animation.transformation.ITransformable;
import net.malisis.core.renderer.element.Face;
import net.malisis.core.renderer.element.MergedVertex;
import net.malisis.core.renderer.element.Vertex;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.util.ForgeDirection;
import org.apache.commons.lang3.ArrayUtils;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

public class Shape
implements ITransformable.Translate,
ITransformable.Rotate,
ITransformable.Scale {
    protected Face[] faces;
    protected Matrix4f transformMatrix = new Matrix4f();
    protected Map<String, MergedVertex> mergedVertexes;

    public void reset() {
        for (Face f : this.faces) {
            f.reset();
        }
        this.resetMatrix();
        if (this.mergedVertexes != null) {
            this.mergedVertexes.clear();
        }
    }

    public Shape() {
        this.resetMatrix();
        this.faces = new Face[0];
    }

    public Shape(int capacity) {
        this.resetMatrix();
        this.faces = new Face[capacity];
    }

    public Shape(Face ... faces) {
        this.resetMatrix();
        this.faces = faces;
    }

    public Shape(List<Face> faces) {
        this(faces.toArray(new Face[0]));
    }

    public Shape(Shape s) {
        this.resetMatrix();
        Face[] shapeFaces = s.getFaces();
        this.faces = new Face[shapeFaces.length];
        for (int i = 0; i < shapeFaces.length; ++i) {
            this.faces[i] = new Face(shapeFaces[i]);
        }
        this.copyMatrix(s);
    }

    public Shape copy(Shape s) {
        if (this.faces.length != s.faces.length) {
            this.faces = new Face[s.faces.length];
        }
        for (int i = 0; i < s.faces.length; ++i) {
            this.faces[i].copy(s.faces[i]);
        }
        this.copyMatrix(s);
        return this;
    }

    public Shape addFaces(Face[] faces) {
        return this.addFaces(faces, null);
    }

    public Shape addFaces(Face[] faces, String groupName) {
        if (groupName != null) {
            for (Face f : faces) {
                f.setName(groupName);
            }
        }
        this.faces = (Face[])ArrayUtils.addAll((Object[])this.faces, (Object[])faces);
        return this;
    }

    public List<Face> getFaces(String name) {
        ArrayList<Face> list = new ArrayList<Face>();
        for (Face f : this.faces) {
            if (!f.name().equalsIgnoreCase(name)) continue;
            list.add(f);
        }
        return list;
    }

    public Face getFace(String name) {
        List<Face> list = this.getFaces(name);
        return !list.isEmpty() ? list.get(0) : null;
    }

    public Shape removeFace(Face face) {
        if (this.mergedVertexes != null) {
            for (Vertex v : face.getVertexes()) {
                MergedVertex mv = this.getMergedVertex(v);
                mv.removeVertex(v);
            }
        }
        this.faces = (Face[])ArrayUtils.removeElement((Object[])this.faces, (Object)face);
        return this;
    }

    public void enableMergedVertexes() {
        if (this.mergedVertexes != null) {
            return;
        }
        this.mergedVertexes = MergedVertex.getMergedVertexes(this);
        for (MergedVertex mv : this.mergedVertexes.values()) {
            mv.copyMatrix(this.transformMatrix);
        }
    }

    public List<Vertex> getVertexes(String name) {
        ArrayList<Vertex> vertexes = new ArrayList<Vertex>();
        for (Face f : this.faces) {
            for (Vertex v : f.getVertexes()) {
                if (!v.baseName().toLowerCase().contains(name.toLowerCase())) continue;
                vertexes.add(v);
            }
        }
        return vertexes;
    }

    public List<Vertex> getVertexes(Face face) {
        if (face == null) {
            return new ArrayList<Vertex>();
        }
        return this.getVertexes(face.name());
    }

    public List<Vertex> getVertexes(ForgeDirection direction) {
        return this.getVertexes(Face.nameFromDirection(direction));
    }

    public MergedVertex getMergedVertex(Vertex vertex) {
        if (this.mergedVertexes == null) {
            return null;
        }
        return this.mergedVertexes.get(vertex.baseName());
    }

    public List<MergedVertex> getMergedVertexes(String ... names) {
        if (this.mergedVertexes == null || names == null || names.length == 0) {
            return new ArrayList<MergedVertex>();
        }
        ArrayList<MergedVertex> vertexes = new ArrayList<MergedVertex>();
        for (MergedVertex mv : this.mergedVertexes.values()) {
            if (!mv.is(names)) continue;
            vertexes.add(mv);
        }
        return vertexes;
    }

    public List<MergedVertex> getMergedVertexes(Face face) {
        if (face == null) {
            return new ArrayList<MergedVertex>();
        }
        return this.getMergedVertexes(face.name());
    }

    public List<MergedVertex> getMergedVertexes(ForgeDirection direction) {
        return this.getMergedVertexes(Face.nameFromDirection(direction));
    }

    protected void resetMatrix() {
        this.transformMatrix.identity();
        this.transformMatrix.translate(0.5f, 0.5f, 0.5f);
    }

    public Shape copyMatrix(Shape shape) {
        this.transformMatrix.set((Matrix4fc)shape.transformMatrix);
        return this;
    }

    public Shape applyMatrix() {
        if (this.mergedVertexes != null) {
            for (MergedVertex mv : this.mergedVertexes.values()) {
                mv.applyMatrix();
            }
            return this;
        }
        this.transformMatrix.translate(-0.5f, -0.5f, -0.5f);
        for (Face f : this.faces) {
            for (Vertex v : f.getVertexes()) {
                if (v == null) continue;
                v.applyMatrix(this.transformMatrix);
            }
        }
        this.resetMatrix();
        return this;
    }

    public Shape setParameters(RenderParameters params, boolean merge) {
        for (Face f : this.faces) {
            if (merge) {
                f.getParameters().merge(params);
                continue;
            }
            f.setParameters(params);
        }
        return this;
    }

    public Shape setParameters(String name, RenderParameters params, boolean merge) {
        for (Face f : this.faces) {
            if (!f.name.equalsIgnoreCase(name)) continue;
            if (merge) {
                f.getParameters().merge(params);
                continue;
            }
            f.setParameters(params);
        }
        return this;
    }

    public Shape setSize(float width, float height, float depth) {
        float x = 0.0f;
        float y = 0.0f;
        float z = 0.0f;
        for (Face f : this.faces) {
            for (Vertex v : f.getVertexes()) {
                int flags = v.getDirectionFlags();
                if ((flags & Vertex.WEST) != 0) {
                    x = (float)v.getX();
                }
                if ((flags & Vertex.DOWN) != 0) {
                    y = (float)v.getY();
                }
                if ((flags & Vertex.NORTH) == 0) continue;
                z = (float)v.getZ();
            }
        }
        return this.setBounds(x, y, z, x + width, y + height, z + depth);
    }

    public Shape setBounds(AxisAlignedBB aabb) {
        if (aabb == null) {
            return this;
        }
        return this.setBounds(aabb.field_72340_a, aabb.field_72338_b, aabb.field_72339_c, aabb.field_72336_d, aabb.field_72337_e, aabb.field_72334_f);
    }

    public Shape setBounds(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        for (Face f : this.faces) {
            for (Vertex v : f.getVertexes()) {
                int flags = v.getDirectionFlags();
                if ((flags & Vertex.WEST) != 0) {
                    v.setX(minX);
                }
                if ((flags & Vertex.EAST) != 0) {
                    v.setX(maxX);
                }
                if ((flags & Vertex.DOWN) != 0) {
                    v.setY(minY);
                }
                if ((flags & Vertex.UP) != 0) {
                    v.setY(maxY);
                }
                if ((flags & Vertex.NORTH) != 0) {
                    v.setZ(minZ);
                }
                if ((flags & Vertex.SOUTH) == 0) continue;
                v.setZ(maxZ);
            }
        }
        return this;
    }

    public Shape limit(AxisAlignedBB aabb) {
        return this.limit(aabb.field_72340_a, aabb.field_72338_b, aabb.field_72339_c, aabb.field_72336_d, aabb.field_72337_e, aabb.field_72334_f);
    }

    public Shape limit(double x, double y, double z, double X, double Y, double Z) {
        for (Face f : this.faces) {
            for (Vertex v : f.getVertexes()) {
                v.setX(Vertex.clamp(v.getX(), x, X));
                v.setY(Vertex.clamp(v.getY(), y, Y));
                v.setZ(Vertex.clamp(v.getZ(), z, Z));
            }
        }
        return this;
    }

    @Override
    public void translate(float x, float y, float z) {
        if (this.mergedVertexes != null) {
            for (MergedVertex mv : this.mergedVertexes.values()) {
                mv.translate(x, y, z);
            }
        } else {
            this.transformMatrix.translate(x, y, z);
        }
    }

    public void scale(float factor) {
        this.scale(factor, factor, factor, 0.0f, 0.0f, 0.0f);
    }

    public void scale(float x, float y, float z) {
        this.scale(x, y, z, 0.0f, 0.0f, 0.0f);
    }

    @Override
    public void scale(float x, float y, float z, float offsetX, float offsetY, float offsetZ) {
        if (this.mergedVertexes != null) {
            for (MergedVertex mv : this.mergedVertexes.values()) {
                mv.scale(x, y, z, offsetX, offsetY, offsetZ);
            }
        } else {
            this.translate(offsetX, offsetY, offsetZ);
            this.transformMatrix.scale(x, y, z);
            this.translate(-offsetX, -offsetY, -offsetZ);
        }
    }

    public void rotate(float angle, float x, float y, float z) {
        this.rotate(angle, x, y, z, 0.0f, 0.0f, 0.0f);
    }

    @Override
    public void rotate(float angle, float x, float y, float z, float offsetX, float offsetY, float offsetZ) {
        if (this.mergedVertexes != null) {
            for (MergedVertex mv : this.mergedVertexes.values()) {
                mv.rotate(angle, x, y, z, offsetX, offsetY, offsetZ);
            }
        } else {
            this.translate(offsetX, offsetY, offsetZ);
            this.transformMatrix.rotate((float)Math.toRadians(angle), x, y, z);
            this.translate(-offsetX, -offsetY, -offsetZ);
        }
    }

    public Shape storeState() {
        this.applyMatrix();
        for (Face f : this.faces) {
            for (Vertex v : f.getVertexes()) {
                if (v == null) continue;
                v.setInitialState();
            }
        }
        return this;
    }

    public Shape resetState() {
        this.resetMatrix();
        for (Face f : this.faces) {
            for (Vertex v : f.getVertexes()) {
                if (v == null) continue;
                v.resetState();
            }
        }
        return this;
    }

    public Shape interpolateUV() {
        for (Face f : this.faces) {
            f.interpolateUV();
        }
        return this;
    }

    public Shape shrink(ForgeDirection dir, float factor) {
        Face face = this.getFace(Face.nameFromDirection(dir));
        if (face == null) {
            return this;
        }
        this.enableMergedVertexes();
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        for (Vertex v : face.getVertexes()) {
            x += v.getX() / 4.0;
            y += v.getY() / 4.0;
            z += v.getZ() / 4.0;
        }
        face.scale(factor, x, y, z);
        for (Vertex v : face.getVertexes()) {
            for (Vertex sv : this.mergedVertexes.get(v.baseName())) {
                if (sv == v) continue;
                sv.set(v.getX(), v.getY(), v.getZ());
            }
        }
        return this;
    }

    public void deductParameters() {
        for (Face f : this.faces) {
            f.deductParameters();
        }
    }

    public static Shape fromShapes(Shape ... shapes) {
        Object[] faces = new Face[]{};
        for (Shape s : shapes) {
            s.applyMatrix();
            faces = (Face[])ArrayUtils.addAll((Object[])faces, (Object[])s.getFaces());
        }
        return new Shape((Face[])faces);
    }

    public Shape takeShapes(Shape ... shapes) {
        int i;
        int size = 0;
        for (i = 0; i < shapes.length; ++i) {
            size += shapes[i].faces.length;
        }
        if (this.faces.length != size) {
            this.faces = new Face[size];
        }
        size = 0;
        for (i = 0; i < shapes.length; ++i) {
            shapes[i].applyMatrix();
            System.arraycopy(shapes[i].faces, 0, this.faces, size, shapes[i].faces.length);
            size += shapes[i].faces.length;
        }
        return this;
    }

    public Shape takeFaces(String[] groupNames, Shape ... shapes) {
        int i;
        int size = 0;
        for (i = 0; i < shapes.length; ++i) {
            size += shapes[i].faces.length;
            for (Face f : shapes[i].faces) {
                f.setName(groupNames[i]);
            }
        }
        if (this.faces.length != size) {
            this.faces = new Face[size];
        }
        size = 0;
        for (i = 0; i < shapes.length; ++i) {
            System.arraycopy(shapes[i].faces, 0, this.faces, size, shapes[i].faces.length);
            size += shapes[i].faces.length;
        }
        return this;
    }

    public Face[] getFaces() {
        return this.faces;
    }
}

