/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.renderer.element;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.malisis.core.renderer.element.Vertex;

public class Bezier {
    private List<Vertex> vertexes = new ArrayList<Vertex>();
    private List<Vertex> controlPoints = new ArrayList<Vertex>();
    private int precision;
    private boolean dirty = false;

    public Bezier(List<Vertex> controlPoints, int precision) {
        this.setControlPoints(controlPoints);
        this.setPrecision(precision);
    }

    public Bezier(Vertex[] controlPoints, int precision) {
        this(Arrays.asList(controlPoints), precision);
    }

    public void setControlPoints(List<Vertex> controlPoints) {
        this.controlPoints = controlPoints != null ? controlPoints : new ArrayList();
        this.dirty = true;
    }

    public void addControlPoint(Vertex vertex) {
        this.controlPoints.add(vertex);
        this.dirty = true;
    }

    public void removeControlPoint(Vertex vertex) {
        this.controlPoints.remove(vertex);
        this.dirty = true;
    }

    public List<Vertex> getControlPoints() {
        return this.controlPoints;
    }

    public void setPrecision(int precision) {
        this.precision = precision;
        this.dirty = true;
    }

    public int getPrecision() {
        return this.precision;
    }

    public void markDirty() {
        this.dirty = true;
    }

    private void buildVertexes() {
        this.vertexes.clear();
        if (this.controlPoints.size() == 0) {
            return;
        }
        double step = 1.0 / (double)(this.precision + 1);
        double t = 0.0;
        this.vertexes.add(this.controlPoints.get(0));
        for (int i = 1; i <= this.precision; ++i) {
            t = (double)i * step;
            this.vertexes.add(i, this.interpolateAll(this.controlPoints, this.controlPoints.size() - 1, 0, t));
        }
        this.vertexes.add(this.controlPoints.get(this.controlPoints.size() - 1));
        this.dirty = false;
    }

    public Vertex interpolateAll(List<Vertex> vertexes, int r, int index, double t) {
        if (vertexes.size() == 1) {
            return vertexes.get(0);
        }
        if (r == 0) {
            return vertexes.get(index);
        }
        Vertex v1 = this.interpolateAll(vertexes, r - 1, index, t);
        Vertex v2 = this.interpolateAll(vertexes, r - 1, index + 1, t);
        return this.interpolate(v1, v2, t);
    }

    private Vertex interpolate(Vertex start, Vertex end, double t) {
        double x = this.interpolate(start.getX(), end.getX(), t);
        double y = this.interpolate(start.getY(), end.getY(), t);
        double z = this.interpolate(start.getZ(), end.getZ(), t);
        return new Vertex(x, y, z);
    }

    private double interpolate(double start, double end, double t) {
        return (1.0 - t) * start + t * end;
    }

    public List<Vertex> getVertexes() {
        if (this.dirty) {
            this.buildVertexes();
        }
        return this.vertexes;
    }
}

