/*
 * Decompiled with CFR 0.152.
 */
package advsolar.common.tiles;

import advsolar.common.container.ContainerAdvSolarPanel;
import advsolar.common.tiles.TileEntityBase;
import cpw.mods.fml.common.eventhandler.Event;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergySource;
import ic2.api.energy.tile.IEnergyTile;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import ic2.api.network.INetworkDataProvider;
import ic2.api.network.INetworkUpdateListener;
import ic2.api.tile.IWrenchable;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntitySolarPanel
extends TileEntityBase
implements IEnergyTile,
IWrenchable,
IEnergySource,
IInventory,
INetworkDataProvider,
INetworkUpdateListener {
    public static Random randomizer = new Random();
    public int ticker;
    public int generating;
    public int genDay;
    public int genNight;
    public boolean initialized;
    public boolean sunIsUp;
    public boolean skyIsVisible;
    private short facing = (short)2;
    private boolean noSunWorld;
    private boolean wetBiome;
    private int machineTire;
    public boolean addedToEnergyNet;
    private boolean created = false;
    private ItemStack[] chargeSlots;
    public int fuel;
    private int lastX;
    private int lastY;
    private int lastZ;
    public int storage;
    private int solarType;
    public String panelName;
    public int production;
    public int maxStorage;
    public boolean loaded = false;
    private static List<String> fields = Arrays.asList(new String[0]);

    public TileEntitySolarPanel(String gName, int typeSolar, int gDay, int gNight, int gOutput, int gmaxStorage) {
        this.solarType = typeSolar;
        this.genDay = gDay;
        this.genNight = gNight;
        this.storage = 0;
        this.panelName = gName;
        this.sunIsUp = false;
        this.skyIsVisible = false;
        this.maxStorage = gmaxStorage;
        this.chargeSlots = new ItemStack[4];
        this.initialized = false;
        this.production = gOutput;
        this.ticker = randomizer.nextInt(this.tickRate());
        this.lastX = this.field_145851_c;
        this.lastY = this.field_145848_d;
        this.lastZ = this.field_145849_e;
        this.machineTire = Integer.MAX_VALUE;
    }

    public void func_145829_t() {
        super.func_145829_t();
        if (this.func_145837_r() || !this.field_145850_b.func_72899_e(this.field_145851_c, this.field_145848_d, this.field_145849_e)) {
            return;
        }
        this.onLoaded();
    }

    public void func_145843_s() {
        if (this.loaded) {
            this.onUnloaded();
        }
        super.func_145843_s();
    }

    public void onLoaded() {
        if (!this.field_145850_b.field_72995_K) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent((IEnergyTile)this));
            this.addedToEnergyNet = true;
        }
        this.loaded = true;
    }

    public void onChunkUnload() {
        if (this.loaded) {
            this.onUnloaded();
        }
        super.onChunkUnload();
    }

    public void onUnloaded() {
        if (!this.field_145850_b.field_72995_K && this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent((IEnergyTile)this));
            this.addedToEnergyNet = false;
        }
        this.loaded = false;
    }

    public void intialize() {
        this.wetBiome = this.field_145850_b.func_72959_q().func_76935_a(this.field_145851_c, this.field_145849_e).func_76744_g() > 0;
        this.noSunWorld = this.field_145850_b.field_73011_w.field_76576_e;
        this.updateVisibility();
        this.initialized = true;
        if (!this.addedToEnergyNet) {
            this.onLoaded();
        }
    }

    public void func_145845_h() {
        super.func_145845_h();
        if (!this.initialized && this.field_145850_b != null) {
            this.intialize();
        }
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.lastX != this.field_145851_c || this.lastZ != this.field_145849_e || this.lastY != this.field_145848_d) {
            this.lastX = this.field_145851_c;
            this.lastY = this.field_145848_d;
            this.lastZ = this.field_145849_e;
            this.onUnloaded();
            this.intialize();
        }
        this.gainFuel();
        if (this.generating > 0) {
            this.storage = this.storage + this.generating <= this.maxStorage ? (this.storage += this.generating) : this.maxStorage;
        }
        boolean needInvUpdate = false;
        double sentPacket = 0.0;
        for (int i = 0; i < this.chargeSlots.length; ++i) {
            if (this.chargeSlots[i] == null || !(this.chargeSlots[i].func_77973_b() instanceof IElectricItem) || this.storage <= 0) continue;
            sentPacket = ElectricItem.manager.charge(this.chargeSlots[i], (double)this.storage, Integer.MAX_VALUE, false, false);
            if (sentPacket > 0.0) {
                needInvUpdate = true;
            }
            this.storage = (int)((double)this.storage - sentPacket);
        }
        if (needInvUpdate) {
            super.func_70296_d();
        }
    }

    public int gainFuel() {
        if (this.ticker++ % this.tickRate() == 0) {
            this.updateVisibility();
        }
        if (this.sunIsUp && this.skyIsVisible) {
            this.generating = 0 + this.genDay;
            return this.generating;
        }
        if (this.skyIsVisible) {
            this.generating = 0 + this.genNight;
            return this.generating;
        }
        this.generating = 0;
        return this.generating;
    }

    public void updateVisibility() {
        Boolean rainWeather = this.wetBiome && (this.field_145850_b.func_72896_J() || this.field_145850_b.func_72911_I());
        this.sunIsUp = this.field_145850_b.func_72935_r() && rainWeather == false;
        this.skyIsVisible = this.field_145850_b.func_72937_j(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e) && !this.noSunWorld;
    }

    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.storage = nbttagcompound.func_74762_e("storage");
        this.lastX = nbttagcompound.func_74762_e("lastX");
        this.lastY = nbttagcompound.func_74762_e("lastY");
        this.lastZ = nbttagcompound.func_74762_e("lastZ");
        NBTTagList nbttaglist = nbttagcompound.func_150295_c("Items", 10);
        this.chargeSlots = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound1 = nbttaglist.func_150305_b(i);
            int j = nbttagcompound1.func_74771_c("Slot") & 0xFF;
            if (j < 0 || j >= this.chargeSlots.length) continue;
            this.chargeSlots[j] = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound1);
        }
    }

    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        NBTTagList nbttaglist = new NBTTagList();
        nbttagcompound.func_74768_a("storage", this.storage);
        nbttagcompound.func_74768_a("lastX", this.lastX);
        nbttagcompound.func_74768_a("lastY", this.lastY);
        nbttagcompound.func_74768_a("lastZ", this.lastZ);
        for (int i = 0; i < this.chargeSlots.length; ++i) {
            if (this.chargeSlots[i] == null) continue;
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.func_74774_a("Slot", (byte)i);
            this.chargeSlots[i].func_77955_b(nbttagcompound1);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
        }
        nbttagcompound.func_74782_a("Items", (NBTBase)nbttaglist);
    }

    public boolean isAddedToEnergyNet() {
        return this.addedToEnergyNet;
    }

    public int getMaxEnergyOutput() {
        return this.production;
    }

    public int gaugeEnergyScaled(int i) {
        return this.storage * i / this.maxStorage;
    }

    public int gaugeFuelScaled(int i) {
        return i;
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        return entityplayer.func_70011_f((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public int tickRate() {
        return 128;
    }

    @Override
    public short getFacing() {
        return this.facing;
    }

    @Override
    public void setFacing(short facing) {
        this.facing = facing;
    }

    @Override
    public boolean wrenchCanSetFacing(EntityPlayer entityplayer, int i) {
        return false;
    }

    @Override
    public boolean wrenchCanRemove(EntityPlayer entityplayer) {
        return true;
    }

    @Override
    public float getWrenchDropRate() {
        return 1.0f;
    }

    @Override
    public ItemStack getWrenchDrop(EntityPlayer entityPlayer) {
        return new ItemStack(this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e), 1, this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e));
    }

    public ItemStack[] getContents() {
        return this.chargeSlots;
    }

    public int func_70302_i_() {
        return 4;
    }

    public ItemStack func_70301_a(int i) {
        return this.chargeSlots[i];
    }

    public ItemStack func_70298_a(int i, int j) {
        if (this.chargeSlots[i] != null) {
            if (this.chargeSlots[i].field_77994_a <= j) {
                ItemStack itemstack = this.chargeSlots[i];
                this.chargeSlots[i] = null;
                return itemstack;
            }
            ItemStack itemstack1 = this.chargeSlots[i].func_77979_a(j);
            if (this.chargeSlots[i].field_77994_a == 0) {
                this.chargeSlots[i] = null;
            }
            return itemstack1;
        }
        return null;
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        this.chargeSlots[i] = itemstack;
        if (itemstack != null && itemstack.field_77994_a > this.func_70297_j_()) {
            itemstack.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_145825_b() {
        return "Advanced Solar Panel";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 64;
    }

    public Container getGuiContainer(InventoryPlayer inventoryplayer) {
        return new ContainerAdvSolarPanel(inventoryplayer, this);
    }

    public String getInvName() {
        return null;
    }

    public ItemStack func_70304_b(int var1) {
        if (this.chargeSlots[var1] != null) {
            ItemStack var2 = this.chargeSlots[var1];
            this.chargeSlots[var1] = null;
            return var2;
        }
        return null;
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return true;
    }

    public void onNetworkUpdate(String field) {
    }

    @Override
    public List<String> getNetworkedFields() {
        return fields;
    }

    public boolean emitsEnergyTo(TileEntity receiver, ForgeDirection direction) {
        return true;
    }

    public double getOfferedEnergy() {
        return Math.min(this.production, this.storage);
    }

    public void drawEnergy(double amount) {
        this.storage = (int)((double)this.storage - amount);
    }

    public int getSourceTier() {
        return this.machineTire;
    }
}

