/*
 * Decompiled with CFR 0.152.
 */
package com.github.namikon.angermod.auxiliary;

import com.github.namikon.angermod.AngerMod;
import cpw.mods.fml.common.registry.GameRegistry;
import eu.usrv.yamcore.auxiliary.IntHelper;
import net.minecraft.block.Block;
import net.minecraftforge.event.world.BlockEvent;

public class MinecraftBlock {
    private String _mFQBN;
    private String _mBlockDomain;
    private String _mBlockName;
    private int _mBlockMetaData;
    private int _mDimensionID;

    public MinecraftBlock(String pFullQualifiedBlockName, int pDimensionID) {
        this._mFQBN = pFullQualifiedBlockName;
        this._mDimensionID = pDimensionID;
        String[] tSplitFQBN = this._mFQBN.split(":");
        if (tSplitFQBN.length < 2) {
            AngerMod.Logger.error((Object)String.format("BlockName %s in config is invalid. Make sure you use full [domain]:[blockname] notation!", this._mFQBN));
            throw new IllegalArgumentException(pFullQualifiedBlockName);
        }
        this._mBlockDomain = tSplitFQBN[0];
        this._mBlockName = tSplitFQBN[1];
        if (tSplitFQBN.length > 2) {
            String tMetaData = tSplitFQBN[2];
            this._mBlockMetaData = IntHelper.tryParse((String)tMetaData) ? Integer.parseInt(tMetaData) : -1;
        }
    }

    public boolean isEqualTo(BlockEvent.BreakEvent pEventData) {
        boolean tResult = false;
        int tPlayerDIM = pEventData.getPlayer().field_71093_bK;
        AngerMod.Logger.debug((Object)"BlockCompare begun ");
        try {
            if (tPlayerDIM == this._mDimensionID) {
                AngerMod.Logger.debug((Object)"DimensionID match");
                GameRegistry.UniqueIdentifier tBlockDomain = GameRegistry.findUniqueIdentifierFor((Block)pEventData.block);
                if (tBlockDomain.modId.equalsIgnoreCase(this._mBlockDomain)) {
                    AngerMod.Logger.debug((Object)"_mBlockDomain match");
                    if (tBlockDomain.name.equalsIgnoreCase(this._mBlockName)) {
                        AngerMod.Logger.debug((Object)"_mBlockName match");
                        if (this._mBlockMetaData > 0) {
                            if (this._mBlockMetaData == pEventData.blockMetadata) {
                                AngerMod.Logger.debug((Object)"FullMatch");
                                tResult = true;
                            }
                        } else {
                            AngerMod.Logger.debug((Object)"FullMatch (w/o meta)");
                            tResult = true;
                        }
                    } else {
                        AngerMod.Logger.debug((Object)"_mBlockName match");
                    }
                } else {
                    AngerMod.Logger.debug((Object)"_mBlockDomain mismatch");
                }
            } else {
                AngerMod.Logger.debug((Object)String.format("DimensionID mismatch %d != %d", tPlayerDIM, this._mDimensionID));
            }
        }
        catch (Exception e) {
            AngerMod.Logger.error("MinecraftBlock.isEqualTo.Error", (Object)"Error while comparing Blockidentifier");
            AngerMod.Logger.DumpStack("MinecraftBlock.isEqualTo.Error.Exception", e);
        }
        return tResult;
    }
}

