/*
 * Decompiled with CFR 0.152.
 */
package binnie.extrabees.worldgen;

import binnie.extrabees.ExtraBees;
import binnie.extrabees.worldgen.EnumHiveType;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.apiculture.IHiveDrop;
import forestry.api.core.Tabs;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class BlockExtraBeeHive
extends Block {
    protected IIcon[][] icons;

    public BlockExtraBeeHive() {
        super(ExtraBees.materialBeehive);
        this.func_149715_a(0.2f);
        this.func_149711_c(1.0f);
        this.func_149675_a(true);
        this.func_149663_c("hive");
        this.func_149647_a(Tabs.tabApiculture);
    }

    public String getUnlocalizedName(ItemStack par1ItemStack) {
        return "extrabees.block.hive." + par1ItemStack.func_77960_j();
    }

    public void func_149666_a(Item par1, CreativeTabs par2CreativeTabs, List<ItemStack> itemList) {
        for (int i = 0; i < 4; ++i) {
            itemList.add(new ItemStack((Block)this, 1, i));
        }
    }

    public IIcon func_149691_a(int side, int metadata) {
        if (metadata >= EnumHiveType.values().length) {
            return null;
        }
        if (side < 2) {
            return this.icons[metadata][1];
        }
        return this.icons[metadata][0];
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister register) {
        this.icons = new IIcon[EnumHiveType.values().length][2];
        for (EnumHiveType hive : EnumHiveType.values()) {
            this.icons[hive.ordinal()][0] = ExtraBees.proxy.getIcon(register, "hive/" + hive.toString().toLowerCase() + ".0");
            this.icons[hive.ordinal()][1] = ExtraBees.proxy.getIcon(register, "hive/" + hive.toString().toLowerCase() + ".1");
        }
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        List<IHiveDrop> dropList = EnumHiveType.values()[metadata].drops;
        Collections.shuffle(dropList);
        int tries = 0;
        boolean hasPrincess = false;
        while (tries <= 10 && !hasPrincess) {
            ++tries;
            for (IHiveDrop drop : dropList) {
                if (world.field_73012_v.nextInt(100) >= drop.getChance(world, x, y, z)) continue;
                ret.add(drop.getPrincess(world, x, y, z, fortune));
                break;
            }
            hasPrincess = true;
        }
        for (IHiveDrop drop : dropList) {
            if (world.field_73012_v.nextInt(100) >= drop.getChance(world, x, y, z)) continue;
            ret.addAll(drop.getDrones(world, x, y, z, fortune));
            break;
        }
        for (IHiveDrop drop : dropList) {
            if (world.field_73012_v.nextInt(100) >= drop.getChance(world, x, y, z)) continue;
            ret.addAll(drop.getAdditional(world, x, y, z, fortune));
            break;
        }
        return ret;
    }

    public int func_149692_a(int meta) {
        return meta;
    }
}

