/*
 * Decompiled with CFR 0.152.
 */
package binnie.extrabees.gui.database;

import binnie.Binnie;
import binnie.core.craftgui.CraftGUI;
import binnie.core.craftgui.ITooltip;
import binnie.core.craftgui.IWidget;
import binnie.core.craftgui.Tooltip;
import binnie.core.craftgui.WidgetAttribute;
import binnie.core.craftgui.controls.core.Control;
import binnie.core.craftgui.geometry.IArea;
import binnie.core.craftgui.resource.minecraft.CraftGUITexture;
import forestry.api.apiculture.IAlleleBeeSpecies;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeRoot;
import forestry.api.core.EnumHumidity;
import forestry.api.core.EnumTemperature;
import forestry.api.genetics.EnumTolerance;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;

public class ControlClimateBar
extends Control
implements ITooltip {
    protected boolean isHumidity;
    protected List<Integer> tolerated = new ArrayList<Integer>();
    private static final Color[] TEMP_COLORS = new Color[]{new Color(65531), new Color(7912447), new Color(5242672), new Color(0xFFFF00), new Color(16753152), new Color(0xFF0000)};
    private static final Color[] HUMID_COLORS = new Color[]{new Color(16770979), new Color(1769216), new Color(3177727)};

    public ControlClimateBar(IWidget parent, int x, int y, int width, int height) {
        this(parent, x, y, width, height, false);
    }

    public ControlClimateBar(IWidget parent, int x, int y, int width, int height, boolean humidity) {
        super(parent, x, y, width, height);
        this.addAttribute(WidgetAttribute.MOUSE_OVER);
        this.isHumidity = humidity;
    }

    @Override
    public void getTooltip(Tooltip tooltip) {
        if (this.tolerated.isEmpty()) {
            return;
        }
        int types = this.isHumidity ? 3 : 6;
        int type = (int)((float)((int)(this.getRelativeMousePosition().x() - 1.0f)) / ((this.getSize().x() - 2.0f) / (float)types));
        if (!this.tolerated.contains(type) || type >= types) {
            return;
        }
        if (this.isHumidity) {
            tooltip.add(EnumHumidity.values()[type].name);
        } else {
            tooltip.add(EnumTemperature.values()[type + 1].name);
        }
    }

    @Override
    public void onRenderBackground() {
        CraftGUI.render.texture((Object)CraftGUITexture.EnergyBarBack, this.getArea());
        int types = this.isHumidity ? 3 : 6;
        int w = (int)((this.getSize().x() - 2.0f) / (float)types);
        for (int i = 0; i < types; ++i) {
            int x = i * w;
            if (!this.tolerated.contains(i)) continue;
            Color color = this.isHumidity ? HUMID_COLORS[i] : TEMP_COLORS[i];
            CraftGUI.render.solid(new IArea(x + 1, 1.0f, w, this.getSize().y() - 2.0f), color.getRGB());
        }
        CraftGUI.render.texture((Object)CraftGUITexture.EnergyBarGlass, this.getArea());
    }

    public void setSpecies(IAlleleBeeSpecies species) {
        EnumTolerance tolerance;
        int main;
        this.tolerated.clear();
        if (species == null) {
            return;
        }
        IBeeRoot beeRoot = Binnie.Genetics.getBeeRoot();
        IBeeGenome genome = beeRoot.templateAsGenome(beeRoot.getTemplate(species.getUID()));
        if (!this.isHumidity) {
            main = species.getTemperature().ordinal() - 1;
            tolerance = genome.getToleranceTemp();
        } else {
            main = species.getHumidity().ordinal();
            tolerance = genome.getToleranceHumid();
        }
        this.tolerated.add(main);
        switch (tolerance) {
            case BOTH_5: 
            case UP_5: {
                this.addTolerance(main, 5);
                break;
            }
            case BOTH_4: 
            case UP_4: {
                this.addTolerance(main, 4);
                break;
            }
            case BOTH_3: 
            case UP_3: {
                this.addTolerance(main, 3);
                break;
            }
            case BOTH_2: 
            case UP_2: {
                this.addTolerance(main, 2);
                break;
            }
            case BOTH_1: 
            case UP_1: {
                this.addTolerance(main, 1);
            }
        }
        switch (tolerance) {
            case BOTH_5: 
            case DOWN_5: {
                this.addTolerance(main, -5);
                break;
            }
            case BOTH_4: 
            case DOWN_4: {
                this.addTolerance(main, -4);
                break;
            }
            case BOTH_3: 
            case DOWN_3: {
                this.addTolerance(main, -3);
                break;
            }
            case BOTH_2: 
            case DOWN_2: {
                this.addTolerance(main, -2);
                break;
            }
            case BOTH_1: 
            case DOWN_1: {
                this.addTolerance(main, -1);
            }
        }
    }

    private void addTolerance(int main, int offset) {
        if (main > (offset += main)) {
            for (int i = offset; i < main; ++i) {
                this.tolerated.add(i);
            }
        } else {
            for (int i = offset; i > main; --i) {
                this.tolerated.add(i);
            }
        }
    }
}

