/*
 * Decompiled with CFR 0.152.
 */
package binnie.extrabees.genetics.effect;

import binnie.Binnie;
import binnie.core.Mods;
import binnie.core.util.I18N;
import binnie.extrabees.ExtraBees;
import binnie.extrabees.genetics.ExtraBeesFlowers;
import binnie.extrabees.genetics.effect.EntityBeeLightning;
import binnie.extrabees.genetics.effect.FireworkCreator;
import cofh.api.energy.IEnergyReceiver;
import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.IAlleleBeeEffect;
import forestry.api.apiculture.IArmorApiarist;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IEffectData;
import forestry.core.proxy.Proxies;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityFireworkRocket;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntitySmallFireball;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.IFluidHandler;

public enum ExtraBeesEffect implements IAlleleBeeEffect
{
    ECTOPLASM,
    ACID,
    SPAWN_ZOMBIE,
    SPAWN_SKELETON,
    SPAWN_CREEPER,
    LIGHTNING,
    RADIOACTIVE,
    METEOR,
    HUNGER,
    FOOD,
    BLINDNESS,
    CONFUSION,
    FIREWORKS,
    FESTIVAL,
    BIRTHDAY,
    TELEPORT,
    GRAVITY,
    THIEF,
    WITHER,
    WATER,
    SLOW,
    BONEMEAL_SAPLING,
    BONEMEAL_FRUIT,
    BONEMEAL_MUSHROOM,
    POWER;

    private static final List<Birthday> birthdays;
    public final boolean combinable;
    public final boolean dominant;
    public int id;
    String fx = "";
    private final String uid = this.toString().toLowerCase();

    private ExtraBeesEffect() {
        this.combinable = false;
        this.dominant = true;
    }

    public static void doInit() {
        BLINDNESS.setFX("blindness");
        FOOD.setFX("food");
        GRAVITY.setFX("gravity");
        THIEF.setFX("gravity");
        TELEPORT.setFX("gravity");
        LIGHTNING.setFX("lightning");
        METEOR.setFX("meteor");
        RADIOACTIVE.setFX("radioactive");
        WATER.setFX("water");
        WITHER.setFX("wither");
        for (ExtraBeesEffect effect : ExtraBeesEffect.values()) {
            effect.register();
        }
    }

    public static boolean wearsHelmet(EntityPlayer player) {
        ItemStack armorItem = player.field_71071_by.field_70460_b[3];
        return armorItem != null && armorItem.func_77973_b() instanceof IArmorApiarist;
    }

    public static boolean wearsChest(EntityPlayer player) {
        ItemStack armorItem = player.field_71071_by.field_70460_b[2];
        return armorItem != null && armorItem.func_77973_b() instanceof IArmorApiarist;
    }

    public static boolean wearsLegs(EntityPlayer player) {
        ItemStack armorItem = player.field_71071_by.field_70460_b[1];
        return armorItem != null && armorItem.func_77973_b() instanceof IArmorApiarist;
    }

    public static boolean wearsBoots(EntityPlayer player) {
        ItemStack armorItem = player.field_71071_by.field_70460_b[0];
        return armorItem != null && armorItem.func_77973_b() instanceof IArmorApiarist;
    }

    public static int wearsItems(EntityPlayer player) {
        int count = 0;
        if (ExtraBeesEffect.wearsHelmet(player)) {
            ++count;
        }
        if (ExtraBeesEffect.wearsChest(player)) {
            ++count;
        }
        if (ExtraBeesEffect.wearsLegs(player)) {
            ++count;
        }
        if (ExtraBeesEffect.wearsBoots(player)) {
            ++count;
        }
        return count;
    }

    public void register() {
        AlleleManager.alleleRegistry.registerAllele((IAllele)this);
    }

    public boolean isCombinable() {
        return this.combinable;
    }

    public IEffectData validateStorage(IEffectData storedData) {
        return storedData;
    }

    public String getName() {
        return I18N.localise("extrabees.effect." + this.name().toLowerCase().replace("_", "") + ".name");
    }

    public boolean isDominant() {
        return this.dominant;
    }

    public void spawnMob(World world, int x, int y, int z, String name) {
        if (!this.anyPlayerInRange(world, x, y, z, 16)) {
            return;
        }
        double xOffset = (float)x + world.field_73012_v.nextFloat();
        double yOffset = (float)y + world.field_73012_v.nextFloat();
        double zOffset = (float)z + world.field_73012_v.nextFloat();
        world.func_72869_a("smoke", xOffset, yOffset, zOffset, 0.0, 0.0, 0.0);
        world.func_72869_a("flame", xOffset, yOffset, zOffset, 0.0, 0.0, 0.0);
        EntityLiving entity = (EntityLiving)EntityList.func_75620_a((String)name, (World)world);
        if (entity == null) {
            return;
        }
        int entityCount = world.func_72872_a(entity.getClass(), AxisAlignedBB.func_72330_a((double)x, (double)y, (double)z, (double)(x + 1), (double)(y + 1), (double)(z + 1)).func_72314_b(8.0, 4.0, 8.0)).size();
        if (entityCount >= 6) {
            return;
        }
        xOffset = (double)x + (world.field_73012_v.nextDouble() - world.field_73012_v.nextDouble()) * 4.0;
        yOffset = y + world.field_73012_v.nextInt(3) - 1;
        zOffset = (double)z + (world.field_73012_v.nextDouble() - world.field_73012_v.nextDouble()) * 4.0;
        entity.func_70012_b(xOffset, yOffset, zOffset, world.field_73012_v.nextFloat() * 360.0f, 0.0f);
        if (entity.func_70601_bi()) {
            world.func_72838_d((Entity)entity);
            world.func_72926_e(2004, x, y, z, 0);
            entity.func_70656_aK();
        }
    }

    private boolean anyPlayerInRange(World world, int x, int y, int z, int distance) {
        return world.func_72977_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, (double)distance) != null;
    }

    public String getUID() {
        return "extrabees.effect." + this.uid;
    }

    public IEffectData doEffect(IBeeGenome genome, IEffectData storedData, IBeeHousing housing) {
        World world = housing.getWorld();
        int xHouse = housing.getCoordinates().field_71574_a;
        int yHouse = housing.getCoordinates().field_71572_b;
        int zHouse = housing.getCoordinates().field_71573_c;
        int[] area = this.getModifiedArea(genome, housing);
        int xd = 1 + area[0] / 2;
        int yd = 1 + area[1] / 2;
        int zd = 1 + area[2] / 2;
        int x = xHouse - xd + world.field_73012_v.nextInt(2 * xd + 1);
        int y = yHouse - yd + world.field_73012_v.nextInt(2 * yd + 1);
        int z = zHouse - zd + world.field_73012_v.nextInt(2 * zd + 1);
        switch (this) {
            case ECTOPLASM: {
                this.onEctoplasmEffect(world, x, y, z);
                break;
            }
            case ACID: {
                this.onAcidEffect(world, x, y, z);
                break;
            }
            case SPAWN_ZOMBIE: {
                this.onSpawnMobEffect(world, x, y, z, "Zombie");
                break;
            }
            case SPAWN_SKELETON: {
                this.onSpawnMobEffect(world, x, y, z, "Skeleton");
                break;
            }
            case SPAWN_CREEPER: {
                this.onSpawnMobEffect(world, x, y, z, "Creeper");
                break;
            }
            case LIGHTNING: {
                this.onLightingEffect(world, x, y, z);
                break;
            }
            case METEOR: {
                this.onMeteorEffect(world, x, y, z);
                break;
            }
            case RADIOACTIVE: {
                this.onRadioactiveEffect(genome, housing);
                break;
            }
            case FOOD: {
                this.onFoodEffect(genome, housing);
                break;
            }
            case HUNGER: {
                this.onHungerEffect(genome, housing, world);
                break;
            }
            case BLINDNESS: {
                this.onPotionEffect(genome, housing, world, new PotionEffect(Potion.field_76440_q.field_76415_H, 200));
                break;
            }
            case SLOW: {
                this.onPotionEffect(genome, housing, world, new PotionEffect(Potion.field_76437_t.field_76415_H, 200));
                break;
            }
            case CONFUSION: {
                this.onPotionEffect(genome, housing, world, new PotionEffect(Potion.field_76431_k.field_76415_H, 200));
                break;
            }
            case BIRTHDAY: 
            case FESTIVAL: 
            case FIREWORKS: {
                this.onFeastEffect(genome, world, x, y, z);
                break;
            }
            case GRAVITY: {
                this.onGravityEffect(genome, housing, x, y, z);
                break;
            }
            case THIEF: {
                this.onThiefEffect(genome, housing, x, y, z);
                break;
            }
            case TELEPORT: {
                this.onTeleportEffect(genome, housing, world, x, y, z);
                break;
            }
            case WATER: {
                this.onWaterEffect(world, x, y, z);
                break;
            }
            case BONEMEAL_SAPLING: {
                this.onBonemealSaplingEffect(world, x, y, z);
                break;
            }
            case BONEMEAL_FRUIT: {
                this.onBonemealFruitEffect(world, x, y, z);
                break;
            }
            case BONEMEAL_MUSHROOM: {
                this.onBonemealMushroomEffect(world, x, y, z);
                break;
            }
            case POWER: {
                this.onPowerEffect(world, x, y, z);
            }
        }
        return null;
    }

    private void onLightingEffect(World world, int x, int y, int z) {
        if (world.field_73012_v.nextInt(100) < 1 && world.func_72937_j(x, y, z) && world instanceof WorldServer) {
            world.func_72942_c((Entity)new EntityBeeLightning(world, x, y, z));
        }
    }

    private void onEctoplasmEffect(World world, int x, int y, int z) {
        if (world.field_73012_v.nextInt(100) >= 4) {
            return;
        }
        if (world.func_147437_c(x, y, z) && (world.func_147445_c(x, y - 1, z, false) || world.func_147439_a(x, y - 1, z) == ExtraBees.ectoplasm)) {
            world.func_147465_d(x, y, z, ExtraBees.ectoplasm, 0, 0);
        }
    }

    private void onAcidEffect(World world, int x, int y, int z) {
        if (world.field_73012_v.nextInt(100) >= 6) {
            return;
        }
        Block block = world.func_147439_a(x, y, z);
        if (block == Blocks.field_150347_e || block == Blocks.field_150348_b) {
            world.func_147465_d(x, y, z, Blocks.field_150351_n, 0, 0);
        } else if (block == Blocks.field_150346_d | block == Blocks.field_150349_c) {
            world.func_147465_d(x, y, z, (Block)Blocks.field_150354_m, 0, 0);
        }
    }

    private void onSpawnMobEffect(World world, int x, int y, int z, String mobName) {
        if (world.field_73012_v.nextInt(200) < 2) {
            this.spawnMob(world, x, y, z, mobName);
        }
    }

    private void onMeteorEffect(World world, int x, int y, int z) {
        if (world.field_73012_v.nextInt(100) < 1 && world.func_72937_j(x, y, z)) {
            world.func_72838_d((Entity)new EntitySmallFireball(world, (double)x, (double)(y + 64), (double)z, 0.0, -0.6, 0.0));
        }
    }

    private void onRadioactiveEffect(IBeeGenome genome, IBeeHousing housing) {
        for (EntityLivingBase entity : this.getEntities(EntityLivingBase.class, genome, housing)) {
            int damage = 4;
            if (entity instanceof EntityPlayer) {
                int count = ExtraBeesEffect.wearsItems((EntityPlayer)entity);
                if (count > 3) continue;
                if (count > 2) {
                    damage = 1;
                } else if (count > 1) {
                    damage = 2;
                } else if (count > 0) {
                    damage = 3;
                }
            }
            entity.func_70097_a(DamageSource.field_76377_j, (float)damage);
        }
    }

    private void onFoodEffect(IBeeGenome genome, IBeeHousing housing) {
        for (EntityPlayer player : this.getEntities(EntityPlayer.class, genome, housing)) {
            player.func_71024_bL().func_75122_a(2, 0.2f);
        }
    }

    private void onHungerEffect(IBeeGenome genome, IBeeHousing housing, World world) {
        for (EntityPlayer player : this.getEntities(EntityPlayer.class, genome, housing)) {
            if (world.field_73012_v.nextInt(4) < ExtraBeesEffect.wearsItems(player)) continue;
            player.func_71020_j(4.0f);
            player.func_70690_d(new PotionEffect(Potion.field_76438_s.field_76415_H, 100));
        }
    }

    private void onPotionEffect(IBeeGenome genome, IBeeHousing housing, World world, PotionEffect potion) {
        for (EntityPlayer player : this.getEntities(EntityPlayer.class, genome, housing)) {
            if (world.field_73012_v.nextInt(4) < ExtraBeesEffect.wearsItems(player)) continue;
            player.func_70690_d(potion);
        }
    }

    private void onFeastEffect(IBeeGenome genome, World world, int x, int y, int z) {
        if (world.field_73012_v.nextInt(this == FIREWORKS ? 8 : 12) >= 1) {
            return;
        }
        FireworkCreator.Firework firework = new FireworkCreator.Firework();
        switch (this) {
            case BIRTHDAY: {
                firework.setShape(FireworkCreator.Shape.Star);
                firework.addColor(0xFFDD00);
                for (Birthday birthday : birthdays) {
                    if (!birthday.isToday()) continue;
                    firework.addColor(0xFF0000);
                    firework.addColor(65280);
                    firework.addColor(255);
                    firework.setTrail();
                    break;
                }
            }
            case FIREWORKS: {
                firework.setShape(FireworkCreator.Shape.Ball);
                firework.addColor(genome.getPrimary().getIconColour(0));
                firework.addColor(genome.getPrimary().getIconColour(0));
                firework.addColor(genome.getPrimary().getIconColour(1));
                firework.addColor(genome.getSecondary().getIconColour(0));
                firework.addColor(genome.getSecondary().getIconColour(0));
                firework.addColor(genome.getPrimary().getIconColour(1));
                firework.setTrail();
            }
        }
        EntityFireworkRocket rocket = new EntityFireworkRocket(world, (double)x, (double)y, (double)z, firework.getFirework());
        if (world.func_72937_j(x, y, z)) {
            world.func_72838_d((Entity)rocket);
        }
    }

    private void onGravityEffect(IBeeGenome genome, IBeeHousing housing, int x, int y, int z) {
        List<Entity> entities = this.getEntities(Entity.class, genome, housing);
        for (Entity entity : entities) {
            double dz;
            double dy;
            double dx;
            float entityStrength = 1.0f;
            if (entity instanceof EntityPlayer) {
                entityStrength *= 100.0f;
            }
            if ((dx = (double)x - entity.field_70165_t) * dx + (dy = (double)y - entity.field_70163_u) * dy + (dz = (double)z - entity.field_70161_v) * dz < 2.0) break;
            double strength = 0.5 / (dx * dx + dy * dy + dz * dz) * (double)entityStrength;
            entity.func_70024_g(dx * strength, dy * strength, dz * strength);
        }
    }

    private void onThiefEffect(IBeeGenome genome, IBeeHousing housing, int x, int y, int z) {
        List<EntityPlayer> players = this.getEntities(EntityPlayer.class, genome, housing);
        for (EntityPlayer player : players) {
            double dx = (double)x - player.field_70165_t;
            double dy = (double)y - player.field_70163_u;
            double dz = (double)z - player.field_70161_v;
            if (dx * dx + dy * dy + dz * dz < 2.0) break;
            double strength = 0.5 / (dx * dx + dy * dy + dz * dz);
            player.func_70024_g(-dx * strength, -dy * strength, -dz * strength);
        }
    }

    private void onTeleportEffect(IBeeGenome genome, IBeeHousing housing, World world, int x, int y, int z) {
        if (world.field_73012_v.nextInt(80) > 1) {
            return;
        }
        List<Entity> entities = this.getEntities(Entity.class, genome, housing);
        if (entities.isEmpty()) {
            return;
        }
        Entity entity = entities.get(world.field_73012_v.nextInt(entities.size()));
        if (!(entity instanceof EntityLiving)) {
            return;
        }
        EntityLiving living = (EntityLiving)entity;
        if (y < 4) {
            y = 4;
        }
        if (!world.func_147437_c(x, y, z) || !world.func_147437_c(x, y + 1, z)) {
            return;
        }
        living.func_70634_a((double)x, (double)y, (double)z);
        living.func_70690_d(new PotionEffect(Potion.field_76431_k.field_76415_H, 160, 10));
    }

    private void onWaterEffect(World world, int x, int y, int z) {
        if (world.field_73012_v.nextInt(120) > 1) {
            return;
        }
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof IFluidHandler) {
            ((IFluidHandler)tile).fill(ForgeDirection.UP, Binnie.Liquid.getLiquidStack("water", 100), true);
        }
    }

    private void onBonemealSaplingEffect(World world, int x, int y, int z) {
        if (world.field_73012_v.nextInt(20) > 1) {
            return;
        }
        if (ExtraBeesFlowers.SAPLING.isAcceptedFlower(world, x, y, z)) {
            ItemDye.applyBonemeal((ItemStack)new ItemStack(Blocks.field_150346_d, 1), (World)world, (int)x, (int)y, (int)z, null);
        }
    }

    private void onBonemealFruitEffect(World world, int x, int y, int z) {
        if (world.field_73012_v.nextInt(20) > 1) {
            return;
        }
        if (ExtraBeesFlowers.FRUIT.isAcceptedFlower(world, x, y, z)) {
            ItemDye.applyBonemeal((ItemStack)new ItemStack(Blocks.field_150346_d, 1), (World)world, (int)x, (int)y, (int)z, null);
        }
    }

    private void onBonemealMushroomEffect(World world, int x, int y, int z) {
        if (world.field_73012_v.nextInt(20) > 1) {
            return;
        }
        if (world.func_147439_a(x, y, z) == Blocks.field_150338_P || world.func_147439_a(x, y, z) == Blocks.field_150337_Q) {
            ItemDye.applyBonemeal((ItemStack)new ItemStack(Blocks.field_150346_d, 1), (World)world, (int)x, (int)y, (int)z, null);
        }
    }

    private void onPowerEffect(World world, int x, int y, int z) {
        TileEntity tile2 = world.func_147438_o(x, y, z);
        if (tile2 instanceof IEnergyReceiver) {
            ((IEnergyReceiver)tile2).receiveEnergy(ForgeDirection.getOrientation((int)0), 5, true);
        }
    }

    private int[] getModifiedArea(IBeeGenome genome, IBeeHousing housing) {
        int n3;
        int n2;
        int n;
        int[] territory;
        int[] area = territory = genome.getTerritory();
        int n4 = n = 0;
        territory[n4] = territory[n4] * (int)(BeeManager.beeRoot.createBeeHousingModifier(housing).getTerritoryModifier(genome, 1.0f) * 3.0f);
        int n5 = n2 = 1;
        area[n5] = area[n5] * (int)(BeeManager.beeRoot.createBeeHousingModifier(housing).getTerritoryModifier(genome, 1.0f) * 3.0f);
        int n6 = n3 = 2;
        area[n6] = area[n6] * (int)(BeeManager.beeRoot.createBeeHousingModifier(housing).getTerritoryModifier(genome, 1.0f) * 3.0f);
        if (area[0] < 1) {
            area[0] = 1;
        }
        if (area[1] < 1) {
            area[1] = 1;
        }
        if (area[2] < 1) {
            area[2] = 1;
        }
        return area;
    }

    public IEffectData doFX(IBeeGenome genome, IEffectData storedData, IBeeHousing housing) {
        Proxies.render.addBeeHiveFX("particles/swarm_bee", housing.getWorld(), housing.getBeeFXCoordinates().field_72450_a, housing.getBeeFXCoordinates().field_72448_b, housing.getBeeFXCoordinates().field_72449_c, genome.getPrimary().getIconColour(0));
        return storedData;
    }

    private void setFX(String string) {
        this.fx = "particles/" + string;
    }

    public <T extends Entity> List<T> getEntities(Class<T> eClass, IBeeGenome genome, IBeeHousing housing) {
        int[] area = genome.getTerritory();
        int offsetX = -Math.round((float)area[0] / 2.0f);
        int offsetY = -Math.round((float)area[1] / 2.0f);
        int offsetZ = -Math.round((float)area[2] / 2.0f);
        int minX = housing.getCoordinates().field_71574_a + offsetX;
        int minY = housing.getCoordinates().field_71572_b + offsetY;
        int minZ = housing.getCoordinates().field_71573_c + offsetZ;
        int maxX = housing.getCoordinates().field_71574_a + offsetX + area[0];
        int maxY = housing.getCoordinates().field_71572_b + offsetY + area[1];
        int maxZ = housing.getCoordinates().field_71573_c + offsetZ + area[2];
        AxisAlignedBB box = AxisAlignedBB.func_72330_a((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ);
        return housing.getWorld().func_72872_a(eClass, box);
    }

    public String getUnlocalizedName() {
        return this.getUID();
    }

    static {
        birthdays = new ArrayList<Birthday>();
        if (Mods.dreamcraft.active()) {
            birthdays.add(new Birthday(3, 10, "Binnie"));
        } else {
            birthdays.add(new Birthday(11, 4, "Binnie"));
        }
    }

    public static class Birthday {
        protected int day;
        protected int month;
        protected String name;

        private Birthday(int day, int month, String name) {
            this.day = day;
            this.month = month - 1;
            this.name = name;
        }

        public boolean isToday() {
            return Calendar.getInstance().get(2) == this.month && Calendar.getInstance().get(5) == this.day;
        }

        public String getName() {
            return this.name;
        }
    }
}

