/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.liquid;

import binnie.core.BinnieCore;
import binnie.core.Mods;
import binnie.core.liquid.IFluidType;
import binnie.core.liquid.ItemFluidContainer;
import binnie.core.util.I18N;
import binnie.genetics.item.GeneticsItems;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraftforge.fluids.FluidContainerRegistry;

public enum FluidContainer {
    Bucket,
    Capsule,
    Refractory,
    Can,
    Glass,
    Cylinder;

    private IIcon bottle;
    private IIcon contents;
    ItemFluidContainer item;

    public int getMaxStackSize() {
        return this == Bucket ? 1 : 16;
    }

    @SideOnly(value=Side.CLIENT)
    public void updateIcons(IIconRegister register) {
        String liquidName = "liquids/" + this.toString().toLowerCase();
        String modName = this == Cylinder ? "binniecore" : "forestry";
        this.bottle = BinnieCore.proxy.getIcon(register, modName, liquidName + ".bottle");
        this.contents = BinnieCore.proxy.getIcon(register, modName, liquidName + ".contents");
    }

    public IIcon getBottleIcon() {
        return this.bottle;
    }

    public IIcon getContentsIcon() {
        return this.contents;
    }

    public String getName() {
        return I18N.localise("binniecore.item.container." + this.name().toLowerCase());
    }

    public String getName(String fluid) {
        return I18N.localise("binniecore.item.container." + this.name().toLowerCase() + "." + fluid);
    }

    public boolean isActive() {
        return this.getEmpty() != null;
    }

    public ItemStack getEmpty() {
        ItemStack itemStack;
        switch (this) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case Bucket: {
                itemStack = new ItemStack(Items.field_151133_ar, 1, 0);
                break;
            }
            case Can: {
                itemStack = Mods.forestry.stack("canEmpty");
                break;
            }
            case Capsule: {
                itemStack = Mods.forestry.stack("waxCapsule");
                break;
            }
            case Glass: {
                itemStack = new ItemStack(Items.field_151069_bo, 1, 0);
                break;
            }
            case Refractory: {
                itemStack = Mods.forestry.stack("refractoryEmpty");
                break;
            }
            case Cylinder: {
                itemStack = GeneticsItems.Cylinder.get(1);
            }
        }
        return itemStack;
    }

    public void registerContainerData(IFluidType fluid) {
        if (!this.isActive()) {
            return;
        }
        ItemStack filled = this.item.getContainer(fluid);
        ItemStack empty = this.getEmpty();
        if (filled == null || empty == null || fluid.get(1000) == null) {
            return;
        }
        FluidContainerRegistry.FluidContainerData data = new FluidContainerRegistry.FluidContainerData(fluid.get(1000), filled, empty);
        FluidContainerRegistry.registerFluidContainer((FluidContainerRegistry.FluidContainerData)data);
    }
}

