/*
 * Decompiled with CFR 0.152.
 */
package binnie.botany.network;

import binnie.botany.api.IAlleleFlowerSpecies;
import binnie.botany.flower.TileEntityFlower;
import binnie.botany.genetics.EnumFlowerColor;
import binnie.botany.network.MessageFlowerUpdate;
import binnie.core.BinnieCore;
import binnie.core.network.IPacketID;
import binnie.core.network.packet.MessageBinnie;
import binnie.core.network.packet.MessageNBT;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import cpw.mods.fml.relauncher.Side;
import forestry.api.genetics.AlleleManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;

public enum PacketID implements IPacketID
{
    FieldKit,
    FlowerUpdate;


    @Override
    public void onMessage(MessageBinnie message, MessageContext context) {
        if (this == FieldKit && context.side == Side.CLIENT) {
            this.onFieldKitPacket(message);
        } else if (this == FlowerUpdate) {
            this.onFlowerUpdatePacket(message);
        }
    }

    private void onFlowerUpdatePacket(MessageBinnie message) {
        MessageFlowerUpdate packet = new MessageFlowerUpdate(message);
        TileEntity tile = packet.getTileEntity(BinnieCore.proxy.getWorld());
        if (tile instanceof TileEntityFlower) {
            ((TileEntityFlower)tile).setRender(packet.render);
        }
    }

    private void onFieldKitPacket(MessageBinnie message) {
        MessageNBT packet = new MessageNBT(message);
        NBTTagCompound data = packet.getTagCompound();
        EntityPlayer player = BinnieCore.proxy.getPlayer();
        String info = "";
        if (data.func_82582_d()) {
            info = info + "Flower has not been discovered by you. Breed this flower yourself to discover.";
        } else {
            IAlleleFlowerSpecies primary = (IAlleleFlowerSpecies)AlleleManager.alleleRegistry.getAllele(data.func_74779_i("Species"));
            IAlleleFlowerSpecies secondary = (IAlleleFlowerSpecies)AlleleManager.alleleRegistry.getAllele(data.func_74779_i("Species2"));
            float age = data.func_74760_g("Age");
            EnumFlowerColor color1 = EnumFlowerColor.get(data.func_74765_d("Colour"));
            EnumFlowerColor color2 = EnumFlowerColor.get(data.func_74765_d("Colour2"));
            if (primary == null || secondary == null) {
                return;
            }
            info = info + "A";
            info = age == 0.0f ? info + "" : (age < 0.25f ? info + " Young" : (age < 0.75f ? info + " Mature" : info + " Old"));
            info = color1 == color2 ? info + " " + color1.getName() : info + " " + color1.getName() + " & " + color2.getName();
            info = primary == secondary ? info + " " + primary.getName() : info + " " + primary.getName() + "-" + secondary.getName() + " Hybrid";
            if (age == 0.0f) {
                info = info + " Germling";
            }
            if (data.func_74767_n("Wilting")) {
                info = info + ". Shame it is Wilting!";
            }
        }
        ChatComponentText chat = new ChatComponentText(info);
        player.func_145747_a((IChatComponent)chat);
    }
}

