/*
 * Decompiled with CFR 0.152.
 */
package squeek.spiceoflife.foodtracker;

import java.util.UUID;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import squeek.spiceoflife.ModConfig;
import squeek.spiceoflife.foodtracker.FoodHistory;
import squeek.spiceoflife.foodtracker.ProgressInfo;

public class MaxHealthHandler {
    private static final UUID SOL_HEALTH_MODIFIER_ID = UUID.fromString("f88d6ac1-4193-4ff0-85f5-f0357fe89d17");

    public static boolean updateFoodHPModifier(EntityPlayer player) {
        if (player.field_70170_p.field_72995_K) {
            return false;
        }
        if (!ModConfig.EXTRA_HEARTS_ENABLE) {
            return false;
        }
        IAttributeInstance attribute = player.func_110140_aT().func_111151_a(SharedMonsterAttributes.field_111267_a);
        AttributeModifier prevModifier = attribute.func_111127_a(SOL_HEALTH_MODIFIER_ID);
        FoodHistory foodHistory = FoodHistory.get(player);
        ProgressInfo progressInfo = foodHistory.getProgressInfo();
        int milestonesAchieved = progressInfo.milestonesAchieved();
        double totalHealthModifier = milestonesAchieved * 2 * ProgressInfo.HEARTS_PER_MILESTONE;
        boolean hasChanged = prevModifier == null || prevModifier.func_111164_d() != totalHealthModifier;
        AttributeModifier modifier = new AttributeModifier(SOL_HEALTH_MODIFIER_ID, "Health gained from trying new foods", totalHealthModifier, 0);
        MaxHealthHandler.updateHealthModifier(player, modifier);
        return hasChanged;
    }

    private static void updateHealthModifier(EntityPlayer player, AttributeModifier modifier) {
        float oldMax = player.func_110138_aP();
        IAttributeInstance attribute = player.func_110140_aT().func_111151_a(SharedMonsterAttributes.field_111267_a);
        attribute.func_111124_b(modifier);
        attribute.func_111121_a(modifier);
        float newHealth = player.func_110143_aJ() * player.func_110138_aP() / oldMax;
        player.func_70606_j(0.1f);
        player.func_70606_j(newHealth);
    }
}

