/*
 * Decompiled with CFR 0.152.
 */
package tuhljin.automagy.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.util.ForgeDirection;
import thaumcraft.codechicken.lib.raytracer.IndexedCuboid6;
import thaumcraft.common.Thaumcraft;
import tuhljin.automagy.Automagy;
import tuhljin.automagy.blocks.BlockRedcrystalLarge;
import tuhljin.automagy.lib.RedstoneCalc;
import tuhljin.automagy.lib.TjUtil;
import tuhljin.automagy.lib.struct.WorldSpecificCoordinates;
import tuhljin.automagy.tiles.TileEntityRedcrystalMerc;

public class BlockRedcrystalMerc
extends BlockRedcrystalLarge {
    private WorldSpecificCoordinates lastCoord = null;

    public BlockRedcrystalMerc(String name) {
        super(name);
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 0.32f, 1.0f);
        this.func_149672_a(field_149769_e);
        this.func_149711_c(2.5f);
        this.setHarvestLevel("pickaxe", 0);
    }

    @Override
    public TileEntity func_149915_a(World var1, int var2) {
        TileEntityRedcrystalMerc te = new TileEntityRedcrystalMerc((short)this.nextTEOrientation, this.nextTENoConnections);
        this.nextTEOrientation = -1;
        this.nextTENoConnections = false;
        return te;
    }

    @Override
    public boolean func_149742_c(World world, int x, int y, int z) {
        if (!TjUtil.isAcceptableSurfaceForBlock(world, x, y - 1, z, true, true, false)) {
            return false;
        }
        return world.func_147439_a(x, y, z).isReplaceable((IBlockAccess)world, x, y, z);
    }

    @Override
    public boolean func_149707_d(World world, int x, int y, int z, int side) {
        return TjUtil.isAcceptableSurfaceForBlock(world, x, y - 1, z, true, true, false);
    }

    public boolean func_149718_j(World world, int x, int y, int z) {
        return TjUtil.isAcceptableSurfaceForBlock(world, x, y - 1, z, true, true, false);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_149734_b(World world, int x, int y, int z, Random rand) {
        TileEntityRedcrystalMerc te = null;
        try {
            te = (TileEntityRedcrystalMerc)world.func_147438_o(x, y, z);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (te != null && te.hasValidMirrorConnection()) {
            int color;
            int strength = this.getRedstoneSignalStrength((IBlockAccess)world, x, y, z, true);
            boolean power = strength > 0;
            int n = color = power ? 8 : 6;
            if (power) {
                boolean mirrorIsSource;
                boolean bl = mirrorIsSource = te.strengthWithoutMirror != strength;
                if (rand.nextInt(4) == 0) {
                    int dz;
                    int dy;
                    int dx;
                    int sz;
                    int sy;
                    int sx;
                    if (mirrorIsSource) {
                        sx = te.mirrorX;
                        sy = te.mirrorY;
                        sz = te.mirrorZ;
                        dx = x;
                        dy = y;
                        dz = z;
                    } else {
                        sx = x;
                        sy = y;
                        sz = z;
                        dx = te.mirrorX;
                        dy = te.mirrorY;
                        dz = te.mirrorZ;
                    }
                    Automagy.proxy.ghostlyBallStreamFX(world, (float)sx + 0.5f, (float)sy + 0.5f, (float)sz + 0.5f, (float)dx + 0.5f, (float)dy + 0.5f, (float)dz + 0.5f, 0.05f, 8, false, 0.0f);
                }
                Thaumcraft.proxy.sparkle((float)x + 0.2f + rand.nextFloat() * 0.6f, (float)y + (mirrorIsSource ? 0.8f : 0.5f), (float)z + 0.2f + rand.nextFloat() * 0.6f, 1.0f, color, mirrorIsSource ? 0.1f : -0.1f);
            } else {
                Thaumcraft.proxy.sparkle((float)x + 0.2f + rand.nextFloat() * 0.6f, (float)y + 0.2f, (float)z + 0.2f + rand.nextFloat() * 0.6f, 1.0f, color, -0.1f);
            }
        }
        super.func_149734_b(world, x, y, z, rand);
    }

    @Override
    public void func_149749_a(World world, int x, int y, int z, Block block, int p_149749_6_) {
        TileEntityRedcrystalMerc te = null;
        try {
            te = (TileEntityRedcrystalMerc)world.func_147438_o(x, y, z);
        }
        catch (Exception exception) {
            // empty catch block
        }
        WorldSpecificCoordinates worldSpecificCoordinates = this.lastCoord = te.mirrorY == -1 ? null : new WorldSpecificCoordinates(te.mirrorDim, te.mirrorX, te.mirrorY, te.mirrorZ);
        if (!world.field_72995_K) {
            te.removeFromMirrorNetwork();
        }
        super.func_149749_a(world, x, y, z, block, p_149749_6_);
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        Item item = this.func_149650_a(metadata, world.field_73012_v, fortune);
        ItemStack stack = new ItemStack(item, 1, this.func_149692_a(metadata));
        TileEntityRedcrystalMerc te = null;
        try {
            te = (TileEntityRedcrystalMerc)world.func_147438_o(x, y, z);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (te != null) {
            if (te.mirrorY != -1) {
                stack.func_77983_a("mirrorX", (NBTBase)new NBTTagInt(te.mirrorX));
                stack.func_77983_a("mirrorY", (NBTBase)new NBTTagInt(te.mirrorY));
                stack.func_77983_a("mirrorZ", (NBTBase)new NBTTagInt(te.mirrorZ));
                stack.func_77983_a("mirrorDim", (NBTBase)new NBTTagInt(te.mirrorDim));
                stack.func_77983_a("mirrorDimName", (NBTBase)new NBTTagString(DimensionManager.getProvider((int)te.mirrorDim).func_80007_l()));
            }
        } else if (this.lastCoord != null) {
            stack.func_77983_a("mirrorX", (NBTBase)new NBTTagInt(this.lastCoord.x));
            stack.func_77983_a("mirrorY", (NBTBase)new NBTTagInt(this.lastCoord.y));
            stack.func_77983_a("mirrorZ", (NBTBase)new NBTTagInt(this.lastCoord.z));
            stack.func_77983_a("mirrorDim", (NBTBase)new NBTTagInt(this.lastCoord.dim));
            stack.func_77983_a("mirrorDimName", (NBTBase)new NBTTagString(DimensionManager.getProvider((int)this.lastCoord.dim).func_80007_l()));
        }
        this.lastCoord = null;
        drops.add(stack);
        return drops;
    }

    @Override
    protected RedstoneCalc.PowerResult calculateRedstonePowerAt(World world, int x, int y, int z, int orientation) {
        TileEntityRedcrystalMerc te;
        int receivingStrength = 0;
        try {
            te = (TileEntityRedcrystalMerc)world.func_147438_o(x, y, z);
        }
        catch (Exception ex) {
            return null;
        }
        if (te != null && (receivingStrength = Math.max(te.extraData - 1, 0)) >= 99) {
            return new RedstoneCalc.PowerResult(receivingStrength, ForgeDirection.UNKNOWN);
        }
        RedstoneCalc.PowerResult result = super.calculateRedstonePowerAt(world, x, y, z, orientation);
        if (result != null && result.strength > 0) {
            te.strengthWithoutMirror = result.strength;
            te.markDirty(false);
            if (receivingStrength > result.strength) {
                return new RedstoneCalc.PowerResult(receivingStrength, ForgeDirection.UNKNOWN);
            }
            return result;
        }
        te.strengthWithoutMirror = 0;
        te.markDirty(false);
        if (receivingStrength > 0) {
            return new RedstoneCalc.PowerResult(receivingStrength, ForgeDirection.UNKNOWN);
        }
        return null;
    }

    @Override
    public void updateAndPropagateChanges(World world, int x, int y, int z, boolean checkStrength, boolean calledByNeighborWire, boolean forcePropagate, boolean immediateNeighborUpdates) {
        super.updateAndPropagateChanges(world, x, y, z, checkStrength, calledByNeighborWire, forcePropagate, immediateNeighborUpdates);
        if (!world.field_72995_K) {
            TileEntityRedcrystalMerc te = null;
            boolean receivingStrength = false;
            try {
                te = (TileEntityRedcrystalMerc)world.func_147438_o(x, y, z);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (te != null) {
                te.updateMirrorNetwork();
            }
        }
    }

    @Override
    public void addTraceableCuboids(IBlockAccess blockaccess, int x, int y, int z, List<IndexedCuboid6> cuboids) {
        double cmin = 0.36;
        double cmax = 0.64;
        double a = 0.44;
        double b = 0.9;
        double c = 0.8;
        double d = 0.2;
        double e = 0.0;
        double f = 0.56;
        double g = 1.0;
        double h = 0.3;
        this.addIndexedCuboid(x, y, z, cuboids, 6, cmin, 0.3, cmin, cmax, 0.8, cmax);
        this.addIndexedCuboid(x, y, z, cuboids, 2, a, 0.125, e, f, h, d);
        this.addIndexedCuboid(x, y, z, cuboids, 3, a, 0.125, c, f, h, g);
        this.addIndexedCuboid(x, y, z, cuboids, 5, c, 0.125, a, g, h, f);
        this.addIndexedCuboid(x, y, z, cuboids, 4, e, 0.125, a, d, h, f);
        this.addIndexedCuboid(x, y, z, cuboids, 7, 0.0, 0.0, 0.0, 1.0, 0.125, 1.0);
    }

    @Override
    protected void setNoWandBlockBounds(World world, int x, int y, int z) {
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 0.3f, 1.0f);
    }

    @Override
    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        return AxisAlignedBB.func_72330_a((double)x, (double)y, (double)z, (double)((double)x + 1.0), (double)((double)y + 0.125), (double)((double)z + 1.0));
    }

    public void func_149743_a(World world, int x, int y, int z, AxisAlignedBB p_149743_5_, List p_149743_6_, Entity p_149743_7_) {
        AxisAlignedBB axisalignedbb1;
        super.func_149743_a(world, x, y, z, p_149743_5_, p_149743_6_, p_149743_7_);
        if (p_149743_7_ instanceof EntityPlayer && (axisalignedbb1 = AxisAlignedBB.func_72330_a((double)((double)x + 0.36), (double)y, (double)((double)z + 0.36), (double)((double)x + 0.64), (double)((double)y + 0.8), (double)((double)z + 0.64))) != null && p_149743_5_.func_72326_a(axisalignedbb1)) {
            p_149743_6_.add(axisalignedbb1);
        }
    }
}

