/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.machine.alpha;

import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.Random;
import mods.railcraft.api.core.items.IStackFilter;
import mods.railcraft.common.blocks.machine.IEnumMachine;
import mods.railcraft.common.blocks.machine.TileMachineItem;
import mods.railcraft.common.blocks.machine.alpha.EnumMachineAlpha;
import mods.railcraft.common.blocks.machine.alpha.ai.EntityAIMateBreeding;
import mods.railcraft.common.gui.EnumGui;
import mods.railcraft.common.gui.GuiHandler;
import mods.railcraft.common.plugins.forge.PowerPlugin;
import mods.railcraft.common.util.inventory.InvTools;
import mods.railcraft.common.util.inventory.filters.StackFilter;
import mods.railcraft.common.util.misc.Game;
import mods.railcraft.common.util.misc.MiscTools;
import mods.railcraft.common.util.network.ITileExtraDataHandler;
import mods.railcraft.common.util.network.PacketDispatcher;
import mods.railcraft.common.util.network.PacketTileExtraData;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import org.apache.logging.log4j.Level;

public class TileFeedStation
extends TileMachineItem
implements ITileExtraDataHandler {
    private static final int AREA = 3;
    private static final int MIN_FEED_INTERVAL = 128;
    private static final int FEED_VARIANCE = 256;
    private static final byte ANIMALS_PER_FOOD = 2;
    private static final Random rand = MiscTools.getRand();
    private int feedTime;
    private byte feedCounter;
    private boolean powered;

    public TileFeedStation() {
        super(1);
    }

    @Override
    public IEnumMachine getMachineType() {
        return EnumMachineAlpha.FEED_STATION;
    }

    @Override
    public boolean openGui(EntityPlayer player) {
        GuiHandler.openGui(EnumGui.FEED_STATION, player, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        return true;
    }

    @Override
    public IIcon getIcon(int side) {
        return this.getMachineType().getTexture(side);
    }

    @Override
    public boolean canUpdate() {
        return true;
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (Game.isNotHost(this.getWorld())) {
            return;
        }
        ItemStack feed = this.func_70301_a(0);
        if (this.clock % 32 == 0 && (feed == null || feed.field_77994_a < feed.func_77976_d())) {
            List<IInventory> chests = InvTools.getAdjacentInventories(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            for (IInventory inv : chests) {
                if (InvTools.moveOneItem(inv, (IInventory)this, (IStackFilter)StackFilter.FEED) != null) break;
            }
        }
        feed = this.func_70301_a(0);
        --this.feedTime;
        if (!this.powered && feed != null && feed.field_77994_a > 0 && this.feedTime <= 0) {
            this.feedTime = 128 + rand.nextInt(256);
            AxisAlignedBB box = AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)(this.field_145848_d - 1), (double)this.field_145849_e, (double)(this.field_145851_c + 1), (double)(this.field_145848_d + 3), (double)(this.field_145849_e + 1));
            box = box.func_72314_b(3.0, 0.0, 3.0);
            List animals = this.field_145850_b.func_72872_a(EntityAnimal.class, box);
            for (EntityAnimal target : animals) {
                if (!target.func_70877_b(this.func_70301_a(0)) || !this.feedAnimal(target)) continue;
                if (this.feedCounter <= 0) {
                    this.func_70299_a(0, InvTools.depleteItem(feed));
                    this.feedCounter = (byte)2;
                }
                this.feedCounter = (byte)(this.feedCounter - 1);
                this.sendFeedPacket(target);
                break;
            }
        }
    }

    public void sendFeedPacket(EntityAnimal animal) {
        try {
            PacketTileExtraData pkt = new PacketTileExtraData(this);
            DataOutputStream data = pkt.getDataStream();
            data.writeInt(animal.func_145782_y());
            PacketDispatcher.sendToAllAround(pkt, new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.field_76574_g, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, 80.0));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onUpdatePacket(DataInputStream data) throws IOException {
        Entity e = this.field_145850_b.func_73045_a(data.readInt());
        if (e instanceof EntityAnimal) {
            this.feedAnimal((EntityAnimal)e);
        }
    }

    private boolean feedAnimal(EntityAnimal animal) {
        if (animal == null) {
            return false;
        }
        try {
            if (animal.func_70874_b() == 0 && !animal.func_70880_s()) {
                if (Game.isHost(this.field_145850_b)) {
                    EntityAIMateBreeding.modifyAI(animal);
                }
                animal.func_146082_f(null);
                for (int i = 0; i < 7; ++i) {
                    double d = rand.nextGaussian() * 0.02;
                    double d1 = rand.nextGaussian() * 0.02;
                    double d2 = rand.nextGaussian() * 0.02;
                    this.field_145850_b.func_72869_a("heart", animal.field_70165_t + (double)(rand.nextFloat() * animal.field_70130_N * 2.0f) - (double)animal.field_70130_N, animal.field_70163_u + 0.5 + (double)(rand.nextFloat() * animal.field_70131_O), animal.field_70161_v + (double)(rand.nextFloat() * animal.field_70130_N * 2.0f) - (double)animal.field_70130_N, d, d1, d2);
                }
                return true;
            }
        }
        catch (Throwable ex) {
            Game.log(Level.ERROR, "Feed Station encountered error, {0}", ex);
        }
        return false;
    }

    @Override
    public void onNeighborBlockChange(Block block) {
        super.onNeighborBlockChange(block);
        this.powered = PowerPlugin.isBlockBeingPowered(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @Override
    public void func_145839_a(NBTTagCompound data) {
        super.func_145839_a(data);
        this.powered = data.func_74767_n("powered");
        this.feedCounter = data.func_74771_c("feedCounter");
    }

    @Override
    public void func_145841_b(NBTTagCompound data) {
        super.func_145841_b(data);
        data.func_74757_a("powered", this.powered);
        data.func_74774_a("feedCounter", this.feedCounter);
    }
}

