/*
 * Decompiled with CFR 0.152.
 */
package shedar.mods.ic2.nuclearcontrol.items;

import mekanism.api.energy.IStrictEnergyStorage;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;
import shedar.mods.ic2.nuclearcontrol.IC2NuclearControl;
import shedar.mods.ic2.nuclearcontrol.crossmod.EnergyStorageData;
import shedar.mods.ic2.nuclearcontrol.crossmod.RF.CrossTE;
import shedar.mods.ic2.nuclearcontrol.crossmod.mekanism.CrossMekanism;
import shedar.mods.ic2.nuclearcontrol.items.ItemSensorKitBase;
import shedar.mods.ic2.nuclearcontrol.utils.EnergyStorageHelper;
import shedar.mods.ic2.nuclearcontrol.utils.ItemStackUtils;
import shedar.mods.ic2.nuclearcontrol.utils.NuclearNetworkHelper;

public class ItemKitEnergySensor
extends ItemSensorKitBase {
    public ItemKitEnergySensor() {
        super("kitEnergy");
    }

    @Override
    protected ItemStack getItemStackByDamage(int damage) {
        return new ItemStack(IC2NuclearControl.itemEnergySensorLocationCard);
    }

    protected ItemStack getItemStackbyType(EnergyStorageData storageData, TileEntity tileEntity) {
        if (tileEntity != null) {
            if (CrossMekanism.isMekanismPresent() && CrossMekanism.classExists && tileEntity instanceof IStrictEnergyStorage) {
                return new ItemStack(CrossMekanism.mekCard);
            }
            if (storageData.type == 1) {
                return new ItemStack(CrossTE.RFSensorCard);
            }
            return new ItemStack(IC2NuclearControl.itemEnergySensorLocationCard);
        }
        return new ItemStack(IC2NuclearControl.itemEnergySensorLocationCard);
    }

    @Override
    protected ChunkCoordinates getTargetCoordinates(World world, int x, int y, int z, ItemStack stack) {
        return null;
    }

    @Override
    public boolean onItemUseFirst(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (player == null) {
            return false;
        }
        boolean isServer = player instanceof EntityPlayerMP;
        if (!isServer) {
            return false;
        }
        EnergyStorageData storage = EnergyStorageHelper.getStorageAt(world, x, y, z, -1);
        if (storage != null) {
            ItemStack sensorLocationCard = this.getItemStackbyType(storage, world.func_147438_o(x, y, z));
            NBTTagCompound nbtTagCompound = ItemStackUtils.getTagCompound(sensorLocationCard);
            nbtTagCompound.func_74768_a("x", x);
            nbtTagCompound.func_74768_a("y", y);
            nbtTagCompound.func_74768_a("z", z);
            nbtTagCompound.func_74768_a("targetType", storage.type);
            player.field_71071_by.field_70462_a[player.field_71071_by.field_70461_c] = sensorLocationCard;
            if (!world.field_72995_K) {
                NuclearNetworkHelper.chatMessage(player, "SensorKit");
            }
            return true;
        }
        return false;
    }
}

