/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.common.utills;

import com.brandon3055.draconicevolution.common.ModBlocks;
import com.brandon3055.draconicevolution.common.tileentities.multiblocktiles.TileDislocatorReceptacle;
import com.brandon3055.draconicevolution.common.tileentities.multiblocktiles.TilePortalBlock;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class PortalHelper {
    public static final int MAXIMUM_PORTAL_SIZE = 150;

    public static boolean isFrame(Block block) {
        return block == ModBlocks.infusedObsidian;
    }

    public static boolean isReceptacle(Block block) {
        return block == ModBlocks.dislocatorReceptacle;
    }

    public static boolean isPortal(Block block) {
        return block == ModBlocks.portal;
    }

    public static PortalStructure getValidStructure(World world, int x, int y, int z) {
        if (world.field_72995_K) {
            return null;
        }
        for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
            for (ForgeDirection plane : ForgeDirection.VALID_DIRECTIONS) {
                PortalStructure structure;
                if (plane == direction || plane == direction.getOpposite() || (structure = PortalHelper.traceFrame(world, x, y, z, direction, plane)) == null || !structure.scanPortal(world, x, y, z, false, false)) continue;
                return structure;
            }
        }
        return null;
    }

    public static PortalStructure traceFrame(World world, int x, int y, int z, ForgeDirection startDir, ForgeDirection plane) {
        int startX = x + startDir.offsetX;
        int startY = y + startDir.offsetY;
        int startZ = z + startDir.offsetZ;
        if (!world.func_147437_c(startX, startY, startZ)) {
            return null;
        }
        int xSize = PortalHelper.findDistanceToFrame(world, startX, startY, startZ, startDir);
        int ySize = PortalHelper.findDistanceToFrame(world, startX, startY, startZ, plane);
        int yOffset = PortalHelper.findDistanceToFrame(world, startX, startY, startZ, plane.getOpposite());
        if (xSize == 0 || (ySize += yOffset - 1) == 0 || yOffset == 0 || ySize > 150) {
            return null;
        }
        PortalStructure structure = new PortalStructure(xSize, ySize, yOffset, startDir, plane);
        if (structure.checkFrameIsValid(world, x, y, z) && structure.scanPortal(world, x, y, z, false, false)) {
            return structure;
        }
        return null;
    }

    private static int findDistanceToFrame(World world, int startX, int startY, int startZ, ForgeDirection direction) {
        for (int distance = 1; distance <= 150; ++distance) {
            int targetX = startX + direction.offsetX * distance;
            int targetY = startY + direction.offsetY * distance;
            int targetZ = startZ + direction.offsetZ * distance;
            Block block = world.func_147439_a(targetX, targetY, targetZ);
            if (PortalHelper.isFrame(block)) {
                return distance;
            }
            if (world.func_147437_c(targetX, targetY, targetZ)) continue;
            return 0;
        }
        return 0;
    }

    public static class PortalStructure {
        public int xSize;
        public int ySize;
        public int yOffset;
        public ForgeDirection startDir;
        public ForgeDirection plane;

        public PortalStructure() {
        }

        public PortalStructure(int xSize, int ySize, int yOffset, ForgeDirection startDir, ForgeDirection plane) {
            this.xSize = xSize;
            this.ySize = ySize;
            this.yOffset = yOffset;
            this.startDir = startDir;
            this.plane = plane;
        }

        public boolean checkFrameIsValid(World world, int x, int y, int z) {
            for (int xDistance = 1; xDistance <= this.xSize; ++xDistance) {
                if (!this.isFrameMissing(world, x, y, z, xDistance, -this.yOffset) && !this.isFrameMissing(world, x, y, z, xDistance, this.ySize - this.yOffset + 1)) continue;
                return false;
            }
            for (int yDistance = 1 - this.yOffset; yDistance <= this.ySize - this.yOffset; ++yDistance) {
                if ((yDistance == 0 || !this.isFrameMissing(world, x, y, z, 0, yDistance)) && !this.isFrameMissing(world, x, y, z, this.xSize + 1, yDistance)) continue;
                return false;
            }
            return true;
        }

        private boolean isFrameMissing(World world, int x, int y, int z, int xDistance, int yDistance) {
            int targetX = x + this.startDir.offsetX * xDistance + this.plane.offsetX * yDistance;
            int targetY = y + this.startDir.offsetY * xDistance + this.plane.offsetY * yDistance;
            int targetZ = z + this.startDir.offsetZ * xDistance + this.plane.offsetZ * yDistance;
            return !PortalHelper.isFrame(world.func_147439_a(targetX, targetY, targetZ));
        }

        public boolean scanPortal(World world, int x, int y, int z, boolean setPortalBlocks, boolean checkPortalBlocks) {
            TileEntity tile = world.func_147438_o(x, y, z);
            if (!(tile instanceof TileDislocatorReceptacle)) {
                return false;
            }
            TileDislocatorReceptacle receptacle = (TileDislocatorReceptacle)tile;
            if (setPortalBlocks) {
                receptacle.updating = true;
            }
            for (int xDistance = 1; xDistance <= this.xSize; ++xDistance) {
                for (int yDistance = 1 - this.yOffset; yDistance <= this.ySize - this.yOffset; ++yDistance) {
                    int targetX = x + xDistance * this.startDir.offsetX + yDistance * this.plane.offsetX;
                    int targetY = y + xDistance * this.startDir.offsetY + yDistance * this.plane.offsetY;
                    int targetZ = z + xDistance * this.startDir.offsetZ + yDistance * this.plane.offsetZ;
                    Block block = world.func_147439_a(targetX, targetY, targetZ);
                    if (checkPortalBlocks) {
                        if (PortalHelper.isPortal(block)) continue;
                        return false;
                    }
                    if (setPortalBlocks) {
                        world.func_147449_b(targetX, targetY, targetZ, (Block)ModBlocks.portal);
                        tile = world.func_147438_o(targetX, targetY, targetZ);
                        if (!(tile instanceof TilePortalBlock)) continue;
                        TilePortalBlock portal = (TilePortalBlock)tile;
                        portal.masterX = x;
                        portal.masterY = y;
                        portal.masterZ = z;
                        continue;
                    }
                    if (world.func_147437_c(targetX, targetY, targetZ)) continue;
                    return false;
                }
            }
            if (setPortalBlocks) {
                receptacle.updating = false;
            }
            return true;
        }

        public void writeToNBT(NBTTagCompound compound) {
            compound.func_74768_a("XSize", this.xSize);
            compound.func_74768_a("YSize", this.ySize);
            compound.func_74768_a("YOffset", this.yOffset);
            compound.func_74778_a("StartDir", this.startDir.name());
            compound.func_74778_a("Plane", this.plane.name());
        }

        public void readFromNBT(NBTTagCompound compound) {
            this.xSize = compound.func_74762_e("XSize");
            this.ySize = compound.func_74762_e("YSize");
            this.yOffset = compound.func_74762_e("YOffset");
            this.startDir = ForgeDirection.valueOf((String)compound.func_74779_i("StartDir"));
            this.plane = ForgeDirection.valueOf((String)compound.func_74779_i("Plane"));
        }
    }
}

