/*
 * Decompiled with CFR 0.152.
 */
package com.github.lunatrius.schematica.handler.client;

import com.github.lunatrius.schematica.Schematica;
import com.github.lunatrius.schematica.client.gui.control.GuiSchematicControl;
import com.github.lunatrius.schematica.client.gui.load.GuiSchematicLoad;
import com.github.lunatrius.schematica.client.gui.save.GuiSchematicSave;
import com.github.lunatrius.schematica.client.renderer.RendererSchematicGlobal;
import com.github.lunatrius.schematica.client.world.SchematicWorld;
import com.github.lunatrius.schematica.proxy.ClientProxy;
import com.github.lunatrius.schematica.reference.Reference;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.InputEvent;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;

public class InputHandler {
    public static final InputHandler INSTANCE = new InputHandler();
    private static final KeyBinding KEY_BINDING_LOAD = new KeyBinding("schematica.key.load", Schematica.proxy.GTNH ? 0 : 181, "schematica.key.category");
    private static final KeyBinding KEY_BINDING_SAVE = new KeyBinding("schematica.key.save", Schematica.proxy.GTNH ? 0 : 55, "schematica.key.category");
    private static final KeyBinding KEY_BINDING_CONTROL = new KeyBinding("schematica.key.control", Schematica.proxy.GTNH ? 0 : 74, "schematica.key.category");
    private static final KeyBinding KEY_BINDING_LAYER_INC = new KeyBinding("schematica.key.layerInc", 0, "schematica.key.category");
    private static final KeyBinding KEY_BINDING_LAYER_DEC = new KeyBinding("schematica.key.layerDec", 0, "schematica.key.category");
    public static final KeyBinding[] KEY_BINDINGS = new KeyBinding[]{KEY_BINDING_LOAD, KEY_BINDING_SAVE, KEY_BINDING_CONTROL, KEY_BINDING_LAYER_INC, KEY_BINDING_LAYER_DEC};
    private final Minecraft minecraft = Minecraft.func_71410_x();

    private InputHandler() {
    }

    @SubscribeEvent
    public void onKeyInput(InputEvent event) {
        if (this.minecraft.field_71462_r == null) {
            SchematicWorld schematic;
            if (KEY_BINDING_LOAD.func_151468_f()) {
                this.minecraft.func_147108_a((GuiScreen)new GuiSchematicLoad(this.minecraft.field_71462_r));
            }
            if (KEY_BINDING_SAVE.func_151468_f()) {
                this.minecraft.func_147108_a((GuiScreen)new GuiSchematicSave(this.minecraft.field_71462_r));
            }
            if (KEY_BINDING_CONTROL.func_151468_f()) {
                this.minecraft.func_147108_a((GuiScreen)new GuiSchematicControl(this.minecraft.field_71462_r));
            }
            if (KEY_BINDING_LAYER_INC.func_151468_f() && (schematic = ClientProxy.schematic) != null && schematic.isRenderingLayer) {
                schematic.renderingLayer = MathHelper.func_76125_a((int)(schematic.renderingLayer + 1), (int)0, (int)(schematic.func_72800_K() - 1));
                RendererSchematicGlobal.INSTANCE.refresh();
            }
            if (KEY_BINDING_LAYER_DEC.func_151468_f() && (schematic = ClientProxy.schematic) != null && schematic.isRenderingLayer) {
                schematic.renderingLayer = MathHelper.func_76125_a((int)(schematic.renderingLayer - 1), (int)0, (int)(schematic.func_72800_K() - 1));
                RendererSchematicGlobal.INSTANCE.refresh();
            }
            this.handlePickBlock();
        }
    }

    private void handlePickBlock() {
        KeyBinding keyPickBlock = this.minecraft.field_71474_y.field_74322_I;
        if (keyPickBlock.func_151468_f()) {
            try {
                SchematicWorld schematic = ClientProxy.schematic;
                boolean revert = true;
                if (schematic != null && schematic.isRendering) {
                    revert = this.pickBlock(schematic, ClientProxy.movingObjectPosition);
                }
                if (revert) {
                    KeyBinding.func_74507_a((int)keyPickBlock.func_151463_i());
                }
            }
            catch (Exception e) {
                Reference.logger.error("Could not pick block!", (Throwable)e);
            }
        }
    }

    private boolean pickBlock(SchematicWorld schematic, MovingObjectPosition objectMouseOver) {
        boolean revert = false;
        if (objectMouseOver != null) {
            MovingObjectPosition mcObjectMouseOver;
            EntityClientPlayerMP player = this.minecraft.field_71439_g;
            if (objectMouseOver.field_72313_a == MovingObjectPosition.MovingObjectType.MISS) {
                revert = true;
            }
            if ((mcObjectMouseOver = this.minecraft.field_71476_x) != null && mcObjectMouseOver.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
                int x = mcObjectMouseOver.field_72311_b - schematic.position.x;
                int y = mcObjectMouseOver.field_72312_c - schematic.position.y;
                int z = mcObjectMouseOver.field_72309_d - schematic.position.z;
                if (x == objectMouseOver.field_72311_b && y == objectMouseOver.field_72312_c && z == objectMouseOver.field_72309_d) {
                    return true;
                }
            }
            if (!ForgeHooks.onPickBlock((MovingObjectPosition)objectMouseOver, (EntityPlayer)player, (World)schematic)) {
                return revert;
            }
            if (player.field_71075_bZ.field_75098_d) {
                Block block = schematic.func_147439_a(objectMouseOver.field_72311_b, objectMouseOver.field_72312_c, objectMouseOver.field_72309_d);
                int metadata = schematic.func_72805_g(objectMouseOver.field_72311_b, objectMouseOver.field_72312_c, objectMouseOver.field_72309_d);
                if (block == Blocks.field_150334_T || block == Blocks.field_150373_bw || block == Blocks.field_150431_aC) {
                    player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, new ItemStack(block, 1, metadata & 0xF));
                }
                int slot = player.field_71069_bz.field_75151_b.size() - 9 + player.field_71071_by.field_70461_c;
                this.minecraft.field_71442_b.func_78761_a(player.field_71071_by.func_70301_a(player.field_71071_by.field_70461_c), slot);
            }
        }
        return revert;
    }
}

