/*
 * Decompiled with CFR 0.152.
 */
package com.github.lunatrius.schematica.client.printer.registry;

import com.github.lunatrius.schematica.client.printer.registry.IExtraClick;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraftforge.common.util.ForgeDirection;

public class PlacementData {
    public static final ForgeDirection[] VALID_DIRECTIONS = ForgeDirection.VALID_DIRECTIONS;
    public final PlacementType type;
    public int maskOffset = 0;
    public float offsetLowY = 0.0f;
    public float offsetHighY = 1.0f;
    public int maskMeta = 15;
    public final Map<ForgeDirection, Integer> mapping = new HashMap<ForgeDirection, Integer>();
    private IExtraClick extraClick;

    public PlacementData(PlacementType type, int ... metadata) {
        this.type = type;
        for (int i = 0; i < VALID_DIRECTIONS.length && i < metadata.length; ++i) {
            if (metadata[i] < 0 || metadata[i] > 15) continue;
            this.mapping.put(VALID_DIRECTIONS[i], metadata[i]);
        }
    }

    public PlacementData setOffset(int maskOffset, float offsetLowY, float offsetHighY) {
        this.maskOffset = maskOffset;
        this.offsetLowY = offsetLowY;
        this.offsetHighY = offsetHighY;
        return this;
    }

    public PlacementData setMaskMeta(int maskMeta) {
        this.maskMeta = maskMeta;
        return this;
    }

    public float getOffsetFromMetadata(int metadata) {
        return (metadata & this.maskOffset) == 0 ? this.offsetLowY : this.offsetHighY;
    }

    public ForgeDirection[] getValidDirections(ForgeDirection[] solidSides, int metadata) {
        ArrayList<ForgeDirection> list = new ArrayList<ForgeDirection>();
        for (ForgeDirection direction : solidSides) {
            Integer meta;
            if (this.maskOffset != 0 && ((metadata & this.maskOffset) != 0 ? this.offsetLowY < 0.5f && direction == ForgeDirection.DOWN : this.offsetLowY < 0.5f && direction == ForgeDirection.UP)) continue;
            if (this.type == PlacementType.BLOCK && ((meta = this.mapping.get(direction)) != null ? meta : -1) != (this.maskMeta & metadata) && !this.mapping.isEmpty()) continue;
            list.add(direction);
        }
        ForgeDirection[] directions = new ForgeDirection[list.size()];
        return list.toArray(directions);
    }

    public PlacementData setExtraClick(IExtraClick extraClick) {
        this.extraClick = extraClick;
        return this;
    }

    public int getExtraClicks(Block block, int metadata) {
        if (this.extraClick != null) {
            return this.extraClick.getExtraClicks(block, metadata);
        }
        return 0;
    }

    public static enum PlacementType {
        BLOCK,
        PLAYER,
        PISTON;

    }
}

