/*
 * Decompiled with CFR 0.152.
 */
package com.carpentersblocks.util.collapsible;

import com.carpentersblocks.data.Collapsible;
import com.carpentersblocks.tileentity.TEBase;

public class CollapsibleUtil {
    private static Collapsible data = new Collapsible();
    public static double CENTER_YMAX;
    public static double offset_XZNN;
    public static double offset_XZNP;
    public static double offset_XZPN;
    public static double offset_XZPP;

    public static boolean isMin(TEBase TE) {
        for (int quad = 0; quad < 4; ++quad) {
            if (Collapsible.getQuadDepth(TE, quad) <= 0) continue;
            return false;
        }
        return true;
    }

    public static boolean isMax(TEBase TE) {
        for (int quad = 0; quad < 4; ++quad) {
            if (Collapsible.getQuadDepth(TE, quad) >= 16) continue;
            return false;
        }
        return true;
    }

    public static void computeOffsets(TEBase TE) {
        double BIAS = CollapsibleUtil.isMin(TE) ? 9.765625E-4 : 0.0;
        offset_XZNN = (double)Collapsible.getQuadDepth(TE, 0) / 16.0 + BIAS;
        offset_XZNP = (double)Collapsible.getQuadDepth(TE, 1) / 16.0 + BIAS;
        offset_XZPN = (double)Collapsible.getQuadDepth(TE, 2) / 16.0 + BIAS;
        offset_XZPP = (double)Collapsible.getQuadDepth(TE, 3) / 16.0 + BIAS;
        double NW_SE = Math.abs(offset_XZNN - offset_XZPP);
        double NE_SW = Math.abs(offset_XZPN - offset_XZNP);
        CENTER_YMAX = NW_SE < NE_SW ? (offset_XZPN + offset_XZNP) / 2.0 : (offset_XZNN + offset_XZPP) / 2.0;
    }

    public static float getBoundsMaxDepth(TEBase TE) {
        float maxDepth = 0.0f;
        for (int quad = 0; quad < 4; ++quad) {
            float depth = (float)Collapsible.getQuadDepth(TE, quad) / 16.0f;
            if (!(depth > maxDepth)) continue;
            maxDepth = depth;
        }
        return maxDepth;
    }

    public static float[] genBounds(TEBase TE, int quad) {
        float xMin = 0.0f;
        float zMin = 0.0f;
        float xMax = 1.0f;
        float zMax = 1.0f;
        switch (quad) {
            case 0: {
                xMax = 0.5f;
                zMax = 0.5f;
                break;
            }
            case 1: {
                xMax = 0.5f;
                zMin = 0.5f;
                break;
            }
            case 2: {
                xMin = 0.5f;
                zMax = 0.5f;
                break;
            }
            case 3: {
                xMin = 0.5f;
                zMin = 0.5f;
            }
        }
        float maxDepth = CollapsibleUtil.getBoundsMaxDepth(TE);
        float depth = (float)Collapsible.getQuadDepth(TE, quad) / 16.0f;
        if (data.isPositive(TE)) {
            if (maxDepth - depth > 0.5f) {
                depth = maxDepth - 0.5f;
            }
            return new float[]{xMin, 0.0f, zMin, xMax, depth, zMax};
        }
        return new float[]{xMin, 1.0f - depth, zMin, xMax, 1.0f, zMax};
    }
}

