/*
 * Decompiled with CFR 0.152.
 */
package com.carpentersblocks.renderer.helper;

import com.carpentersblocks.util.BlockProperties;
import com.carpentersblocks.util.handler.ShadersHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;

@SideOnly(value=Side.CLIENT)
public class LightingHelper {
    public RenderBlocks renderBlocks;
    private boolean hasLightnessOverride;
    private float lightnessOverride;
    private boolean hasBrightnessOverride;
    private int brightnessOverride;
    private boolean hasColorOverride;
    private int colorOverride = 0xFFFFFF;
    public final int MAX_BRIGHTNESS = 0xF000F0;
    public float[] LIGHTNESS = new float[]{0.5f, 1.0f, 0.8f, 0.8f, 0.6f, 0.6f};
    public float[] ao = new float[4];
    public int brightness;

    public LightingHelper(RenderBlocks renderBlocks) {
        this.renderBlocks = renderBlocks;
    }

    public void setMaximumLuminosity() {
        this.setBrightnessOverride(0xF000F0);
        this.setLightnessOverride(1.0f);
    }

    public void clearMaximumLuminosity() {
        this.clearBrightnessOverride();
        this.clearLightnessOverride();
    }

    public LightingHelper setLightnessOverride(float lightness) {
        this.hasLightnessOverride = true;
        this.lightnessOverride = lightness;
        return this;
    }

    public void clearLightnessOverride() {
        this.hasLightnessOverride = false;
    }

    public LightingHelper setBrightnessOverride(int brightness) {
        this.hasBrightnessOverride = true;
        this.brightnessOverride = brightness;
        return this;
    }

    public void clearBrightnessOverride() {
        this.hasBrightnessOverride = false;
    }

    public void setColorOverride(int color) {
        this.hasColorOverride = true;
        this.colorOverride = color;
    }

    public void clearColorOverride() {
        this.hasColorOverride = false;
    }

    public static float[] getRGB(int hexColor) {
        float red = (float)(hexColor >> 16 & 0xFF) / 255.0f;
        float green = (float)(hexColor >> 8 & 0xFF) / 255.0f;
        float blue = (float)(hexColor & 0xFF) / 255.0f;
        return new float[]{red, green, blue};
    }

    public void setupColor(int x, int y, int z, int side, int hexColor, IIcon icon) {
        float lightness;
        Tessellator tessellator = Tessellator.field_78398_a;
        float f = lightness = this.hasLightnessOverride ? this.lightnessOverride : this.LIGHTNESS[side];
        if (ShadersHandler.enableShadersModCoreIntegration && !ShadersHandler.oldLighting) {
            lightness = 1.0f;
        }
        tessellator.func_78380_c(this.hasBrightnessOverride ? this.brightnessOverride : this.brightness);
        float[] rgb = LightingHelper.getRGB(hexColor);
        if (this.hasColorOverride && !this.renderBlocks.func_147744_b()) {
            rgb = LightingHelper.getRGB(this.colorOverride);
        }
        this.applyAnaglyph(rgb);
        if (this.renderBlocks.field_147863_w) {
            if (this.renderBlocks.func_147744_b()) {
                this.renderBlocks.field_147850_ar = this.renderBlocks.field_147848_as = rgb[0];
                this.renderBlocks.field_147852_aq = this.renderBlocks.field_147848_as;
                this.renderBlocks.field_147872_ap = this.renderBlocks.field_147848_as;
                this.renderBlocks.field_147858_av = this.renderBlocks.field_147856_aw = rgb[1];
                this.renderBlocks.field_147860_au = this.renderBlocks.field_147856_aw;
                this.renderBlocks.field_147846_at = this.renderBlocks.field_147856_aw;
                this.renderBlocks.field_147839_az = this.renderBlocks.field_147833_aA = rgb[2];
                this.renderBlocks.field_147841_ay = this.renderBlocks.field_147833_aA;
                this.renderBlocks.field_147854_ax = this.renderBlocks.field_147833_aA;
            } else {
                this.renderBlocks.field_147850_ar = this.renderBlocks.field_147848_as = rgb[0] * lightness;
                this.renderBlocks.field_147852_aq = this.renderBlocks.field_147848_as;
                this.renderBlocks.field_147872_ap = this.renderBlocks.field_147848_as;
                this.renderBlocks.field_147858_av = this.renderBlocks.field_147856_aw = rgb[1] * lightness;
                this.renderBlocks.field_147860_au = this.renderBlocks.field_147856_aw;
                this.renderBlocks.field_147846_at = this.renderBlocks.field_147856_aw;
                this.renderBlocks.field_147839_az = this.renderBlocks.field_147833_aA = rgb[2] * lightness;
                this.renderBlocks.field_147841_ay = this.renderBlocks.field_147833_aA;
                this.renderBlocks.field_147854_ax = this.renderBlocks.field_147833_aA;
                this.renderBlocks.field_147872_ap *= this.ao[0];
                this.renderBlocks.field_147846_at *= this.ao[0];
                this.renderBlocks.field_147854_ax *= this.ao[0];
                this.renderBlocks.field_147852_aq *= this.ao[1];
                this.renderBlocks.field_147860_au *= this.ao[1];
                this.renderBlocks.field_147841_ay *= this.ao[1];
                this.renderBlocks.field_147850_ar *= this.ao[2];
                this.renderBlocks.field_147858_av *= this.ao[2];
                this.renderBlocks.field_147839_az *= this.ao[2];
                this.renderBlocks.field_147848_as *= this.ao[3];
                this.renderBlocks.field_147856_aw *= this.ao[3];
                this.renderBlocks.field_147833_aA *= this.ao[3];
            }
        } else {
            tessellator.func_78386_a(rgb[0] * lightness, rgb[1] * lightness, rgb[2] * lightness);
        }
    }

    public void applyAnaglyph(float[] rgb) {
        if (EntityRenderer.field_78517_a) {
            rgb[0] = (rgb[0] * 30.0f + rgb[1] * 59.0f + rgb[2] * 11.0f) / 100.0f;
            rgb[1] = (rgb[0] * 30.0f + rgb[1] * 70.0f) / 100.0f;
            rgb[2] = (rgb[0] * 30.0f + rgb[2] * 70.0f) / 100.0f;
        }
    }

    public static float getMixedAo(float ao1, float ao2, double ratio) {
        float diff = (float)((double)Math.abs(ao1 - ao2) * (1.0 - ratio));
        return ao1 > ao2 ? ao1 - diff : ao1 + diff;
    }

    public static int getAverageBrightness(int brightness1, int brightness2) {
        int section_1_1 = brightness1 >> 16 & 0xFF;
        int section_1_3 = brightness1 & 0xFF;
        int section_2_1 = brightness2 >> 16 & 0xFF;
        int section_2_3 = brightness2 & 0xFF;
        int difference1 = (int)((float)(section_1_1 + section_2_1) / 2.0f);
        int difference3 = (int)((float)(section_1_3 + section_2_3) / 2.0f);
        return difference1 << 16 | difference3;
    }

    public LightingHelper setupLightingYNeg(ItemStack itemStack, int x, int y, int z) {
        Block block = BlockProperties.toBlock(itemStack);
        int y_offset = this.renderBlocks.field_147855_j > 0.0 ? y : y - 1;
        this.brightness = block.func_149677_c(this.renderBlocks.field_147845_a, x, y_offset, z);
        if (this.renderBlocks.field_147863_w) {
            float ratio = (float)(1.0 - this.renderBlocks.field_147855_j);
            float aoLightValue = this.renderBlocks.field_147845_a.func_147439_a(x, y_offset, z).func_149685_I();
            this.renderBlocks.field_147831_S = block.func_149677_c(this.renderBlocks.field_147845_a, x - 1, y_offset, z);
            this.renderBlocks.field_147825_U = block.func_149677_c(this.renderBlocks.field_147845_a, x, y_offset, z - 1);
            this.renderBlocks.field_147828_V = block.func_149677_c(this.renderBlocks.field_147845_a, x, y_offset, z + 1);
            this.renderBlocks.field_147835_X = block.func_149677_c(this.renderBlocks.field_147845_a, x + 1, y_offset, z);
            this.renderBlocks.field_147832_R = block.func_149677_c(this.renderBlocks.field_147845_a, x - 1, y_offset, z - 1);
            this.renderBlocks.field_147826_T = block.func_149677_c(this.renderBlocks.field_147845_a, x - 1, y_offset, z + 1);
            this.renderBlocks.field_147827_W = block.func_149677_c(this.renderBlocks.field_147845_a, x + 1, y_offset, z - 1);
            this.renderBlocks.field_147834_Y = block.func_149677_c(this.renderBlocks.field_147845_a, x + 1, y_offset, z + 1);
            this.renderBlocks.field_147886_y = LightingHelper.getMixedAo(this.renderBlocks.field_147845_a.func_147439_a(x - 1, y - 1, z).func_149685_I(), this.renderBlocks.field_147845_a.func_147439_a(x - 1, y, z).func_149685_I(), ratio);
            this.renderBlocks.field_147814_A = LightingHelper.getMixedAo(this.renderBlocks.field_147845_a.func_147439_a(x, y - 1, z - 1).func_149685_I(), this.renderBlocks.field_147845_a.func_147439_a(x, y, z - 1).func_149685_I(), ratio);
            this.renderBlocks.field_147815_B = LightingHelper.getMixedAo(this.renderBlocks.field_147845_a.func_147439_a(x, y - 1, z + 1).func_149685_I(), this.renderBlocks.field_147845_a.func_147439_a(x, y, z + 1).func_149685_I(), ratio);
            this.renderBlocks.field_147810_D = LightingHelper.getMixedAo(this.renderBlocks.field_147845_a.func_147439_a(x + 1, y - 1, z).func_149685_I(), this.renderBlocks.field_147845_a.func_147439_a(x + 1, y, z).func_149685_I(), ratio);
            this.renderBlocks.field_147888_x = LightingHelper.getMixedAo(this.renderBlocks.field_147845_a.func_147439_a(x - 1, y - 1, z - 1).func_149685_I(), this.renderBlocks.field_147845_a.func_147439_a(x - 1, y, z - 1).func_149685_I(), ratio);
            this.renderBlocks.field_147884_z = LightingHelper.getMixedAo(this.renderBlocks.field_147845_a.func_147439_a(x - 1, y - 1, z + 1).func_149685_I(), this.renderBlocks.field_147845_a.func_147439_a(x - 1, y, z + 1).func_149685_I(), ratio);
            this.renderBlocks.field_147816_C = LightingHelper.getMixedAo(this.renderBlocks.field_147845_a.func_147439_a(x + 1, y - 1, z - 1).func_149685_I(), this.renderBlocks.field_147845_a.func_147439_a(x + 1, y, z - 1).func_149685_I(), ratio);
            this.renderBlocks.field_147811_E = LightingHelper.getMixedAo(this.renderBlocks.field_147845_a.func_147439_a(x + 1, y - 1, z + 1).func_149685_I(), this.renderBlocks.field_147845_a.func_147439_a(x + 1, y, z + 1).func_149685_I(), ratio);
            float aoMixed_XYZPNP = this.ao[0] = (this.renderBlocks.field_147815_B + aoLightValue + this.renderBlocks.field_147811_E + this.renderBlocks.field_147810_D) / 4.0f;
            float aoMixed_XYZPNN = this.ao[1] = (aoLightValue + this.renderBlocks.field_147814_A + this.renderBlocks.field_147810_D + this.renderBlocks.field_147816_C) / 4.0f;
            float aoMixed_XYZNNN = this.ao[2] = (this.renderBlocks.field_147886_y + this.renderBlocks.field_147888_x + aoLightValue + this.renderBlocks.field_147814_A) / 4.0f;
            float aoMixed_XYZNNP = this.ao[3] = (this.renderBlocks.field_147884_z + this.renderBlocks.field_147886_y + this.renderBlocks.field_147815_B + aoLightValue) / 4.0f;
            int brightnessMixed_XYZPNP = this.renderBlocks.field_147864_al = this.renderBlocks.func_147778_a(this.renderBlocks.field_147828_V, this.renderBlocks.field_147834_Y, this.renderBlocks.field_147835_X, this.brightness);
            int brightnessMixed_XYZPNN = this.renderBlocks.field_147874_am = this.renderBlocks.func_147778_a(this.renderBlocks.field_147825_U, this.renderBlocks.field_147835_X, this.renderBlocks.field_147827_W, this.brightness);
            int brightnessMixed_XYZNNN = this.renderBlocks.field_147876_an = this.renderBlocks.func_147778_a(this.renderBlocks.field_147831_S, this.renderBlocks.field_147832_R, this.renderBlocks.field_147825_U, this.brightness);
            int brightnessMixed_XYZNNP = this.renderBlocks.field_147870_ao = this.renderBlocks.func_147778_a(this.renderBlocks.field_147826_T, this.renderBlocks.field_147831_S, this.renderBlocks.field_147828_V, this.brightness);
            if (this.renderBlocks.field_147849_o) {
                this.ao[0] = (float)((double)aoMixed_XYZNNP * this.renderBlocks.field_147853_m * (1.0 - this.renderBlocks.field_147861_i) + (double)aoMixed_XYZPNP * this.renderBlocks.field_147853_m * this.renderBlocks.field_147861_i + (double)aoMixed_XYZPNN * (1.0 - this.renderBlocks.field_147853_m) * this.renderBlocks.field_147861_i + (double)aoMixed_XYZNNN * (1.0 - this.renderBlocks.field_147853_m) * (1.0 - this.renderBlocks.field_147861_i));
                this.ao[1] = (float)((double)aoMixed_XYZNNP * this.renderBlocks.field_147851_l * (1.0 - this.renderBlocks.field_147861_i) + (double)aoMixed_XYZPNP * this.renderBlocks.field_147851_l * this.renderBlocks.field_147861_i + (double)aoMixed_XYZPNN * (1.0 - this.renderBlocks.field_147851_l) * this.renderBlocks.field_147861_i + (double)aoMixed_XYZNNN * (1.0 - this.renderBlocks.field_147851_l) * (1.0 - this.renderBlocks.field_147861_i));
                this.ao[2] = (float)((double)aoMixed_XYZNNP * this.renderBlocks.field_147851_l * (1.0 - this.renderBlocks.field_147859_h) + (double)aoMixed_XYZPNP * this.renderBlocks.field_147851_l * this.renderBlocks.field_147859_h + (double)aoMixed_XYZPNN * (1.0 - this.renderBlocks.field_147851_l) * this.renderBlocks.field_147859_h + (double)aoMixed_XYZNNN * (1.0 - this.renderBlocks.field_147851_l) * (1.0 - this.renderBlocks.field_147859_h));
                this.ao[3] = (float)((double)aoMixed_XYZNNP * this.renderBlocks.field_147853_m * (1.0 - this.renderBlocks.field_147859_h) + (double)aoMixed_XYZPNP * this.renderBlocks.field_147853_m * this.renderBlocks.field_147859_h + (double)aoMixed_XYZPNN * (1.0 - this.renderBlocks.field_147853_m) * this.renderBlocks.field_147859_h + (double)aoMixed_XYZNNN * (1.0 - this.renderBlocks.field_147853_m) * (1.0 - this.renderBlocks.field_147859_h));
                this.renderBlocks.field_147864_al = this.renderBlocks.func_147727_a(brightnessMixed_XYZNNP, brightnessMixed_XYZPNP, brightnessMixed_XYZPNN, brightnessMixed_XYZNNN, this.renderBlocks.field_147853_m * (1.0 - this.renderBlocks.field_147861_i), this.renderBlocks.field_147853_m * this.renderBlocks.field_147861_i, (1.0 - this.renderBlocks.field_147853_m) * this.renderBlocks.field_147861_i, (1.0 - this.renderBlocks.field_147853_m) * (1.0 - this.renderBlocks.field_147861_i));
                this.renderBlocks.field_147874_am = this.renderBlocks.func_147727_a(brightnessMixed_XYZNNP, brightnessMixed_XYZPNP, brightnessMixed_XYZPNN, brightnessMixed_XYZNNN, this.renderBlocks.field_147851_l * (1.0 - this.renderBlocks.field_147861_i), this.renderBlocks.field_147851_l * this.renderBlocks.field_147861_i, (1.0 - this.renderBlocks.field_147851_l) * this.renderBlocks.field_147861_i, (1.0 - this.renderBlocks.field_147851_l) * (1.0 - this.renderBlocks.field_147861_i));
                this.renderBlocks.field_147876_an = this.renderBlocks.func_147727_a(brightnessMixed_XYZNNP, brightnessMixed_XYZPNP, brightnessMixed_XYZPNN, brightnessMixed_XYZNNN, this.renderBlocks.field_147851_l * (1.0 - this.renderBlocks.field_147859_h), this.renderBlocks.field_147851_l * this.renderBlocks.field_147859_h, (1.0 - this.renderBlocks.field_147851_l) * this.renderBlocks.field_147859_h, (1.0 - this.renderBlocks.field_147851_l) * (1.0 - this.renderBlocks.field_147859_h));
                this.renderBlocks.field_147870_ao = this.renderBlocks.func_147727_a(brightnessMixed_XYZNNP, brightnessMixed_XYZPNP, brightnessMixed_XYZPNN, brightnessMixed_XYZNNN, this.renderBlocks.field_147853_m * (1.0 - this.renderBlocks.field_147859_h), this.renderBlocks.field_147853_m * this.renderBlocks.field_147859_h, (1.0 - this.renderBlocks.field_147853_m) * this.renderBlocks.field_147859_h, (1.0 - this.renderBlocks.field_147853_m) * (1.0 - this.renderBlocks.field_147859_h));
            }
        }
        return this;
    }

    public LightingHelper setupLightingYPos(ItemStack itemStack, int x, int y, int z) {
        Block block = BlockProperties.toBlock(itemStack);
        int y_offset = this.renderBlocks.field_147857_k < 1.0 ? y : y + 1;
        this.brightness = block.func_149677_c(this.renderBlocks.field_147845_a, x, y_offset, z);
        if (this.renderBlocks.field_147863_w) {
            float aoLightValue = this.renderBlocks.field_147845_a.func_147439_a(x, y_offset, z).func_149685_I();
            this.renderBlocks.field_147880_aa = block.func_149677_c(this.renderBlocks.field_147845_a, x - 1, y_offset, z);
            this.renderBlocks.field_147885_ae = block.func_149677_c(this.renderBlocks.field_147845_a, x + 1, y_offset, z);
            this.renderBlocks.field_147878_ac = block.func_149677_c(this.renderBlocks.field_147845_a, x, y_offset, z - 1);
            this.renderBlocks.field_147887_af = block.func_149677_c(this.renderBlocks.field_147845_a, x, y_offset, z + 1);
            this.renderBlocks.field_147836_Z = block.func_149677_c(this.renderBlocks.field_147845_a, x - 1, y_offset, z - 1);
            this.renderBlocks.field_147879_ad = block.func_149677_c(this.renderBlocks.field_147845_a, x + 1, y_offset, z - 1);
            this.renderBlocks.field_147881_ab = block.func_149677_c(this.renderBlocks.field_147845_a, x - 1, y_offset, z + 1);
            this.renderBlocks.field_147882_ag = block.func_149677_c(this.renderBlocks.field_147845_a, x + 1, y_offset, z + 1);
            this.renderBlocks.field_147813_G = LightingHelper.getMixedAo(this.renderBlocks.field_147845_a.func_147439_a(x - 1, y + 1, z).func_149685_I(), this.renderBlocks.field_147845_a.func_147439_a(x - 1, y, z).func_149685_I(), this.renderBlocks.field_147857_k);
            this.renderBlocks.field_147824_K = LightingHelper.getMixedAo(this.renderBlocks.field_147845_a.func_147439_a(x + 1, y + 1, z).func_149685_I(), this.renderBlocks.field_147845_a.func_147439_a(x + 1, y, z).func_149685_I(), this.renderBlocks.field_147857_k);
            this.renderBlocks.field_147822_I = LightingHelper.getMixedAo(this.renderBlocks.field_147845_a.func_147439_a(x, y + 1, z - 1).func_149685_I(), this.renderBlocks.field_147845_a.func_147439_a(x, y, z - 1).func_149685_I(), this.renderBlocks.field_147857_k);
            this.renderBlocks.field_147817_L = LightingHelper.getMixedAo(this.renderBlocks.field_147845_a.func_147439_a(x, y + 1, z + 1).func_149685_I(), this.renderBlocks.field_147845_a.func_147439_a(x, y, z + 1).func_149685_I(), this.renderBlocks.field_147857_k);
            this.renderBlocks.field_147812_F = LightingHelper.getMixedAo(this.renderBlocks.field_147845_a.func_147439_a(x - 1, y + 1, z - 1).func_149685_I(), this.renderBlocks.field_147845_a.func_147439_a(x - 1, y, z - 1).func_149685_I(), this.renderBlocks.field_147857_k);
            this.renderBlocks.field_147823_J = LightingHelper.getMixedAo(this.renderBlocks.field_147845_a.func_147439_a(x + 1, y + 1, z - 1).func_149685_I(), this.renderBlocks.field_147845_a.func_147439_a(x + 1, y, z - 1).func_149685_I(), this.renderBlocks.field_147857_k);
            this.renderBlocks.field_147821_H = LightingHelper.getMixedAo(this.renderBlocks.field_147845_a.func_147439_a(x - 1, y + 1, z + 1).func_149685_I(), this.renderBlocks.field_147845_a.func_147439_a(x - 1, y, z + 1).func_149685_I(), this.renderBlocks.field_147857_k);
            this.renderBlocks.field_147818_M = LightingHelper.getMixedAo(this.renderBlocks.field_147845_a.func_147439_a(x + 1, y + 1, z + 1).func_149685_I(), this.renderBlocks.field_147845_a.func_147439_a(x + 1, y, z + 1).func_149685_I(), this.renderBlocks.field_147857_k);
            float aoMixed_XYZPPP = this.ao[0] = (this.renderBlocks.field_147817_L + aoLightValue + this.renderBlocks.field_147818_M + this.renderBlocks.field_147824_K) / 4.0f;
            float aoMixed_XYZPPN = this.ao[1] = (aoLightValue + this.renderBlocks.field_147822_I + this.renderBlocks.field_147824_K + this.renderBlocks.field_147823_J) / 4.0f;
            float aoMixed_XYZNPN = this.ao[2] = (this.renderBlocks.field_147813_G + this.renderBlocks.field_147812_F + aoLightValue + this.renderBlocks.field_147822_I) / 4.0f;
            float aoMixed_XYZNPP = this.ao[3] = (this.renderBlocks.field_147821_H + this.renderBlocks.field_147813_G + this.renderBlocks.field_147817_L + aoLightValue) / 4.0f;
            int brightnessMixed_XYZPPP = this.renderBlocks.field_147864_al = this.renderBlocks.func_147778_a(this.renderBlocks.field_147887_af, this.renderBlocks.field_147882_ag, this.renderBlocks.field_147885_ae, this.brightness);
            int brightnessMixed_XYZPPN = this.renderBlocks.field_147874_am = this.renderBlocks.func_147778_a(this.renderBlocks.field_147878_ac, this.renderBlocks.field_147885_ae, this.renderBlocks.field_147879_ad, this.brightness);
            int brightnessMixed_XYZNPN = this.renderBlocks.field_147876_an = this.renderBlocks.func_147778_a(this.renderBlocks.field_147880_aa, this.renderBlocks.field_147836_Z, this.renderBlocks.field_147878_ac, this.brightness);
            int brightnessMixed_XYZNPP = this.renderBlocks.field_147870_ao = this.renderBlocks.func_147778_a(this.renderBlocks.field_147881_ab, this.renderBlocks.field_147880_aa, this.renderBlocks.field_147887_af, this.brightness);
            if (this.renderBlocks.field_147849_o) {
                this.ao[0] = (float)((double)aoMixed_XYZNPP * this.renderBlocks.field_147853_m * (1.0 - this.renderBlocks.field_147861_i) + (double)aoMixed_XYZPPP * this.renderBlocks.field_147853_m * this.renderBlocks.field_147861_i + (double)aoMixed_XYZPPN * (1.0 - this.renderBlocks.field_147853_m) * this.renderBlocks.field_147861_i + (double)aoMixed_XYZNPN * (1.0 - this.renderBlocks.field_147853_m) * (1.0 - this.renderBlocks.field_147861_i));
                this.ao[1] = (float)((double)aoMixed_XYZNPP * this.renderBlocks.field_147851_l * (1.0 - this.renderBlocks.field_147861_i) + (double)aoMixed_XYZPPP * this.renderBlocks.field_147851_l * this.renderBlocks.field_147861_i + (double)aoMixed_XYZPPN * (1.0 - this.renderBlocks.field_147851_l) * this.renderBlocks.field_147861_i + (double)aoMixed_XYZNPN * (1.0 - this.renderBlocks.field_147851_l) * (1.0 - this.renderBlocks.field_147861_i));
                this.ao[2] = (float)((double)aoMixed_XYZNPP * this.renderBlocks.field_147851_l * (1.0 - this.renderBlocks.field_147859_h) + (double)aoMixed_XYZPPP * this.renderBlocks.field_147851_l * this.renderBlocks.field_147859_h + (double)aoMixed_XYZPPN * (1.0 - this.renderBlocks.field_147851_l) * this.renderBlocks.field_147859_h + (double)aoMixed_XYZNPN * (1.0 - this.renderBlocks.field_147851_l) * (1.0 - this.renderBlocks.field_147859_h));
                this.ao[3] = (float)((double)aoMixed_XYZNPP * this.renderBlocks.field_147853_m * (1.0 - this.renderBlocks.field_147859_h) + (double)aoMixed_XYZPPP * this.renderBlocks.field_147853_m * this.renderBlocks.field_147859_h + (double)aoMixed_XYZPPN * (1.0 - this.renderBlocks.field_147853_m) * this.renderBlocks.field_147859_h + (double)aoMixed_XYZNPN * (1.0 - this.renderBlocks.field_147853_m) * (1.0 - this.renderBlocks.field_147859_h));
                this.renderBlocks.field_147864_al = this.renderBlocks.func_147727_a(brightnessMixed_XYZNPP, brightnessMixed_XYZPPP, brightnessMixed_XYZPPN, brightnessMixed_XYZNPN, this.renderBlocks.field_147853_m * (1.0 - this.renderBlocks.field_147861_i), this.renderBlocks.field_147853_m * this.renderBlocks.field_147861_i, (1.0 - this.renderBlocks.field_147853_m) * this.renderBlocks.field_147861_i, (1.0 - this.renderBlocks.field_147853_m) * (1.0 - this.renderBlocks.field_147861_i));
                this.renderBlocks.field_147874_am = this.renderBlocks.func_147727_a(brightnessMixed_XYZNPP, brightnessMixed_XYZPPP, brightnessMixed_XYZPPN, brightnessMixed_XYZNPN, this.renderBlocks.field_147851_l * (1.0 - this.renderBlocks.field_147861_i), this.renderBlocks.field_147851_l * this.renderBlocks.field_147861_i, (1.0 - this.renderBlocks.field_147851_l) * this.renderBlocks.field_147861_i, (1.0 - this.renderBlocks.field_147851_l) * (1.0 - this.renderBlocks.field_147861_i));
                this.renderBlocks.field_147876_an = this.renderBlocks.func_147727_a(brightnessMixed_XYZNPP, brightnessMixed_XYZPPP, brightnessMixed_XYZPPN, brightnessMixed_XYZNPN, this.renderBlocks.field_147851_l * (1.0 - this.renderBlocks.field_147859_h), this.renderBlocks.field_147851_l * this.renderBlocks.field_147859_h, (1.0 - this.renderBlocks.field_147851_l) * this.renderBlocks.field_147859_h, (1.0 - this.renderBlocks.field_147851_l) * (1.0 - this.renderBlocks.field_147859_h));
                this.renderBlocks.field_147870_ao = this.renderBlocks.func_147727_a(brightnessMixed_XYZNPP, brightnessMixed_XYZPPP, brightnessMixed_XYZPPN, brightnessMixed_XYZNPN, this.renderBlocks.field_147853_m * (1.0 - this.renderBlocks.field_147859_h), this.renderBlocks.field_147853_m * this.renderBlocks.field_147859_h, (1.0 - this.renderBlocks.field_147853_m) * this.renderBlocks.field_147859_h, (1.0 - this.renderBlocks.field_147853_m) * (1.0 - this.renderBlocks.field_147859_h));
            }
        }
        return this;
    }

    public LightingHelper setupLightingZNeg(ItemStack itemStack, int x, int y, int z) {
        Block block = BlockProperties.toBlock(itemStack);
        int z_offset = this.renderBlocks.field_147851_l > 0.0 ? z : z - 1;
        this.brightness = block.func_149677_c(this.renderBlocks.field_147845_a, x, y, z_offset);
        if (this.renderBlocks.field_147863_w) {
            float ratio = (float)(1.0 - this.renderBlocks.field_147851_l);
            float aoLightValue = this.renderBlocks.field_147845_a.func_147439_a(x, y, z_offset).func_149685_I();
            this.renderBlocks.field_147883_ah = block.func_149677_c(this.renderBlocks.field_147845_a, x - 1, y, z_offset);
            this.renderBlocks.field_147825_U = block.func_149677_c(this.renderBlocks.field_147845_a, x, y - 1, z_offset);
            this.renderBlocks.field_147878_ac = block.func_149677_c(this.renderBlocks.field_147845_a, x, y + 1, z_offset);
            this.renderBlocks.field_147866_ai = block.func_149677_c(this.renderBlocks.field_147845_a, x + 1, y, z_offset);
            this.renderBlocks.field_147832_R = block.func_149677_c(this.renderBlocks.field_147845_a, x - 1, y - 1, z_offset);
            this.renderBlocks.field_147836_Z = block.func_149677_c(this.renderBlocks.field_147845_a, x - 1, y + 1, z_offset);
            this.renderBlocks.field_147827_W = block.func_149677_c(this.renderBlocks.field_147845_a, x + 1, y - 1, z_offset);
            this.renderBlocks.field_147879_ad = block.func_149677_c(this.renderBlocks.field_147845_a, x + 1, y + 1, z_offset);
            this.renderBlocks.field_147819_N = LightingHelper.getMixedAo(this.renderBlocks.field_147845_a.func_147439_a(x - 1, y, z - 1).func_149685_I(), this.renderBlocks.field_147845_a.func_147439_a(x - 1, y, z).func_149685_I(), ratio);
            this.renderBlocks.field_147814_A = LightingHelper.getMixedAo(this.renderBlocks.field_147845_a.func_147439_a(x, y - 1, z - 1).func_149685_I(), this.renderBlocks.field_147845_a.func_147439_a(x, y - 1, z).func_149685_I(), ratio);
            this.renderBlocks.field_147822_I = LightingHelper.getMixedAo(this.renderBlocks.field_147845_a.func_147439_a(x, y + 1, z - 1).func_149685_I(), this.renderBlocks.field_147845_a.func_147439_a(x, y + 1, z).func_149685_I(), ratio);
            this.renderBlocks.field_147820_O = LightingHelper.getMixedAo(this.renderBlocks.field_147845_a.func_147439_a(x + 1, y, z - 1).func_149685_I(), this.renderBlocks.field_147845_a.func_147439_a(x + 1, y, z).func_149685_I(), ratio);
            this.renderBlocks.field_147888_x = LightingHelper.getMixedAo(this.renderBlocks.field_147845_a.func_147439_a(x - 1, y - 1, z - 1).func_149685_I(), this.renderBlocks.field_147845_a.func_147439_a(x - 1, y - 1, z).func_149685_I(), ratio);
            this.renderBlocks.field_147812_F = LightingHelper.getMixedAo(this.renderBlocks.field_147845_a.func_147439_a(x - 1, y + 1, z - 1).func_149685_I(), this.renderBlocks.field_147845_a.func_147439_a(x - 1, y + 1, z).func_149685_I(), ratio);
            this.renderBlocks.field_147816_C = LightingHelper.getMixedAo(this.renderBlocks.field_147845_a.func_147439_a(x + 1, y - 1, z - 1).func_149685_I(), this.renderBlocks.field_147845_a.func_147439_a(x + 1, y - 1, z).func_149685_I(), ratio);
            this.renderBlocks.field_147823_J = LightingHelper.getMixedAo(this.renderBlocks.field_147845_a.func_147439_a(x + 1, y + 1, z - 1).func_149685_I(), this.renderBlocks.field_147845_a.func_147439_a(x + 1, y + 1, z).func_149685_I(), ratio);
            float aoMixed_XYZPPN = this.ao[0] = (aoLightValue + this.renderBlocks.field_147822_I + this.renderBlocks.field_147820_O + this.renderBlocks.field_147823_J) / 4.0f;
            float aoMixed_XYZPNN = this.ao[1] = (this.renderBlocks.field_147814_A + aoLightValue + this.renderBlocks.field_147816_C + this.renderBlocks.field_147820_O) / 4.0f;
            float aoMixed_XYZNNN = this.ao[2] = (this.renderBlocks.field_147888_x + this.renderBlocks.field_147819_N + this.renderBlocks.field_147814_A + aoLightValue) / 4.0f;
            float aoMixed_XYZNPN = this.ao[3] = (this.renderBlocks.field_147819_N + this.renderBlocks.field_147812_F + aoLightValue + this.renderBlocks.field_147822_I) / 4.0f;
            int brightnessMixed_XYZPPN = this.renderBlocks.field_147864_al = this.renderBlocks.func_147778_a(this.renderBlocks.field_147878_ac, this.renderBlocks.field_147866_ai, this.renderBlocks.field_147879_ad, this.brightness);
            int brightnessMixed_XYZPNN = this.renderBlocks.field_147874_am = this.renderBlocks.func_147778_a(this.renderBlocks.field_147825_U, this.renderBlocks.field_147827_W, this.renderBlocks.field_147866_ai, this.brightness);
            int brightnessMixed_XYZNNN = this.renderBlocks.field_147876_an = this.renderBlocks.func_147778_a(this.renderBlocks.field_147832_R, this.renderBlocks.field_147883_ah, this.renderBlocks.field_147825_U, this.brightness);
            int brightnessMixed_XYZNPN = this.renderBlocks.field_147870_ao = this.renderBlocks.func_147778_a(this.renderBlocks.field_147883_ah, this.renderBlocks.field_147836_Z, this.renderBlocks.field_147878_ac, this.brightness);
            if (this.renderBlocks.field_147849_o) {
                this.ao[0] = (float)((double)aoMixed_XYZNPN * this.renderBlocks.field_147857_k * (1.0 - this.renderBlocks.field_147861_i) + (double)aoMixed_XYZPPN * this.renderBlocks.field_147857_k * this.renderBlocks.field_147861_i + (double)aoMixed_XYZPNN * (1.0 - this.renderBlocks.field_147857_k) * this.renderBlocks.field_147861_i + (double)aoMixed_XYZNNN * (1.0 - this.renderBlocks.field_147857_k) * (1.0 - this.renderBlocks.field_147861_i));
                this.ao[1] = (float)((double)aoMixed_XYZNPN * this.renderBlocks.field_147855_j * (1.0 - this.renderBlocks.field_147861_i) + (double)aoMixed_XYZPPN * this.renderBlocks.field_147855_j * this.renderBlocks.field_147861_i + (double)aoMixed_XYZPNN * (1.0 - this.renderBlocks.field_147855_j) * this.renderBlocks.field_147861_i + (double)aoMixed_XYZNNN * (1.0 - this.renderBlocks.field_147855_j) * (1.0 - this.renderBlocks.field_147861_i));
                this.ao[2] = (float)((double)aoMixed_XYZNPN * this.renderBlocks.field_147855_j * (1.0 - this.renderBlocks.field_147859_h) + (double)aoMixed_XYZPPN * this.renderBlocks.field_147855_j * this.renderBlocks.field_147859_h + (double)aoMixed_XYZPNN * (1.0 - this.renderBlocks.field_147855_j) * this.renderBlocks.field_147859_h + (double)aoMixed_XYZNNN * (1.0 - this.renderBlocks.field_147855_j) * (1.0 - this.renderBlocks.field_147859_h));
                this.ao[3] = (float)((double)aoMixed_XYZNPN * this.renderBlocks.field_147857_k * (1.0 - this.renderBlocks.field_147859_h) + (double)aoMixed_XYZPPN * this.renderBlocks.field_147857_k * this.renderBlocks.field_147859_h + (double)aoMixed_XYZPNN * (1.0 - this.renderBlocks.field_147857_k) * this.renderBlocks.field_147859_h + (double)aoMixed_XYZNNN * (1.0 - this.renderBlocks.field_147857_k) * (1.0 - this.renderBlocks.field_147859_h));
                this.renderBlocks.field_147864_al = this.renderBlocks.func_147727_a(brightnessMixed_XYZNPN, brightnessMixed_XYZPPN, brightnessMixed_XYZPNN, brightnessMixed_XYZNNN, this.renderBlocks.field_147857_k * (1.0 - this.renderBlocks.field_147861_i), this.renderBlocks.field_147857_k * this.renderBlocks.field_147861_i, (1.0 - this.renderBlocks.field_147857_k) * this.renderBlocks.field_147861_i, (1.0 - this.renderBlocks.field_147857_k) * (1.0 - this.renderBlocks.field_147861_i));
                this.renderBlocks.field_147874_am = this.renderBlocks.func_147727_a(brightnessMixed_XYZNPN, brightnessMixed_XYZPPN, brightnessMixed_XYZPNN, brightnessMixed_XYZNNN, this.renderBlocks.field_147855_j * (1.0 - this.renderBlocks.field_147861_i), this.renderBlocks.field_147855_j * this.renderBlocks.field_147861_i, (1.0 - this.renderBlocks.field_147855_j) * this.renderBlocks.field_147861_i, (1.0 - this.renderBlocks.field_147855_j) * (1.0 - this.renderBlocks.field_147861_i));
                this.renderBlocks.field_147876_an = this.renderBlocks.func_147727_a(brightnessMixed_XYZNPN, brightnessMixed_XYZPPN, brightnessMixed_XYZPNN, brightnessMixed_XYZNNN, this.renderBlocks.field_147855_j * (1.0 - this.renderBlocks.field_147859_h), this.renderBlocks.field_147855_j * this.renderBlocks.field_147859_h, (1.0 - this.renderBlocks.field_147855_j) * this.renderBlocks.field_147859_h, (1.0 - this.renderBlocks.field_147855_j) * (1.0 - this.renderBlocks.field_147859_h));
                this.renderBlocks.field_147870_ao = this.renderBlocks.func_147727_a(brightnessMixed_XYZNPN, brightnessMixed_XYZPPN, brightnessMixed_XYZPNN, brightnessMixed_XYZNNN, this.renderBlocks.field_147857_k * (1.0 - this.renderBlocks.field_147859_h), this.renderBlocks.field_147857_k * this.renderBlocks.field_147859_h, (1.0 - this.renderBlocks.field_147857_k) * this.renderBlocks.field_147859_h, (1.0 - this.renderBlocks.field_147857_k) * (1.0 - this.renderBlocks.field_147859_h));
            }
        }
        return this;
    }

    public LightingHelper setupLightingZPos(ItemStack itemStack, int x, int y, int z) {
        Block block = BlockProperties.toBlock(itemStack);
        int z_offset = this.renderBlocks.field_147853_m < 1.0 ? z : z + 1;
        this.brightness = block.func_149677_c(this.renderBlocks.field_147845_a, x, y, z_offset);
        if (this.renderBlocks.field_147863_w) {
            float aoLightValue = this.renderBlocks.field_147845_a.func_147439_a(x, y, z_offset).func_149685_I();
            this.renderBlocks.field_147868_aj = block.func_149677_c(this.renderBlocks.field_147845_a, x - 1, y, z_offset);
            this.renderBlocks.field_147862_ak = block.func_149677_c(this.renderBlocks.field_147845_a, x + 1, y, z_offset);
            this.renderBlocks.field_147828_V = block.func_149677_c(this.renderBlocks.field_147845_a, x, y - 1, z_offset);
            this.renderBlocks.field_147887_af = block.func_149677_c(this.renderBlocks.field_147845_a, x, y + 1, z_offset);
            this.renderBlocks.field_147826_T = block.func_149677_c(this.renderBlocks.field_147845_a, x - 1, y - 1, z_offset);
            this.renderBlocks.field_147881_ab = block.func_149677_c(this.renderBlocks.field_147845_a, x - 1, y + 1, z_offset);
            this.renderBlocks.field_147834_Y = block.func_149677_c(this.renderBlocks.field_147845_a, x + 1, y - 1, z_offset);
            this.renderBlocks.field_147882_ag = block.func_149677_c(this.renderBlocks.field_147845_a, x + 1, y + 1, z_offset);
            this.renderBlocks.field_147830_P = LightingHelper.getMixedAo(this.renderBlocks.field_147845_a.func_147439_a(x - 1, y, z + 1).func_149685_I(), this.renderBlocks.field_147845_a.func_147439_a(x - 1, y, z).func_149685_I(), this.renderBlocks.field_147853_m);
            this.renderBlocks.field_147829_Q = LightingHelper.getMixedAo(this.renderBlocks.field_147845_a.func_147439_a(x + 1, y, z + 1).func_149685_I(), this.renderBlocks.field_147845_a.func_147439_a(x + 1, y, z).func_149685_I(), this.renderBlocks.field_147853_m);
            this.renderBlocks.field_147815_B = LightingHelper.getMixedAo(this.renderBlocks.field_147845_a.func_147439_a(x, y - 1, z + 1).func_149685_I(), this.renderBlocks.field_147845_a.func_147439_a(x, y - 1, z).func_149685_I(), this.renderBlocks.field_147853_m);
            this.renderBlocks.field_147817_L = LightingHelper.getMixedAo(this.renderBlocks.field_147845_a.func_147439_a(x, y + 1, z + 1).func_149685_I(), this.renderBlocks.field_147845_a.func_147439_a(x, y + 1, z).func_149685_I(), this.renderBlocks.field_147853_m);
            this.renderBlocks.field_147884_z = LightingHelper.getMixedAo(this.renderBlocks.field_147845_a.func_147439_a(x - 1, y - 1, z + 1).func_149685_I(), this.renderBlocks.field_147845_a.func_147439_a(x - 1, y - 1, z).func_149685_I(), this.renderBlocks.field_147853_m);
            this.renderBlocks.field_147821_H = LightingHelper.getMixedAo(this.renderBlocks.field_147845_a.func_147439_a(x - 1, y + 1, z + 1).func_149685_I(), this.renderBlocks.field_147845_a.func_147439_a(x - 1, y + 1, z).func_149685_I(), this.renderBlocks.field_147853_m);
            this.renderBlocks.field_147811_E = LightingHelper.getMixedAo(this.renderBlocks.field_147845_a.func_147439_a(x + 1, y - 1, z + 1).func_149685_I(), this.renderBlocks.field_147845_a.func_147439_a(x + 1, y - 1, z).func_149685_I(), this.renderBlocks.field_147853_m);
            this.renderBlocks.field_147818_M = LightingHelper.getMixedAo(this.renderBlocks.field_147845_a.func_147439_a(x + 1, y + 1, z + 1).func_149685_I(), this.renderBlocks.field_147845_a.func_147439_a(x + 1, y + 1, z).func_149685_I(), this.renderBlocks.field_147853_m);
            float aoMixed_XYZNPP = this.ao[0] = (this.renderBlocks.field_147830_P + this.renderBlocks.field_147821_H + aoLightValue + this.renderBlocks.field_147817_L) / 4.0f;
            float aoMixed_XYZNNP = this.ao[1] = (this.renderBlocks.field_147884_z + this.renderBlocks.field_147830_P + this.renderBlocks.field_147815_B + aoLightValue) / 4.0f;
            float aoMixed_XYZPNP = this.ao[2] = (this.renderBlocks.field_147815_B + aoLightValue + this.renderBlocks.field_147811_E + this.renderBlocks.field_147829_Q) / 4.0f;
            float aoMixed_XYZPPP = this.ao[3] = (aoLightValue + this.renderBlocks.field_147817_L + this.renderBlocks.field_147829_Q + this.renderBlocks.field_147818_M) / 4.0f;
            int brightnessMixed_XYZNPP = this.renderBlocks.field_147864_al = this.renderBlocks.func_147778_a(this.renderBlocks.field_147868_aj, this.renderBlocks.field_147881_ab, this.renderBlocks.field_147887_af, this.brightness);
            int brightnessMixed_XYZNNP = this.renderBlocks.field_147874_am = this.renderBlocks.func_147778_a(this.renderBlocks.field_147826_T, this.renderBlocks.field_147868_aj, this.renderBlocks.field_147828_V, this.brightness);
            int brightnessMixed_XYZPNP = this.renderBlocks.field_147876_an = this.renderBlocks.func_147778_a(this.renderBlocks.field_147828_V, this.renderBlocks.field_147834_Y, this.renderBlocks.field_147862_ak, this.brightness);
            int brightnessMixed_XYZPPP = this.renderBlocks.field_147870_ao = this.renderBlocks.func_147778_a(this.renderBlocks.field_147887_af, this.renderBlocks.field_147862_ak, this.renderBlocks.field_147882_ag, this.brightness);
            if (this.renderBlocks.field_147849_o) {
                this.ao[0] = (float)((double)aoMixed_XYZNPP * this.renderBlocks.field_147857_k * (1.0 - this.renderBlocks.field_147859_h) + (double)aoMixed_XYZPPP * this.renderBlocks.field_147857_k * this.renderBlocks.field_147859_h + (double)aoMixed_XYZPNP * (1.0 - this.renderBlocks.field_147857_k) * this.renderBlocks.field_147859_h + (double)aoMixed_XYZNNP * (1.0 - this.renderBlocks.field_147857_k) * (1.0 - this.renderBlocks.field_147859_h));
                this.ao[1] = (float)((double)aoMixed_XYZNPP * this.renderBlocks.field_147855_j * (1.0 - this.renderBlocks.field_147859_h) + (double)aoMixed_XYZPPP * this.renderBlocks.field_147855_j * this.renderBlocks.field_147859_h + (double)aoMixed_XYZPNP * (1.0 - this.renderBlocks.field_147855_j) * this.renderBlocks.field_147859_h + (double)aoMixed_XYZNNP * (1.0 - this.renderBlocks.field_147855_j) * (1.0 - this.renderBlocks.field_147859_h));
                this.ao[2] = (float)((double)aoMixed_XYZNPP * this.renderBlocks.field_147855_j * (1.0 - this.renderBlocks.field_147861_i) + (double)aoMixed_XYZPPP * this.renderBlocks.field_147855_j * this.renderBlocks.field_147861_i + (double)aoMixed_XYZPNP * (1.0 - this.renderBlocks.field_147855_j) * this.renderBlocks.field_147861_i + (double)aoMixed_XYZNNP * (1.0 - this.renderBlocks.field_147855_j) * (1.0 - this.renderBlocks.field_147861_i));
                this.ao[3] = (float)((double)aoMixed_XYZNPP * this.renderBlocks.field_147857_k * (1.0 - this.renderBlocks.field_147861_i) + (double)aoMixed_XYZPPP * this.renderBlocks.field_147857_k * this.renderBlocks.field_147861_i + (double)aoMixed_XYZPNP * (1.0 - this.renderBlocks.field_147857_k) * this.renderBlocks.field_147861_i + (double)aoMixed_XYZNNP * (1.0 - this.renderBlocks.field_147857_k) * (1.0 - this.renderBlocks.field_147861_i));
                this.renderBlocks.field_147864_al = this.renderBlocks.func_147727_a(brightnessMixed_XYZNPP, brightnessMixed_XYZNNP, brightnessMixed_XYZPNP, brightnessMixed_XYZPPP, this.renderBlocks.field_147857_k * (1.0 - this.renderBlocks.field_147859_h), (1.0 - this.renderBlocks.field_147857_k) * (1.0 - this.renderBlocks.field_147859_h), (1.0 - this.renderBlocks.field_147857_k) * this.renderBlocks.field_147859_h, this.renderBlocks.field_147857_k * this.renderBlocks.field_147859_h);
                this.renderBlocks.field_147874_am = this.renderBlocks.func_147727_a(brightnessMixed_XYZNPP, brightnessMixed_XYZNNP, brightnessMixed_XYZPNP, brightnessMixed_XYZPPP, this.renderBlocks.field_147855_j * (1.0 - this.renderBlocks.field_147859_h), (1.0 - this.renderBlocks.field_147855_j) * (1.0 - this.renderBlocks.field_147859_h), (1.0 - this.renderBlocks.field_147855_j) * this.renderBlocks.field_147859_h, this.renderBlocks.field_147855_j * this.renderBlocks.field_147859_h);
                this.renderBlocks.field_147876_an = this.renderBlocks.func_147727_a(brightnessMixed_XYZNPP, brightnessMixed_XYZNNP, brightnessMixed_XYZPNP, brightnessMixed_XYZPPP, this.renderBlocks.field_147855_j * (1.0 - this.renderBlocks.field_147861_i), (1.0 - this.renderBlocks.field_147855_j) * (1.0 - this.renderBlocks.field_147861_i), (1.0 - this.renderBlocks.field_147855_j) * this.renderBlocks.field_147861_i, this.renderBlocks.field_147855_j * this.renderBlocks.field_147861_i);
                this.renderBlocks.field_147870_ao = this.renderBlocks.func_147727_a(brightnessMixed_XYZNPP, brightnessMixed_XYZNNP, brightnessMixed_XYZPNP, brightnessMixed_XYZPPP, this.renderBlocks.field_147857_k * (1.0 - this.renderBlocks.field_147861_i), (1.0 - this.renderBlocks.field_147857_k) * (1.0 - this.renderBlocks.field_147861_i), (1.0 - this.renderBlocks.field_147857_k) * this.renderBlocks.field_147861_i, this.renderBlocks.field_147857_k * this.renderBlocks.field_147861_i);
            }
        }
        return this;
    }

    public LightingHelper setupLightingXNeg(ItemStack itemStack, int x, int y, int z) {
        Block block = BlockProperties.toBlock(itemStack);
        int x_offset = this.renderBlocks.field_147859_h > 0.0 ? x : x - 1;
        this.brightness = block.func_149677_c(this.renderBlocks.field_147845_a, x_offset, y, z);
        if (this.renderBlocks.field_147863_w) {
            float ratio = (float)(1.0 - this.renderBlocks.field_147859_h);
            float aoLightValue = this.renderBlocks.field_147845_a.func_147439_a(x_offset, y, z).func_149685_I();
            this.renderBlocks.field_147831_S = block.func_149677_c(this.renderBlocks.field_147845_a, x_offset, y - 1, z);
            this.renderBlocks.field_147883_ah = block.func_149677_c(this.renderBlocks.field_147845_a, x_offset, y, z - 1);
            this.renderBlocks.field_147868_aj = block.func_149677_c(this.renderBlocks.field_147845_a, x_offset, y, z + 1);
            this.renderBlocks.field_147880_aa = block.func_149677_c(this.renderBlocks.field_147845_a, x_offset, y + 1, z);
            this.renderBlocks.field_147832_R = block.func_149677_c(this.renderBlocks.field_147845_a, x_offset, y - 1, z - 1);
            this.renderBlocks.field_147826_T = block.func_149677_c(this.renderBlocks.field_147845_a, x_offset, y - 1, z + 1);
            this.renderBlocks.field_147836_Z = block.func_149677_c(this.renderBlocks.field_147845_a, x_offset, y + 1, z - 1);
            this.renderBlocks.field_147881_ab = block.func_149677_c(this.renderBlocks.field_147845_a, x_offset, y + 1, z + 1);
            this.renderBlocks.field_147886_y = LightingHelper.getMixedAo(this.renderBlocks.field_147845_a.func_147439_a(x - 1, y - 1, z).func_149685_I(), this.renderBlocks.field_147845_a.func_147439_a(x, y - 1, z).func_149685_I(), ratio);
            this.renderBlocks.field_147819_N = LightingHelper.getMixedAo(this.renderBlocks.field_147845_a.func_147439_a(x - 1, y, z - 1).func_149685_I(), this.renderBlocks.field_147845_a.func_147439_a(x, y, z - 1).func_149685_I(), ratio);
            this.renderBlocks.field_147830_P = LightingHelper.getMixedAo(this.renderBlocks.field_147845_a.func_147439_a(x - 1, y, z + 1).func_149685_I(), this.renderBlocks.field_147845_a.func_147439_a(x, y, z + 1).func_149685_I(), ratio);
            this.renderBlocks.field_147813_G = LightingHelper.getMixedAo(this.renderBlocks.field_147845_a.func_147439_a(x - 1, y + 1, z).func_149685_I(), this.renderBlocks.field_147845_a.func_147439_a(x, y + 1, z).func_149685_I(), ratio);
            this.renderBlocks.field_147888_x = LightingHelper.getMixedAo(this.renderBlocks.field_147845_a.func_147439_a(x - 1, y - 1, z - 1).func_149685_I(), this.renderBlocks.field_147845_a.func_147439_a(x, y - 1, z - 1).func_149685_I(), ratio);
            this.renderBlocks.field_147884_z = LightingHelper.getMixedAo(this.renderBlocks.field_147845_a.func_147439_a(x - 1, y - 1, z + 1).func_149685_I(), this.renderBlocks.field_147845_a.func_147439_a(x, y - 1, z + 1).func_149685_I(), ratio);
            this.renderBlocks.field_147812_F = LightingHelper.getMixedAo(this.renderBlocks.field_147845_a.func_147439_a(x - 1, y + 1, z - 1).func_149685_I(), this.renderBlocks.field_147845_a.func_147439_a(x, y + 1, z - 1).func_149685_I(), ratio);
            this.renderBlocks.field_147821_H = LightingHelper.getMixedAo(this.renderBlocks.field_147845_a.func_147439_a(x - 1, y + 1, z + 1).func_149685_I(), this.renderBlocks.field_147845_a.func_147439_a(x, y + 1, z + 1).func_149685_I(), ratio);
            float aoMixed_XYZNPN = this.ao[0] = (this.renderBlocks.field_147819_N + aoLightValue + this.renderBlocks.field_147812_F + this.renderBlocks.field_147813_G) / 4.0f;
            float aoMixed_XYZNNN = this.ao[1] = (this.renderBlocks.field_147888_x + this.renderBlocks.field_147886_y + this.renderBlocks.field_147819_N + aoLightValue) / 4.0f;
            float aoMixed_XYZNNP = this.ao[2] = (this.renderBlocks.field_147886_y + this.renderBlocks.field_147884_z + aoLightValue + this.renderBlocks.field_147830_P) / 4.0f;
            float aoMixed_XYZNPP = this.ao[3] = (aoLightValue + this.renderBlocks.field_147830_P + this.renderBlocks.field_147813_G + this.renderBlocks.field_147821_H) / 4.0f;
            int brightnessMixed_XYZNPN = this.renderBlocks.field_147864_al = this.renderBlocks.func_147778_a(this.renderBlocks.field_147883_ah, this.renderBlocks.field_147836_Z, this.renderBlocks.field_147880_aa, this.brightness);
            int brightnessMixed_XYZNNN = this.renderBlocks.field_147874_am = this.renderBlocks.func_147778_a(this.renderBlocks.field_147832_R, this.renderBlocks.field_147831_S, this.renderBlocks.field_147883_ah, this.brightness);
            int brightnessMixed_XYZNNP = this.renderBlocks.field_147876_an = this.renderBlocks.func_147778_a(this.renderBlocks.field_147831_S, this.renderBlocks.field_147826_T, this.renderBlocks.field_147868_aj, this.brightness);
            int brightnessMixed_XYZNPP = this.renderBlocks.field_147870_ao = this.renderBlocks.func_147778_a(this.renderBlocks.field_147868_aj, this.renderBlocks.field_147880_aa, this.renderBlocks.field_147881_ab, this.brightness);
            if (this.renderBlocks.field_147849_o) {
                this.ao[0] = (float)((double)aoMixed_XYZNPP * this.renderBlocks.field_147857_k * this.renderBlocks.field_147851_l + (double)aoMixed_XYZNPN * this.renderBlocks.field_147857_k * (1.0 - this.renderBlocks.field_147851_l) + (double)aoMixed_XYZNNN * (1.0 - this.renderBlocks.field_147857_k) * (1.0 - this.renderBlocks.field_147851_l) + (double)aoMixed_XYZNNP * (1.0 - this.renderBlocks.field_147857_k) * this.renderBlocks.field_147851_l);
                this.ao[1] = (float)((double)aoMixed_XYZNPP * this.renderBlocks.field_147855_j * this.renderBlocks.field_147851_l + (double)aoMixed_XYZNPN * this.renderBlocks.field_147855_j * (1.0 - this.renderBlocks.field_147851_l) + (double)aoMixed_XYZNNN * (1.0 - this.renderBlocks.field_147855_j) * (1.0 - this.renderBlocks.field_147851_l) + (double)aoMixed_XYZNNP * (1.0 - this.renderBlocks.field_147855_j) * this.renderBlocks.field_147851_l);
                this.ao[2] = (float)((double)aoMixed_XYZNPP * this.renderBlocks.field_147855_j * this.renderBlocks.field_147853_m + (double)aoMixed_XYZNPN * this.renderBlocks.field_147855_j * (1.0 - this.renderBlocks.field_147853_m) + (double)aoMixed_XYZNNN * (1.0 - this.renderBlocks.field_147855_j) * (1.0 - this.renderBlocks.field_147853_m) + (double)aoMixed_XYZNNP * (1.0 - this.renderBlocks.field_147855_j) * this.renderBlocks.field_147853_m);
                this.ao[3] = (float)((double)aoMixed_XYZNPP * this.renderBlocks.field_147857_k * this.renderBlocks.field_147853_m + (double)aoMixed_XYZNPN * this.renderBlocks.field_147857_k * (1.0 - this.renderBlocks.field_147853_m) + (double)aoMixed_XYZNNN * (1.0 - this.renderBlocks.field_147857_k) * (1.0 - this.renderBlocks.field_147853_m) + (double)aoMixed_XYZNNP * (1.0 - this.renderBlocks.field_147857_k) * this.renderBlocks.field_147853_m);
                this.renderBlocks.field_147864_al = this.renderBlocks.func_147727_a(brightnessMixed_XYZNPP, brightnessMixed_XYZNPN, brightnessMixed_XYZNNN, brightnessMixed_XYZNNP, this.renderBlocks.field_147857_k * this.renderBlocks.field_147851_l, this.renderBlocks.field_147857_k * (1.0 - this.renderBlocks.field_147851_l), (1.0 - this.renderBlocks.field_147857_k) * (1.0 - this.renderBlocks.field_147851_l), (1.0 - this.renderBlocks.field_147857_k) * this.renderBlocks.field_147851_l);
                this.renderBlocks.field_147874_am = this.renderBlocks.func_147727_a(brightnessMixed_XYZNPP, brightnessMixed_XYZNPN, brightnessMixed_XYZNNN, brightnessMixed_XYZNNP, this.renderBlocks.field_147855_j * this.renderBlocks.field_147851_l, this.renderBlocks.field_147855_j * (1.0 - this.renderBlocks.field_147851_l), (1.0 - this.renderBlocks.field_147855_j) * (1.0 - this.renderBlocks.field_147851_l), (1.0 - this.renderBlocks.field_147855_j) * this.renderBlocks.field_147851_l);
                this.renderBlocks.field_147876_an = this.renderBlocks.func_147727_a(brightnessMixed_XYZNPP, brightnessMixed_XYZNPN, brightnessMixed_XYZNNN, brightnessMixed_XYZNNP, this.renderBlocks.field_147855_j * this.renderBlocks.field_147853_m, this.renderBlocks.field_147855_j * (1.0 - this.renderBlocks.field_147853_m), (1.0 - this.renderBlocks.field_147855_j) * (1.0 - this.renderBlocks.field_147853_m), (1.0 - this.renderBlocks.field_147855_j) * this.renderBlocks.field_147853_m);
                this.renderBlocks.field_147870_ao = this.renderBlocks.func_147727_a(brightnessMixed_XYZNPP, brightnessMixed_XYZNPN, brightnessMixed_XYZNNN, brightnessMixed_XYZNNP, this.renderBlocks.field_147857_k * this.renderBlocks.field_147853_m, this.renderBlocks.field_147857_k * (1.0 - this.renderBlocks.field_147853_m), (1.0 - this.renderBlocks.field_147857_k) * (1.0 - this.renderBlocks.field_147853_m), (1.0 - this.renderBlocks.field_147857_k) * this.renderBlocks.field_147853_m);
            }
        }
        return this;
    }

    public LightingHelper setupLightingXPos(ItemStack itemStack, int x, int y, int z) {
        Block block = BlockProperties.toBlock(itemStack);
        int x_offset = this.renderBlocks.field_147861_i < 1.0 ? x : x + 1;
        this.brightness = block.func_149677_c(this.renderBlocks.field_147845_a, x_offset, y, z);
        if (this.renderBlocks.field_147863_w) {
            float aoLightValue = this.renderBlocks.field_147845_a.func_147439_a(x_offset, y, z).func_149685_I();
            this.renderBlocks.field_147835_X = block.func_149677_c(this.renderBlocks.field_147845_a, x_offset, y - 1, z);
            this.renderBlocks.field_147866_ai = block.func_149677_c(this.renderBlocks.field_147845_a, x_offset, y, z - 1);
            this.renderBlocks.field_147862_ak = block.func_149677_c(this.renderBlocks.field_147845_a, x_offset, y, z + 1);
            this.renderBlocks.field_147885_ae = block.func_149677_c(this.renderBlocks.field_147845_a, x_offset, y + 1, z);
            this.renderBlocks.field_147827_W = block.func_149677_c(this.renderBlocks.field_147845_a, x_offset, y - 1, z - 1);
            this.renderBlocks.field_147834_Y = block.func_149677_c(this.renderBlocks.field_147845_a, x_offset, y - 1, z + 1);
            this.renderBlocks.field_147879_ad = block.func_149677_c(this.renderBlocks.field_147845_a, x_offset, y + 1, z - 1);
            this.renderBlocks.field_147882_ag = block.func_149677_c(this.renderBlocks.field_147845_a, x_offset, y + 1, z + 1);
            this.renderBlocks.field_147810_D = LightingHelper.getMixedAo(this.renderBlocks.field_147845_a.func_147439_a(x + 1, y - 1, z).func_149685_I(), this.renderBlocks.field_147845_a.func_147439_a(x, y - 1, z).func_149685_I(), this.renderBlocks.field_147861_i);
            this.renderBlocks.field_147820_O = LightingHelper.getMixedAo(this.renderBlocks.field_147845_a.func_147439_a(x + 1, y, z - 1).func_149685_I(), this.renderBlocks.field_147845_a.func_147439_a(x, y, z - 1).func_149685_I(), this.renderBlocks.field_147861_i);
            this.renderBlocks.field_147829_Q = LightingHelper.getMixedAo(this.renderBlocks.field_147845_a.func_147439_a(x + 1, y, z + 1).func_149685_I(), this.renderBlocks.field_147845_a.func_147439_a(x, y, z + 1).func_149685_I(), this.renderBlocks.field_147861_i);
            this.renderBlocks.field_147824_K = LightingHelper.getMixedAo(this.renderBlocks.field_147845_a.func_147439_a(x + 1, y + 1, z).func_149685_I(), this.renderBlocks.field_147845_a.func_147439_a(x, y + 1, z).func_149685_I(), this.renderBlocks.field_147861_i);
            this.renderBlocks.field_147816_C = LightingHelper.getMixedAo(this.renderBlocks.field_147845_a.func_147439_a(x + 1, y - 1, z - 1).func_149685_I(), this.renderBlocks.field_147845_a.func_147439_a(x, y - 1, z - 1).func_149685_I(), this.renderBlocks.field_147861_i);
            this.renderBlocks.field_147811_E = LightingHelper.getMixedAo(this.renderBlocks.field_147845_a.func_147439_a(x + 1, y - 1, z + 1).func_149685_I(), this.renderBlocks.field_147845_a.func_147439_a(x, y - 1, z + 1).func_149685_I(), this.renderBlocks.field_147861_i);
            this.renderBlocks.field_147823_J = LightingHelper.getMixedAo(this.renderBlocks.field_147845_a.func_147439_a(x + 1, y + 1, z - 1).func_149685_I(), this.renderBlocks.field_147845_a.func_147439_a(x, y + 1, z - 1).func_149685_I(), this.renderBlocks.field_147861_i);
            this.renderBlocks.field_147818_M = LightingHelper.getMixedAo(this.renderBlocks.field_147845_a.func_147439_a(x + 1, y + 1, z + 1).func_149685_I(), this.renderBlocks.field_147845_a.func_147439_a(x, y + 1, z + 1).func_149685_I(), this.renderBlocks.field_147861_i);
            float aoMixed_XYZPPP = this.ao[0] = (aoLightValue + this.renderBlocks.field_147829_Q + this.renderBlocks.field_147824_K + this.renderBlocks.field_147818_M) / 4.0f;
            float aoMixed_XYZPNP = this.ao[1] = (this.renderBlocks.field_147810_D + this.renderBlocks.field_147811_E + aoLightValue + this.renderBlocks.field_147829_Q) / 4.0f;
            float aoMixed_XYZPNN = this.ao[2] = (this.renderBlocks.field_147816_C + this.renderBlocks.field_147810_D + this.renderBlocks.field_147820_O + aoLightValue) / 4.0f;
            float aoMixed_XYZPPN = this.ao[3] = (this.renderBlocks.field_147820_O + aoLightValue + this.renderBlocks.field_147823_J + this.renderBlocks.field_147824_K) / 4.0f;
            int brightnessMixed_XYZPPP = this.renderBlocks.field_147864_al = this.renderBlocks.func_147778_a(this.renderBlocks.field_147862_ak, this.renderBlocks.field_147885_ae, this.renderBlocks.field_147882_ag, this.brightness);
            int brightnessMixed_XYZPNP = this.renderBlocks.field_147874_am = this.renderBlocks.func_147778_a(this.renderBlocks.field_147835_X, this.renderBlocks.field_147834_Y, this.renderBlocks.field_147862_ak, this.brightness);
            int brightnessMixed_XYZPNN = this.renderBlocks.field_147876_an = this.renderBlocks.func_147778_a(this.renderBlocks.field_147827_W, this.renderBlocks.field_147835_X, this.renderBlocks.field_147866_ai, this.brightness);
            int brightnessMixed_XYZPPN = this.renderBlocks.field_147870_ao = this.renderBlocks.func_147778_a(this.renderBlocks.field_147866_ai, this.renderBlocks.field_147879_ad, this.renderBlocks.field_147885_ae, this.brightness);
            if (this.renderBlocks.field_147849_o) {
                this.ao[0] = (float)((double)aoMixed_XYZPNP * (1.0 - this.renderBlocks.field_147857_k) * this.renderBlocks.field_147853_m + (double)aoMixed_XYZPNN * (1.0 - this.renderBlocks.field_147857_k) * (1.0 - this.renderBlocks.field_147853_m) + (double)aoMixed_XYZPPN * this.renderBlocks.field_147857_k * (1.0 - this.renderBlocks.field_147853_m) + (double)aoMixed_XYZPPP * this.renderBlocks.field_147857_k * this.renderBlocks.field_147853_m);
                this.ao[1] = (float)((double)aoMixed_XYZPNP * (1.0 - this.renderBlocks.field_147855_j) * this.renderBlocks.field_147853_m + (double)aoMixed_XYZPNN * (1.0 - this.renderBlocks.field_147855_j) * (1.0 - this.renderBlocks.field_147853_m) + (double)aoMixed_XYZPPN * this.renderBlocks.field_147855_j * (1.0 - this.renderBlocks.field_147853_m) + (double)aoMixed_XYZPPP * this.renderBlocks.field_147855_j * this.renderBlocks.field_147853_m);
                this.ao[2] = (float)((double)aoMixed_XYZPNP * (1.0 - this.renderBlocks.field_147855_j) * this.renderBlocks.field_147851_l + (double)aoMixed_XYZPNN * (1.0 - this.renderBlocks.field_147855_j) * (1.0 - this.renderBlocks.field_147851_l) + (double)aoMixed_XYZPPN * this.renderBlocks.field_147855_j * (1.0 - this.renderBlocks.field_147851_l) + (double)aoMixed_XYZPPP * this.renderBlocks.field_147855_j * this.renderBlocks.field_147851_l);
                this.ao[3] = (float)((double)aoMixed_XYZPNP * (1.0 - this.renderBlocks.field_147857_k) * this.renderBlocks.field_147851_l + (double)aoMixed_XYZPNN * (1.0 - this.renderBlocks.field_147857_k) * (1.0 - this.renderBlocks.field_147851_l) + (double)aoMixed_XYZPPN * this.renderBlocks.field_147857_k * (1.0 - this.renderBlocks.field_147851_l) + (double)aoMixed_XYZPPP * this.renderBlocks.field_147857_k * this.renderBlocks.field_147851_l);
                this.renderBlocks.field_147864_al = this.renderBlocks.func_147727_a(brightnessMixed_XYZPNP, brightnessMixed_XYZPNN, brightnessMixed_XYZPPN, brightnessMixed_XYZPPP, (1.0 - this.renderBlocks.field_147857_k) * this.renderBlocks.field_147853_m, (1.0 - this.renderBlocks.field_147857_k) * (1.0 - this.renderBlocks.field_147853_m), this.renderBlocks.field_147857_k * (1.0 - this.renderBlocks.field_147853_m), this.renderBlocks.field_147857_k * this.renderBlocks.field_147853_m);
                this.renderBlocks.field_147874_am = this.renderBlocks.func_147727_a(brightnessMixed_XYZPNP, brightnessMixed_XYZPNN, brightnessMixed_XYZPPN, brightnessMixed_XYZPPP, (1.0 - this.renderBlocks.field_147855_j) * this.renderBlocks.field_147853_m, (1.0 - this.renderBlocks.field_147855_j) * (1.0 - this.renderBlocks.field_147853_m), this.renderBlocks.field_147855_j * (1.0 - this.renderBlocks.field_147853_m), this.renderBlocks.field_147855_j * this.renderBlocks.field_147853_m);
                this.renderBlocks.field_147876_an = this.renderBlocks.func_147727_a(brightnessMixed_XYZPNP, brightnessMixed_XYZPNN, brightnessMixed_XYZPPN, brightnessMixed_XYZPPP, (1.0 - this.renderBlocks.field_147855_j) * this.renderBlocks.field_147851_l, (1.0 - this.renderBlocks.field_147855_j) * (1.0 - this.renderBlocks.field_147851_l), this.renderBlocks.field_147855_j * (1.0 - this.renderBlocks.field_147851_l), this.renderBlocks.field_147855_j * this.renderBlocks.field_147851_l);
                this.renderBlocks.field_147870_ao = this.renderBlocks.func_147727_a(brightnessMixed_XYZPNP, brightnessMixed_XYZPNN, brightnessMixed_XYZPPN, brightnessMixed_XYZPPP, (1.0 - this.renderBlocks.field_147857_k) * this.renderBlocks.field_147851_l, (1.0 - this.renderBlocks.field_147857_k) * (1.0 - this.renderBlocks.field_147851_l), this.renderBlocks.field_147857_k * (1.0 - this.renderBlocks.field_147851_l), this.renderBlocks.field_147857_k * this.renderBlocks.field_147851_l);
            }
        }
        return this;
    }
}

