/*
 * Decompiled with CFR 0.152.
 */
package makeo.gadomancy.common.items;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import makeo.gadomancy.client.events.ResourceReloadListener;
import makeo.gadomancy.common.blocks.BlockRemoteJar;
import makeo.gadomancy.common.blocks.tiles.TileRemoteJar;
import makeo.gadomancy.common.registration.RegisteredBlocks;
import makeo.gadomancy.common.utils.NBTHelper;
import makeo.gadomancy.common.utils.StringHelper;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.common.blocks.ItemJarFilled;
import thaumcraft.common.config.ConfigItems;

public class ItemBlockRemoteJar
extends ItemBlock {
    public ItemBlockRemoteJar() {
        super((Block)RegisteredBlocks.blockRemoteJar);
    }

    public ItemBlockRemoteJar(Block block) {
        super(block);
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        NBTTagCompound compound;
        if (!world.field_72995_K && player.func_70093_af() && (compound = NBTHelper.getData(stack)).func_74764_b("networkId")) {
            compound.func_82580_o("networkId");
            if (compound.func_82582_d()) {
                stack.func_77982_d(null);
            }
            player.func_146105_b((IChatComponent)new ChatComponentTranslation("gadomancy.info.RemoteJar.clear", new Object[0]));
        }
        return super.func_77659_a(stack, world, player);
    }

    public boolean func_77648_a(ItemStack p_77648_1_, EntityPlayer p_77648_2_, World p_77648_3_, int p_77648_4_, int p_77648_5_, int p_77648_6_, int p_77648_7_, float p_77648_8_, float p_77648_9_, float p_77648_10_) {
        return super.func_77648_a(p_77648_1_, p_77648_2_, p_77648_3_, p_77648_4_, p_77648_5_, p_77648_6_, p_77648_7_, p_77648_8_, p_77648_9_, p_77648_10_);
    }

    public boolean onItemUseFirst(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        TileRemoteJar tile = BlockRemoteJar.getJarTile(world, x, y, z);
        if (tile != null) {
            if (!world.field_72995_K) {
                NBTTagCompound compound = NBTHelper.getData(stack);
                if (!player.func_70093_af()) {
                    UUID networkId = null;
                    if (tile.networkId == null) {
                        player.func_146105_b((IChatComponent)new ChatComponentTranslation("gadomancy.info.RemoteJar.new", new Object[0]));
                        tile.networkId = networkId = UUID.randomUUID();
                        tile.markForUpdate();
                    } else {
                        UUID current = NBTHelper.getUUID(compound, "networkId");
                        if (current == null || !current.equals(tile.networkId)) {
                            player.func_146105_b((IChatComponent)new ChatComponentTranslation("gadomancy.info.RemoteJar.connected", new Object[0]));
                            networkId = tile.networkId;
                        }
                    }
                    if (networkId != null) {
                        NBTHelper.setUUID(compound, "networkId", networkId);
                    }
                }
                return true;
            }
            return player.func_70093_af();
        }
        return false;
    }

    public boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ, int metadata) {
        boolean placed = super.placeBlockAt(stack, player, world, x, y, z, side, hitX, hitY, hitZ, metadata);
        if (placed && stack.func_77942_o()) {
            TileRemoteJar tile = (TileRemoteJar)world.func_147438_o(x, y, z);
            AspectList aspects = ((ItemJarFilled)ConfigItems.itemJarFilled).getAspects(stack);
            if (aspects != null) {
                tile.aspect = aspects.getAspects()[0];
                tile.amount = aspects.getAmount(tile.aspect);
            }
            if (!world.field_72995_K) {
                tile.networkId = NBTHelper.getUUID(stack.func_77978_p(), "networkId");
                tile.aspectFilter = Aspect.getAspect((String)stack.func_77978_p().func_74779_i("AspectFilter"));
                tile.markForUpdate();
            }
        }
        return placed;
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.uncommon;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean advancedItemTooltips) {
        UUID networkId;
        if (stack.func_77942_o() && (networkId = NBTHelper.getUUID(stack.func_77978_p(), "networkId")) != null) {
            list.add(String.format(StatCollector.func_74838_a((String)"gadomancy.lore.remotejar"), ItemBlockRemoteJar.generateName(networkId)));
        }
        ConfigItems.itemJarFilled.func_77624_a(stack, player, list, advancedItemTooltips);
    }

    public static String generateName(UUID uuid) {
        ArrayList values = new ArrayList(ResourceReloadListener.languageList.values());
        Random random = new Random(uuid.getLeastSignificantBits());
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < 2; ++i) {
            int entryIndex = random.nextInt(values.size());
            String[] split = ((String)values.get(entryIndex)).split(" ");
            String part = split[random.nextInt(split.length)];
            if (!ItemBlockRemoteJar.isValidName(part)) {
                --i;
                continue;
            }
            result.append(StringHelper.firstToUpper(part.toLowerCase()));
        }
        return result.toString().trim();
    }

    private static boolean isValidName(String name) {
        if (name.length() <= 8 && name.length() >= 4) {
            for (char c : name.toCharArray()) {
                if (Character.isAlphabetic(c)) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

