/*
 * Decompiled with CFR 0.152.
 */
package com.sinthoras.visualprospecting.database;

import com.sinthoras.visualprospecting.Utils;
import java.util.Arrays;
import net.minecraftforge.fluids.Fluid;

public class UndergroundFluidPosition {
    public static final int BYTES = 272;
    public static final UndergroundFluidPosition NOT_PROSPECTED = new UndergroundFluidPosition(0, 0, 0, null, null);
    public final int dimensionId;
    public final int chunkX;
    public final int chunkZ;
    public final Fluid fluid;
    public final int[][] chunks;

    public UndergroundFluidPosition(int dimensionId, int chunkX, int chunkZ, Fluid fluid, int[][] chunks) {
        this.dimensionId = dimensionId;
        this.chunkX = Utils.mapToCornerUndergroundFluidChunkCoord(chunkX);
        this.chunkZ = Utils.mapToCornerUndergroundFluidChunkCoord(chunkZ);
        this.fluid = fluid;
        this.chunks = chunks;
    }

    public int getBlockX() {
        return Utils.coordChunkToBlock(this.chunkX);
    }

    public int getBlockZ() {
        return Utils.coordChunkToBlock(this.chunkZ);
    }

    public int getMinProduction() {
        int smallest = Integer.MAX_VALUE;
        for (int chunkX = 0; chunkX < 8; ++chunkX) {
            for (int chunkZ = 0; chunkZ < 8; ++chunkZ) {
                if (this.chunks[chunkX][chunkZ] >= smallest) continue;
                smallest = this.chunks[chunkX][chunkZ];
            }
        }
        return smallest;
    }

    public int getMaxProduction() {
        int largest = Integer.MIN_VALUE;
        for (int chunkX = 0; chunkX < 8; ++chunkX) {
            for (int chunkZ = 0; chunkZ < 8; ++chunkZ) {
                if (this.chunks[chunkX][chunkZ] <= largest) continue;
                largest = this.chunks[chunkX][chunkZ];
            }
        }
        return largest;
    }

    public boolean isProspected() {
        return this.fluid != null;
    }

    public boolean equals(UndergroundFluidPosition other) {
        return this.dimensionId == other.dimensionId && this.chunkX == other.chunkX && this.chunkZ == other.chunkZ && this.fluid == other.fluid && Arrays.deepEquals((Object[])this.chunks, (Object[])other.chunks);
    }
}

