/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.hypercube;

import com.enderio.core.common.util.PlayerUtil;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import crazypants.enderio.machine.hypercube.Channel;
import crazypants.enderio.machine.hypercube.ClientChannelRegister;
import crazypants.enderio.machine.hypercube.HyperCubeRegister;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;

public class PacketChannelList
implements IMessage,
IMessageHandler<PacketChannelList, IMessage> {
    private boolean isPrivate;
    private List<Channel> channels;
    private UUID userId;

    public PacketChannelList() {
    }

    public PacketChannelList(EntityPlayer player, boolean isPrivate) {
        this(PlayerUtil.getPlayerUUID((String)player.func_146103_bH().getName()), isPrivate);
    }

    public PacketChannelList(UUID uuid, boolean isPrivate) {
        this.userId = uuid;
        this.isPrivate = isPrivate;
        if (isPrivate && uuid == null) {
            throw new RuntimeException("Null user ID.");
        }
        List<Channel> res = isPrivate ? HyperCubeRegister.instance.getChannelsForUser(uuid) : HyperCubeRegister.instance.getPublicChannels();
        this.channels = res != null && !res.isEmpty() ? new ArrayList<Channel>(res) : new ArrayList<Channel>();
    }

    public void toBytes(ByteBuf buffer) {
        buffer.writeBoolean(this.isPrivate);
        if (this.isPrivate) {
            buffer.writeLong(this.userId.getMostSignificantBits());
            buffer.writeLong(this.userId.getLeastSignificantBits());
        }
        buffer.writeInt(this.channels.size());
        for (Channel channel : this.channels) {
            ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)channel.name);
        }
    }

    public void fromBytes(ByteBuf buffer) {
        this.isPrivate = buffer.readBoolean();
        if (this.isPrivate) {
            long long1 = buffer.readLong();
            long long2 = buffer.readLong();
            this.userId = new UUID(long1, long2);
        } else {
            this.userId = null;
        }
        int numChannels = buffer.readInt();
        this.channels = new ArrayList<Channel>();
        for (int i = 0; i < numChannels; ++i) {
            this.channels.add(new Channel(ByteBufUtils.readUTF8String((ByteBuf)buffer), this.userId));
        }
    }

    public IMessage onMessage(PacketChannelList message, MessageContext ctx) {
        if (message.isPrivate) {
            ClientChannelRegister.instance.setPrivateChannels(message.channels);
        } else {
            ClientChannelRegister.instance.setPublicChannels(message.channels);
        }
        return null;
    }
}

