/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.capbank.network;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import crazypants.enderio.machine.capbank.TileCapBank;
import crazypants.enderio.machine.capbank.network.CapBankClientNetwork;
import crazypants.enderio.machine.capbank.network.NetworkState;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;

public class ClientNetworkManager {
    private static final ClientNetworkManager instance = new ClientNetworkManager();
    private final Map<Integer, CapBankClientNetwork> networks = new HashMap<Integer, CapBankClientNetwork>();

    public static ClientNetworkManager getInstance() {
        return instance;
    }

    ClientNetworkManager() {
    }

    public void destroyNetwork(int id) {
        CapBankClientNetwork res = this.networks.remove(id);
        if (res != null) {
            res.destroyNetwork();
        }
    }

    public void updateState(World world, int id, NetworkState state) {
        CapBankClientNetwork network = this.getOrCreateNetwork(id);
        network.setState(world, state);
    }

    public void updateEnergy(int id, long energyStored, float avgInput, float avgOutput) {
        CapBankClientNetwork res = this.networks.get(id);
        if (res == null) {
            return;
        }
        res.setEnergyStored(energyStored);
        res.setAverageIOPerTick(avgInput, avgOutput);
    }

    public CapBankClientNetwork getOrCreateNetwork(int id) {
        CapBankClientNetwork res = this.networks.get(id);
        if (res == null) {
            res = new CapBankClientNetwork(id);
            this.networks.put(id, res);
        }
        return res;
    }

    public void addToNetwork(int id, TileCapBank tileCapBank) {
        CapBankClientNetwork network = this.getOrCreateNetwork(id);
        network.addMember(tileCapBank);
    }

    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload event) {
        if (event.world.field_72995_K) {
            this.networks.forEach((id, network) -> network.destroyNetwork());
            this.networks.clear();
        }
    }

    static {
        MinecraftForge.EVENT_BUS.register((Object)instance);
    }
}

