/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.capbank;

import crazypants.enderio.config.Config;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;

public class CapBankType {
    public static final CapBankType CREATIVE = new CapBankType("CREATIVE", "tile.blockCapBank.creative", 500000, Config.capacitorBankTierTwoMaxStorageRF, false, true, "enderio:capacitorBank", "enderio:capacitorBankCreativeBorder", "enderio:capacitorBankInput", "enderio:capacitorBankOutput", "enderio:capacitorBankLocked");
    public static final CapBankType SIMPLE = new CapBankType("SIMPLE", "tile.blockCapBank.simple", Config.capacitorBankTierOneMaxIoRF, Config.capacitorBankTierOneMaxStorageRF, true, false, "enderio:capacitorBank", "enderio:capacitorBankSimpleBorder", "enderio:capacitorBankInput", "enderio:capacitorBankOutput", "enderio:capacitorBankLocked");
    public static final CapBankType ACTIVATED = new CapBankType("ACTIVATED", "tile.blockCapBank.activated", Config.capacitorBankTierTwoMaxIoRF, Config.capacitorBankTierTwoMaxStorageRF, true, false, "enderio:capacitorBank", "enderio:capacitorBankActivatedBorder", "enderio:capacitorBankInput", "enderio:capacitorBankOutput", "enderio:capacitorBankLocked");
    public static final CapBankType VIBRANT = new CapBankType("VIBRANT", "tile.blockCapBank.vibrant", Config.capacitorBankTierThreeMaxIoRF, Config.capacitorBankTierThreeMaxStorageRF, true, false, "enderio:capacitorBank", "enderio:capacitorBankVibrantBorder", "enderio:capacitorBankInput", "enderio:capacitorBankOutput", "enderio:capacitorBankLocked");
    private static final List<CapBankType> TYPES = new ArrayList<CapBankType>();
    private final String uid;
    private final String unlocalizedName;
    private final int maxIO;
    private final int maxStored;
    private final boolean isMultiblock;
    private final boolean isCreative;
    private final String icon;
    private final String borderIcon;
    private final String inputIcon;
    private final String outputIcon;
    private final String lockedIcon;

    public static List<CapBankType> types() {
        return TYPES;
    }

    public static int getMetaFromType(CapBankType type) {
        for (int i = 0; i < TYPES.size(); ++i) {
            if (TYPES.get(i) != type) continue;
            return i;
        }
        return 1;
    }

    public static CapBankType getTypeFromMeta(int meta) {
        meta = MathHelper.func_76125_a((int)meta, (int)0, (int)(TYPES.size() - 1));
        return CapBankType.types().get(meta);
    }

    public static CapBankType getTypeFromUID(String uid) {
        for (CapBankType type : TYPES) {
            if (!type.uid.equals(uid)) continue;
            return type;
        }
        return ACTIVATED;
    }

    public CapBankType(String uid, String unlocalizedName, int maxIO, int maxStored, boolean isMultiblock, boolean isCreative, String icon, String borderIcon, String inputIcon, String outputIcon, String lockedIcon) {
        this.uid = uid;
        this.unlocalizedName = unlocalizedName;
        this.maxIO = maxIO;
        this.maxStored = maxStored;
        this.isMultiblock = isMultiblock;
        this.isCreative = isCreative;
        this.icon = icon;
        this.borderIcon = borderIcon;
        this.inputIcon = inputIcon;
        this.outputIcon = outputIcon;
        this.lockedIcon = lockedIcon;
    }

    public int getMaxIO() {
        return this.maxIO;
    }

    public int getMaxEnergyStored() {
        return this.maxStored;
    }

    public boolean isMultiblock() {
        return this.isMultiblock;
    }

    public boolean isCreative() {
        return this.isCreative;
    }

    public String getUnlocalizedName() {
        return this.unlocalizedName;
    }

    public String getIcon() {
        return this.icon;
    }

    public String getBorderIcon() {
        return this.borderIcon;
    }

    public String getInputIcon() {
        return this.inputIcon;
    }

    public String getOutputIcon() {
        return this.outputIcon;
    }

    public String getLockedIcon() {
        return this.lockedIcon;
    }

    public String getUid() {
        return this.uid;
    }

    public void writeTypeToNBT(NBTTagCompound nbtRoot) {
        nbtRoot.func_74778_a("type", this.getUid());
    }

    public static CapBankType readTypeFromNBT(NBTTagCompound nbtRoot) {
        if (nbtRoot == null || !nbtRoot.func_74764_b("type")) {
            return ACTIVATED;
        }
        return CapBankType.getTypeFromUID(nbtRoot.func_74779_i("type"));
    }

    static {
        TYPES.add(CREATIVE);
        TYPES.add(SIMPLE);
        TYPES.add(ACTIVATED);
        TYPES.add(VIBRANT);
    }
}

