/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.reporting;

import appeng.api.AEApi;
import appeng.api.config.Settings;
import appeng.api.config.SortDir;
import appeng.api.config.SortOrder;
import appeng.api.config.TypeFilter;
import appeng.api.config.ViewItems;
import appeng.api.implementations.tiles.IViewCellStorage;
import appeng.api.networking.IGrid;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.ITerminalHost;
import appeng.api.storage.ITerminalPins;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.util.IConfigManager;
import appeng.core.sync.GuiBridge;
import appeng.items.contents.PinsHandler;
import appeng.items.contents.PinsHolder;
import appeng.me.GridAccessException;
import appeng.parts.reporting.AbstractPartDisplay;
import appeng.tile.inventory.AppEngInternalInventory;
import appeng.tile.inventory.IAEAppEngInventory;
import appeng.tile.inventory.InvOperation;
import appeng.util.ConfigManager;
import appeng.util.IConfigManagerHost;
import appeng.util.Platform;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Vec3;

public abstract class AbstractPartTerminal
extends AbstractPartDisplay
implements ITerminalHost,
IConfigManagerHost,
IViewCellStorage,
IAEAppEngInventory,
ITerminalPins {
    private final IConfigManager cm = new ConfigManager(this);
    private final AppEngInternalInventory viewCell = new AppEngInternalInventory(this, 5);
    private final PinsHolder pinsInv = new PinsHolder(this);
    private final AppEngInternalInventory upgrades = new RefillerInventory(this);

    public AbstractPartTerminal(ItemStack is) {
        super(is);
        this.cm.registerSetting(Settings.SORT_BY, SortOrder.NAME);
        this.cm.registerSetting(Settings.VIEW_MODE, ViewItems.ALL);
        this.cm.registerSetting(Settings.SORT_DIRECTION, SortDir.ASCENDING);
        this.cm.registerSetting(Settings.TYPE_FILTER, TypeFilter.ALL);
    }

    @Override
    public void getDrops(List<ItemStack> drops, boolean wrenched) {
        super.getDrops(drops, wrenched);
        for (ItemStack is : this.viewCell) {
            if (is == null) continue;
            drops.add(is);
        }
        ItemStack u = this.upgrades.func_70301_a(0);
        if (u != null) {
            drops.add(u);
        }
    }

    @Override
    public IConfigManager getConfigManager() {
        return this.cm;
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.cm.readFromNBT(data);
        this.viewCell.readFromNBT(data, "viewCell");
        this.pinsInv.readFromNBT(data, "pins");
        this.upgrades.readFromNBT(data, "upgrades");
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        this.cm.writeToNBT(data);
        this.viewCell.writeToNBT(data, "viewCell");
        this.pinsInv.writeToNBT(data, "pins");
        this.upgrades.writeToNBT(data, "upgrades");
    }

    @Override
    public boolean onPartActivate(EntityPlayer player, Vec3 pos) {
        if (!super.onPartActivate(player, pos) && !player.func_70093_af()) {
            if (Platform.isClient()) {
                return true;
            }
            Platform.openGUI(player, this.getHost().getTile(), this.getSide(), this.getGui(player));
            return true;
        }
        return false;
    }

    public GuiBridge getGui(EntityPlayer player) {
        return GuiBridge.GUI_ME;
    }

    @Override
    public IMEMonitor<IAEItemStack> getItemInventory() {
        try {
            return this.getProxy().getStorage().getItemInventory();
        }
        catch (GridAccessException gridAccessException) {
            return null;
        }
    }

    @Override
    public IMEMonitor<IAEFluidStack> getFluidInventory() {
        try {
            return this.getProxy().getStorage().getFluidInventory();
        }
        catch (GridAccessException gridAccessException) {
            return null;
        }
    }

    @Override
    public void updateSetting(IConfigManager manager, Enum settingName, Enum newValue) {
    }

    @Override
    public IInventory getViewCellStorage() {
        return this.viewCell;
    }

    @Override
    public PinsHandler getPinsHandler(EntityPlayer player) {
        return this.pinsInv.getHandler(player);
    }

    @Override
    public IGrid getGrid() {
        return this.getGridNode().getGrid();
    }

    @Override
    public void onChangeInventory(IInventory inv, int slot, InvOperation mc, ItemStack removedStack, ItemStack newStack) {
        this.getHost().markForSave();
    }

    @Override
    public IInventory getInventoryByName(String name) {
        if (name.equals("upgrades")) {
            return this.upgrades;
        }
        return super.getInventoryByName(name);
    }

    public boolean hasRefillerUpgrade() {
        return this.upgrades.func_70301_a(0) != null;
    }

    static class RefillerInventory
    extends AppEngInternalInventory {
        public RefillerInventory(IAEAppEngInventory parent) {
            super(parent, 1, 1);
            this.setTileEntity(parent);
        }

        @Override
        public boolean func_94041_b(int i, ItemStack itemstack) {
            return i == 0 && this.func_70301_a(0) == null && AEApi.instance().definitions().materials().cardPatternRefiller().isSameAs(itemstack);
        }
    }
}

