/*
 * Decompiled with CFR 0.152.
 */
package appeng.container.implementations;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.definitions.IDefinitions;
import appeng.api.networking.security.MachineSource;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.ITerminalHost;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IItemList;
import appeng.container.ContainerNull;
import appeng.container.guisync.GuiSync;
import appeng.container.implementations.ContainerMEMonitorable;
import appeng.container.slot.AppEngSlot;
import appeng.container.slot.IOptionalSlotHost;
import appeng.container.slot.OptionalSlotFake;
import appeng.container.slot.SlotFake;
import appeng.container.slot.SlotFakeCraftingMatrix;
import appeng.container.slot.SlotPatternOutputs;
import appeng.container.slot.SlotPatternTerm;
import appeng.container.slot.SlotRestrictedInput;
import appeng.core.sync.packets.PacketPatternSlot;
import appeng.helpers.IContainerCraftingPacket;
import appeng.items.storage.ItemViewCell;
import appeng.parts.reporting.PartPatternTerminal;
import appeng.tile.inventory.AppEngInternalInventory;
import appeng.tile.inventory.IAEAppEngInventory;
import appeng.tile.inventory.InvOperation;
import appeng.util.InventoryAdaptor;
import appeng.util.Platform;
import appeng.util.inv.AdaptorPlayerHand;
import appeng.util.item.AEItemStack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.Slot;
import net.minecraft.inventory.SlotCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.common.util.ForgeDirection;

public class ContainerPatternTerm
extends ContainerMEMonitorable
implements IAEAppEngInventory,
IOptionalSlotHost,
IContainerCraftingPacket {
    public static final int MULTIPLE_OF_BUTTON_CLICK = 2;
    public static final int MULTIPLE_OF_BUTTON_CLICK_ON_SHIFT = 8;
    private final PartPatternTerminal patternTerminal;
    private final AppEngInternalInventory cOut = new AppEngInternalInventory(null, 1);
    private final IInventory crafting;
    private final SlotFakeCraftingMatrix[] craftingSlots = new SlotFakeCraftingMatrix[9];
    private final OptionalSlotFake[] outputSlots = new OptionalSlotFake[3];
    private final SlotPatternTerm craftSlot;
    private final SlotRestrictedInput patternSlotIN;
    private final SlotRestrictedInput patternSlotOUT;
    @GuiSync(value=97)
    public boolean craftingMode = true;
    @GuiSync(value=96)
    public boolean substitute = false;
    @GuiSync(value=95)
    public boolean beSubstitute = true;

    public ContainerPatternTerm(InventoryPlayer ip, ITerminalHost monitorable) {
        super(ip, monitorable, false);
        int y;
        this.patternTerminal = (PartPatternTerminal)monitorable;
        IInventory patternInv = this.getPatternTerminal().getInventoryByName("pattern");
        IInventory output = this.getPatternTerminal().getInventoryByName("output");
        this.crafting = this.getPatternTerminal().getInventoryByName("crafting");
        for (y = 0; y < 3; ++y) {
            for (int x = 0; x < 3; ++x) {
                SlotFakeCraftingMatrix slotFakeCraftingMatrix = new SlotFakeCraftingMatrix(this.crafting, x + y * 3, 18 + x * 18, -76 + y * 18);
                this.craftingSlots[x + y * 3] = slotFakeCraftingMatrix;
                this.func_75146_a(slotFakeCraftingMatrix);
            }
        }
        this.craftSlot = new SlotPatternTerm(ip.field_70458_d, this.getActionSource(), this.getPowerSource(), monitorable, this.crafting, patternInv, this.cOut, 110, -58, this, 2, this);
        this.func_75146_a(this.craftSlot);
        this.craftSlot.setIIcon(-1);
        for (y = 0; y < 3; ++y) {
            this.outputSlots[y] = new SlotPatternOutputs(output, this, y, 110, -76 + y * 18, 0, 0, 1);
            this.func_75146_a(this.outputSlots[y]);
            this.outputSlots[y].setRenderDisabled(false);
        }
        this.patternSlotIN = new SlotRestrictedInput(SlotRestrictedInput.PlacableItemType.BLANK_PATTERN, patternInv, 0, 147, -81, this.getInventoryPlayer());
        this.func_75146_a(this.patternSlotIN);
        this.patternSlotOUT = new SlotRestrictedInput(SlotRestrictedInput.PlacableItemType.ENCODED_PATTERN, patternInv, 1, 147, -38, this.getInventoryPlayer());
        this.func_75146_a(this.patternSlotOUT);
        this.patternSlotOUT.setStackLimit(1);
        this.bindPlayerInventory(ip, 0, 0);
        this.updateOrderOfOutputSlots();
        if (this.getPatternTerminal().hasRefillerUpgrade()) {
            this.refillBlankPatterns(this.patternSlotIN);
        }
    }

    private void updateOrderOfOutputSlots() {
        if (!this.isCraftingMode()) {
            this.craftSlot.field_75223_e = -9000;
            for (int y = 0; y < 3; ++y) {
                this.outputSlots[y].field_75223_e = this.outputSlots[y].getX();
            }
        } else {
            this.craftSlot.field_75223_e = this.craftSlot.getX();
            for (int y = 0; y < 3; ++y) {
                this.outputSlots[y].field_75223_e = -9000;
            }
        }
    }

    public void func_75141_a(int par1, ItemStack par2ItemStack) {
        super.func_75141_a(par1, par2ItemStack);
        this.getAndUpdateOutput();
    }

    public void func_75131_a(ItemStack[] par1ArrayOfItemStack) {
        super.func_75131_a(par1ArrayOfItemStack);
        this.getAndUpdateOutput();
    }

    private ItemStack getAndUpdateOutput() {
        InventoryCrafting ic = new InventoryCrafting((Container)this, 3, 3);
        for (int x = 0; x < ic.func_70302_i_(); ++x) {
            ic.func_70299_a(x, this.crafting.func_70301_a(x));
        }
        ItemStack is = CraftingManager.func_77594_a().func_82787_a(ic, this.getPlayerInv().field_70458_d.field_70170_p);
        this.cOut.func_70299_a(0, is);
        return is;
    }

    @Override
    public void saveChanges() {
    }

    @Override
    public void onChangeInventory(IInventory inv, int slot, InvOperation mc, ItemStack removedStack, ItemStack newStack) {
    }

    public void encodeAndMoveToInventory(boolean encodeWholeStack) {
        this.encode();
        ItemStack output = this.patternSlotOUT.func_75211_c();
        if (output != null) {
            if (encodeWholeStack) {
                ItemStack blanks = this.patternSlotIN.func_75211_c();
                this.patternSlotIN.func_75215_d(null);
                if (blanks != null) {
                    output.field_77994_a += blanks.field_77994_a;
                }
            }
            if (!this.getPlayerInv().func_70441_a(output)) {
                this.getPlayerInv().field_70458_d.func_70099_a(output, 0.0f);
            }
            this.patternSlotOUT.func_75215_d(null);
            if (this.getPatternTerminal().hasRefillerUpgrade()) {
                this.refillBlankPatterns(this.patternSlotIN);
            }
        }
    }

    public void encode() {
        ItemStack output = this.patternSlotOUT.func_75211_c();
        ItemStack[] in = this.getInputs();
        ItemStack[] out = this.getOutputs();
        if (in == null || out == null) {
            return;
        }
        if (output != null && !this.isPattern(output)) {
            return;
        }
        if (output == null) {
            output = this.patternSlotIN.func_75211_c();
            if (!this.isPattern(output)) {
                return;
            }
            --output.field_77994_a;
            if (output.field_77994_a == 0) {
                this.patternSlotIN.func_75215_d(null);
            }
            Iterator iterator = AEApi.instance().definitions().items().encodedPattern().maybeStack(1).asSet().iterator();
            while (iterator.hasNext()) {
                ItemStack encodedPatternStack;
                output = encodedPatternStack = (ItemStack)iterator.next();
                this.patternSlotOUT.func_75215_d(output);
            }
            if (this.getPatternTerminal().hasRefillerUpgrade()) {
                this.refillBlankPatterns(this.patternSlotIN);
            }
        }
        NBTTagCompound encodedValue = new NBTTagCompound();
        NBTTagList tagIn = new NBTTagList();
        NBTTagList tagOut = new NBTTagList();
        for (ItemStack i : in) {
            tagIn.func_74742_a(this.createItemTag(i));
        }
        for (ItemStack i : out) {
            tagOut.func_74742_a(this.createItemTag(i));
        }
        encodedValue.func_74782_a("in", (NBTBase)tagIn);
        encodedValue.func_74782_a("out", (NBTBase)tagOut);
        encodedValue.func_74757_a("crafting", this.isCraftingMode());
        encodedValue.func_74757_a("substitute", this.isSubstitute());
        encodedValue.func_74757_a("beSubstitute", this.canBeSubstitute());
        encodedValue.func_74778_a("author", this.getPlayerInv().field_70458_d.func_70005_c_());
        output.func_77982_d(encodedValue);
    }

    private ItemStack[] getInputs() {
        ItemStack[] input = new ItemStack[9];
        boolean hasValue = false;
        for (int x = 0; x < this.craftingSlots.length; ++x) {
            input[x] = this.craftingSlots[x].func_75211_c();
            if (input[x] == null) continue;
            hasValue = true;
        }
        if (hasValue) {
            return input;
        }
        return null;
    }

    private ItemStack[] getOutputs() {
        if (this.isCraftingMode()) {
            ItemStack out = this.getAndUpdateOutput();
            if (out != null && out.field_77994_a > 0) {
                return new ItemStack[]{out};
            }
        } else {
            ArrayList<ItemStack> list = new ArrayList<ItemStack>(3);
            boolean hasValue = false;
            for (OptionalSlotFake outputSlot : this.outputSlots) {
                ItemStack out = outputSlot.func_75211_c();
                if (out == null || out.field_77994_a <= 0) continue;
                list.add(out);
                hasValue = true;
            }
            if (hasValue) {
                return list.toArray(new ItemStack[0]);
            }
        }
        return null;
    }

    private boolean isPattern(ItemStack output) {
        if (output == null) {
            return false;
        }
        IDefinitions definitions = AEApi.instance().definitions();
        boolean isPattern = definitions.items().encodedPattern().isSameAs(output);
        return isPattern |= definitions.materials().blankPattern().isSameAs(output);
    }

    private NBTBase createItemTag(ItemStack i) {
        NBTTagCompound c = new NBTTagCompound();
        if (i != null) {
            i.func_77955_b(c);
            c.func_74768_a("Count", i.field_77994_a);
        }
        return c;
    }

    @Override
    public boolean isSlotEnabled(int idx) {
        if (idx == 1) {
            return Platform.isServer() ? !this.getPatternTerminal().isCraftingRecipe() : !this.isCraftingMode();
        }
        if (idx == 2) {
            return Platform.isServer() ? this.getPatternTerminal().isCraftingRecipe() : this.isCraftingMode();
        }
        return false;
    }

    public void craftOrGetItem(PacketPatternSlot packetPatternSlot) {
        if (packetPatternSlot.slotItem != null && this.getCellInventory() != null) {
            IAEItemStack out = packetPatternSlot.slotItem.copy();
            InventoryAdaptor inv = new AdaptorPlayerHand(this.getPlayerInv().field_70458_d);
            InventoryAdaptor playerInv = InventoryAdaptor.getAdaptor(this.getPlayerInv().field_70458_d, ForgeDirection.UNKNOWN);
            if (packetPatternSlot.shift) {
                inv = playerInv;
            }
            if (inv.simulateAdd(out.getItemStack()) != null) {
                return;
            }
            IAEItemStack extracted = Platform.poweredExtraction(this.getPowerSource(), this.getCellInventory(), out, this.getActionSource());
            EntityPlayer p = this.getPlayerInv().field_70458_d;
            if (extracted != null) {
                inv.addItems(extracted.getItemStack());
                if (p instanceof EntityPlayerMP) {
                    this.updateHeld((EntityPlayerMP)p);
                }
                this.func_75142_b();
                return;
            }
            InventoryCrafting ic = new InventoryCrafting((Container)new ContainerNull(), 3, 3);
            InventoryCrafting real = new InventoryCrafting((Container)new ContainerNull(), 3, 3);
            for (int x = 0; x < 9; ++x) {
                ic.func_70299_a(x, packetPatternSlot.pattern[x] == null ? null : packetPatternSlot.pattern[x].getItemStack());
            }
            IRecipe r = Platform.findMatchingRecipe(ic, p.field_70170_p);
            if (r == null) {
                return;
            }
            IMEMonitor<IAEItemStack> storage = this.getPatternTerminal().getItemInventory();
            IItemList<IAEItemStack> all = storage.getStorageList();
            ItemStack is = r.func_77572_b(ic);
            for (int x = 0; x < ic.func_70302_i_(); ++x) {
                if (ic.func_70301_a(x) == null) continue;
                ItemStack pulled = Platform.extractItemsByRecipe(this.getPowerSource(), this.getActionSource(), storage, p.field_70170_p, r, is, ic, ic.func_70301_a(x), x, all, Actionable.MODULATE, ItemViewCell.createFilter(this.getViewCells()));
                real.func_70299_a(x, pulled);
            }
            IRecipe rr = Platform.findMatchingRecipe(real, p.field_70170_p);
            if (rr == r && Platform.isSameItemPrecise(rr.func_77572_b(real), is)) {
                SlotCrafting sc = new SlotCrafting(p, (IInventory)real, (IInventory)this.cOut, 0, 0, 0);
                sc.func_82870_a(p, is);
                for (int x = 0; x < real.func_70302_i_(); ++x) {
                    ItemStack failed = playerInv.addItems(real.func_70301_a(x));
                    if (failed == null) continue;
                    p.func_71019_a(failed, false);
                }
                inv.addItems(is);
                if (p instanceof EntityPlayerMP) {
                    this.updateHeld((EntityPlayerMP)p);
                }
                this.func_75142_b();
            } else {
                for (int x = 0; x < real.func_70302_i_(); ++x) {
                    ItemStack failed = real.func_70301_a(x);
                    if (failed == null) continue;
                    this.getCellInventory().injectItems(AEItemStack.create(failed), Actionable.MODULATE, new MachineSource(this.getPatternTerminal()));
                }
            }
        }
    }

    @Override
    public void func_75142_b() {
        super.func_75142_b();
        if (Platform.isServer()) {
            if (this.isCraftingMode() != this.getPatternTerminal().isCraftingRecipe()) {
                this.setCraftingMode(this.getPatternTerminal().isCraftingRecipe());
                this.updateOrderOfOutputSlots();
            }
            this.substitute = this.patternTerminal.isSubstitution();
            this.beSubstitute = this.patternTerminal.canBeSubstitution();
        }
    }

    @Override
    public void onUpdate(String field, Object oldValue, Object newValue) {
        super.onUpdate(field, oldValue, newValue);
        if (field.equals("craftingMode")) {
            this.getAndUpdateOutput();
            this.updateOrderOfOutputSlots();
        }
    }

    @Override
    public void onSlotChange(Slot s) {
        if (!Platform.isServer()) {
            return;
        }
        if (s == this.patternSlotOUT) {
            for (Object crafter : this.field_75149_d) {
                ICrafting icrafting = (ICrafting)crafter;
                for (Object g : this.field_75151_b) {
                    if (!(g instanceof OptionalSlotFake) && !(g instanceof SlotFakeCraftingMatrix)) continue;
                    Slot sri = (Slot)g;
                    icrafting.func_71111_a((Container)this, sri.field_75222_d, sri.func_75211_c());
                }
                ((EntityPlayerMP)icrafting).field_71137_h = false;
            }
            this.func_75142_b();
        } else if (s == this.patternRefiller && this.patternRefiller.func_75211_c() != null) {
            this.refillBlankPatterns(this.patternSlotIN);
            this.func_75142_b();
        }
    }

    public void clear() {
        for (SlotFakeCraftingMatrix slotFakeCraftingMatrix : this.craftingSlots) {
            slotFakeCraftingMatrix.func_75215_d(null);
        }
        for (SlotFake slotFake : this.outputSlots) {
            slotFake.func_75215_d(null);
        }
        this.func_75142_b();
        this.getAndUpdateOutput();
    }

    @Override
    public IInventory getInventoryByName(String name) {
        if (name.equals("player")) {
            return this.getInventoryPlayer();
        }
        return this.getPatternTerminal().getInventoryByName(name);
    }

    @Override
    public boolean useRealItems() {
        return false;
    }

    public void toggleSubstitute() {
        this.substitute = !this.substitute;
        this.func_75142_b();
        this.getAndUpdateOutput();
    }

    public boolean isCraftingMode() {
        return this.craftingMode;
    }

    private void setCraftingMode(boolean craftingMode) {
        this.craftingMode = craftingMode;
    }

    public PartPatternTerminal getPatternTerminal() {
        return this.patternTerminal;
    }

    private boolean isSubstitute() {
        return this.substitute;
    }

    private boolean canBeSubstitute() {
        return this.beSubstitute;
    }

    public void setSubstitute(boolean substitute) {
        this.substitute = substitute;
    }

    public void setCanBeSubstitute(boolean beSubstitute) {
        this.beSubstitute = beSubstitute;
    }

    public void doubleStacks(int val) {
        this.multiplyOrDivideStacks(((val & 1) != 0 ? 8 : 2) * ((val & 2) != 0 ? -1 : 1));
    }

    static boolean canMultiplyOrDivide(SlotFake[] slots, int mult) {
        if (mult > 0) {
            for (SlotFake s : slots) {
                long val;
                if (s.func_75211_c() == null || (val = (long)s.func_75211_c().field_77994_a * (long)mult) <= Integer.MAX_VALUE) continue;
                return false;
            }
            return true;
        }
        if (mult < 0) {
            mult = -mult;
            for (SlotFake s : slots) {
                if (s.func_75211_c() == null || s.func_75211_c().field_77994_a % mult == 0) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    static void multiplyOrDivideStacksInternal(SlotFake[] slots, int mult) {
        block3: {
            List enabledSlots;
            block2: {
                enabledSlots = Arrays.stream(slots).filter(AppEngSlot::isEnabled).collect(Collectors.toList());
                if (mult <= 0) break block2;
                for (Slot s : enabledSlots) {
                    ItemStack st = s.func_75211_c();
                    if (st == null) continue;
                    st.field_77994_a *= mult;
                    s.func_75215_d(st);
                }
                break block3;
            }
            if (mult >= 0) break block3;
            mult = -mult;
            for (Slot s : enabledSlots) {
                ItemStack st = s.func_75211_c();
                if (st == null) continue;
                st.field_77994_a /= mult;
                s.func_75215_d(st);
            }
        }
    }

    public void multiplyOrDivideStacks(int multi) {
        if (!this.isCraftingMode()) {
            if (ContainerPatternTerm.canMultiplyOrDivide(this.craftingSlots, multi) && ContainerPatternTerm.canMultiplyOrDivide(this.outputSlots, multi)) {
                ContainerPatternTerm.multiplyOrDivideStacksInternal(this.craftingSlots, multi);
                ContainerPatternTerm.multiplyOrDivideStacksInternal(this.outputSlots, multi);
            }
            this.func_75142_b();
        }
    }

    @Override
    public boolean isAPatternTerminal() {
        return true;
    }
}

