/*
 * Decompiled with CFR 0.152.
 */
package mods.battlegear2.api.core;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.EventBus;
import java.io.Closeable;
import java.io.IOException;
import mods.battlegear2.api.IAllowItem;
import mods.battlegear2.api.IOffhandDual;
import mods.battlegear2.api.IOffhandWield;
import mods.battlegear2.api.IUsableItem;
import mods.battlegear2.api.PlayerEventChild;
import mods.battlegear2.api.core.IBattlePlayer;
import mods.battlegear2.api.quiver.IArrowContainer2;
import mods.battlegear2.api.quiver.ISpecialBow;
import mods.battlegear2.api.shield.IShield;
import mods.battlegear2.api.weapons.IBattlegearWeapon;
import mods.battlegear2.api.weapons.WeaponRegistry;
import mods.battlegear2.asm.loader.BattlegearLoadingPlugin;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.BaseAttributeMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemBucket;
import net.minecraft.item.ItemEnderPearl;
import net.minecraft.item.ItemFireball;
import net.minecraft.item.ItemFlintAndSteel;
import net.minecraft.item.ItemSnowball;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTSizeTracker;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.oredict.OreDictionary;
import xonin.backhand.api.core.BackhandUtils;

public class BattlegearUtils {
    public static final EventBus RENDER_BUS = new EventBus();
    private static final String[] itemBlackListMethodNames = new String[]{BattlegearLoadingPlugin.isObf() ? "func_77648_a" : "onItemUse", "onItemUseFirst", BattlegearLoadingPlugin.isObf() ? "func_77659_a" : "onItemRightClick"};
    private static final Class<?>[][] itemBlackListMethodParams = new Class[][]{{ItemStack.class, EntityPlayer.class, World.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Float.TYPE, Float.TYPE, Float.TYPE}, {ItemStack.class, EntityPlayer.class, World.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Float.TYPE, Float.TYPE, Float.TYPE}, {ItemStack.class, World.class, EntityPlayer.class}};
    private static ItemStack prevNotWieldable;
    private static final String genericAttack;

    public static boolean canBlockWithShield(EntityPlayer player) {
        ItemStack offhand = BackhandUtils.getOffhandItem((EntityPlayer)player);
        return offhand != null && offhand.func_77973_b() instanceof IShield;
    }

    public static boolean isBlockingWithShield(EntityPlayer player) {
        return ((IBattlePlayer)player).battlegear2$isBlockingWithShield();
    }

    public static void setPlayerCurrentItem(EntityPlayer player, ItemStack stack) {
        player.field_71071_by.field_70462_a[player.field_71071_by.field_70461_c] = stack;
    }

    public static void setPlayerOffhandItem(EntityPlayer player, ItemStack stack) {
        BackhandUtils.setPlayerOffhandItem((EntityPlayer)player, (ItemStack)stack);
    }

    public static boolean isWeapon(ItemStack main) {
        if (main.func_77973_b() instanceof IBattlegearWeapon) {
            return true;
        }
        if (main.func_77976_d() == 1 && main.func_77958_k() > 0 && !main.func_77981_g()) {
            return true;
        }
        if (main == prevNotWieldable) {
            return false;
        }
        if (WeaponRegistry.isWeapon(main)) {
            return true;
        }
        if (BattlegearUtils.checkWeaponOreDictEntries(main)) {
            return true;
        }
        if (!BattlegearUtils.checkForRightClickFunction(main)) {
            WeaponRegistry.addDualWeapon(main);
            return true;
        }
        prevNotWieldable = main;
        return false;
    }

    public static boolean checkWeaponOreDictEntries(ItemStack main) {
        int[] oreDictEntries = OreDictionary.getOreIDs((ItemStack)main);
        for (int i = 0; i < oreDictEntries.length; ++i) {
            int ore = oreDictEntries[i];
            String name = OreDictionary.getOreName((int)ore);
            if (!name.equals("craftingToolBlade") && !name.equals("craftingToolAxe")) continue;
            return true;
        }
        return false;
    }

    public static boolean isMainHand(ItemStack main, ItemStack off) {
        if (main == null) {
            return true;
        }
        if (main.func_77973_b() instanceof IAllowItem) {
            return ((IAllowItem)main.func_77973_b()).allowOffhand(main, off);
        }
        if (main.func_77973_b() instanceof IArrowContainer2) {
            return true;
        }
        if (BattlegearUtils.usagePriorAttack(main)) {
            return off == null || !BattlegearUtils.usagePriorAttack(off);
        }
        if (BattlegearUtils.isWeapon(main)) {
            return BattlegearUtils.checkWeaponOreDictEntries(main) || main.func_111283_C().containsKey((Object)genericAttack) || WeaponRegistry.isMainHand(main);
        }
        return false;
    }

    public static boolean isMainHand(ItemStack main, ItemStack off, EntityPlayer wielder) {
        if (main == null) {
            return true;
        }
        if (main.func_77973_b() instanceof IAllowItem) {
            return ((IAllowItem)main.func_77973_b()).allowOffhand(main, off);
        }
        if (main.func_77973_b() instanceof IArrowContainer2) {
            return true;
        }
        if (BattlegearUtils.usagePriorAttack(main, wielder, false)) {
            return off == null || !BattlegearUtils.usagePriorAttack(off, wielder, true);
        }
        if (BattlegearUtils.isWeapon(main)) {
            return BattlegearUtils.checkWeaponOreDictEntries(main) || main.func_111283_C().containsKey((Object)genericAttack) || WeaponRegistry.isMainHand(main);
        }
        return false;
    }

    public static boolean isOffHand(ItemStack off) {
        if (off == null) {
            return true;
        }
        if (off.func_77973_b() instanceof IOffhandDual) {
            return ((IOffhandDual)off.func_77973_b()).isOffhandHandDual(off);
        }
        if (off.func_77973_b() instanceof IShield || off.func_77973_b() instanceof IArrowContainer2 || BattlegearUtils.usagePriorAttack(off)) {
            return true;
        }
        if (BattlegearUtils.isWeapon(off)) {
            return BattlegearUtils.checkWeaponOreDictEntries(off) || off.func_111283_C().containsKey((Object)genericAttack) || WeaponRegistry.isOffHand(off);
        }
        return false;
    }

    public static boolean isOffHand(ItemStack off, EntityPlayer wielder) {
        if (off == null) {
            return true;
        }
        if (off.func_77973_b() instanceof IOffhandDual) {
            return ((IOffhandDual)off.func_77973_b()).isOffhandHandDual(off);
        }
        if (off.func_77973_b() instanceof IOffhandWield) {
            return ((IOffhandWield)off.func_77973_b()).isOffhandWieldable(off, wielder);
        }
        if (off.func_77973_b() instanceof IShield || off.func_77973_b() instanceof IArrowContainer2 || BattlegearUtils.usagePriorAttack(off, wielder, true)) {
            return true;
        }
        if (BattlegearUtils.isWeapon(off)) {
            return BattlegearUtils.checkWeaponOreDictEntries(off) || off.func_111283_C().containsKey((Object)genericAttack) || WeaponRegistry.isOffHand(off);
        }
        return false;
    }

    public static boolean usagePriorAttack(ItemStack itemStack) {
        if (itemStack.func_77973_b() instanceof IUsableItem) {
            return ((IUsableItem)itemStack.func_77973_b()).isUsedOverAttack(itemStack);
        }
        EnumAction useAction = itemStack.func_77975_n();
        return useAction == EnumAction.bow || useAction == EnumAction.drink || useAction == EnumAction.eat || BattlegearUtils.isCommonlyUsable(itemStack.func_77973_b());
    }

    public static boolean usagePriorAttack(ItemStack itemStack, EntityPlayer wielder, boolean off) {
        if (itemStack.func_77973_b() instanceof IUsableItem) {
            return ((IUsableItem)itemStack.func_77973_b()).isUsedOverAttack(itemStack);
        }
        EnumAction useAction = itemStack.func_77975_n();
        return useAction == EnumAction.bow || useAction == EnumAction.drink || useAction == EnumAction.eat || BattlegearUtils.isCommonlyUsable(itemStack.func_77973_b()) || WeaponRegistry.useOverAttack(itemStack, off);
    }

    public static boolean isCommonlyUsable(Item item) {
        return BattlegearUtils.isBow(item) || item instanceof ItemBlock || item instanceof ItemFlintAndSteel || item instanceof ItemFireball || item instanceof ItemBucket || item instanceof ItemSnowball || item instanceof ItemEnderPearl;
    }

    public static boolean isBow(Item item) {
        return item instanceof ItemBow || item instanceof ISpecialBow;
    }

    @Deprecated
    public static boolean checkForRightClickFunction(Item item, ItemStack stack) {
        return BattlegearUtils.checkForRightClickFunction(stack);
    }

    public static boolean checkForRightClickFunction(ItemStack stack) {
        if (stack.func_77975_n() == EnumAction.block || stack.func_77975_n() == EnumAction.none) {
            Class<?> c = stack.func_77973_b().getClass();
            while (!(c.equals(Item.class) || c.equals(ItemTool.class) || c.equals(ItemSword.class))) {
                if (BattlegearUtils.getBlackListedMethodIn(c)) {
                    return true;
                }
                c = c.getSuperclass();
            }
            return false;
        }
        return true;
    }

    private static boolean getBlackListedMethodIn(Class<?> c) {
        for (int i = 0; i < itemBlackListMethodNames.length; ++i) {
            try {
                c.getDeclaredMethod(itemBlackListMethodNames[i], itemBlackListMethodParams[i]);
                return true;
            }
            catch (Throwable throwable) {
                continue;
            }
        }
        return false;
    }

    public static ItemStack readItemStack(ByteArrayDataInput par0DataInputStream) throws IOException {
        ItemStack itemstack = null;
        int short1 = par0DataInputStream.readInt();
        if (short1 >= 0) {
            byte b0 = par0DataInputStream.readByte();
            short short2 = par0DataInputStream.readShort();
            itemstack = new ItemStack(Item.func_150899_d((int)short1), (int)b0, (int)short2);
            itemstack.field_77990_d = BattlegearUtils.readNBTTagCompound(par0DataInputStream);
        }
        return itemstack;
    }

    public static NBTTagCompound readNBTTagCompound(ByteArrayDataInput par0DataInputStream) throws IOException {
        short short1 = par0DataInputStream.readShort();
        if (short1 < 0) {
            return null;
        }
        byte[] abyte = new byte[short1];
        par0DataInputStream.readFully(abyte);
        return CompressedStreamTools.func_152457_a((byte[])abyte, (NBTSizeTracker)NBTSizeTracker.field_152451_a);
    }

    public static void writeItemStack(ByteArrayDataOutput par1DataOutputStream, ItemStack par0ItemStack) throws IOException {
        if (par0ItemStack == null) {
            par1DataOutputStream.writeShort(-1);
        } else {
            par1DataOutputStream.writeInt(Item.func_150891_b((Item)par0ItemStack.func_77973_b()));
            par1DataOutputStream.writeByte(par0ItemStack.field_77994_a);
            par1DataOutputStream.writeShort(par0ItemStack.func_77960_j());
            NBTTagCompound nbttagcompound = null;
            if (par0ItemStack.func_77973_b().func_77645_m() || par0ItemStack.func_77973_b().func_77651_p()) {
                nbttagcompound = par0ItemStack.field_77990_d;
            }
            BattlegearUtils.writeNBTTagCompound(nbttagcompound, par1DataOutputStream);
        }
    }

    protected static void writeNBTTagCompound(NBTTagCompound par0NBTTagCompound, ByteArrayDataOutput par1DataOutputStream) throws IOException {
        if (par0NBTTagCompound == null) {
            par1DataOutputStream.writeShort(-1);
        } else {
            byte[] abyte = CompressedStreamTools.func_74798_a((NBTTagCompound)par0NBTTagCompound);
            par1DataOutputStream.writeShort((int)((short)abyte.length));
            par1DataOutputStream.write(abyte);
        }
    }

    public static void sendOffSwingEvent(PlayerEvent event, ItemStack offhandItem) {
        if (!MinecraftForge.EVENT_BUS.post((Event)new PlayerEventChild.OffhandSwingEvent(event, offhandItem))) {
            ((IBattlePlayer)event.entityPlayer).battlegear2$swingOffItem();
        }
    }

    public static void refreshAttributes(BaseAttributeMap attributeMap, ItemStack oldItem, ItemStack currentItem) {
        if (oldItem != null) {
            attributeMap.func_111148_a(oldItem.func_111283_C());
        }
        if (currentItem != null) {
            attributeMap.func_111147_b(currentItem.func_111283_C());
        }
    }

    public static void closeStream(Closeable c) {
        try {
            if (c != null) {
                c.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void onBowStackDepleted(EntityPlayer entityPlayer, ItemStack itemStack) {
        if (itemStack == entityPlayer.func_71045_bC()) {
            entityPlayer.func_71028_bD();
        } else {
            ItemStack orig = BackhandUtils.getOffhandItem((EntityPlayer)entityPlayer);
            if (orig == itemStack) {
                BattlegearUtils.setPlayerOffhandItem(entityPlayer, null);
                ForgeEventFactory.onPlayerDestroyItem((EntityPlayer)entityPlayer, (ItemStack)orig);
            }
        }
    }

    static {
        genericAttack = SharedMonsterAttributes.field_111264_e.func_111108_a();
    }
}

