/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.Direction;
import net.minecraft.world.World;
import twilightforest.TFTreasure;
import twilightforest.block.TFBlocks;
import twilightforest.entity.TFCreatures;
import twilightforest.world.TFGenerator;
import twilightforest.world.TFWorld;

public class TFGenHollowTree
extends TFGenerator {
    private static final int LEAF_DUNGEON_CHANCE = 8;
    protected Block treeBlock = TFBlocks.log;
    protected int treeMeta = 0;
    protected int branchMeta = 12;
    protected Block leafBlock = TFBlocks.leaves;
    protected int leafMeta = 0;
    protected Block rootBlock = TFBlocks.root;
    protected int rootMeta = 0;

    public TFGenHollowTree() {
        this(false);
    }

    public TFGenHollowTree(boolean par1) {
        super(par1);
    }

    public boolean func_76484_a(World world, Random random, int x, int y, int z) {
        double fAngle;
        int i;
        int height = random.nextInt(64) + 32;
        int diameter = random.nextInt(4) + 1;
        if (y < 1 || y + height + diameter > TFWorld.MAXHEIGHT) {
            return false;
        }
        int crownRadius = diameter * 4 + 8;
        for (int dx = -crownRadius; dx <= crownRadius; ++dx) {
            for (int dz = -crownRadius; dz <= crownRadius; ++dz) {
                for (int dy = height - crownRadius; dy <= height + crownRadius; ++dy) {
                    Block whatsThere = world.func_147439_a(dx + x, dy + y, dz + z);
                    if (whatsThere == Blocks.field_150350_a || whatsThere == Blocks.field_150362_t) continue;
                    return false;
                }
            }
        }
        Block j1 = world.func_147439_a(x, y - 1, z);
        if (j1 != Blocks.field_150349_c && j1 != Blocks.field_150346_d) {
            return false;
        }
        this.buildTrunk(world, random, x, y, z, diameter, height);
        int numFireflies = random.nextInt(3 * diameter) + 5;
        for (i = 0; i <= numFireflies; ++i) {
            int fHeight = (int)((double)height * random.nextDouble() * 0.9) + height / 10;
            fAngle = random.nextDouble();
            this.addFirefly(world, x, y, z, diameter, fHeight, fAngle);
        }
        numFireflies = random.nextInt(3 * diameter) + 5;
        for (i = 0; i <= numFireflies; ++i) {
            int fHeight = (int)((double)height * random.nextDouble() * 0.9) + height / 10;
            fAngle = random.nextDouble();
            this.addCicada(world, x, y, z, diameter, fHeight, fAngle);
        }
        this.buildFullCrown(world, random, x, y, z, diameter, height);
        int numBranches = random.nextInt(3) + 3;
        for (int i2 = 0; i2 <= numBranches; ++i2) {
            int branchHeight = (int)((double)height * random.nextDouble() * 0.9) + height / 10;
            double branchRotation = random.nextDouble();
            this.makeSmallBranch(world, random, x, y, z, diameter, branchHeight, 4.0, branchRotation, 0.35, true);
        }
        this.buildBranchRing(world, random, x, y, z, diameter, 3, 2, 6, 0, 0.75, 0.0, 3, 5, 3, false);
        this.buildBranchRing(world, random, x, y, z, diameter, 1, 2, 8, 0, 0.9, 0.0, 3, 5, 3, false);
        return true;
    }

    protected void buildFullCrown(World world, Random random, int x, int y, int z, int diameter, int height) {
        int crownRadius = diameter * 4 + 4;
        int bvar = diameter + 2;
        this.buildBranchRing(world, random, x, y, z, diameter, height - crownRadius, 0, crownRadius, 0, 0.35, 0.0, bvar, bvar + 2, 2, true);
        this.buildBranchRing(world, random, x, y, z, diameter, height - crownRadius / 2, 0, crownRadius, 0, 0.28, 0.0, bvar, bvar + 2, 1, true);
        this.buildBranchRing(world, random, x, y, z, diameter, height, 0, crownRadius, 0, 0.15, 0.0, 2, 4, 2, true);
        this.buildBranchRing(world, random, x, y, z, diameter, height, 0, crownRadius / 2, 0, 0.05, 0.0, bvar, bvar + 2, 1, true);
    }

    protected void buildWeakCrown(World world, Random random, int x, int y, int z, int diameter, int height) {
        int crownRadius = 8;
        int bvar = 2;
        this.buildBranchRing(world, random, x, y, z, diameter, height - crownRadius, 0, crownRadius, 0, 0.35, 0.0, bvar, bvar + 2, 1, true);
        this.buildBranchRing(world, random, x, y, z, diameter, height - crownRadius / 2, 0, crownRadius, 0, 0.28, 0.0, bvar, bvar + 2, 1, true);
        this.buildBranchRing(world, random, x, y, z, diameter, height, 0, crownRadius, 0, 0.15, 0.0, 2, 4, 1, true);
        this.buildBranchRing(world, random, x, y, z, diameter, height, 0, crownRadius / 2, 0, 0.05, 0.0, bvar, bvar + 2, 1, true);
    }

    protected void buildBranchRing(World world, Random random, int x, int y, int z, int diameter, int branchHeight, int heightVar, int length, int lengthVar, double tilt, double tiltVar, int minBranches, int maxBranches, int size, boolean leafy) {
        int numBranches = random.nextInt(maxBranches - minBranches) + minBranches;
        double branchRotation = 1.0 / (double)(numBranches + 1);
        double branchOffset = random.nextDouble();
        block5: for (int i = 0; i <= numBranches; ++i) {
            int dHeight = heightVar > 0 ? branchHeight - heightVar + random.nextInt(2 * heightVar) : branchHeight;
            switch (size) {
                case 1: {
                    this.makeMedBranch(world, random, x, y, z, diameter, dHeight, length, (double)i * branchRotation + branchOffset, tilt, leafy);
                    continue block5;
                }
                case 2: {
                    this.makeLargeBranch(world, random, x, y, z, diameter, dHeight, length, (double)i * branchRotation + branchOffset, tilt, leafy);
                    continue block5;
                }
                case 3: {
                    this.makeRoot(world, random, x, y, z, diameter, dHeight, length, (double)i * branchRotation + branchOffset, tilt);
                }
                default: {
                    this.makeSmallBranch(world, random, x, y, z, diameter, dHeight, length, (double)i * branchRotation + branchOffset, tilt, leafy);
                }
            }
        }
    }

    protected void buildTrunk(World world, Random random, int x, int y, int z, int diameter, int height) {
        int dist;
        int az;
        int ax;
        int dy;
        int dz;
        int dx;
        int hollow = diameter / 2;
        for (dx = -diameter; dx <= diameter; ++dx) {
            for (dz = -diameter; dz <= diameter; ++dz) {
                for (dy = -4; dy < 0; ++dy) {
                    ax = Math.abs(dx);
                    dist = (int)((double)Math.max(ax, az = Math.abs(dz)) + (double)Math.min(ax, az) * 0.5);
                    if (dist > diameter) continue;
                    if (TFGenHollowTree.hasAirAround(world, dx + x, dy + y, dz + z)) {
                        this.setBlockAndMetadata(world, dx + x, dy + y, dz + z, this.treeBlock, dist > hollow ? this.treeMeta : this.branchMeta);
                        continue;
                    }
                    this.setBlockAndMetadata(world, dx + x, dy + y, dz + z, this.rootBlock, this.rootMeta);
                }
            }
        }
        for (dx = -diameter; dx <= diameter; ++dx) {
            for (dz = -diameter; dz <= diameter; ++dz) {
                for (dy = 0; dy <= height; ++dy) {
                    ax = Math.abs(dx);
                    dist = (int)((double)Math.max(ax, az = Math.abs(dz)) + (double)Math.min(ax, az) * 0.5);
                    if (dist <= diameter && dist > hollow) {
                        this.setBlockAndMetadata(world, dx + x, dy + y, dz + z, this.treeBlock, this.treeMeta);
                    }
                    if (dist <= hollow) {
                        // empty if block
                    }
                    if (dist != hollow || dx != hollow) continue;
                    this.setBlockAndMetadata(world, dx + x, dy + y, dz + z, Blocks.field_150395_bd, 8);
                }
            }
        }
    }

    protected void makeMedBranch(World world, Random random, int x, int y, int z, int diameter, int branchHeight, double length, double angle, double tilt, boolean leafy) {
        int sx = x;
        int sy = y + branchHeight;
        int sz = z;
        int[] src = TFGenHollowTree.translate(sx, sy, sz, diameter, angle, 0.5);
        this.makeMedBranch(world, random, src[0], src[1], src[2], length, angle, tilt, leafy);
    }

    protected void makeMedBranch(World world, Random random, int sx, int sy, int sz, double length, double angle, double tilt, boolean leafy) {
        int[] src = new int[]{sx, sy, sz};
        int[] dest = TFGenHollowTree.translate(src[0], src[1], src[2], length, angle, tilt);
        this.drawBresehnam(world, src[0], src[1], src[2], dest[0], dest[1], dest[2], this.treeBlock, this.branchMeta);
        if (leafy) {
            this.drawLeafBlob(world, dest[0], dest[1], dest[2], 2, this.leafBlock, this.leafMeta);
        }
        int numShoots = random.nextInt(2) + 1;
        double angleInc = 0.8 / (double)numShoots;
        for (int i = 0; i <= numShoots; ++i) {
            double angleVar = angleInc * (double)i - 0.4;
            double outVar = random.nextDouble() * 0.8 + 0.2;
            double tiltVar = random.nextDouble() * 0.75 + 0.15;
            int[] bsrc = TFGenHollowTree.translate(src[0], src[1], src[2], length * outVar, angle, tilt);
            double slength = length * 0.4;
            this.makeSmallBranch(world, random, bsrc[0], bsrc[1], bsrc[2], slength, angle + angleVar, tilt * tiltVar, leafy);
        }
    }

    protected void makeSmallBranch(World world, Random random, int sx, int sy, int sz, double length, double angle, double tilt, boolean leafy) {
        int[] src = new int[]{sx, sy, sz};
        int[] dest = TFGenHollowTree.translate(src[0], src[1], src[2], length, angle, tilt);
        this.drawBresehnam(world, src[0], src[1], src[2], dest[0], dest[1], dest[2], this.treeBlock, this.branchMeta);
        if (leafy) {
            byte leafRad = (byte)(random.nextInt(2) + 1);
            this.drawLeafBlob(world, dest[0], dest[1], dest[2], leafRad, this.leafBlock, this.leafMeta);
        }
    }

    protected void makeSmallBranch(World world, Random random, int x, int y, int z, int diameter, int branchHeight, double length, double angle, double tilt, boolean leafy) {
        int sx = x;
        int sy = y + branchHeight;
        int sz = z;
        int[] src = TFGenHollowTree.translate(sx, sy, sz, diameter, angle, 0.5);
        this.makeSmallBranch(world, random, src[0], src[1], src[2], length, angle, tilt, leafy);
    }

    protected void makeRoot(World world, Random random, int x, int y, int z, int diameter, int branchHeight, double length, double angle, double tilt) {
        ChunkCoordinates src = TFGenHollowTree.translateCoords(x, y + branchHeight, z, diameter, angle, 0.5);
        ChunkCoordinates dest = TFGenHollowTree.translateCoords(src.field_71574_a, src.field_71572_b, src.field_71573_c, length, angle, tilt);
        ChunkCoordinates[] lineArray = TFGenHollowTree.getBresehnamArrayCoords(src, dest);
        boolean stillAboveGround = true;
        for (ChunkCoordinates coord : lineArray) {
            if (stillAboveGround && TFGenHollowTree.hasAirAround(world, coord.field_71574_a, coord.field_71572_b, coord.field_71573_c)) {
                this.setBlockAndMetadata(world, coord.field_71574_a, coord.field_71572_b, coord.field_71573_c, this.treeBlock, this.branchMeta);
                this.setBlockAndMetadata(world, coord.field_71574_a, coord.field_71572_b - 1, coord.field_71573_c, this.treeBlock, this.branchMeta);
                continue;
            }
            this.setBlockAndMetadata(world, coord.field_71574_a, coord.field_71572_b, coord.field_71573_c, this.rootBlock, this.rootMeta);
            this.setBlockAndMetadata(world, coord.field_71574_a, coord.field_71572_b - 1, coord.field_71573_c, this.rootBlock, this.rootMeta);
            stillAboveGround = false;
        }
    }

    protected void makeLargeBranch(World world, Random random, int sx, int sy, int sz, double length, double angle, double tilt, boolean leafy) {
        int[] src = new int[]{sx, sy, sz};
        int[] dest = TFGenHollowTree.translate(src[0], src[1], src[2], length, angle, tilt);
        this.drawBresehnam(world, src[0], src[1], src[2], dest[0], dest[1], dest[2], this.treeBlock, this.branchMeta);
        int reinforcements = random.nextInt(3);
        for (int i = 0; i <= reinforcements; ++i) {
            int vx = (i & 2) == 0 ? 1 : 0;
            int vy = (i & 1) == 0 ? 1 : -1;
            int vz = (i & 2) == 0 ? 0 : 1;
            this.drawBresehnam(world, src[0] + vx, src[1] + vy, src[2] + vz, dest[0], dest[1], dest[2], this.treeBlock, this.branchMeta);
        }
        if (leafy) {
            this.drawLeafBlob(world, dest[0], dest[1] + 1, dest[2], 3, this.leafBlock, this.leafMeta);
        }
        int numMedBranches = random.nextInt((int)(length / 6.0)) + random.nextInt(2) + 1;
        for (int i = 0; i <= numMedBranches; ++i) {
            double outVar = random.nextDouble() * 0.3 + 0.3;
            double angleVar = random.nextDouble() * 0.225 * ((i & 1) == 0 ? 1.0 : -1.0);
            int[] bsrc = TFGenHollowTree.translate(src[0], src[1], src[2], length * outVar, angle, tilt);
            this.makeMedBranch(world, random, bsrc[0], bsrc[1], bsrc[2], length * 0.6, angle + angleVar, tilt, leafy);
        }
        int numSmallBranches = random.nextInt(2) + 1;
        for (int i = 0; i <= numSmallBranches; ++i) {
            double outVar = random.nextDouble() * 0.25 + 0.25;
            double angleVar = random.nextDouble() * 0.25 * ((i & 1) == 0 ? 1.0 : -1.0);
            int[] bsrc = TFGenHollowTree.translate(src[0], src[1], src[2], length * outVar, angle, tilt);
            this.makeSmallBranch(world, random, bsrc[0], bsrc[1], bsrc[2], Math.max(length * 0.3, 2.0), angle + angleVar, tilt, leafy);
        }
        if (random.nextInt(8) == 0) {
            this.makeLeafDungeon(world, random, dest[0], dest[1] + 1, dest[2]);
        }
    }

    private void makeLeafDungeon(World world, Random random, int x, int y, int z) {
        this.drawLeafBlob(world, x, y, z, 4, this.leafBlock, this.leafMeta);
        this.drawBlob(world, x, y, z, 3, this.treeBlock, this.branchMeta);
        this.drawBlob(world, x, y, z, 2, Blocks.field_150350_a, 0);
        world.func_147465_d(x + 0, y + 1, z + 0, Blocks.field_150474_ac, 0, 2);
        TileEntityMobSpawner ms = (TileEntityMobSpawner)world.func_147438_o(x + 0, y + 1, z + 0);
        if (ms != null) {
            ms.func_145881_a().func_98272_a(TFCreatures.getSpawnerNameFor("Swarm Spider"));
        }
        this.makeLeafDungeonChest(world, random, x, y, z);
    }

    private void makeLeafDungeonChest(World world, Random random, int x, int y, int z) {
        int dir = random.nextInt(4);
        x += Direction.field_71583_a[dir];
        z += Direction.field_71581_b[dir];
        TFTreasure.tree_cache.generate(world, random, x += Direction.field_71583_a[dir], y - 1, z += Direction.field_71581_b[dir]);
    }

    protected void makeLargeBranch(World world, Random random, int x, int y, int z, int diameter, int branchHeight, double length, double angle, double tilt, boolean leafy) {
        int sx = x;
        int sy = y + branchHeight;
        int sz = z;
        int[] src = TFGenHollowTree.translate(sx, sy, sz, diameter, angle, 0.5);
        this.makeLargeBranch(world, random, src[0], src[1], src[2], length, angle, tilt, leafy);
    }

    protected void addFirefly(World world, int x, int y, int z, int diameter, int fHeight, double fAngle) {
        int[] src = TFGenHollowTree.translate(x, y + fHeight, z, diameter + 1, fAngle, 0.5);
        int tmeta = 0;
        if ((fAngle %= 1.0) > 0.875 || fAngle <= 0.125) {
            tmeta = 3;
        } else if (fAngle > 0.125 && fAngle <= 0.375) {
            tmeta = 1;
        } else if (fAngle > 0.375 && fAngle <= 0.625) {
            tmeta = 4;
        } else if (fAngle > 0.625 && fAngle <= 0.875) {
            tmeta = 2;
        }
        if (TFBlocks.firefly.func_149742_c(world, src[0], src[1], src[2])) {
            this.setBlockAndMetadata(world, src[0], src[1], src[2], TFBlocks.firefly, tmeta);
        }
    }

    protected void addCicada(World world, int x, int y, int z, int diameter, int fHeight, double fAngle) {
        int[] src = TFGenHollowTree.translate(x, y + fHeight, z, diameter + 1, fAngle, 0.5);
        int tmeta = 1;
        if ((fAngle %= 1.0) > 0.875 || fAngle <= 0.125) {
            tmeta = 3;
        } else if (fAngle > 0.125 && fAngle <= 0.375) {
            tmeta = 1;
        } else if (fAngle > 0.375 && fAngle <= 0.625) {
            tmeta = 4;
        } else if (fAngle > 0.625 && fAngle <= 0.875) {
            tmeta = 2;
        }
        if (TFBlocks.cicada.func_149742_c(world, src[0], src[1], src[2])) {
            this.setBlockAndMetadata(world, src[0], src[1], src[2], TFBlocks.cicada, tmeta);
        }
    }
}

