/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.common.network.packet.server;

import appeng.api.config.Actionable;
import appeng.api.config.FuzzyMode;
import appeng.api.config.PowerMultiplier;
import appeng.api.config.SecurityPermissions;
import appeng.api.networking.IGrid;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.ISecurityGrid;
import appeng.api.networking.security.PlayerSource;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.storage.IMEInventory;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.items.storage.ItemViewCell;
import appeng.util.InventoryAdaptor;
import appeng.util.Platform;
import appeng.util.item.AEItemStack;
import appeng.util.prioitylist.IPartitionList;
import cpw.mods.fml.common.network.ByteBufUtils;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import thaumcraft.api.crafting.IArcaneRecipe;
import thaumcraft.common.tiles.TileMagicWorkbench;
import thaumicenergistics.common.container.ContainerInternalCrafting;
import thaumicenergistics.common.container.ContainerPartArcaneCraftingTerminal;
import thaumicenergistics.common.integration.tc.ArcaneRecipeHelper;
import thaumicenergistics.common.network.packet.server.ThEServerPacket;
import thaumicenergistics.common.parts.PartArcaneCraftingTerminal;

public class Packet_S_NEIRecipe
extends ThEServerPacket {
    private ItemStack[][] recipe = null;
    private NBTTagCompound nbt = null;

    @Override
    protected void readData(ByteBuf stream) {
        this.setRecipe(ByteBufUtils.readTag((ByteBuf)stream));
    }

    public void setRecipe(NBTTagCompound comp) {
        this.nbt = comp;
        if (comp != null) {
            this.recipe = new ItemStack[9][];
            for (int x = 0; x < this.recipe.length; ++x) {
                NBTTagList list = comp.func_150295_c("#" + x, 10);
                if (list.func_74745_c() <= 0) continue;
                this.recipe[x] = new ItemStack[list.func_74745_c()];
                for (int y = 0; y < list.func_74745_c(); ++y) {
                    this.recipe[x][y] = ItemStack.func_77949_a((NBTTagCompound)list.func_150305_b(y));
                }
            }
        }
    }

    @Override
    protected void writeData(ByteBuf stream) {
        if (this.nbt != null) {
            ByteBufUtils.writeTag((ByteBuf)stream, (NBTTagCompound)this.nbt);
        }
    }

    @Override
    public void execute() {
        EntityPlayerMP pmp = (EntityPlayerMP)this.player;
        Container con = pmp.field_71070_bA;
        if (con instanceof ContainerPartArcaneCraftingTerminal) {
            ContainerPartArcaneCraftingTerminal act = (ContainerPartArcaneCraftingTerminal)con;
            InventoryCrafting testInv = new InventoryCrafting((Container)new ContainerInternalCrafting(), 3, 3);
            for (int x = 0; x < 9; ++x) {
                if (this.recipe[x] == null || this.recipe[x].length <= 0) continue;
                testInv.func_70299_a(x, this.recipe[x][0]);
            }
            IRecipe r = Platform.findMatchingRecipe((InventoryCrafting)testInv, (World)this.player.field_70170_p);
            IArcaneRecipe arcaneRecipe = r == null ? ArcaneRecipeHelper.INSTANCE.findMatchingArcaneResult((IInventory)testInv, 0, 9, this.player) : null;
            IGrid grid = act.getHostGrid();
            if (grid == null) {
                return;
            }
            IStorageGrid inv = (IStorageGrid)grid.getCache(IStorageGrid.class);
            IEnergyGrid energy = (IEnergyGrid)grid.getCache(IEnergyGrid.class);
            ISecurityGrid security = (ISecurityGrid)grid.getCache(ISecurityGrid.class);
            TileMagicWorkbench workbenchTile = ArcaneRecipeHelper.INSTANCE.createBridgeInventory((IInventory)testInv, 0, 9);
            workbenchTile.func_145834_a(this.player.field_70170_p);
            if ((r != null || arcaneRecipe != null) && security != null && security.hasPermission(this.player, SecurityPermissions.EXTRACT)) {
                ItemStack is;
                ItemStack itemStack = is = r != null ? r.func_77572_b(testInv) : arcaneRecipe.getCraftingResult((IInventory)workbenchTile);
                if (is == null) {
                    return;
                }
                IMEMonitor storage = inv.getItemInventory();
                IItemList all = storage.getStorageList();
                IPartitionList filter = ItemViewCell.createFilter((ItemStack[])act.getViewCells());
                PartArcaneCraftingTerminal craftMatrix = (PartArcaneCraftingTerminal)act.getCraftingHost();
                InventoryPlayer playerInventory = this.player.field_71071_by;
                PlayerSource as = new PlayerSource(this.player, (IActionHost)act.terminal);
                for (int x = 0; x < 9; ++x) {
                    ItemStack patternItem = testInv.func_70301_a(x);
                    ItemStack currentItem = craftMatrix.func_70301_a(x);
                    if (currentItem != null) {
                        testInv.func_70299_a(x, currentItem);
                        workbenchTile.func_70299_a(x, currentItem);
                        ItemStack newItemStack = r != null ? (r.func_77569_a(testInv, pmp.field_70170_p) ? r.func_77572_b(testInv) : null) : (arcaneRecipe.matches((IInventory)workbenchTile, pmp.field_70170_p, (EntityPlayer)pmp) ? arcaneRecipe.getCraftingResult((IInventory)workbenchTile) : null);
                        testInv.func_70299_a(x, patternItem);
                        workbenchTile.func_70299_a(x, patternItem);
                        if (newItemStack == null || !Platform.isSameItemPrecise((ItemStack)newItemStack, (ItemStack)is)) {
                            AEItemStack in = AEItemStack.create((ItemStack)currentItem);
                            IAEItemStack out = (IAEItemStack)Platform.poweredInsert((IEnergySource)energy, (IMEInventory)storage, (IAEStack)in, (BaseActionSource)as);
                            craftMatrix.func_70299_a(x, out != null ? out.getItemStack() : null);
                            currentItem = craftMatrix.func_70301_a(x);
                        }
                    }
                    if (patternItem != null && currentItem == null) {
                        ItemStack whichItem;
                        ItemStack itemStack2 = whichItem = r != null ? Platform.extractItemsByRecipe((IEnergySource)energy, (BaseActionSource)as, (IMEMonitor)storage, (World)this.player.field_70170_p, (IRecipe)r, (ItemStack)is, (InventoryCrafting)testInv, (ItemStack)patternItem, (int)x, (IItemList)all, (Actionable)Actionable.MODULATE, (IPartitionList)filter) : this.extractItemsByArcaneRecipe((IEnergySource)energy, (BaseActionSource)as, (IMEMonitor<IAEItemStack>)storage, this.player.field_70170_p, arcaneRecipe, is, workbenchTile, patternItem, x, (IItemList<IAEItemStack>)all, Actionable.MODULATE, (IPartitionList<IAEItemStack>)filter);
                        if (whichItem == null && playerInventory != null) {
                            whichItem = this.extractItemFromPlayerInventory(this.player, patternItem);
                        }
                        craftMatrix.func_70299_a(x, whichItem);
                    }
                    con.func_75130_a((IInventory)craftMatrix);
                }
            }
        }
    }

    ItemStack extractItemsByArcaneRecipe(IEnergySource energySrc, BaseActionSource mySrc, IMEMonitor<IAEItemStack> src, World w, IArcaneRecipe r, ItemStack output, TileMagicWorkbench workbenchTile, ItemStack providedTemplate, int slot, IItemList<IAEItemStack> items, Actionable realForFake, IPartitionList<IAEItemStack> filter) {
        if (energySrc.extractAEPower(1.0, Actionable.SIMULATE, PowerMultiplier.CONFIG) > 0.9) {
            boolean checkFuzzy;
            ItemStack extracted;
            IAEItemStack ae_ext;
            if (providedTemplate == null) {
                return null;
            }
            AEItemStack ae_req = AEItemStack.create((ItemStack)providedTemplate);
            ae_req.setStackSize(1L);
            if ((filter == null || filter.isListed((IAEStack)ae_req)) && (ae_ext = (IAEItemStack)src.extractItems((IAEStack)ae_req, realForFake, mySrc)) != null && (extracted = ae_ext.getItemStack()) != null) {
                energySrc.extractAEPower(1.0, realForFake, PowerMultiplier.CONFIG);
                return extracted;
            }
            boolean bl = checkFuzzy = ae_req.isOre() || providedTemplate.func_77960_j() == Short.MAX_VALUE || providedTemplate.func_77942_o() || providedTemplate.func_77984_f();
            if (items != null && checkFuzzy) {
                for (IAEItemStack x : items) {
                    ItemStack sh = x.getItemStack();
                    if (!Platform.isSameItemType((ItemStack)providedTemplate, (ItemStack)sh) && !ae_req.sameOre(x) || Platform.isSameItem((ItemStack)sh, (ItemStack)output)) continue;
                    ItemStack cp = Platform.cloneItemStack((ItemStack)sh);
                    cp.field_77994_a = 1;
                    workbenchTile.func_70299_a(slot, cp);
                    if (r.matches((IInventory)workbenchTile, w, this.player) && Platform.isSameItem((ItemStack)r.getCraftingResult((IInventory)workbenchTile), (ItemStack)output)) {
                        IAEItemStack ex;
                        IAEItemStack ax = x.copy();
                        ax.setStackSize(1L);
                        if ((filter == null || filter.isListed((IAEStack)ax)) && (ex = (IAEItemStack)src.extractItems((IAEStack)ax, realForFake, mySrc)) != null) {
                            energySrc.extractAEPower(1.0, realForFake, PowerMultiplier.CONFIG);
                            return ex.getItemStack();
                        }
                    }
                    workbenchTile.func_70299_a(slot, providedTemplate);
                }
            }
        }
        return null;
    }

    private ItemStack extractItemFromPlayerInventory(EntityPlayer player, ItemStack patternItem) {
        InventoryAdaptor ia = InventoryAdaptor.getAdaptor((Object)player, (ForgeDirection)ForgeDirection.UNKNOWN);
        AEItemStack request = AEItemStack.create((ItemStack)patternItem);
        boolean checkFuzzy = request.isOre() || patternItem.func_77960_j() == Short.MAX_VALUE || patternItem.func_77942_o() || patternItem.func_77984_f();
        return checkFuzzy ? ia.removeSimilarItems(1, patternItem, FuzzyMode.IGNORE_ALL, null) : ia.removeItems(1, patternItem, null);
    }
}

