/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.tracks;

import java.util.List;
import mods.railcraft.common.blocks.machine.epsilon.EnumMachineEpsilon;
import mods.railcraft.common.blocks.machine.epsilon.TileForceTrackEmitter;
import mods.railcraft.common.blocks.tracks.EnumTrack;
import mods.railcraft.common.blocks.tracks.EnumTrackMeta;
import mods.railcraft.common.blocks.tracks.TrackUnsupported;
import mods.railcraft.common.plugins.forge.WorldPlugin;
import mods.railcraft.common.util.misc.Game;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

public class TrackForce
extends TrackUnsupported {
    public TileForceTrackEmitter emitter;

    @Override
    public EnumTrack getTrackType() {
        return EnumTrack.FORCE;
    }

    @Override
    public List<ItemStack> getDrops(int fortune) {
        return null;
    }

    @Override
    public void onNeighborBlockChange(Block block) {
        super.onNeighborBlockChange(block);
        if (Game.isHost(this.getWorld())) {
            this.checkForEmitter();
        }
    }

    public void checkForEmitter() {
        EnumTrackMeta meta = EnumTrackMeta.fromMeta(this.tileEntity.func_145832_p());
        int y = this.getY() - 1;
        Block emitterBlock = EnumMachineEpsilon.FORCE_TRACK_EMITTER.getBlock();
        if (meta == EnumTrackMeta.NORTH_SOUTH) {
            int z;
            int x;
            int i;
            if (this.isValidEmitterTile(this.emitter, ForgeDirection.NORTH, ForgeDirection.SOUTH)) {
                return;
            }
            this.setEmitter(null);
            for (i = 1; i <= 64; ++i) {
                x = this.getX() + i * ForgeDirection.NORTH.offsetX;
                if (!this.isValidEmitter(x, y, z = this.getZ() + i * ForgeDirection.NORTH.offsetZ, emitterBlock, ForgeDirection.SOUTH)) continue;
                return;
            }
            for (i = 1; i <= 64; ++i) {
                x = this.getX() + i * ForgeDirection.SOUTH.offsetX;
                if (!this.isValidEmitter(x, y, z = this.getZ() + i * ForgeDirection.SOUTH.offsetZ, emitterBlock, ForgeDirection.NORTH)) continue;
                return;
            }
        } else {
            int z;
            int x;
            int i;
            if (this.isValidEmitterTile(this.emitter, ForgeDirection.EAST, ForgeDirection.WEST)) {
                return;
            }
            this.setEmitter(null);
            for (i = 1; i <= 64; ++i) {
                x = this.getX() + i * ForgeDirection.EAST.offsetX;
                if (!this.isValidEmitter(x, y, z = this.getZ() + i * ForgeDirection.EAST.offsetZ, emitterBlock, ForgeDirection.WEST)) continue;
                return;
            }
            for (i = 1; i <= 64; ++i) {
                x = this.getX() + i * ForgeDirection.WEST.offsetX;
                if (!this.isValidEmitter(x, y, z = this.getZ() + i * ForgeDirection.WEST.offsetZ, emitterBlock, ForgeDirection.EAST)) continue;
                return;
            }
        }
        WorldPlugin.setBlockToAir(this.getWorld(), this.getX(), this.getY(), this.getZ());
    }

    public TileForceTrackEmitter getEmitter() {
        return this.emitter;
    }

    public void setEmitter(TileForceTrackEmitter emitter) {
        this.emitter = emitter;
    }

    private boolean isValidEmitter(int x, int y, int z, Block emitterBlock, ForgeDirection facing) {
        if (WorldPlugin.getBlock((IBlockAccess)this.getWorld(), x, y, z) != emitterBlock) {
            return false;
        }
        TileEntity tile = WorldPlugin.getBlockTile((IBlockAccess)this.getWorld(), x, y, z);
        if (tile instanceof TileForceTrackEmitter && this.isValidEmitterTile((TileForceTrackEmitter)tile, facing)) {
            this.setEmitter(this.emitter);
            return true;
        }
        return false;
    }

    private boolean isValidEmitterTile(TileForceTrackEmitter tile, ForgeDirection ... facing) {
        if (tile == null || tile.func_145837_r()) {
            return false;
        }
        if (this.getY() - 1 != tile.field_145848_d) {
            return false;
        }
        if (this.getX() != tile.field_145851_c && this.getZ() != tile.field_145849_e) {
            return false;
        }
        ForgeDirection emitterFacing = tile.getFacing();
        for (ForgeDirection f : facing) {
            if (f != emitterFacing) continue;
            return true;
        }
        return false;
    }

    @Override
    public float getHardness() {
        return -1.0f;
    }

    @Override
    public float getExplosionResistance(double srcX, double srcY, double srcZ, Entity exploder) {
        return 6000000.0f;
    }
}

