/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.machine;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import mods.railcraft.common.blocks.machine.MultiBlockPattern;
import mods.railcraft.common.blocks.machine.TileMachineBase;
import mods.railcraft.common.plugins.forge.WorldPlugin;
import mods.railcraft.common.util.inventory.InvTools;
import mods.railcraft.common.util.inventory.wrappers.InventoryMapper;
import mods.railcraft.common.util.misc.Game;
import mods.railcraft.common.util.misc.MiscTools;
import mods.railcraft.common.util.misc.Timer;
import mods.railcraft.common.util.network.PacketDispatcher;
import mods.railcraft.common.util.network.PacketTileRequest;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.inventory.IInventory;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class TileMultiBlock
extends TileMachineBase {
    private static final int UNKNOWN_STATE_RECHECK = 256;
    private static final int NETWORK_RECHECK = 64;
    private final Timer netTimer = new Timer();
    private final List<? extends MultiBlockPattern> patterns;
    private final List<TileEntity> components = new LinkedList<TileEntity>();
    private final List<TileEntity> componentsImmutable = Collections.unmodifiableList(this.components);
    public ListMultimap<MultiBlockStateReturn, Integer> patternStates = ArrayListMultimap.create();
    protected boolean isMaster;
    private byte patternX;
    private byte patternY;
    private byte patternZ;
    private boolean tested;
    private boolean requestPacket;
    private MultiBlockState state;
    private TileMultiBlock masterBlock;
    private MultiBlockPattern currentPattern;
    private UUID uuidMaster;

    public TileMultiBlock(List<? extends MultiBlockPattern> patterns) {
        this.patterns = patterns;
        this.currentPattern = patterns.get(0);
        this.tested = FMLCommonHandler.instance().getEffectiveSide() != Side.SERVER;
    }

    public UUID getMasterUUID() {
        return this.uuidMaster;
    }

    public List<TileEntity> getComponents() {
        return this.componentsImmutable;
    }

    protected void onMasterChanged() {
    }

    private void setMaster(TileMultiBlock master) {
        this.masterBlock = master;
        if (this.uuidMaster != null && !this.uuidMaster.equals(master.getUUID())) {
            this.onMasterChanged();
        }
        this.uuidMaster = master.getUUID();
    }

    protected void onPatternLock(MultiBlockPattern pattern) {
    }

    protected void onPatternChanged() {
        if (!this.isMaster && this instanceof IInventory) {
            InvTools.dropInventory(new InventoryMapper((IInventory)this), this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    public final char getPatternMarker() {
        if (this.currentPattern == null || !this.isStructureValid()) {
            return 'O';
        }
        return this.currentPattern.getPatternMarker(this.patternX, this.patternY, this.patternZ);
    }

    public final int getPatternPositionX() {
        return this.patternX;
    }

    public final int getPatternPositionY() {
        return this.patternY;
    }

    public final int getPatternPositionZ() {
        return this.patternZ;
    }

    private void setPatternPosition(byte x, byte y, byte z) {
        this.patternX = x;
        this.patternY = y;
        this.patternZ = z;
    }

    public final MultiBlockPattern getPattern() {
        return this.currentPattern;
    }

    public final void setPattern(MultiBlockPattern pattern) {
        if (this.currentPattern != pattern) {
            this.onPatternChanged();
        }
        this.currentPattern = pattern;
        this.onPatternLock(pattern);
    }

    public final byte getPatternIndex() {
        return (byte)this.patterns.indexOf(this.currentPattern);
    }

    protected int getMaxRecursionDepth() {
        return 12;
    }

    public MultiBlockState getState() {
        return this.state;
    }

    @Override
    public final boolean canUpdate() {
        return true;
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (Game.isHost(this.field_145850_b)) {
            if (!(this.tested || this.state == MultiBlockState.UNKNOWN && this.clock % 256 != 0)) {
                this.testIfMasterBlock();
            }
        } else if (this.requestPacket && this.netTimer.hasTriggered(this.field_145850_b, 64)) {
            PacketDispatcher.sendToServer(new PacketTileRequest(this));
            this.requestPacket = false;
        }
    }

    private void testIfMasterBlock() {
        this.state = this.getMasterBlockState();
        this.tested = true;
        this.components.clear();
        if (this.state == MultiBlockState.UNKNOWN) {
            this.tested = false;
        } else if (this.state == MultiBlockState.VALID) {
            this.isMaster = true;
            byte by = this.currentPattern.getPatternWidthX();
            byte by2 = this.currentPattern.getPatternWidthZ();
            byte by3 = this.currentPattern.getPatternHeight();
            int xOffset = this.field_145851_c - this.currentPattern.getMasterOffsetX();
            int yOffset = this.field_145848_d - this.currentPattern.getMasterOffsetY();
            int zOffset = this.field_145849_e - this.currentPattern.getMasterOffsetZ();
            for (byte px = 0; px < by; px = (byte)((byte)(px + 1))) {
                for (byte py = 0; py < by3; py = (byte)((byte)(py + 1))) {
                    for (byte pz = 0; pz < by2; pz = (byte)((byte)(pz + 1))) {
                        int z;
                        int y;
                        int x;
                        TileEntity tile;
                        char marker = this.currentPattern.getPatternMarker(px, py, pz);
                        if (this.isMapPositionOtherBlock(marker) || !((tile = this.field_145850_b.func_147438_o(x = px + xOffset, y = py + yOffset, z = pz + zOffset)) instanceof TileMultiBlock)) continue;
                        TileMultiBlock multiBlock = (TileMultiBlock)tile;
                        if (multiBlock != this) {
                            multiBlock.components.clear();
                        }
                        this.components.add(multiBlock);
                        multiBlock.tested = true;
                        multiBlock.setMaster(this);
                        multiBlock.setPattern(this.currentPattern);
                        multiBlock.setPatternPosition(px, py, pz);
                        multiBlock.sendUpdateToClient();
                    }
                }
            }
        } else if (this.isMaster) {
            this.isMaster = false;
            this.onMasterReset();
            this.sendUpdateToClient();
        }
    }

    protected void onMasterReset() {
        this.components.clear();
    }

    protected boolean isMapPositionOtherBlock(char mapPos) {
        switch (mapPos) {
            case '*': 
            case 'A': 
            case 'O': {
                return true;
            }
        }
        return false;
    }

    protected boolean isMapPositionValid(int x, int y, int z, char mapPos) {
        Block block = WorldPlugin.getBlock((IBlockAccess)this.field_145850_b, x, y, z);
        switch (mapPos) {
            case 'O': {
                if (block != this.func_145838_q() || this.field_145850_b.func_72805_g(x, y, z) != this.func_145832_p()) break;
                return false;
            }
            case 'B': 
            case 'W': {
                if (block == this.func_145838_q() && this.field_145850_b.func_72805_g(x, y, z) == this.func_145832_p()) break;
                return false;
            }
            case 'A': {
                if (this.field_145850_b.func_147437_c(x, y, z)) break;
                return false;
            }
            case '*': {
                return true;
            }
        }
        return true;
    }

    private MultiBlockState getMasterBlockState() {
        MultiBlockState endResult = MultiBlockState.INVALID;
        this.patternStates.clear();
        for (MultiBlockPattern multiBlockPattern : this.patterns) {
            MultiBlockStateReturn result = this.isPatternValid(multiBlockPattern);
            this.patternStates.put((Object)result, (Object)this.patterns.indexOf(multiBlockPattern));
            switch (result.type) {
                case VALID: {
                    this.setPattern(multiBlockPattern);
                    return result.type;
                }
                case UNKNOWN: {
                    endResult = MultiBlockState.UNKNOWN;
                }
            }
        }
        return endResult;
    }

    private MultiBlockStateReturn isPatternValid(MultiBlockPattern map) {
        int xWidth = map.getPatternWidthX();
        int zWidth = map.getPatternWidthZ();
        int height = map.getPatternHeight();
        int xOffset = this.field_145851_c - map.getMasterOffsetX();
        int yOffset = this.field_145848_d - map.getMasterOffsetY();
        int zOffset = this.field_145849_e - map.getMasterOffsetZ();
        for (int patX = 0; patX < xWidth; ++patX) {
            for (int patY = 0; patY < height; ++patY) {
                for (int patZ = 0; patZ < zWidth; ++patZ) {
                    int x = patX + xOffset;
                    int y = patY + yOffset;
                    int z = patZ + zOffset;
                    if (!this.field_145850_b.func_72899_e(x, y, z)) {
                        return MultiBlockStateReturn.NOT_LOADED;
                    }
                    if (this.isMapPositionValid(x, y, z, map.getPatternMarker(patX, patY, patZ))) continue;
                    return MultiBlockStateReturn.PATTERN_DOES_NOT_MATCH;
                }
            }
        }
        AxisAlignedBB entityCheckBounds = map.getEntityCheckBounds(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        if (entityCheckBounds != null && !this.field_145850_b.func_72872_a(EntityLivingBase.class, entityCheckBounds).isEmpty()) {
            return MultiBlockStateReturn.ENTITY_IN_WAY;
        }
        return MultiBlockStateReturn.VALID;
    }

    @Override
    public void onBlockAdded() {
        super.onBlockAdded();
        if (Game.isNotHost(this.field_145850_b)) {
            return;
        }
        this.onBlockChange();
    }

    @Override
    public void onBlockRemoval() {
        super.onBlockRemoval();
        if (Game.isNotHost(this.field_145850_b)) {
            return;
        }
        this.onBlockChange();
        this.isMaster = false;
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        if (Game.isNotHost(this.field_145850_b)) {
            return;
        }
        this.tested = false;
        this.scheduleMasterRetest();
    }

    @Override
    public void func_145843_s() {
        if (this.field_145850_b == null || Game.isHost(this.field_145850_b)) {
            this.tested = false;
            this.scheduleMasterRetest();
        }
        super.func_145843_s();
    }

    private void onBlockChange() {
        for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
            TileEntity tile = this.tileCache.getTileOnSide(side);
            if (!this.isStructureTile(tile)) continue;
            ((TileMultiBlock)tile).onBlockChange(this.getMaxRecursionDepth());
        }
    }

    private void onBlockChange(int depth) {
        if (--depth < 0) {
            return;
        }
        if (this.tested) {
            this.tested = false;
            TileMultiBlock mBlock = this.getMasterBlock();
            if (mBlock != null) {
                mBlock.onBlockChange(this.getMaxRecursionDepth());
                return;
            }
            for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
                TileEntity tile = this.tileCache.getTileOnSide(side);
                if (!this.isStructureTile(tile)) continue;
                ((TileMultiBlock)tile).onBlockChange(depth);
            }
        }
    }

    protected boolean isStructureTile(TileEntity tile) {
        return tile != null && tile.getClass() == this.getClass();
    }

    public void func_70296_d() {
        TileMultiBlock mBlock;
        super.func_70296_d();
        if (!this.isMaster && (mBlock = this.getMasterBlock()) != null) {
            mBlock.func_70296_d();
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound data) {
        super.func_145841_b(data);
        data.func_74757_a("master", this.isMaster);
        data.func_74774_a("pattern", this.getPatternIndex());
        MiscTools.writeUUID(data, "uuidMaster", this.uuidMaster);
    }

    @Override
    public void func_145839_a(NBTTagCompound data) {
        super.func_145839_a(data);
        this.isMaster = data.func_74767_n("master");
        try {
            this.currentPattern = this.patterns.get(data.func_74771_c("pattern"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.uuidMaster = MiscTools.readUUID(data, "uuidMaster");
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        boolean hasMaster = this.getMasterBlock() != null;
        data.writeBoolean(hasMaster);
        if (hasMaster) {
            byte patternIndex = this.getPatternIndex();
            data.writeByte(patternIndex);
            data.writeByte(this.patternX);
            data.writeByte(this.patternY);
            data.writeByte(this.patternZ);
        }
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        this.requestPacket = false;
        boolean needsRenderUpdate = false;
        boolean hasMaster = data.readBoolean();
        if (hasMaster) {
            byte patternIndex = data.readByte();
            patternIndex = (byte)Math.max(patternIndex, 0);
            patternIndex = (byte)Math.min(patternIndex, this.patterns.size() - 1);
            MultiBlockPattern pat = this.patterns.get(patternIndex);
            byte pX = data.readByte();
            byte pY = data.readByte();
            byte pZ = data.readByte();
            if (this.patternX != pX || this.patternY != pY || this.patternZ != pZ) {
                this.patternX = pX;
                this.patternY = pY;
                this.patternZ = pZ;
                needsRenderUpdate = true;
            }
            this.isMaster = pX == pat.getMasterOffsetX() && pY == pat.getMasterOffsetY() && pZ == pat.getMasterOffsetZ();
            this.setPattern(pat);
            int masterX = pat.getMasterRelativeX(this.field_145851_c, pX);
            int masterY = pat.getMasterRelativeY(this.field_145848_d, pY);
            int masterZ = pat.getMasterRelativeZ(this.field_145849_e, pZ);
            TileEntity tile = null;
            if (this.field_145850_b != null) {
                tile = this.field_145850_b.func_147438_o(masterX, masterY, masterZ);
            }
            if (tile != null && this.masterBlock != tile && this.isStructureTile(tile)) {
                needsRenderUpdate = true;
                this.masterBlock = (TileMultiBlock)tile;
            }
            if (this.getMasterBlock() == null) {
                this.requestPacket = true;
            }
        } else if (this.masterBlock != null) {
            needsRenderUpdate = true;
            this.masterBlock = null;
            this.isMaster = false;
        }
        if (needsRenderUpdate) {
            this.markBlockForUpdate();
        }
    }

    public final boolean isMaster() {
        return this.isMaster;
    }

    public final void setMaster(boolean m) {
        this.isMaster = m;
    }

    public final void scheduleMasterRetest() {
        if (Game.isNotHost(this.field_145850_b)) {
            return;
        }
        if (this.masterBlock != null) {
            this.masterBlock.tested = false;
        }
    }

    public final boolean isStructureValid() {
        return this.masterBlock != null && this.masterBlock.tested && this.masterBlock.isMaster && !this.masterBlock.func_145837_r();
    }

    public final TileMultiBlock getMasterBlock() {
        if (this.masterBlock != null && !this.isStructureValid()) {
            this.masterBlock = null;
            this.sendUpdateToClient();
        }
        return this.masterBlock;
    }

    @Override
    public boolean canCreatureSpawn(EnumCreatureType type) {
        return this.isStructureValid() && this.getPatternPositionY() < 2 ? false : super.canCreatureSpawn(type);
    }

    public static enum MultiBlockState {
        VALID,
        INVALID,
        UNKNOWN;

    }

    public static enum MultiBlockStateReturn {
        VALID(MultiBlockState.VALID, "railcraft.multiblock.state.valid"),
        ENTITY_IN_WAY(MultiBlockState.INVALID, "railcraft.multiblock.state.invalid.entity"),
        PATTERN_DOES_NOT_MATCH(MultiBlockState.INVALID, "railcraft.multiblock.state.invalid.pattern"),
        NOT_LOADED(MultiBlockState.UNKNOWN, "railcraft.multiblock.state.unknown.unloaded");

        public final MultiBlockState type;
        public final String message;

        private MultiBlockStateReturn(MultiBlockState type, String msg) {
            this.type = type;
            this.message = msg;
        }
    }
}

