/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.frame;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import mods.railcraft.api.core.IPostConnection;
import mods.railcraft.client.util.textures.TextureAtlasSheet;
import mods.railcraft.common.blocks.ItemBlockRailcraft;
import mods.railcraft.common.blocks.machine.delta.EnumMachineDelta;
import mods.railcraft.common.blocks.machine.delta.TileWire;
import mods.railcraft.common.core.Railcraft;
import mods.railcraft.common.core.RailcraftConfig;
import mods.railcraft.common.items.ItemPlate;
import mods.railcraft.common.items.RailcraftItem;
import mods.railcraft.common.plugins.forestry.ForestryPlugin;
import mods.railcraft.common.plugins.forge.CraftingPlugin;
import mods.railcraft.common.plugins.forge.CreativePlugin;
import mods.railcraft.common.plugins.forge.HarvestPlugin;
import mods.railcraft.common.plugins.forge.RailcraftRegistry;
import mods.railcraft.common.plugins.forge.WorldPlugin;
import mods.railcraft.common.util.inventory.InvTools;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockFrame
extends Block
implements IPostConnection {
    private static BlockFrame instance;
    private final int renderId;
    private IIcon[] icons;
    public static boolean flipTextures;
    public static boolean poweredTexture;

    public static BlockFrame getBlock() {
        return instance;
    }

    public static void registerBlock() {
        if (instance == null && RailcraftConfig.isBlockEnabled("frame")) {
            instance = new BlockFrame(Railcraft.proxy.getRenderId());
            RailcraftRegistry.register(instance, ItemBlockRailcraft.class);
            HarvestPlugin.setHarvestLevel(instance, "pickaxe", 1);
            ForestryPlugin.addBackpackItem("builder", instance);
            CraftingPlugin.addShapedRecipe(BlockFrame.getItem(6), new Object[]{"PPP", "I I", "III", Character.valueOf('P'), RailcraftItem.plate, ItemPlate.EnumPlate.IRON, Character.valueOf('I'), RailcraftItem.rebar});
        }
    }

    public static ItemStack getItem() {
        return BlockFrame.getItem(1);
    }

    public static ItemStack getItem(int qty) {
        if (instance == null) {
            return null;
        }
        return new ItemStack((Block)instance, qty, 0);
    }

    public BlockFrame(int renderId) {
        super(Material.field_151592_s);
        this.renderId = renderId;
        this.func_149752_b(10.0f);
        this.func_149711_c(5.0f);
        this.func_149672_a(Block.field_149777_j);
        this.func_149647_a(CreativePlugin.RAILCRAFT_TAB);
        this.func_149663_c("railcraft.frame");
    }

    public int func_149645_b() {
        return this.renderId;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        this.icons = TextureAtlasSheet.unstitchIcons(iconRegister, "railcraft:frame", 3);
    }

    public IIcon func_149673_e(IBlockAccess world, int x, int y, int z, int side) {
        return this.func_149691_a(side, 0);
    }

    public IIcon func_149691_a(int side, int meta) {
        if (ForgeDirection.UP.ordinal() == side) {
            if (flipTextures) {
                return this.icons[1];
            }
            return poweredTexture ? this.icons[2] : this.icons[0];
        }
        if (flipTextures && ForgeDirection.DOWN.ordinal() == side) {
            return this.icons[0];
        }
        return this.icons[1];
    }

    public boolean func_149646_a(IBlockAccess world, int x, int y, int z, int side) {
        return flipTextures || super.func_149646_a(world, x, y, z, side);
    }

    public boolean canBeReplacedByLeaves(IBlockAccess world, int x, int y, int z) {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean isSideSolid(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        return side == ForgeDirection.UP;
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        ItemStack current = player.func_71045_bC();
        if (current != null && InvTools.isItemEqualIgnoreNBT(current, EnumMachineDelta.WIRE.getItem()) && WorldPlugin.setBlock(world, x, y, z, EnumMachineDelta.WIRE.getBlock(), EnumMachineDelta.WIRE.ordinal(), 2)) {
            TileEntity tile = WorldPlugin.getBlockTile((IBlockAccess)world, x, y, z);
            if (tile instanceof TileWire) {
                TileWire wire = (TileWire)tile;
                wire.setAddon(TileWire.AddonType.FRAME);
            }
            if (!player.field_71075_bZ.field_75098_d) {
                player.func_70062_b(0, InvTools.depleteItem(current));
            }
            return true;
        }
        return false;
    }

    @Override
    public IPostConnection.ConnectStyle connectsToPost(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        return IPostConnection.ConnectStyle.TWO_THIN;
    }
}

