/*
 * Decompiled with CFR 0.152.
 */
package shukaro.nodalmechanics.recipe;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;
import shukaro.nodalmechanics.items.NodalItems;
import thaumcraft.api.ItemApi;
import thaumcraft.api.ThaumcraftApiHelper;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.crafting.IArcaneRecipe;

public class RecipeAttune
implements IArcaneRecipe {
    private static final int ESSENTIA_MULTIPLIER = 4;
    private ItemStack output;

    public boolean matches(IInventory inventory, World world, EntityPlayer player) {
        if (!ThaumcraftApiHelper.isResearchComplete((String)player.func_70005_c_(), (String)this.getResearch())) {
            return false;
        }
        ItemStack matrix = null;
        ItemStack targetMatrix = new ItemStack((Item)NodalItems.itemMatrix);
        ItemStack phial = ItemApi.getItem((String)"itemEssence", (int)1);
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                ItemStack slotStack = ThaumcraftApiHelper.getStackInRowAndColumn((Object)inventory, (int)i, (int)j);
                if (!OreDictionary.itemMatches((ItemStack)targetMatrix, (ItemStack)slotStack, (boolean)true)) continue;
                if (matrix != null) {
                    return false;
                }
                matrix = slotStack;
            }
        }
        if (matrix == null) {
            return false;
        }
        AspectList aspectList = new AspectList();
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                ItemStack slotStack = ThaumcraftApiHelper.getStackInRowAndColumn((Object)inventory, (int)i, (int)j);
                if (slotStack == null || slotStack.func_77973_b() == null || OreDictionary.itemMatches((ItemStack)matrix, (ItemStack)slotStack, (boolean)true)) continue;
                if (OreDictionary.itemMatches((ItemStack)phial, (ItemStack)slotStack, (boolean)true)) {
                    if (!slotStack.func_77942_o()) {
                        return false;
                    }
                    AspectList phialAspectList = new AspectList();
                    phialAspectList.readFromNBT(slotStack.func_77978_p());
                    if (phialAspectList.size() == 0) {
                        return false;
                    }
                    for (Aspect aspect : phialAspectList.getAspects()) {
                        aspectList.add(aspect, phialAspectList.getAmount(aspect) / 4);
                    }
                    continue;
                }
                return false;
            }
        }
        if (aspectList.size() > 0) {
            this.output = matrix.func_77946_l();
            NBTTagCompound tagCompound = this.output.func_77942_o() ? this.output.func_77978_p() : new NBTTagCompound();
            AspectList initialAspectList = new AspectList();
            initialAspectList.readFromNBT(tagCompound);
            aspectList.add(initialAspectList);
            aspectList.writeToNBT(tagCompound);
            this.output.func_77982_d(tagCompound);
            return true;
        }
        return false;
    }

    public ItemStack getCraftingResult(IInventory inventory) {
        return this.output.func_77946_l();
    }

    public int getRecipeSize() {
        return 9;
    }

    public ItemStack getRecipeOutput() {
        return this.output;
    }

    public AspectList getAspects() {
        return new AspectList().add(Aspect.AIR, 2).add(Aspect.WATER, 2).add(Aspect.FIRE, 2).add(Aspect.ORDER, 2).add(Aspect.ENTROPY, 2).add(Aspect.EARTH, 2);
    }

    public AspectList getAspects(IInventory inventory) {
        return this.getAspects();
    }

    public String getResearch() {
        return "NODECATALYZATION";
    }
}

