/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.world.structure.island.biome;

import chylex.hee.entity.fx.FXType;
import chylex.hee.entity.mob.EntityMobBabyEnderman;
import chylex.hee.entity.mob.EntityMobEnderGuardian;
import chylex.hee.entity.mob.EntityMobEndermage;
import chylex.hee.entity.mob.EntityMobEnderman;
import chylex.hee.entity.mob.EntityMobHomelandEnderman;
import chylex.hee.mechanics.misc.HomelandEndermen;
import chylex.hee.packets.AbstractPacket;
import chylex.hee.packets.PacketPipeline;
import chylex.hee.packets.client.C21EffectEntity;
import chylex.hee.system.achievements.AchievementManager;
import chylex.hee.world.structure.island.biome.IslandBiomeBase;
import chylex.hee.world.structure.island.biome.data.AbstractBiomeInteraction;
import chylex.hee.world.structure.island.biome.data.BiomeContentVariation;
import chylex.hee.world.structure.island.biome.data.BiomeRandomDeviation;
import chylex.hee.world.structure.island.biome.decorator.BiomeDecoratorEnchantedIsland;
import chylex.hee.world.structure.island.biome.decorator.IslandBiomeDecorator;
import chylex.hee.world.structure.island.biome.interaction.BiomeInteractionEnchantedIsland;
import chylex.hee.world.structure.util.pregen.LargeStructureWorld;
import chylex.hee.world.util.SpawnEntry;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.stats.Achievement;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;

public class IslandBiomeEnchantedIsland
extends IslandBiomeBase {
    public static final BiomeContentVariation HOMELAND = new BiomeContentVariation(2, 6);
    public static final BiomeContentVariation LABORATORY = new BiomeContentVariation(6, 4);
    public static final BiomeRandomDeviation TALL_PILES = new BiomeRandomDeviation("TallPiles", HOMELAND);
    public static final BiomeRandomDeviation GOO_SWAMP = new BiomeRandomDeviation("GooSwamp", HOMELAND);
    public static final BiomeRandomDeviation MORE_SHADOW_ORCHIDS = new BiomeRandomDeviation("ShadowOrchids", HOMELAND, LABORATORY);
    private final BiomeDecoratorEnchantedIsland decorator = new BiomeDecoratorEnchantedIsland();

    protected IslandBiomeEnchantedIsland(int biomeID) {
        super(biomeID);
        this.contentVariations.addAll(Arrays.asList(HOMELAND, LABORATORY));
        this.randomDeviations.addAll(Arrays.asList(TALL_PILES, GOO_SWAMP, MORE_SHADOW_ORCHIDS));
        this.getSpawnEntries(HOMELAND).addAll(new SpawnEntry[]{new SpawnEntry(EntityMobEnderman.class, 22, 38), new SpawnEntry(EntityMobBabyEnderman.class, 14, 20)});
        this.getSpawnEntries(LABORATORY).addAll(new SpawnEntry[]{new SpawnEntry(EntityMobEndermage.class, 7, 15), new SpawnEntry(EntityMobEnderman.class, 12, 10), new SpawnEntry(EntityMobEnderGuardian.class, 20, 7)});
        this.getInteractions(HOMELAND).addAll((AbstractBiomeInteraction.BiomeInteraction[])new AbstractBiomeInteraction.BiomeInteraction[]{new AbstractBiomeInteraction.BiomeInteraction("EI_Homeland_Overtake", BiomeInteractionEnchantedIsland.InteractionOvertake.class, 50, 1), new AbstractBiomeInteraction.BiomeInteraction("EI_Homeland_CellarSounds", BiomeInteractionEnchantedIsland.InteractionCellarSounds.class, 10, 20)});
        this.getInteractions(LABORATORY).addAll((AbstractBiomeInteraction.BiomeInteraction[])new AbstractBiomeInteraction.BiomeInteraction[]{new AbstractBiomeInteraction.BiomeInteraction("EI_Laboratory_CellarSounds", BiomeInteractionEnchantedIsland.InteractionCellarSounds.class, 10, 20)});
    }

    @Override
    protected void decorate(LargeStructureWorld world, Random rand, int centerX, int centerZ) {
        if (this.data.content == HOMELAND) {
            this.decorator.genHomeland();
        } else if (this.data.content == LABORATORY) {
            this.decorator.genLaboratory();
        }
    }

    @Override
    public void updateCore(World world, int x, int y, int z, int meta) {
        super.updateCore(world, x, y, z, meta);
        if (meta == IslandBiomeEnchantedIsland.HOMELAND.id && world.field_73012_v.nextInt(40) == 0 && world.field_73013_u != EnumDifficulty.PEACEFUL) {
            AxisAlignedBB aabb = AxisAlignedBB.func_72330_a((double)(x - 104), (double)10.0, (double)(z - 104), (double)(x + 104), (double)128.0, (double)(z + 104));
            List all = world.func_72872_a(EntityMobHomelandEnderman.class, aabb);
            if (all.size() > 15 + world.field_73012_v.nextInt(50)) {
                return;
            }
            for (EntityMobHomelandEnderman enderman : all) {
                if (enderman.getHomelandRole() != HomelandEndermen.HomelandRole.ISLAND_LEADERS || enderman.attackedRecentlyTimer != 0) continue;
                List babies = world.func_72872_a(EntityMobBabyEnderman.class, aabb);
                if (babies.isEmpty()) break;
                EntityMobBabyEnderman chosenOne = (EntityMobBabyEnderman)babies.get(world.field_73012_v.nextInt(babies.size()));
                chosenOne.func_70106_y();
                if (chosenOne.isCarrying()) {
                    world.func_72838_d((Entity)new EntityItem(world, chosenOne.field_70165_t, chosenOne.field_70163_u, chosenOne.field_70161_v, chosenOne.getCarrying()));
                }
                EntityMobHomelandEnderman grown = new EntityMobHomelandEnderman(world);
                grown.func_82149_j((Entity)chosenOne);
                grown.setHomelandRole(HomelandEndermen.HomelandRole.getRandomRole(world.field_73012_v));
                world.func_72838_d((Entity)grown);
                PacketPipeline.sendToAllAround((Entity)grown, 64.0, (AbstractPacket)new C21EffectEntity(FXType.Entity.BABY_ENDERMAN_GROW, (Entity)grown));
                break;
            }
        }
    }

    @Override
    public float getIslandMassHeightMultiplier() {
        return 0.8f;
    }

    @Override
    public float getIslandFillFactor() {
        return 0.92f;
    }

    @Override
    public float getCaveAmountMultiplier() {
        return 0.45f;
    }

    @Override
    public float getCaveBranchingChance() {
        return 0.005f;
    }

    @Override
    public float getOreAmountMultiplier() {
        return 1.25f;
    }

    @Override
    protected IslandBiomeDecorator getDecorator() {
        return this.decorator;
    }

    @Override
    protected Achievement getAchievement() {
        return AchievementManager.BIOME_ENCHANTED_ISLAND;
    }

    @Override
    public int getTopBlockMeta() {
        return 2;
    }
}

