/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.tileentity.spawner;

import chylex.hee.tileentity.TileEntityCustomSpawner;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.MobSpawnerBaseLogic;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;

public abstract class CustomSpawnerLogic
extends MobSpawnerBaseLogic {
    protected TileEntityCustomSpawner spawnerTile;
    protected Entity entityCache;
    protected int field_98283_g = 200;
    protected int field_98293_h = 800;
    protected byte field_98290_m;
    protected byte attemptCount = (byte)4;
    protected byte field_98294_i = (byte)4;
    protected byte field_98292_k = (byte)6;
    protected byte field_98289_l = (byte)16;
    public double renderRotation;
    public double renderRotationPrev;

    protected CustomSpawnerLogic(TileEntityCustomSpawner spawnerTile) {
        this.spawnerTile = spawnerTile;
    }

    public void onBlockBreak() {
    }

    public boolean func_98279_f() {
        return this.func_98271_a().func_72977_a((double)this.func_98275_b() + 0.5, (double)this.func_98274_c() + 0.5, (double)this.func_98266_d() + 0.5, (double)this.field_98289_l) != null;
    }

    protected void func_98273_j() {
        this.field_98286_b = this.field_98293_h <= this.field_98283_g ? this.field_98283_g : this.field_98283_g + this.func_98271_a().field_73012_v.nextInt(this.field_98293_h - this.field_98283_g);
        this.func_98267_a(1);
    }

    protected AxisAlignedBB getSpawnerCheckBB() {
        return AxisAlignedBB.func_72330_a((double)this.func_98275_b(), (double)this.func_98274_c(), (double)this.func_98266_d(), (double)(this.func_98275_b() + 1), (double)(this.func_98274_c() + 1), (double)(this.func_98266_d() + 1)).func_72314_b((double)this.field_98290_m * 2.0, 4.0, (double)this.field_98290_m * 2.0);
    }

    protected boolean checkSpawnerConditions() {
        return true;
    }

    protected abstract boolean canMobSpawn(EntityLiving var1);

    protected void onMobSpawned(EntityLiving entity) {
    }

    protected abstract EntityLiving createMob(World var1);

    public final void func_98267_a(int i) {
        this.spawnerTile.func_145831_w().func_147452_c(this.spawnerTile.field_145851_c, this.spawnerTile.field_145848_d, this.spawnerTile.field_145849_e, Blocks.field_150474_ac, i, 0);
    }

    public final void func_98278_g() {
        if (!this.func_98279_f()) {
            return;
        }
        World world = this.func_98271_a();
        if (world.field_72995_K) {
            double particleX = (float)this.func_98275_b() + world.field_73012_v.nextFloat();
            double particleY = (float)this.func_98274_c() + world.field_73012_v.nextFloat();
            double particleZ = (float)this.func_98266_d() + world.field_73012_v.nextFloat();
            world.func_72869_a("smoke", particleX, particleY, particleZ, 0.0, 0.0, 0.0);
            world.func_72869_a("flame", particleX, particleY, particleZ, 0.0, 0.0, 0.0);
            if (this.field_98286_b > 0) {
                --this.field_98286_b;
            }
            this.renderRotationPrev = this.renderRotation;
            this.renderRotation = (this.renderRotation + (double)(1000.0f / ((float)this.field_98286_b + 200.0f))) % 360.0;
        } else {
            if (this.field_98286_b == -1) {
                this.func_98273_j();
            }
            if (this.field_98286_b > 0) {
                --this.field_98286_b;
                return;
            }
            int spawned = 0;
            for (int attempt = 0; attempt < this.attemptCount && spawned < this.field_98294_i; ++attempt) {
                EntityLiving entity = this.createMob(this.func_98271_a());
                if (entity == null) {
                    return;
                }
                int nearby = this.func_98271_a().func_72872_a(entity.getClass(), this.getSpawnerCheckBB()).size();
                if (nearby >= this.field_98292_k || !this.checkSpawnerConditions()) {
                    this.func_98273_j();
                    return;
                }
                double posX = (double)this.func_98275_b() + (world.field_73012_v.nextDouble() - world.field_73012_v.nextDouble()) * (double)this.field_98290_m;
                double posY = this.func_98274_c() + this.func_98271_a().field_73012_v.nextInt(3) - 1;
                double posZ = (double)this.func_98266_d() + (world.field_73012_v.nextDouble() - world.field_73012_v.nextDouble()) * (double)this.field_98290_m;
                entity.func_70012_b(posX, posY, posZ, this.func_98271_a().field_73012_v.nextFloat() * 360.0f, 0.0f);
                if (!this.canMobSpawn(entity)) continue;
                this.func_98265_a((Entity)entity);
                this.func_98271_a().func_72926_e(2004, this.func_98275_b(), this.func_98274_c(), this.func_98266_d(), 0);
                entity.func_70656_aK();
                this.onMobSpawned(entity);
                ++spawned;
            }
            if (spawned != 0) {
                this.func_98273_j();
            }
        }
    }

    public final World func_98271_a() {
        return this.spawnerTile.func_145831_w();
    }

    public final int func_98275_b() {
        return this.spawnerTile.field_145851_c;
    }

    public final int func_98274_c() {
        return this.spawnerTile.field_145848_d;
    }

    public final int func_98266_d() {
        return this.spawnerTile.field_145849_e;
    }

    @SideOnly(value=Side.CLIENT)
    public final Entity func_98281_h() {
        if (this.entityCache == null) {
            this.entityCache = this.func_98265_a((Entity)this.createMob(null));
        }
        return this.entityCache;
    }

    public static final class BrokenSpawnerLogic
    extends CustomSpawnerLogic {
        public BrokenSpawnerLogic(TileEntityCustomSpawner spawnerTile) {
            super(spawnerTile);
        }

        @Override
        protected boolean canMobSpawn(EntityLiving entity) {
            return false;
        }

        @Override
        protected EntityLiving createMob(World world) {
            return new EntityEnderman(world);
        }
    }
}

