/*
 * Decompiled with CFR 0.152.
 */
package glowredman.txloader;

import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import cpw.mods.fml.common.DummyModContainer;
import cpw.mods.fml.common.LoadController;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.MetadataCollection;
import cpw.mods.fml.common.ModMetadata;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.versioning.VersionParser;
import cpw.mods.fml.common.versioning.VersionRange;
import glowredman.txloader.CommandTX;
import glowredman.txloader.TXLoaderCore;
import glowredman.txloader.TXResourcePack;
import glowredman.txloader.progress.ProgressBarProxy;
import java.io.File;
import java.io.InputStream;
import java.util.jar.JarFile;
import net.minecraft.command.ICommand;

public class TXLoaderModContainer
extends DummyModContainer {
    public TXLoaderModContainer() {
        super(TXLoaderModContainer.getModMetadata());
    }

    private static ModMetadata getModMetadata() {
        ModMetadata modMetadata;
        JarFile jar = new JarFile(TXLoaderCore.modFile);
        try {
            modMetadata = MetadataCollection.from((InputStream)jar.getInputStream(jar.getEntry("mcmod.info")), (String)"TX Loader").getMetadataForId("txloader", null);
        }
        catch (Throwable throwable) {
            try {
                try {
                    jar.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                TXLoaderCore.LOGGER.warn("Failed to get mod metadata", (Throwable)e);
                ModMetadata fallback = new ModMetadata();
                fallback.description = "This is a fallback description! Something went wrong while getting this mod's metadata. Refer to the log and report this issue to the mod's author!";
                fallback.modId = "txloader";
                fallback.name = "TX Loader";
                fallback.version = "0.0-FALLBACK";
                return fallback;
            }
        }
        jar.close();
        return modMetadata;
    }

    public VersionRange acceptableMinecraftVersionRange() {
        return VersionParser.parseRange((String)"[1.7.10]");
    }

    public Class<?> getCustomResourcePackClass() {
        return TXResourcePack.Normal.class;
    }

    public File getSource() {
        return TXLoaderCore.modFile;
    }

    public boolean registerBus(EventBus bus, LoadController controller) {
        bus.register((Object)this);
        return true;
    }

    @Subscribe
    public void preInit(FMLPreInitializationEvent event) {
        ProgressBarProxy.isBLSLoaded = Loader.isModLoaded((String)"betterloadingscreen");
    }

    @Subscribe
    public void serverStarting(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandTX());
    }
}

