/*
 * Decompiled with CFR 0.152.
 */
package unilib.external.com.twelvemonkeys.imageio.stream;

import java.io.IOException;
import javax.imageio.stream.ImageInputStreamImpl;
import unilib.external.com.twelvemonkeys.lang.Validate;

public final class ByteArrayImageInputStream
extends ImageInputStreamImpl {
    private final byte[] data;
    private final int dataOffset;
    private final int dataLength;

    public ByteArrayImageInputStream(byte[] byArray) {
        this(byArray, 0, byArray != null ? byArray.length : -1);
    }

    public ByteArrayImageInputStream(byte[] byArray, int n, int n2) {
        this.data = Validate.notNull(byArray, "data");
        this.dataOffset = ByteArrayImageInputStream.isMax(byArray.length, n, "offset");
        this.dataLength = ByteArrayImageInputStream.isMax(byArray.length - n, n2, "length");
    }

    private static int isMax(int n, int n2, String string) {
        return Validate.isTrue(n2 >= 0 && n2 <= n, n2, String.format("%s out of range [0, %d]: %d", string, n, n2));
    }

    @Override
    public int read() throws IOException {
        if (this.streamPos >= (long)this.dataLength) {
            return -1;
        }
        this.bitOffset = 0;
        return this.data[(int)this.streamPos++ + this.dataOffset] & 0xFF;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.streamPos >= (long)this.dataLength) {
            return -1;
        }
        int n3 = (int)Math.min((long)this.dataLength - this.streamPos, (long)n2);
        this.bitOffset = 0;
        System.arraycopy(this.data, (int)this.streamPos + this.dataOffset, byArray, n, n3);
        this.streamPos += (long)n3;
        return n3;
    }

    @Override
    public long length() {
        return this.dataLength;
    }

    @Override
    public boolean isCached() {
        return true;
    }

    @Override
    public boolean isCachedMemory() {
        return true;
    }
}

