/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.pipeline.transform;

import com.gtnewhorizons.angelica.shadow.org.taumc.glsl.Util;
import com.gtnewhorizons.angelica.shadow.org.taumc.glsl.grammar.GLSLParser;
import net.coderbot.iris.gl.shader.ShaderType;
import net.coderbot.iris.pipeline.transform.PatchShaderType;
import net.coderbot.iris.pipeline.transform.parameter.AttributeParameters;

class AttributeTransformer {
    AttributeTransformer() {
    }

    public static void transform(GLSLParser.Translation_unitContext translationUnit, AttributeParameters parameters, String profile, int version) {
        boolean isCore;
        boolean bl = isCore = profile.equals("core") || version > 140;
        if (isCore) {
            if (parameters.type == PatchShaderType.VERTEX) {
                throw new IllegalStateException("Vertex shaders must be in the compatibility profile to run properly!");
            }
            return;
        }
        if (parameters.inputs.lightmap) {
            Util.rename(translationUnit, "gl_MultiTexCoord2", "gl_MultiTexCoord1");
        }
        if (!parameters.inputs.lightmap) {
            Util.replaceExpression(translationUnit, "gl_MultiTexCoord1", "vec4(240.0, 240.0, 0.0, 1.0)");
            Util.replaceExpression(translationUnit, "gl_MultiTexCoord2", "vec4(240.0, 240.0, 0.0, 1.0)");
        }
        if (!parameters.inputs.texture) {
            Util.replaceExpression(translationUnit, "gl_MultiTexCoord0", "vec4(240.0, 240.0, 0.0, 1.0)");
        }
        AttributeTransformer.patchTextureMatrices(translationUnit, parameters.inputs.lightmap);
        if (parameters.type.glShaderType == ShaderType.VERTEX && Util.hasVariable(translationUnit, "gl_MultiTexCoord3") && !Util.hasVariable(translationUnit, "mc_midTexCoord")) {
            Util.rename(translationUnit, "gl_MultiTexCoord3", "mc_midTexCoord");
            Util.injectVariable(translationUnit, "attribute vec4 mc_midTexCoord;");
        }
    }

    private static void patchTextureMatrices(GLSLParser.Translation_unitContext translationUnit, boolean hasLightmap) {
        Util.rename(translationUnit, "gl_TextureMatrix", "iris_TextureMatrix");
        Util.injectVariable(translationUnit, "float iris_ONE_OVER_256 = 0.00390625;");
        Util.injectVariable(translationUnit, "float iris_ONE_OVER_32 = iris_ONE_OVER_256 * 8;");
        if (hasLightmap) {
            Util.injectVariable(translationUnit, "mat4 iris_LightmapTextureMatrix = gl_TextureMatrix[1];");
        } else {
            Util.injectVariable(translationUnit, "mat4 iris_LightmapTextureMatrix =mat4(iris_ONE_OVER_256, 0.0, 0.0, 0.0,     0.0, iris_ONE_OVER_256, 0.0, 0.0,     0.0, 0.0, iris_ONE_OVER_256, 0.0,     iris_ONE_OVER_32, iris_ONE_OVER_32, iris_ONE_OVER_32, iris_ONE_OVER_256);");
        }
        Util.injectVariable(translationUnit, "mat4 iris_TextureMatrix[8] = mat4[8](gl_TextureMatrix[0],iris_LightmapTextureMatrix,mat4(1.0),mat4(1.0),mat4(1.0),mat4(1.0),mat4(1.0),mat4(1.0));");
    }
}

