/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.gui.element;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import net.coderbot.iris.gui.NavigationController;
import net.coderbot.iris.gui.element.IrisGuiSlot;
import net.coderbot.iris.gui.element.shaderoptions.BaseEntry;
import net.coderbot.iris.gui.element.shaderoptions.ElementRowEntry;
import net.coderbot.iris.gui.element.shaderoptions.HeaderEntry;
import net.coderbot.iris.gui.element.widget.AbstractElementWidget;
import net.coderbot.iris.gui.element.widget.OptionMenuConstructor;
import net.coderbot.iris.gui.screen.ShaderPackScreen;
import net.coderbot.iris.shaderpack.ShaderPack;
import net.coderbot.iris.shaderpack.option.menu.OptionMenuContainer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;

public class ShaderPackOptionList
extends IrisGuiSlot {
    private final List<AbstractElementWidget<?>> elementWidgets = new ArrayList();
    private final ShaderPackScreen screen;
    private final NavigationController navigation;
    private OptionMenuContainer container;
    private final List<BaseEntry> entries = new ArrayList<BaseEntry>();

    public ShaderPackOptionList(ShaderPackScreen screen, NavigationController navigation, ShaderPack pack, Minecraft client, int width, int height, int top, int bottom, int left, int right) {
        super(client, width, height, top, bottom, 20);
        this.navigation = navigation;
        this.screen = screen;
        this.applyShaderPack(pack);
    }

    public void applyShaderPack(ShaderPack pack) {
        this.container = pack.getMenuContainer();
    }

    public void rebuild() {
        this.entries.clear();
        this.field_148169_q = 0.0f;
        OptionMenuConstructor.constructAndApplyToScreen(this.container, this.screen, this, this.navigation);
    }

    public void refresh() {
        this.elementWidgets.forEach(widget -> widget.init(this.screen, this.navigation));
    }

    public int func_148139_c() {
        return Math.min(400, this.field_148155_a - 12);
    }

    protected void addEntry(BaseEntry entry) {
        this.entries.add(entry);
    }

    public void addHeader(String text, boolean backButton) {
        this.addEntry(new HeaderEntry(this.screen, this.navigation, text, backButton));
    }

    public void addWidgets(int columns, List<AbstractElementWidget<?>> elements) {
        this.elementWidgets.addAll(elements);
        ArrayList<AbstractElementWidget<Object>> row = new ArrayList();
        for (AbstractElementWidget<?> element : elements) {
            row.add(element);
            if (row.size() < columns) continue;
            this.addEntry(new ElementRowEntry(this.navigation, row));
            row = new ArrayList();
        }
        if (row.size() > 0) {
            while (row.size() < columns) {
                row.add(AbstractElementWidget.EMPTY);
            }
            this.addEntry(new ElementRowEntry(this.navigation, row));
        }
    }

    protected int func_148127_b() {
        return this.entries.size();
    }

    @Override
    protected boolean elementClicked(int index, boolean doubleClick, int mouseX, int mouseY, int mouseButton) {
        BaseEntry entry = this.entries.get(index);
        return entry.mouseClicked(mouseX, mouseY, mouseButton);
    }

    @Override
    public boolean mouseReleased(int mouseX, int mouseY, int button) {
        int relativeY = mouseY - this.field_148153_b - this.field_148160_j + (int)this.field_148169_q - 4;
        int index = relativeY / this.field_148149_f;
        if (index < 0 || index >= this.entries.size()) {
            return false;
        }
        BaseEntry entry = this.entries.get(index);
        return entry.mouseReleased(mouseX, mouseY, button);
    }

    protected boolean func_148131_a(int idx) {
        return false;
    }

    protected void func_148123_a() {
    }

    protected void func_148126_a(int index, int x, int y, int i1, Tessellator tessellator, int mouseX, int mouseY) {
        BaseEntry entry = this.entries.get(index);
        boolean isMouseOver = this.func_148124_c(mouseX, mouseY) == index;
        entry.drawEntry(this.screen, index, x - 2, y + 4, this.func_148139_c(), this.field_148149_f, tessellator, mouseX, mouseY, isMouseOver);
    }

    @Generated
    public NavigationController getNavigation() {
        return this.navigation;
    }
}

