/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.angelica.client.gui;

import com.gtnewhorizon.gtnhlib.config.ConfigException;
import com.gtnewhorizon.gtnhlib.config.ConfigurationManager;
import com.gtnewhorizons.angelica.client.font.FontStrategist;
import com.gtnewhorizons.angelica.client.gui.SliderClone;
import com.gtnewhorizons.angelica.config.FontConfig;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.coderbot.iris.gui.element.widget.IrisButton;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiSlot;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.resources.I18n;
import org.lwjgl.input.Keyboard;

public class FontConfigScreen
extends GuiScreen {
    private final GuiScreen parent;
    private final String title;
    private final String searchPrompt;
    private final Font[] availableFonts;
    private String currentPrimaryFontName;
    private String currentFallbackFontName;
    private FontList fontList;
    private int selectedPrimaryFontListPos = -1;
    private int selectedFallbackFontListPos = -1;
    private ArrayList<Font> displayedFonts;
    private GuiTextField searchBox;
    SliderClone.Option optFontQuality = new SliderClone.Option(6.0f, 72.0f, 6.0f);
    SliderClone.Option optShadowOffset = new SliderClone.Option(0.0f, 2.0f, 0.05f);
    SliderClone.Option optGlyphAspect = new SliderClone.Option(-1.0f, 1.0f, 0.05f);
    SliderClone.Option optGlyphScale = new SliderClone.Option(0.1f, 3.0f, 0.05f);
    SliderClone.Option optWhitespaceScale = new SliderClone.Option(0.1f, 3.0f, 0.05f);
    SliderClone.Option optGlyphSpacing = new SliderClone.Option(-2.0f, 2.0f, 0.05f);
    SliderClone.Option optFontAAMode = new SliderClone.Option(0.0f, 2.0f, 1.0f);
    SliderClone.Option optFontAAStrength = new SliderClone.Option(1.0f, 24.0f, 1.0f);
    private int qualityLast = FontConfig.customFontQuality;
    private float lastMouseX = 0.0f;
    private float lastMouseY = 0.0f;
    private long lastStillTime = 0L;

    public FontConfigScreen(GuiScreen parent) {
        this.title = I18n.func_135052_a((String)"options.angelica.fontconfig.title", (Object[])new Object[0]);
        this.searchPrompt = I18n.func_135052_a((String)"options.angelica.fontconfig.searchprompt", (Object[])new Object[0]);
        this.parent = parent;
        this.currentPrimaryFontName = FontConfig.customFontNamePrimary;
        this.currentFallbackFontName = FontConfig.customFontNameFallback;
        this.availableFonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts();
        this.displayedFonts = new ArrayList<Font>(Arrays.asList(this.availableFonts));
        for (int i = 0; i < this.availableFonts.length; ++i) {
            if (Objects.equals(this.currentPrimaryFontName, this.availableFonts[i].getFontName())) {
                this.selectedPrimaryFontListPos = i;
            }
            if (!Objects.equals(this.currentFallbackFontName, this.availableFonts[i].getFontName())) continue;
            this.selectedFallbackFontListPos = i;
        }
    }

    public void func_73866_w_() {
        Keyboard.enableRepeatEvents((boolean)true);
        this.searchBox = new GuiTextField(this.field_146289_q, this.field_146294_l / 2 - 120, 24, 240, 20);
        this.searchBox.func_146203_f(64);
        this.fontList = new FontList();
        this.initButtons();
    }

    private void initButtons() {
        this.field_146292_n.add(new IrisButton(this.field_146294_l / 2 - 81 - 165, this.field_146295_m - 20 - 7, 162, 20, FontConfig.enableCustomFont ? I18n.func_135052_a((String)"options.angelica.fontconfig.disable_custom_font", (Object[])new Object[0]) : I18n.func_135052_a((String)"options.angelica.fontconfig.enable_custom_font", (Object[])new Object[0]), this::toggleCustomFont));
        this.field_146292_n.add(new IrisButton(this.field_146294_l / 2 - 80, this.field_146295_m - 20 - 7, 160, 20, I18n.func_135052_a((String)"options.angelica.fontconfig.reset_values", (Object[])new Object[0]), this::resetValues));
        this.field_146292_n.add(new IrisButton(this.field_146294_l / 2 - 81 + 165, this.field_146295_m - 20 - 7, 162, 20, I18n.func_135052_a((String)"gui.done", (Object[])new Object[0]), button -> this.onClose()));
        this.field_146292_n.add(new SliderClone(this.field_146294_l / 2 - 60 - 186, this.field_146295_m - 40 - 11, 120, 20, this.optFontQuality, FontConfig.customFontQuality, this::setFontQuality, value -> I18n.func_135052_a((String)"options.angelica.fontconfig.font_quality", (Object[])new Object[]{String.format("%2.0f", value)}), "options.angelica.fontconfig.font_quality.tooltip"));
        this.field_146292_n.add(new SliderClone(this.field_146294_l / 2 - 60 - 186, this.field_146295_m - 60 - 15, 120, 20, this.optShadowOffset, FontConfig.fontShadowOffset, value -> {
            FontConfig.fontShadowOffset = value.floatValue();
        }, value -> I18n.func_135052_a((String)"options.angelica.fontconfig.shadow_offset", (Object[])new Object[]{String.format("x%3.2f", value)}), "options.angelica.fontconfig.shadow_offset.tooltip"));
        this.field_146292_n.add(new SliderClone(this.field_146294_l / 2 - 60 - 62, this.field_146295_m - 40 - 11, 120, 20, this.optGlyphAspect, FontConfig.glyphAspect, value -> {
            FontConfig.glyphAspect = value.floatValue();
        }, value -> I18n.func_135052_a((String)"options.angelica.fontconfig.glyph_aspect", (Object[])new Object[]{String.format("%3.2f", value)}), "options.angelica.fontconfig.glyph_aspect.tooltip"));
        this.field_146292_n.add(new SliderClone(this.field_146294_l / 2 - 60 - 62, this.field_146295_m - 60 - 15, 120, 20, this.optGlyphScale, FontConfig.glyphScale, value -> {
            FontConfig.glyphScale = value.floatValue();
        }, value -> I18n.func_135052_a((String)"options.angelica.fontconfig.glyph_scale", (Object[])new Object[]{String.format("x%3.2f", value)}), "options.angelica.fontconfig.glyph_scale.tooltip"));
        this.field_146292_n.add(new SliderClone(this.field_146294_l / 2 - 60 + 62, this.field_146295_m - 40 - 11, 120, 20, this.optWhitespaceScale, FontConfig.whitespaceScale, value -> {
            FontConfig.whitespaceScale = value.floatValue();
        }, value -> I18n.func_135052_a((String)"options.angelica.fontconfig.whitespace_scale", (Object[])new Object[]{String.format("x%3.2f", value)}), "options.angelica.fontconfig.whitespace_scale.tooltip"));
        this.field_146292_n.add(new SliderClone(this.field_146294_l / 2 - 60 + 62, this.field_146295_m - 60 - 15, 120, 20, this.optGlyphSpacing, FontConfig.glyphSpacing, value -> {
            FontConfig.glyphSpacing = value.floatValue();
        }, value -> I18n.func_135052_a((String)"options.angelica.fontconfig.glyph_spacing", (Object[])new Object[]{String.format("%3.2f", value)}), "options.angelica.fontconfig.glyph_spacing.tooltip"));
        this.field_146292_n.add(new SliderClone(this.field_146294_l / 2 - 60 + 186, this.field_146295_m - 40 - 11, 120, 20, this.optFontAAStrength, FontConfig.fontAAStrength, value -> {
            FontConfig.fontAAStrength = value.intValue();
        }, value -> I18n.func_135052_a((String)"options.angelica.fontconfig.font_aa_strength", (Object[])new Object[]{String.format("%.0f", value)}), "options.angelica.fontconfig.font_aa_strength.tooltip"));
        this.field_146292_n.add(new SliderClone(this.field_146294_l / 2 - 60 + 186, this.field_146295_m - 60 - 15, 120, 20, this.optFontAAMode, FontConfig.fontAAMode, value -> {
            FontConfig.fontAAMode = value.intValue();
        }, this::fontAAModeFormat, "options.angelica.fontconfig.aamode.tooltip"));
    }

    private void onClose() {
        this.applyChanges(true);
        this.field_146297_k.func_147108_a(this.parent);
    }

    private void applyChanges(boolean finalApply) {
        int pos = this.selectedPrimaryFontListPos;
        if (pos >= 0 && pos < this.displayedFonts.size()) {
            FontConfig.customFontNamePrimary = this.displayedFonts.get(pos).getFontName();
        }
        if ((pos = this.selectedFallbackFontListPos) >= 0 && pos < this.displayedFonts.size()) {
            FontConfig.customFontNameFallback = this.displayedFonts.get(pos).getFontName();
        }
        FontStrategist.reloadCustomFontProviders();
        if (finalApply) {
            ConfigurationManager.save((Class[])new Class[]{FontConfig.class});
        }
    }

    private void resetValues(IrisButton button) {
        try {
            ConfigurationManager.getConfigElements(FontConfig.class).forEach(elem -> elem.set(elem.getDefault()));
        }
        catch (ConfigException e) {
            throw new RuntimeException(e);
        }
        this.selectedPrimaryFontListPos = -1;
        this.selectedFallbackFontListPos = -1;
        FontStrategist.customFontInUse = false;
        this.field_146292_n.clear();
        this.initButtons();
    }

    private void toggleCustomFont(IrisButton button) {
        FontConfig.enableCustomFont = !FontConfig.enableCustomFont;
        this.applyChanges(false);
        button.field_146126_j = FontConfig.enableCustomFont ? I18n.func_135052_a((String)"options.angelica.fontconfig.disable_custom_font", (Object[])new Object[0]) : I18n.func_135052_a((String)"options.angelica.fontconfig.enable_custom_font", (Object[])new Object[0]);
    }

    private void setFontQuality(float quality) {
        FontConfig.customFontQuality = (int)quality;
        if (this.qualityLast != (int)quality) {
            this.applyChanges(false);
        }
        this.qualityLast = (int)quality;
    }

    private String fontAAModeFormat(float AAmode) {
        String string;
        switch ((int)AAmode) {
            case 2: {
                string = I18n.func_135052_a((String)"options.angelica.fontconfig.aamode.aa_16x", (Object[])new Object[0]);
                break;
            }
            case 1: {
                string = I18n.func_135052_a((String)"options.angelica.fontconfig.aamode.aa_4x", (Object[])new Object[0]);
                break;
            }
            default: {
                string = I18n.func_135052_a((String)"options.angelica.fontconfig.aamode.aa_none", (Object[])new Object[0]);
            }
        }
        return string;
    }

    public void func_73863_a(int mouseX, int mouseY, float delta) {
        super.func_146276_q_();
        this.fontList.func_148128_a(mouseX, mouseY, delta);
        this.searchBox.func_146194_f();
        if (!this.searchBox.func_146206_l() && this.searchBox.func_146179_b().isEmpty()) {
            this.func_73732_a(this.field_146289_q, this.searchPrompt, this.searchBox.field_146209_f + this.field_146289_q.func_78256_a(this.searchPrompt) / 2 + 4, this.searchBox.field_146210_g + this.searchBox.field_146219_i / 2 - 4, 0xFFFFFF);
        }
        this.func_73732_a(this.field_146289_q, this.title, (int)((double)this.field_146294_l * 0.5), 8, 0xFFFFFF);
        this.func_73732_a(this.field_146289_q, I18n.func_135052_a((String)"options.angelica.fontconfig.currentfonts", (Object[])new Object[]{FontConfig.customFontNamePrimary, FontConfig.customFontNameFallback}), (int)((double)this.field_146294_l * 0.5), this.field_146295_m - 92, 0xFFFFFF);
        super.func_73863_a(mouseX, mouseY, delta);
        for (GuiButton guiButton : this.field_146292_n) {
            if (!(guiButton instanceof SliderClone)) continue;
            SliderClone slider = (SliderClone)guiButton;
            int top = slider.field_146129_i;
            int bot = slider.field_146129_i + slider.field_146121_g;
            int left = slider.field_146128_h;
            int right = slider.field_146128_h + slider.field_146120_f;
            if (mouseY < top || mouseY >= bot || mouseX < left || mouseX >= right) continue;
            if ((float)mouseX == this.lastMouseX && (float)mouseY == this.lastMouseY) {
                if (this.lastStillTime == 0L) {
                    this.lastStillTime = System.currentTimeMillis();
                }
                if (this.lastStillTime + 500L >= System.currentTimeMillis()) break;
                this.displayTooltip(mouseX, mouseY, slider.tooltipKey);
                break;
            }
            this.lastStillTime = 0L;
            break;
        }
        this.lastMouseX = mouseX;
        this.lastMouseY = mouseY;
    }

    private void displayTooltip(int x, int y, String langKey) {
        List lines = this.field_146289_q.func_78271_c(I18n.func_135052_a((String)langKey, (Object[])new Object[0]), this.field_146294_l / 2);
        this.drawHoveringText(lines, x, y, this.field_146289_q);
    }

    protected void func_146284_a(GuiButton guiButton) {
        if (guiButton.field_146124_l && guiButton instanceof IrisButton) {
            IrisButton irisButton = (IrisButton)guiButton;
            irisButton.onPress();
        }
    }

    protected void func_73869_a(char typedChar, int keyCode) {
        if (this.searchBox.func_146206_l()) {
            if (keyCode == 1) {
                this.searchBox.func_146195_b(false);
            }
            this.searchBox.func_146201_a(typedChar, keyCode);
            this.displayedFonts = this.filterFonts(this.searchBox.func_146179_b().toLowerCase());
        }
        if (keyCode == 1) {
            this.onClose();
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        this.searchBox.func_146192_a(mouseX, mouseY, mouseButton);
        this.fontList.mouseClicked(mouseX, mouseY, mouseButton);
    }

    public void func_73876_c() {
        this.searchBox.func_146178_a();
    }

    private ArrayList<Font> filterFonts(String search) {
        ArrayList results = search == null || search.isEmpty() ? new ArrayList(Arrays.asList(this.availableFonts)) : Arrays.stream(this.availableFonts).filter(font -> font.getFontName().toLowerCase().contains(search)).collect(Collectors.toCollection(ArrayList::new));
        this.selectedPrimaryFontListPos = -1;
        this.selectedFallbackFontListPos = -1;
        for (int i = 0; i < results.size(); ++i) {
            if (Objects.equals(this.currentPrimaryFontName, ((Font)results.get(i)).getFontName())) {
                this.selectedPrimaryFontListPos = i;
            }
            if (!Objects.equals(this.currentFallbackFontName, ((Font)results.get(i)).getFontName())) continue;
            this.selectedFallbackFontListPos = i;
        }
        return results;
    }

    class FontList
    extends GuiSlot {
        public FontList() {
            super(FontConfigScreen.this.field_146297_k, FontConfigScreen.this.field_146294_l, FontConfigScreen.this.field_146295_m, 52, FontConfigScreen.this.field_146295_m - 100, 18);
        }

        private void mouseClicked(int mouseX, int mouseY, int mouseButton) {
            if (mouseY < this.field_148153_b || mouseY > this.field_148154_c) {
                return;
            }
            int listLeftBound = this.field_148155_a / 2 - this.func_148139_c() / 2;
            int listRightBound = this.field_148155_a / 2 + this.func_148139_c() / 2;
            if (mouseX < listLeftBound || mouseX > listRightBound) {
                return;
            }
            int mousePosInList = mouseY - this.field_148153_b - this.field_148160_j + (int)this.field_148169_q - 4;
            int slotIndex = mousePosInList / this.field_148149_f;
            if (slotIndex < 0 || slotIndex >= this.func_148127_b()) {
                return;
            }
            if (mouseButton == 0) {
                this.onElemClicked(slotIndex, false);
            } else if (mouseButton == 1) {
                this.onElemClicked(slotIndex, true);
            }
        }

        protected void onElemClicked(int index, boolean rightClick) {
            if (!rightClick) {
                FontConfigScreen.this.selectedPrimaryFontListPos = index;
                FontConfigScreen.this.currentPrimaryFontName = ((Font)FontConfigScreen.this.displayedFonts.get(index)).getFontName();
            } else {
                FontConfigScreen.this.selectedFallbackFontListPos = index;
                FontConfigScreen.this.currentFallbackFontName = ((Font)FontConfigScreen.this.displayedFonts.get(index)).getFontName();
            }
            FontConfigScreen.this.applyChanges(false);
        }

        protected boolean func_148131_a(int index) {
            return index == FontConfigScreen.this.selectedPrimaryFontListPos || index == FontConfigScreen.this.selectedFallbackFontListPos;
        }

        protected int func_148127_b() {
            return FontConfigScreen.this.displayedFonts.size();
        }

        protected int func_148138_e() {
            return this.func_148127_b() * 18;
        }

        protected int func_148137_d() {
            return this.field_148155_a * 11 / 12 - 5;
        }

        public int func_148139_c() {
            return this.field_148155_a * 2 / 3;
        }

        protected void func_148144_a(int index, boolean doubleClicked, int mouseX, int mouseY) {
        }

        protected void func_148123_a() {
            FontConfigScreen.this.func_146276_q_();
        }

        protected void func_148126_a(int index, int x, int y, int p_148126_4_, Tessellator tessellator, int p_148126_6_, int p_148126_7_) {
            int color = 0xFFFFFF;
            if (index == FontConfigScreen.this.selectedPrimaryFontListPos) {
                color &= 0xFFFF55;
            }
            if (index == FontConfigScreen.this.selectedFallbackFontListPos) {
                color &= 0x55FFFF;
            }
            FontConfigScreen.this.func_73732_a(FontConfigScreen.this.field_146289_q, ((Font)FontConfigScreen.this.displayedFonts.get(index)).getFontName(), this.field_148155_a / 2, y + 1, color);
        }
    }
}

