/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.gravisuiteneo.client;

import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.AdvancedModelLoader;
import net.minecraftforge.client.model.IModelCustom;
import org.lwjgl.opengl.GL11;

public class FXQuantumShield
extends EntityFX {
    private static final ResourceLocation MDL_SHIELD = new ResourceLocation("gravisuiteneo", "textures/models/qshield/shield.obj");
    private static final ResourceLocation[] SHIELD_TEXTURE_HIT;
    private static final ResourceLocation[] SHIELD_TEXTURE_POWER_UP;
    private static final ResourceLocation[] SHIELD_TEXTURE_POWER_DOWN;
    private final EShieldMode shieldMode;
    private final Entity target;
    private IModelCustom model;

    public FXQuantumShield(World world, double posX, double posY, double posZ, Entity target, int age, float yaw, float pitch, EShieldMode mode) {
        super(world, posX, posY, posZ, 0.0, 0.0, 0.0);
        this.field_70552_h = 1.0f;
        this.field_70553_i = 1.0f;
        this.field_70551_j = 1.0f;
        this.field_70545_g = 0.0f;
        this.field_70179_y = 0.0;
        this.field_70181_x = 0.0;
        this.field_70159_w = 0.0;
        this.field_70547_e = age + this.field_70146_Z.nextInt(age / 2);
        this.field_70145_X = false;
        this.func_70105_a(0.01f, 0.01f);
        this.field_70145_X = true;
        this.field_70544_f = 1.0f;
        this.target = target;
        this.field_70126_B = this.field_70177_z = yaw;
        this.field_70127_C = this.field_70125_A = pitch;
        this.field_70169_q = this.field_70165_t = this.target.field_70165_t;
        this.field_70167_r = this.field_70163_u = (this.target.field_70121_D.field_72338_b + this.target.field_70121_D.field_72337_e) / 2.0;
        this.field_70166_s = this.field_70161_v = this.target.field_70161_v;
        this.shieldMode = mode;
    }

    private static ResourceLocation getResLoc(int frame, EShieldMode mode) {
        switch (mode) {
            case POWER_DOWN: {
                return SHIELD_TEXTURE_POWER_DOWN[frame];
            }
            case POWER_UP: {
                return SHIELD_TEXTURE_POWER_UP[frame];
            }
        }
        return SHIELD_TEXTURE_HIT[frame];
    }

    public void func_70539_a(Tessellator tessellator, float p_70539_2_, float p_70539_3_, float p_70539_4_, float p_70539_5_, float p_70539_6_, float p_70539_7_) {
        tessellator.func_78381_a();
        GL11.glPushMatrix();
        GL11.glDisable((int)2884);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)1);
        if (this.model == null) {
            this.model = AdvancedModelLoader.loadModel((ResourceLocation)MDL_SHIELD);
        }
        float fade = ((float)this.field_70546_d + p_70539_2_) / (float)this.field_70547_e;
        float xx = (float)(this.field_70169_q + (this.field_70165_t - this.field_70169_q) * (double)p_70539_2_ - field_70556_an);
        float yy = (float)(this.field_70167_r + (this.field_70163_u - this.field_70167_r) * (double)p_70539_2_ - field_70554_ao);
        float zz = (float)(this.field_70166_s + (this.field_70161_v - this.field_70166_s) * (double)p_70539_2_ - field_70555_ap);
        GL11.glTranslated((double)xx, (double)yy, (double)zz);
        float b = 1.0f;
        int frame = Math.min(15, (int)(14.0f * fade) + 1);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(FXQuantumShield.getResLoc(frame, this.shieldMode));
        int i = 220;
        int j = i % 65536;
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)((float)j / 1.0f), (float)0.0f);
        GL11.glRotatef((float)(180.0f - this.field_70177_z), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)(-this.field_70125_A), (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glScaled((double)(0.4 * (double)this.target.field_70131_O), (double)(0.4 * (double)this.target.field_70131_O), (double)(0.4 * (double)this.target.field_70131_O));
        GL11.glColor4f((float)b, (float)b, (float)b, (float)Math.min(1.0f, (1.0f - fade) * 3.0f));
        this.model.renderAll();
        GL11.glDisable((int)3042);
        GL11.glEnable((int)2884);
        GL11.glPopMatrix();
        Minecraft.func_71410_x().field_71446_o.func_110577_a(EffectRenderer.field_110737_b);
        tessellator.func_78382_b();
    }

    public void func_70071_h_() {
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        if (this.field_70546_d++ >= this.field_70547_e) {
            this.func_70106_y();
        }
        this.field_70165_t = this.target.field_70165_t;
        this.field_70163_u = (this.target.field_70121_D.field_72338_b + this.target.field_70121_D.field_72337_e) / 2.0;
        this.field_70161_v = this.target.field_70161_v;
    }

    static {
        int numFrames = 16;
        SHIELD_TEXTURE_HIT = new ResourceLocation[16];
        SHIELD_TEXTURE_POWER_UP = new ResourceLocation[16];
        SHIELD_TEXTURE_POWER_DOWN = new ResourceLocation[16];
        for (int i = 0; i < 16; ++i) {
            FXQuantumShield.SHIELD_TEXTURE_HIT[i] = new ResourceLocation("gravisuiteneo", "textures/models/qshield/hit/quantumShield" + i + ".png");
            FXQuantumShield.SHIELD_TEXTURE_POWER_UP[i] = new ResourceLocation("gravisuiteneo", "textures/models/qshield/up/quantumShield" + i + ".png");
            FXQuantumShield.SHIELD_TEXTURE_POWER_DOWN[i] = new ResourceLocation("gravisuiteneo", "textures/models/qshield/down/quantumShield" + i + ".png");
        }
    }

    public static enum EShieldMode {
        POWER_UP,
        POWER_DOWN,
        IMPACT;

    }
}

