/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.gravisuiteneo;

import com.gtnewhorizons.gravisuiteneo.GraviSuiteNeo;
import com.gtnewhorizons.gravisuiteneo.common.Properties;
import com.gtnewhorizons.gravisuiteneo.items.ItemEpicLappack;
import com.gtnewhorizons.gravisuiteneo.items.ItemPlasmaCell;
import com.gtnewhorizons.gravisuiteneo.items.ItemPlasmaLauncher;
import com.gtnewhorizons.gravisuiteneo.util.GregTechAPIHelper;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.registry.GameRegistry;
import gravisuite.GraviSuite;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class GraviSuiteNeoRegistry {
    public static Item plasmaLauncher;
    public static Item epicLappack;
    public static Item itemPlasmaCell;
    public static CreativeTabs graviCreativeTab;
    private static Map<Fluid, Float> fuelMap;

    private GraviSuiteNeoRegistry() {
    }

    public static void register() {
        graviCreativeTab = new CreativeTabs("GraviSuite"){

            public Item func_78016_d() {
                return GraviSuite.graviChestPlate;
            }
        };
        plasmaLauncher = new ItemPlasmaLauncher();
        epicLappack = new ItemEpicLappack();
        itemPlasmaCell = new ItemPlasmaCell();
        GameRegistry.registerItem((Item)plasmaLauncher, (String)"sonicLauncher");
        GameRegistry.registerItem((Item)epicLappack, (String)"epicLappack");
        GameRegistry.registerItem((Item)itemPlasmaCell, (String)"itemPlasmaCell");
    }

    public static float getPlasmaEfficiency(FluidStack plasmaStack) {
        if (fuelMap == null) {
            GraviSuiteNeoRegistry.initFuelmap();
        }
        return fuelMap.getOrDefault(plasmaStack.getFluid(), Float.valueOf(0.0f)).floatValue();
    }

    public static Set<Fluid> getRegisteredFuels() {
        if (fuelMap == null) {
            GraviSuiteNeoRegistry.initFuelmap();
        }
        return Collections.unmodifiableSet(fuelMap.keySet());
    }

    private static void initFuelmap() {
        fuelMap = new HashMap<Fluid, Float>();
        HashMap<Fluid, Integer> fluids = new HashMap<Fluid, Integer>();
        for (String entry : Properties.AdvTweaks.getPlasmaLauncherFluids()) {
            int fuelValue;
            String[] splitEntry = entry.split(":", 1);
            if (splitEntry.length != 2) continue;
            try {
                fuelValue = Integer.parseInt(splitEntry[1]);
            }
            catch (Exception e) {
                continue;
            }
            Fluid fluid = FluidRegistry.getFluid((String)splitEntry[0]);
            if (fluid == null) continue;
            fluids.put(fluid, fuelValue);
        }
        if (Loader.isModLoaded((String)"gregtech") && !Loader.isModLoaded((String)"gregapi")) {
            fluids.putAll(GregTechAPIHelper.getGTPlasmaFluids());
        }
        long sum = 0L;
        Iterator iterator = fluids.values().iterator();
        while (iterator.hasNext()) {
            int fuelValue = (Integer)iterator.next();
            sum += (long)fuelValue;
        }
        if (sum == 0L) {
            return;
        }
        float plasmaMedianMultip = 100.0f / (float)sum * (float)fluids.size();
        GraviSuiteNeo.LOGGER.debug("Median Plasma Multiplier: {}", new Object[]{Float.valueOf(plasmaMedianMultip)});
        for (Map.Entry entry : fluids.entrySet()) {
            Fluid fluid = (Fluid)entry.getKey();
            float fuelValue = (float)((Integer)entry.getValue()).intValue() * plasmaMedianMultip;
            fuelMap.put(fluid, Float.valueOf(fuelValue));
            GraviSuiteNeo.LOGGER.debug("Added Fluid {} with Fuel Value {}", new Object[]{fluid.getLocalizedName(), Float.valueOf(fuelValue)});
        }
    }
}

