/*
 * Decompiled with CFR 0.152.
 */
package yalter.mousetweaks;

import codechicken.nei.NEIClientConfig;
import com.cleanroommc.bogosorter.mixins.early.minecraft.GuiContainerAccessor;
import cpw.mods.fml.common.Loader;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.gui.inventory.GuiContainerCreative;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import yalter.mousetweaks.MouseTweaks;
import yalter.mousetweaks.SimpleMouseState;
import yalter.mousetweaks.api.IMTModGuiContainer;
import yalter.mousetweaks.api.IMTModGuiContainer2;
import yalter.mousetweaks.api.IMTModGuiContainer2Ex;
import yalter.mousetweaks.config.MTConfig;
import yalter.mousetweaks.handlers.GuiContainerCreativeHandler;
import yalter.mousetweaks.handlers.GuiContainerHandler;
import yalter.mousetweaks.handlers.IMTModGuiContainer2ExHandler;
import yalter.mousetweaks.handlers.IMTModGuiContainer2Handler;
import yalter.mousetweaks.handlers.IMTModGuiContainerHandler;
import yalter.mousetweaks.impl.IGuiScreenHandler;
import yalter.mousetweaks.impl.IMouseState;
import yalter.mousetweaks.impl.MouseButton;

public class Main {
    private static IMouseState mouseState = new SimpleMouseState();
    private static GuiScreen oldGuiScreen = null;
    private static Slot oldSelectedSlot = null;
    private static Slot firstRightClickedSlot = null;
    private static boolean oldRMBDown = false;
    private static boolean disableForThisContainer = false;
    private static boolean disableWheelForThisContainer = false;
    private static boolean lwjgl3Loaded = false;
    private static IGuiScreenHandler handler = null;
    private static boolean initialized = false;
    private static final boolean isNEIPresent = Loader.isModLoaded((String)"NotEnoughItems");

    public static boolean initialize() {
        if (initialized) {
            return true;
        }
        lwjgl3Loaded = Loader.isModLoaded((String)"lwjgl3ify");
        if (lwjgl3Loaded) {
            MouseTweaks.LOGGER.info("Detected lwjgl3!");
        }
        initialized = true;
        MouseTweaks.LOGGER.debug("Mouse Tweaks has been initialized.");
        return true;
    }

    public static void onUpdateInGame() {
        GuiScreen currentScreen = Minecraft.func_71410_x().field_71462_r;
        if (currentScreen == null) {
            oldGuiScreen = null;
            oldSelectedSlot = null;
            firstRightClickedSlot = null;
            disableForThisContainer = false;
            disableWheelForThisContainer = false;
            handler = null;
        } else {
            Main.onUpdateInGui(currentScreen);
        }
        oldRMBDown = mouseState.isButtonPressed(MouseButton.RIGHT);
    }

    public static boolean isLwjgl3Loaded() {
        return lwjgl3Loaded;
    }

    public static void onMouseInput() {
        mouseState.update();
    }

    private static void onUpdateInGui(GuiScreen currentScreen) {
        ItemStack stackOnMouse;
        ItemStack targetStack;
        if (oldGuiScreen != currentScreen) {
            oldGuiScreen = currentScreen;
            handler = Main.findHandler(currentScreen);
            mouseState.clear();
            if (handler == null) {
                disableForThisContainer = true;
                return;
            }
            disableForThisContainer = handler.isMouseTweaksDisabled();
            disableWheelForThisContainer = handler.isWheelTweakDisabled();
            if (Main.isMouseWheelTransferActive() && !disableWheelForThisContainer) {
                Mouse.getDWheel();
            }
        }
        if (!(MTConfig.rmbTweak || MTConfig.lmbTweakWithItem || MTConfig.lmbTweakWithoutItem || Main.isMouseWheelTransferActive())) {
            return;
        }
        if (disableForThisContainer) {
            return;
        }
        Slot selectedSlot = handler.getSlotUnderMouse();
        if (mouseState.isButtonPressed(MouseButton.RIGHT)) {
            if (!oldRMBDown) {
                firstRightClickedSlot = selectedSlot;
            }
            if (MTConfig.rmbTweak && firstRightClickedSlot != null && !handler.isCraftingOutput(firstRightClickedSlot) && handler.disableRMBDraggingFunctionality() && (firstRightClickedSlot != selectedSlot || oldSelectedSlot == selectedSlot) && !handler.isIgnored(firstRightClickedSlot)) {
                targetStack = firstRightClickedSlot.func_75211_c();
                stackOnMouse = Minecraft.func_71410_x().field_71439_g.field_71071_by.func_70445_o();
                if (stackOnMouse != null && Main.areStacksCompatible(stackOnMouse, targetStack) && firstRightClickedSlot.func_75214_a(stackOnMouse)) {
                    handler.clickSlot(firstRightClickedSlot, MouseButton.RIGHT, false);
                }
            }
        } else {
            firstRightClickedSlot = null;
        }
        if (oldSelectedSlot != selectedSlot) {
            boolean shiftIsDown;
            oldSelectedSlot = selectedSlot;
            if (selectedSlot == null) {
                return;
            }
            if (firstRightClickedSlot == selectedSlot) {
                firstRightClickedSlot = null;
            }
            targetStack = ItemStack.func_77944_b((ItemStack)selectedSlot.func_75211_c());
            stackOnMouse = ItemStack.func_77944_b((ItemStack)Minecraft.func_71410_x().field_71439_g.field_71071_by.func_70445_o());
            boolean bl = shiftIsDown = Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54);
            if (mouseState.isButtonPressed(MouseButton.RIGHT)) {
                if (MTConfig.rmbTweak && !handler.isIgnored(selectedSlot) && !handler.isCraftingOutput(selectedSlot) && stackOnMouse != null && Main.areStacksCompatible(stackOnMouse, targetStack) && selectedSlot.func_75214_a(stackOnMouse)) {
                    handler.clickSlot(selectedSlot, MouseButton.RIGHT, false);
                }
            } else if (mouseState.isButtonPressed(MouseButton.LEFT)) {
                if (stackOnMouse != null) {
                    if (MTConfig.lmbTweakWithItem && !handler.isIgnored(selectedSlot) && targetStack != null && Main.areStacksCompatible(stackOnMouse, targetStack)) {
                        if (shiftIsDown) {
                            handler.clickSlot(selectedSlot, MouseButton.LEFT, true);
                        } else if (!((GuiContainerAccessor)currentScreen).getDragSplitting() && stackOnMouse.field_77994_a + targetStack.field_77994_a <= stackOnMouse.func_77976_d()) {
                            handler.clickSlot(selectedSlot, MouseButton.LEFT, false);
                            if (!handler.isCraftingOutput(selectedSlot)) {
                                handler.clickSlot(selectedSlot, MouseButton.LEFT, false);
                            }
                        }
                    }
                } else if (MTConfig.lmbTweakWithoutItem && targetStack != null && shiftIsDown && !handler.isIgnored(selectedSlot)) {
                    handler.clickSlot(selectedSlot, MouseButton.LEFT, true);
                }
            }
        }
        Main.handleWheel(selectedSlot);
    }

    private static void handleWheel(Slot selectedSlot) {
        if (!Main.isMouseWheelTransferActive() || disableWheelForThisContainer) {
            return;
        }
        int wheel = mouseState.consumeScrollAmount();
        if (wheel != 0 && selectedSlot != null) {
            boolean pushItems;
            int numItemsToMove = Math.abs(wheel);
            if (numItemsToMove == 0 || selectedSlot == null || handler.isIgnored(selectedSlot)) {
                return;
            }
            ItemStack stackOnMouse = ItemStack.func_77944_b((ItemStack)Minecraft.func_71410_x().field_71439_g.field_71071_by.func_70445_o());
            ItemStack originalStack = ItemStack.func_77944_b((ItemStack)selectedSlot.func_75211_c());
            boolean isCraftingOutput = handler.isCraftingOutput(selectedSlot);
            if (originalStack == null || stackOnMouse != null && isCraftingOutput != Main.areStacksCompatible(originalStack, stackOnMouse)) {
                return;
            }
            List<Slot> slots = handler.getSlots();
            boolean bl = pushItems = wheel < 0;
            if (MTConfig.wheelScrollDirection.isPositionAware() && Main.otherInventoryIsAbove(selectedSlot, slots)) {
                boolean bl2 = pushItems = !pushItems;
            }
            if (MTConfig.wheelScrollDirection.isInverted()) {
                boolean bl3 = pushItems = !pushItems;
            }
            if (isCraftingOutput) {
                if (pushItems) {
                    if (originalStack == null) {
                        return;
                    }
                    Slot applicableSlot = Main.findWheelApplicableSlot(slots, selectedSlot, pushItems);
                    for (int i = 0; i < numItemsToMove; ++i) {
                        handler.clickSlot(selectedSlot, MouseButton.LEFT, false);
                    }
                    if (applicableSlot != null && stackOnMouse == null) {
                        handler.clickSlot(applicableSlot, MouseButton.LEFT, false);
                    }
                }
                return;
            }
            int attemptsLeft = 100;
            do {
                int i;
                ItemStack stackFrom;
                ItemStack stackTo;
                Slot slotFrom;
                Slot slotTo;
                --attemptsLeft;
                Slot applicableSlot = Main.findWheelApplicableSlot(slots, selectedSlot, pushItems);
                if (applicableSlot == null) break;
                if (pushItems) {
                    slotTo = applicableSlot;
                    slotFrom = selectedSlot;
                    stackTo = ItemStack.func_77944_b((ItemStack)slotTo.func_75211_c());
                    stackFrom = ItemStack.func_77944_b((ItemStack)slotFrom.func_75211_c());
                    numItemsToMove = Math.min(numItemsToMove, stackFrom.field_77994_a);
                    if (stackTo != null && stackTo.func_77976_d() - stackTo.field_77994_a <= numItemsToMove) {
                        handler.clickSlot(slotFrom, MouseButton.LEFT, false);
                        handler.clickSlot(slotTo, MouseButton.LEFT, false);
                        handler.clickSlot(slotFrom, MouseButton.LEFT, false);
                        numItemsToMove -= stackTo.func_77976_d() - stackTo.field_77994_a;
                        continue;
                    }
                    handler.clickSlot(slotFrom, MouseButton.LEFT, false);
                    if (stackFrom.field_77994_a <= numItemsToMove) {
                        handler.clickSlot(slotTo, MouseButton.LEFT, false);
                    } else {
                        for (i = 0; i < numItemsToMove; ++i) {
                            handler.clickSlot(slotTo, MouseButton.RIGHT, false);
                        }
                    }
                    handler.clickSlot(slotFrom, MouseButton.LEFT, false);
                    break;
                }
                slotTo = selectedSlot;
                slotFrom = applicableSlot;
                stackTo = ItemStack.func_77944_b((ItemStack)slotTo.func_75211_c());
                stackFrom = ItemStack.func_77944_b((ItemStack)slotFrom.func_75211_c());
                if (stackTo.field_77994_a == stackTo.func_77976_d()) break;
                if (stackTo.func_77976_d() - stackTo.field_77994_a <= numItemsToMove) {
                    handler.clickSlot(slotFrom, MouseButton.LEFT, false);
                    handler.clickSlot(slotTo, MouseButton.LEFT, false);
                    if (handler.isCraftingOutput(slotFrom)) continue;
                    handler.clickSlot(slotFrom, MouseButton.LEFT, false);
                    continue;
                }
                handler.clickSlot(slotFrom, MouseButton.LEFT, false);
                if (handler.isCraftingOutput(slotFrom)) {
                    handler.clickSlot(slotTo, MouseButton.LEFT, false);
                    --numItemsToMove;
                } else if (stackFrom.field_77994_a <= numItemsToMove) {
                    handler.clickSlot(slotTo, MouseButton.LEFT, false);
                    numItemsToMove -= stackFrom.field_77994_a;
                } else {
                    for (i = 0; i < numItemsToMove; ++i) {
                        handler.clickSlot(slotTo, MouseButton.RIGHT, false);
                    }
                    numItemsToMove = 0;
                }
                if (handler.isCraftingOutput(slotFrom)) continue;
                handler.clickSlot(slotFrom, MouseButton.LEFT, false);
            } while (numItemsToMove > 0 && attemptsLeft > 0);
        }
    }

    private static boolean otherInventoryIsAbove(Slot selectedSlot, List<Slot> slots) {
        boolean selectedIsInPlayerInventory = selectedSlot.field_75224_c == Minecraft.func_71410_x().field_71439_g.field_71071_by;
        for (Slot slot : slots) {
            if (slot.field_75224_c == Minecraft.func_71410_x().field_71439_g.field_71071_by == selectedIsInPlayerInventory || slot.field_75221_f >= selectedSlot.field_75221_f) continue;
            return true;
        }
        return false;
    }

    private static IGuiScreenHandler findHandler(GuiScreen currentScreen) {
        if (currentScreen instanceof IMTModGuiContainer2Ex) {
            return new IMTModGuiContainer2ExHandler((IMTModGuiContainer2Ex)currentScreen);
        }
        if (currentScreen instanceof IMTModGuiContainer2) {
            return new IMTModGuiContainer2Handler((IMTModGuiContainer2)currentScreen);
        }
        if (currentScreen instanceof IMTModGuiContainer) {
            return new IMTModGuiContainerHandler((IMTModGuiContainer)currentScreen);
        }
        if (currentScreen instanceof GuiContainerCreative) {
            return new GuiContainerCreativeHandler((GuiContainerCreative)currentScreen);
        }
        if (currentScreen instanceof GuiContainer) {
            return new GuiContainerHandler((GuiContainer)currentScreen);
        }
        return null;
    }

    private static boolean areStacksCompatible(ItemStack a, ItemStack b) {
        return a == null || b == null || a.func_77969_a(b) && ItemStack.func_77970_a((ItemStack)a, (ItemStack)b);
    }

    private static Slot findWheelApplicableSlot(List<Slot> slots, Slot selectedSlot, boolean pushItems) {
        int direction;
        int endIndex;
        int startIndex;
        if (pushItems || MTConfig.wheelSearchOrder == MTConfig.WheelSearchOrder.FIRST_TO_LAST) {
            startIndex = 0;
            endIndex = slots.size();
            direction = 1;
        } else {
            startIndex = slots.size() - 1;
            endIndex = -1;
            direction = -1;
        }
        ItemStack originalStack = selectedSlot.func_75211_c();
        boolean findInPlayerInventory = selectedSlot.field_75224_c != Minecraft.func_71410_x().field_71439_g.field_71071_by;
        Slot rv = null;
        Slot firstAllowedEncounter = null;
        for (int i = startIndex; i != endIndex; i += direction) {
            Slot slot = slots.get(i);
            if (handler.isIgnored(slot) || (findInPlayerInventory ? slot.field_75224_c != Minecraft.func_71410_x().field_71439_g.field_71071_by : slot.field_75224_c == Minecraft.func_71410_x().field_71439_g.field_71071_by)) continue;
            ItemStack stack = slot.func_75211_c();
            int priority = handler.isSlotPrioritized(slot, originalStack);
            if (stack == null) {
                if (rv != null || !pushItems || !slot.func_75214_a(originalStack) || handler.isCraftingOutput(slot)) continue;
                switch (priority) {
                    case -1: 
                    case 1: {
                        rv = slot;
                        break;
                    }
                    case 0: {
                        if (firstAllowedEncounter != null) break;
                        firstAllowedEncounter = slot;
                    }
                }
                continue;
            }
            if (!Main.areStacksCompatible(originalStack, stack)) continue;
            if (pushItems) {
                if (handler.isCraftingOutput(slot) || stack.field_77994_a >= stack.func_77976_d()) continue;
                switch (priority) {
                    case -1: 
                    case 1: {
                        return slot;
                    }
                    case 0: {
                        firstAllowedEncounter = slot;
                    }
                }
                continue;
            }
            return slot;
        }
        if (rv == null && firstAllowedEncounter != null) {
            return firstAllowedEncounter;
        }
        return rv;
    }

    private static boolean isMouseWheelTransferActive() {
        if (isNEIPresent) {
            return MTConfig.wheelTweak && !NEIClientConfig.isMouseScrollTransferEnabled();
        }
        return MTConfig.wheelTweak;
    }
}

