/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.bogosorter.common;

import com.cleanroommc.bogosorter.BogoSortAPI;
import com.cleanroommc.bogosorter.common.config.SortRulesConfig;
import com.cleanroommc.bogosorter.compat.Mods;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import gregtech.api.items.MetaGeneratedTool;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenCustomHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import tconstruct.library.util.IToolPart;
import vazkii.botania.common.item.brew.ItemBrewBase;

public class OreDictHelper {
    private static final Map<ItemStack, Set<String>> ORE_DICTS = new Object2ObjectOpenCustomHashMap(BogoSortAPI.ITEM_META_HASH_STRATEGY);
    private static final Map<ItemStack, String> MATERIALS = new Object2ObjectOpenCustomHashMap(BogoSortAPI.ITEM_META_HASH_STRATEGY);
    private static final Map<ItemStack, String> PREFIXES = new Object2ObjectOpenCustomHashMap(BogoSortAPI.ITEM_META_HASH_STRATEGY);
    private static final Map<String, String[]> orePrefixOwnerMap = new Object2ObjectOpenHashMap();

    @SubscribeEvent
    public static void onItemRegistration(OreDictionary.OreRegisterEvent event) {
        ORE_DICTS.computeIfAbsent(event.Ore, key -> new ObjectOpenHashSet()).add(event.Name);
        String oreName = event.Name;
        if (!SortRulesConfig.ORE_PREFIXES.containsKey((Object)oreName)) {
            String material = null;
            String prefix = null;
            ArrayList<String> splits = new ArrayList<String>();
            StringBuilder builder = new StringBuilder();
            for (char character : oreName.toCharArray()) {
                if (Character.isUpperCase(character)) {
                    if (builder.length() > 0) {
                        splits.add(builder.toString());
                        builder = new StringBuilder().append(character);
                        continue;
                    }
                    splits.add(Character.toString(character));
                    continue;
                }
                builder.append(character);
            }
            if (builder.length() > 0) {
                splits.add(builder.toString());
            }
            StringBuilder buffer = new StringBuilder();
            for (int i = 0; i < splits.size(); ++i) {
                buffer.append((String)splits.get(i));
                String tryPrefix = buffer.toString();
                if (!SortRulesConfig.ORE_PREFIXES.containsKey((Object)tryPrefix)) continue;
                prefix = tryPrefix;
                material = StringUtils.join(splits.subList(i + 1, splits.size()), (String)"");
            }
            if (prefix != null && SortRulesConfig.ORE_PREFIXES.containsKey(prefix)) {
                MATERIALS.put(event.Ore, material);
                PREFIXES.put(event.Ore, prefix);
            }
        }
    }

    public static Set<String> getOreDicts(ItemStack item) {
        return ORE_DICTS.getOrDefault(item, Collections.emptySet());
    }

    public static String getMaterial(ItemStack item) {
        if (Mods.GT5u.isLoaded() && item.func_77973_b() instanceof MetaGeneratedTool) {
            return OreDictHelper.getGtToolMaterial(item);
        }
        if (Mods.Tconstruct.isLoaded() && item.func_77973_b() instanceof IToolPart) {
            return String.valueOf(((IToolPart)item.func_77973_b()).getMaterialID(item));
        }
        return MATERIALS.get(item);
    }

    public static boolean getModCompoundTag(ItemStack brokenItem, ItemStack stack, ItemStack stack2) {
        if (Mods.GT5u.isLoaded() && brokenItem.func_77973_b() instanceof MetaGeneratedTool) {
            return OreDictHelper.getGtToolMaterial(stack).equals(OreDictHelper.getGtToolMaterial(stack2));
        }
        if (Mods.Botania.isLoaded() && brokenItem.func_77973_b() instanceof ItemBrewBase) {
            return OreDictHelper.getBotaniabrew(stack).equals(OreDictHelper.getBotaniabrew(stack2));
        }
        return false;
    }

    @Optional.Method(modid="gregtech")
    @NotNull
    public static String getGtToolMaterial(ItemStack itemStack) {
        NBTTagCompound statsTag = itemStack.field_77990_d.func_74775_l("GT.ToolStats");
        if (statsTag == null) {
            return "";
        }
        if (statsTag.func_74764_b("PrimaryMaterial")) {
            return statsTag.func_74779_i("PrimaryMaterial");
        }
        return "";
    }

    @Optional.Method(modid="Botania")
    @NotNull
    public static String getBotaniabrew(ItemStack itemStack) {
        NBTTagCompound statsTag = itemStack.func_77978_p();
        if (statsTag == null) {
            return "";
        }
        String Tag = statsTag.func_74779_i("brewKey");
        return Tag;
    }

    public static String getOrePrefix(ItemStack item) {
        return PREFIXES.get(item);
    }

    public static int getOrePrefixIndex(String prefix) {
        return SortRulesConfig.ORE_PREFIXES.containsKey((Object)prefix) ? SortRulesConfig.ORE_PREFIXES.getInt((Object)prefix) : Integer.MAX_VALUE;
    }

    public static String toLowerCaseUnderscore(String string) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            if (i != 0 && (Character.isUpperCase(string.charAt(i)) || Character.isDigit(string.charAt(i - 1)) ^ Character.isDigit(string.charAt(i)))) {
                result.append("_");
            }
            result.append(Character.toLowerCase(string.charAt(i)));
        }
        return result.toString();
    }

    private static void addOrePrefix(String[] owner, String ... orePrefixes) {
        for (String prefix : orePrefixes) {
            if (orePrefixOwnerMap.containsKey(prefix)) {
                orePrefixOwnerMap.put(prefix, (String[])ArrayUtils.addAll((Object[])orePrefixOwnerMap.get(prefix), (Object[])owner));
                continue;
            }
            orePrefixOwnerMap.put(prefix, owner);
        }
    }

    private static void addOrePrefix(String owner, String ... orePrefixes) {
        OreDictHelper.addOrePrefix(new String[]{owner}, orePrefixes);
    }

    private static boolean isPrefixLoaded(String prefix) {
        String[] owners = orePrefixOwnerMap.get(prefix);
        if (owners == null || owners.length == 0) {
            return true;
        }
        for (String owner : owners) {
            if (!Loader.isModLoaded((String)owner)) continue;
            return true;
        }
        return false;
    }

    public static void init() {
        OreDictHelper.addOrePrefix("gregtech", "ingotHot", "gemChipped", "gemFlawed", "gemFlawless", "gemExquisite", "dustTiny", "dustSmall", "plate", "plateDouble", "plateDense", "gear", "bolt", "stick", "stickLong", "ring", "screw", "round", "foil", "wireFine", "springSmall", "spring", "turbineBlade", "rotor", "lens", "dustImpure", "dustPure", "crushed", "crushedCentrifuged", "crushedPurified", "shard", "clump", "reduced", "crystalline", "dirtyGravel", "cleanGravel", "toolHeadSword", "toolHeadPickaxe", "toolHeadShovel", "toolHeadAxe", "toolHeadHoe", "toolHeadSense", "toolHeadFile", "toolHeadHammer", "toolHeadSaw", "toolHeadBuzzSaw", "toolHeadScrewdriver", "toolHeadDrill", "toolHeadChainsaw", "toolHeadWrench", "pipeTinyFluid", "pipeSmallFluid", "pipeNormalFluid", "pipeLargeFluid", "pipeHugeFluid", "pipeQuadrupleFluid", "pipeNonupleFluid", "pipeTinyItem", "pipeSmallItem", "pipeNormalItem", "pipeLargeItem", "pipeHugeItem", "pipeSmallRestrictive", "pipeNormalRestrictive", "pipeLargeRestrictive", "pipeHugeRestrictive", "wireGtSingle", "wireGtDouble", "wireGtQuadruple", "wireGtOctal", "wireGtHex", "cableGtSingle", "cableGtDouble", "cableGtQuadruple", "cableGtOctal", "cableGtHex", "frameGt", "oreGranite", "oreDiorite", "oreAndesite", "oreBlackgranite", "oreRedgranite", "oreMarble", "oreBasalt", "oreSand", "oreRedSand", "oreNetherrack", "oreEndstone");
        OreDictHelper.addOrePrefix("thermalfoundation", "gear", "stick", "plate", "fuel", "crystal", "rod", "coin");
        OreDictHelper.addOrePrefix("thaumcraft", "cluster", "oreCrystal");
        OreDictHelper.addOrePrefix("ic2", "plate", "plateDense", "crushed", "crushedPurified");
        OreDictHelper.addOrePrefix("immersiveengineering", "plate", "wire", "blockSheetmetal");
        OreDictHelper.addOrePrefix("enderio", "ball");
        String[] defaultOrePrefixOrder = new String[]{"ingot", "ingotHot", "gemChipped", "gemFlawed", "gem", "gemFlawless", "gemExquisite", "dustTiny", "dustSmall", "dust", "nugget", "block", "blockSheetmetal", "plate", "plateDouble", "plateDense", "gear", "bolt", "stick", "stickLong", "ring", "screw", "round", "foil", "wireFine", "wire", "springSmall", "spring", "ball", "crystal", "coin", "fuel", "turbineBlade", "rotor", "lens", "dustImpure", "dustPure", "crushed", "crushedCentrifuged", "crushedPurified", "shard", "clump", "reduced", "crystalline", "dirtyGravel", "cleanGravel", "toolHeadSword", "toolHeadPickaxe", "toolHeadShovel", "toolHeadAxe", "toolHeadHoe", "toolHeadSense", "toolHeadFile", "toolHeadHammer", "toolHeadSaw", "toolHeadBuzzSaw", "toolHeadScrewdriver", "toolHeadDrill", "toolHeadChainsaw", "toolHeadWrench", "pipeTinyFluid", "pipeSmallFluid", "pipeNormalFluid", "pipeLargeFluid", "pipeHugeFluid", "pipeQuadrupleFluid", "pipeNonupleFluid", "pipeTinyItem", "pipeSmallItem", "pipeNormalItem", "pipeLargeItem", "pipeHugeItem", "pipeSmallRestrictive", "pipeNormalRestrictive", "pipeLargeRestrictive", "pipeHugeRestrictive", "wireGtSingle", "wireGtDouble", "wireGtQuadruple", "wireGtOctal", "wireGtHex", "cableGtSingle", "cableGtDouble", "cableGtQuadruple", "cableGtOctal", "cableGtHex", "frameGt", "glass", "ore", "oreGranite", "oreDiorite", "oreAndesite", "oreBlackgranite", "oreRedgranite", "oreMarble", "oreBasalt", "oreSand", "oreRedSand", "oreNetherrack", "oreEndstone", "oreCrystal", "log", "rod"};
        SortRulesConfig.ORE_PREFIXES.clear();
        SortRulesConfig.ORE_PREFIXES_LIST.clear();
        int i = 0;
        for (String orePrefix : defaultOrePrefixOrder) {
            if (!OreDictHelper.isPrefixLoaded(orePrefix)) continue;
            SortRulesConfig.ORE_PREFIXES.put((Object)orePrefix, i++);
            SortRulesConfig.ORE_PREFIXES_LIST.add(orePrefix);
        }
    }
}

