/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.bogosorter.client.usageticker.Arrow;

import com.cleanroommc.bogosorter.client.usageticker.Arrow.compat.TConstructCompat;
import com.cleanroommc.bogosorter.client.usageticker.Arrow.compat.VanillaBowHandler;
import com.cleanroommc.bogosorter.common.config.BogoSorterConfig;
import com.cleanroommc.bogosorter.compat.Mods;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class ArrowHandlerRegistry {
    private static final Map<Item, ArrowHandler> HANDLERS = new LinkedHashMap<Item, ArrowHandler>();

    public static void register(Item weapon, ArrowHandler handler) {
        if (weapon != null && handler != null) {
            HANDLERS.put(weapon, handler);
        }
    }

    @Nullable
    public static ArrowHandler getHandler(ItemStack stack) {
        if (stack == null) {
            return null;
        }
        ArrowHandler handler = HANDLERS.get(stack.func_77973_b());
        return handler;
    }

    private static Item parseItemFromString(String itemID) {
        if (itemID == null || itemID.isEmpty()) {
            return null;
        }
        String[] parts = itemID.split(":");
        if (parts.length == 2) {
            return GameRegistry.findItem((String)parts[0], (String)parts[1]);
        }
        return null;
    }

    static {
        VanillaBowHandler handler = new VanillaBowHandler();
        for (String itemID : BogoSorterConfig.usageTicker.arrow.arrowItems) {
            Item arrowItem = ArrowHandlerRegistry.parseItemFromString(itemID);
            if (arrowItem == null) continue;
            handler.addModdedArrows(arrowItem);
        }
        for (String itemID : BogoSorterConfig.usageTicker.arrow.bowItems) {
            Item bowItem = ArrowHandlerRegistry.parseItemFromString(itemID);
            if (bowItem == null) continue;
            ArrowHandlerRegistry.register(bowItem, handler);
        }
        if (Mods.Tconstruct.isLoaded()) {
            TConstructCompat.register();
        }
    }

    public static abstract class ArrowHandler {
        public abstract int getAmmoCount(EntityClientPlayerMP var1, ItemStack var2);

        public abstract ItemStack getDisplayStack(EntityClientPlayerMP var1, ItemStack var2);
    }
}

