/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.bogosorter.client.keybinds.gui;

import com.cleanroommc.bogosorter.client.keybinds.control.BSKeybinds;
import com.cleanroommc.bogosorter.client.keybinds.gui.BSGuiControls;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiListExtended;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.resources.I18n;

public class BSGuiKeybindList
extends GuiListExtended {
    private final BSGuiControls controlsScreen;
    private final Minecraft mc;
    private final GuiListExtended.IGuiListEntry[] listEntries;
    private final BSKeybinds.KeybindDefinition[] bogoSorterKeyBindings;
    private int maxListLabelWidth;

    public BSGuiKeybindList(BSGuiControls controls, Minecraft mc) {
        super(mc, controls.field_146294_l, controls.field_146295_m, 30, controls.field_146295_m - 62, 20);
        this.controlsScreen = controls;
        this.mc = mc;
        this.bogoSorterKeyBindings = BSKeybinds.getAllKeybinds();
        this.listEntries = new GuiListExtended.IGuiListEntry[this.bogoSorterKeyBindings.length];
        for (int i = 0; i < this.bogoSorterKeyBindings.length; ++i) {
            BSKeybinds.KeybindDefinition keybinding = this.bogoSorterKeyBindings[i];
            int width = mc.field_71466_p.func_78256_a(keybinding.getDisplayName());
            if (width > this.maxListLabelWidth) {
                this.maxListLabelWidth = width;
            }
            this.listEntries[i] = new KeyEntry(keybinding);
        }
    }

    public GuiListExtended.IGuiListEntry func_148180_b(int index) {
        return this.listEntries[index];
    }

    protected int func_148127_b() {
        return this.listEntries.length;
    }

    public int func_148139_c() {
        return super.func_148139_c() + 32;
    }

    public boolean mouseClicked(int mouseX, int mouseY, int mouseEvent) {
        for (int i = 0; i < this.func_148127_b(); ++i) {
            int entryTop = this.field_148153_b + this.field_148149_f * i - this.func_148148_g();
            int entryLeft = this.field_148152_e;
            if (mouseY < entryTop || mouseY > entryTop + this.field_148149_f || !this.func_148180_b(i).func_148278_a(i, mouseX, mouseY, mouseEvent, mouseX - entryLeft, mouseY - entryTop)) continue;
            this.func_148143_b(false);
            return true;
        }
        return false;
    }

    public boolean mouseReleased(int mouseX, int mouseY, int mouseEvent) {
        for (int i = 0; i < this.func_148127_b(); ++i) {
            int entryTop = this.field_148153_b + this.field_148149_f * i - this.func_148148_g();
            int entryLeft = this.field_148152_e;
            this.func_148180_b(i).func_148277_b(i, mouseX, mouseY, mouseEvent, mouseX - entryLeft, mouseY - entryTop);
        }
        this.func_148143_b(true);
        return false;
    }

    public boolean keyTyped(char typedChar, int keyCode) {
        if (this.controlsScreen.selectedKeyBinding != null) {
            List<Integer> combo = BSKeybinds.getKeyCombo(this.controlsScreen.selectedKeyBinding);
            if (keyCode == 1) {
                BSKeybinds.resetToDefault(this.controlsScreen.selectedKeyBinding);
                this.controlsScreen.selectedKeyBinding = null;
            } else if (keyCode == 14) {
                if (!combo.isEmpty()) {
                    combo.remove(combo.size() - 1);
                }
            } else if (keyCode != 0 && !combo.contains(keyCode)) {
                combo.add(keyCode);
            }
            return true;
        }
        return false;
    }

    private class KeyEntry
    implements GuiListExtended.IGuiListEntry {
        private final BSKeybinds.KeybindDefinition keybinding;
        private final String keyDesc;
        private final GuiButton btnEdit;
        private final GuiButton btnDone;
        private final GuiButton btnReset;

        private KeyEntry(BSKeybinds.KeybindDefinition keybinding) {
            this.keybinding = keybinding;
            this.keyDesc = keybinding.getDisplayName();
            this.btnEdit = new GuiButton(0, 0, 0, 50, 20, "Edit");
            this.btnDone = new GuiButton(0, 0, 0, 50, 20, "Done");
            this.btnReset = new GuiButton(0, 0, 0, 50, 20, I18n.func_135052_a((String)"controls.reset", (Object[])new Object[0]));
        }

        public void func_148279_a(int slotIndex, int x, int y, int listWidth, int slotHeight, Tessellator tessellator, int mouseX, int mouseY, boolean isSelected) {
            boolean isEditing = ((BSGuiKeybindList)BSGuiKeybindList.this).controlsScreen.selectedKeyBinding == this.keybinding;
            ((BSGuiKeybindList)BSGuiKeybindList.this).mc.field_71466_p.func_78276_b(this.keyDesc, x + 70 - BSGuiKeybindList.this.maxListLabelWidth, y + slotHeight / 2 - ((BSGuiKeybindList)BSGuiKeybindList.this).mc.field_71466_p.field_78288_b / 2, 0xFFFFFF);
            String comboString = BSKeybinds.getComboDisplayString(this.keybinding);
            int stringWidth = ((BSGuiKeybindList)BSGuiKeybindList.this).mc.field_71466_p.func_78256_a(comboString);
            ((BSGuiKeybindList)BSGuiKeybindList.this).mc.field_71466_p.func_78276_b(comboString, ((BSGuiKeybindList)BSGuiKeybindList.this).controlsScreen.field_146294_l / 2 - stringWidth / 2, y + slotHeight / 2 - ((BSGuiKeybindList)BSGuiKeybindList.this).mc.field_71466_p.field_78288_b / 2, 0xFFFFFF);
            int buttonX = x + 180;
            if (isEditing) {
                this.btnDone.field_146128_h = buttonX;
                this.btnDone.field_146129_i = y;
                this.btnDone.func_146112_a(BSGuiKeybindList.this.mc, mouseX, mouseY);
            } else {
                this.btnEdit.field_146128_h = buttonX;
                this.btnEdit.field_146129_i = y;
                this.btnEdit.func_146112_a(BSGuiKeybindList.this.mc, mouseX, mouseY);
            }
            this.btnReset.field_146128_h = buttonX + 55;
            this.btnReset.field_146129_i = y;
            this.btnReset.field_146124_l = !BSKeybinds.isDefault(this.keybinding);
            this.btnReset.func_146112_a(BSGuiKeybindList.this.mc, mouseX, mouseY);
        }

        public boolean func_148278_a(int slotIndex, int mouseX, int mouseY, int mouseEvent, int relativeX, int relativeY) {
            boolean isEditing;
            boolean bl = isEditing = ((BSGuiKeybindList)BSGuiKeybindList.this).controlsScreen.selectedKeyBinding == this.keybinding;
            if (isEditing) {
                if (this.btnDone.func_146116_c(BSGuiKeybindList.this.mc, mouseX, mouseY)) {
                    ((BSGuiKeybindList)BSGuiKeybindList.this).controlsScreen.selectedKeyBinding = null;
                    return true;
                }
            } else if (this.btnEdit.func_146116_c(BSGuiKeybindList.this.mc, mouseX, mouseY)) {
                if (((BSGuiKeybindList)BSGuiKeybindList.this).controlsScreen.selectedKeyBinding != null) {
                    BSKeybinds.resetToDefault(((BSGuiKeybindList)BSGuiKeybindList.this).controlsScreen.selectedKeyBinding);
                }
                ((BSGuiKeybindList)BSGuiKeybindList.this).controlsScreen.selectedKeyBinding = this.keybinding;
                BSKeybinds.getKeyCombo(this.keybinding).clear();
                return true;
            }
            if (this.btnReset.func_146116_c(BSGuiKeybindList.this.mc, mouseX, mouseY)) {
                BSKeybinds.resetToDefault(this.keybinding);
                if (isEditing) {
                    ((BSGuiKeybindList)BSGuiKeybindList.this).controlsScreen.selectedKeyBinding = null;
                }
                return true;
            }
            return false;
        }

        public void func_148277_b(int slotIndex, int x, int y, int mouseEvent, int relativeX, int relativeY) {
            this.btnEdit.func_146118_a(x, y);
            this.btnDone.func_146118_a(x, y);
            this.btnReset.func_146118_a(x, y);
        }
    }
}

