/*
 * Decompiled with CFR 0.152.
 */
package eu.usrv.yamcore.auxiliary;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class TabText {
    private int chatHeight;
    private int[] tabs;
    private int numPages;
    private String[] lines;
    private Map<Integer, String> charList = new HashMap<Integer, String>(){
        {
            this.put(-6, "\u00a7");
            this.put(2, "!.,:;i|");
            this.put(3, "'`l");
            this.put(4, " I[]t");
            this.put(5, "\"()*<>fk{}");
            this.put(7, "@~");
        }
    };

    public TabText(String multilineString) {
        this.setText(multilineString);
    }

    public void setText(String multilineString) {
        this.lines = multilineString.split("\n", -1);
    }

    public int setPageHeight(int chatHeight) {
        this.chatHeight = chatHeight;
        this.numPages = (int)Math.ceil((double)this.lines.length / (double)chatHeight);
        return this.numPages;
    }

    public void setTabs(int ... tabs) {
        int[] tabs2 = new int[tabs.length + 1];
        tabs2[0] = tabs[0];
        for (int i = 1; i < tabs.length; ++i) {
            tabs2[i] = tabs[i] - tabs[i - 1];
        }
        tabs2[tabs.length] = 53 - tabs[tabs.length - 1];
        this.tabs = tabs2;
    }

    public void addChars(String charsList, int charsWidth) {
        if (charsWidth == 6) {
            return;
        }
        if (!this.charList.containsKey(charsWidth)) {
            this.charList.put(charsWidth, "");
        }
        this.charList.get(charsWidth).concat(charsList);
    }

    public String getPage(int page, boolean monospace) {
        int fromLine;
        int toLine;
        int n = toLine = (fromLine = --page * this.chatHeight) + this.chatHeight > this.lines.length ? this.lines.length : fromLine + this.chatHeight;
        if (page < 0) {
            fromLine = 0;
            toLine = this.lines.length;
        }
        String lines2 = "";
        for (int linePos = fromLine; linePos < toLine; ++linePos) {
            String[] fields = this.lines[linePos].split("`", -1);
            String line = "";
            int lineLen = 0;
            int lineLen2 = 0;
            for (int fieldPos = 0; fieldPos < fields.length; ++fieldPos) {
                if (!monospace && lineLen % 4 > 1) {
                    line = line + '.';
                    lineLen += 2;
                }
                while (lineLen < lineLen2) {
                    line = line + ' ';
                    lineLen += monospace ? 1 : 4;
                }
                int tab = monospace ? this.tabs[fieldPos] : this.tabs[fieldPos] * 6;
                Object[] field = this.pxSubstring(fields[fieldPos], tab, monospace);
                line = line + (String)field[0];
                lineLen += ((Integer)field[1]).intValue();
                lineLen2 += tab;
            }
            lines2 = lines2 + (lines2.length() < 1 ? line : '\n' + line);
        }
        return lines2;
    }

    private Object[] pxSubstring(String str, int len, boolean mono) {
        int len2 = 0;
        int len3 = 0;
        int len4 = 0;
        for (char ch : str.toCharArray()) {
            if ((len3 += this.pxLen(ch, mono)) > len) break;
            ++len4;
            len2 = len3;
        }
        return new Object[]{str.substring(0, len4), len2};
    }

    private int pxLen(char ch, boolean mono) {
        if (mono) {
            return ch == '\u00a7' ? -1 : 1;
        }
        int l = 6;
        for (int px : this.charList.keySet()) {
            if (this.charList.get(px).indexOf(ch) < 0) continue;
            l = px;
            break;
        }
        return l;
    }

    public void sortByFields(int ... keys) {
        boolean[] desc = new boolean[keys.length];
        for (int i = 0; i < keys.length; ++i) {
            desc[i] = keys[i] < 0;
            keys[i] = Math.abs(keys[i]) - 1;
        }
        Object[] lines2 = new String[this.lines.length];
        for (int i = 0; i < this.lines.length; ++i) {
            String[] fields = this.lines[i].replaceAll("\u00a7.", "").split("`", -1);
            String line = "";
            for (int j = 0; j < keys.length; ++j) {
                boolean desc2;
                String field = fields[keys[j]];
                String field2 = "~";
                try {
                    double num = Double.parseDouble(field);
                    for (int k = field.length(); k < 53; ++k) {
                        field2 = field2 + " ";
                    }
                    field2 = field2 + field;
                    desc2 = num < 0.0 ? !desc[j] : desc[j];
                }
                catch (NumberFormatException e) {
                    field2 = field2 + field;
                    for (int k = field.length(); k < 53; ++k) {
                        field2 = field2 + " ";
                    }
                    desc2 = desc[j];
                }
                if (desc2) {
                    field = "";
                    for (char c : field2.toCharArray()) {
                        field = field + (char)(158 - c);
                    }
                    field2 = field;
                }
                line = line + field2;
            }
            lines2[i] = line + "`" + i;
        }
        Arrays.sort(lines2);
        String[] lines3 = new String[this.lines.length];
        for (int i = 0; i < this.lines.length; ++i) {
            String[] fields = ((String)lines2[i]).split("`", -1);
            lines3[i] = this.lines[Integer.parseInt(fields[1])];
        }
        this.lines = lines3;
    }
}

