/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block;

import ic2.api.item.ItemWrapper;
import ic2.core.IC2;
import ic2.core.Ic2Items;
import ic2.core.block.BlockMetaData;
import ic2.core.block.machine.tileentity.TileEntityMagnetizer;
import ic2.core.init.InternalName;
import ic2.core.item.block.ItemBlockIC2;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFence;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockPoleFence
extends BlockMetaData {
    private static final float halfThickness = 0.125f;

    public BlockPoleFence(InternalName internalName1) {
        super(internalName1, Material.field_151573_f, ItemBlockIC2.class);
        this.func_149711_c(1.5f);
        this.func_149752_b(5.0f);
        this.func_149672_a(field_149777_j);
        Ic2Items.ironFence = new ItemStack((Block)this);
    }

    @Override
    public int getTextureIndex(int meta) {
        return 0;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean isNormalCube(IBlockAccess world, int i, int j, int k) {
        return false;
    }

    public int func_149645_b() {
        return IC2.platform.getRenderId("fence");
    }

    public void func_149743_a(World world, int x, int y, int z, AxisAlignedBB mask, List list, Entity entity) {
        boolean zneg = this.canConnectFenceTo((IBlockAccess)world, x, y, z - 1, false);
        boolean zpos = this.canConnectFenceTo((IBlockAccess)world, x, y, z + 1, false);
        boolean xneg = this.canConnectFenceTo((IBlockAccess)world, x - 1, y, z, false);
        boolean xpos = this.canConnectFenceTo((IBlockAccess)world, x + 1, y, z, false);
        float boundxneg = 0.375f;
        float boundxpos = 0.625f;
        float boundzneg = 0.375f;
        float boundzpos = 0.625f;
        if (zneg) {
            boundzneg = 0.0f;
        }
        if (zpos) {
            boundzpos = 1.0f;
        }
        if (zneg || zpos) {
            this.func_149676_a(boundxneg, 0.0f, boundzneg, boundxpos, 1.5f, boundzpos);
            super.func_149743_a(world, x, y, z, mask, list, entity);
        }
        boundzneg = 0.375f;
        boundzpos = 0.625f;
        if (xneg) {
            boundxneg = 0.0f;
        }
        if (xpos) {
            boundxpos = 1.0f;
        }
        if (xneg || xpos || !zneg && !zpos) {
            this.func_149676_a(boundxneg, 0.0f, boundzneg, boundxpos, 1.5f, boundzpos);
            super.func_149743_a(world, x, y, z, mask, list, entity);
        }
        if (zneg) {
            boundzneg = 0.0f;
        }
        if (zpos) {
            boundzpos = 1.0f;
        }
        this.func_149676_a(boundxneg, 0.0f, boundzneg, boundxpos, 1.0f, boundzpos);
    }

    public void func_149719_a(IBlockAccess world, int x, int y, int z) {
        boolean zneg = this.canConnectFenceTo(world, x, y, z - 1, false);
        boolean zpos = this.canConnectFenceTo(world, x, y, z + 1, false);
        boolean xneg = this.canConnectFenceTo(world, x - 1, y, z, false);
        boolean xpos = this.canConnectFenceTo(world, x + 1, y, z, false);
        float boundxneg = 0.375f;
        float boundxpos = 0.625f;
        float boundzneg = 0.375f;
        float boundzpos = 0.625f;
        if (zneg) {
            boundzneg = 0.0f;
        }
        if (zpos) {
            boundzpos = 1.0f;
        }
        if (xneg) {
            boundxneg = 0.0f;
        }
        if (xpos) {
            boundxpos = 1.0f;
        }
        this.func_149676_a(boundxneg, 0.0f, boundzneg, boundxpos, 1.0f, boundzpos);
    }

    private boolean canConnectFenceTo(IBlockAccess world, int x, int y, int z, boolean pole) {
        Block block = world.func_147439_a(x, y, z);
        if (block == this || block instanceof BlockFence) {
            return true;
        }
        TileEntity te = world.func_147438_o(x, y, z);
        return te != null && te instanceof TileEntityMagnetizer && !pole;
    }

    public boolean isPole(World world, int i, int j, int k) {
        return !this.canConnectFenceTo((IBlockAccess)world, i - 1, j, k, true) && !this.canConnectFenceTo((IBlockAccess)world, i + 1, j, k, true) && !this.canConnectFenceTo((IBlockAccess)world, i, j, k - 1, true) && !this.canConnectFenceTo((IBlockAccess)world, i, j, k + 1, true);
    }

    public void func_149670_a(World world, int i, int j, int k, Entity entity) {
        boolean slow;
        if (this.field_149764_J != Material.field_151573_f || !this.isPole(world, i, j, k) || !(entity instanceof EntityPlayer)) {
            return;
        }
        int meta = world.func_72805_g(i, j, k);
        boolean powered = meta > 0;
        EntityPlayer player = (EntityPlayer)entity;
        boolean metalShoes = BlockPoleFence.hasMetalShoes(player);
        boolean descending = player.func_70093_af();
        boolean bl = slow = player.field_70181_x >= -0.25 || player.field_70181_x < 1.6;
        if (slow) {
            player.field_70143_R = 0.0f;
        }
        if (!powered) {
            if (descending && !slow) {
                player.field_70181_x *= 0.9;
            }
        } else {
            world.func_72921_c(i, j, k, meta - 1, 7);
            if (descending) {
                if (!slow) {
                    player.field_70181_x *= 0.8;
                }
            } else {
                player.field_70181_x += 0.075;
                if (player.field_70181_x > 0.0) {
                    player.field_70181_x *= 1.03;
                }
                double maxSpeed = IC2.keyboard.isAltKeyDown(player) ? 0.1 : (metalShoes ? 1.5 : 0.5);
                player.field_70181_x = Math.min(player.field_70181_x, maxSpeed);
            }
        }
    }

    public static boolean hasMetalShoes(EntityPlayer player) {
        Item item;
        ItemStack shoes = player.field_71071_by.field_70460_b[0];
        return shoes != null && ((item = shoes.func_77973_b()) == Items.field_151167_ab || item == Items.field_151151_aj || item == Items.field_151029_X || ItemWrapper.isMetalArmor(shoes, player));
    }
}

